/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.notafiscaleletronica;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeFinalidadeEmissao;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeFormaImportacaoIntermediacao;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeProdutoCompoeValorNota;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeViaTransporteInternacional;
import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementor.model.vo.AdicoesImportacao;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.CodigoBarras;
import com.touchcomp.basementor.model.vo.DetImportacaoItem;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaExportacao;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.ItemParamNomeclaturaProdutoXML;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoCliente;
import com.touchcomp.basementor.model.vo.ParamNomeclaturaProdutoXML;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropriaItem;
import com.touchcomp.basementorservice.helpers.impl.cfop.HelperCfop;
import com.touchcomp.basementorservice.service.impl.notafiscaleletronica.AuxItemCofins;
import com.touchcomp.basementorservice.service.impl.notafiscaleletronica.AuxItemIPI;
import com.touchcomp.basementorservice.service.impl.notafiscaleletronica.AuxItemIcms;
import com.touchcomp.basementorservice.service.impl.notafiscaleletronica.AuxItemOutros;
import com.touchcomp.basementorservice.service.impl.notafiscaleletronica.AuxItemPis;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class AuxItem {
    private final AuxItemCofins itemCofins = new AuxItemCofins();
    private final AuxItemPis itemPis = new AuxItemPis();
    private final AuxItemIcms itemIcms = new AuxItemIcms();
    private final AuxItemIPI itemIpi = new AuxItemIPI();
    private final AuxItemOutros itemOutros;
    private final HelperCfop helperCfop = new HelperCfop();
    private final OpcoesFaturamento opcoesFaturamento;
    private final OpcoesFaturamentoCliente opcoesFaturamentoCliente;
    private static final Short CODIGO_BARRAS_EAN = 0;
    private static final Short CODIGO_BARRAS_EAN_TRIB = 1;

    public AuxItem(OpcoesFaturamento opcoesFaturamento, OpcoesFaturamentoCliente opcoesFaturamentoCliente) {
        this.itemOutros = new AuxItemOutros(this.helperCfop);
        this.opcoesFaturamento = opcoesFaturamento;
        this.opcoesFaturamentoCliente = opcoesFaturamentoCliente;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto getProdutoItem(ItemNotaFiscalPropria i, NotaFiscalPropria nf) {
        ItemNotaLivroFiscal lv = i.getItemNotaLivroFiscal();
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto p = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto();
        this.setCodigoProduto(p, i, nf);
        this.setInfoEAN(p, i, nf);
        this.setInfoUnidadeMedida(p, i, nf);
        this.setDetalhesExportacao(p, i, nf);
        this.setNomeProduto(p, i, nf);
        if (i.getProduto().getNcm() != null) {
            p.setNcm(ToolString.onlyNumbers((String)i.getProduto().getNcm().getCodigo()));
        } else if (i.getProduto().getGenero() != null) {
            p.setNcm(ToolString.onlyNumbers((String)i.getProduto().getGenero().getCodigo()));
        }
        if (i.getProduto().getRegraExcecaoNCM() != null && i.getProduto().getTipoProduto() != 1) {
            p.setExtipi(ToolString.onlyNumbers((String)i.getProduto().getRegraExcecaoNCM().getCodigo()));
        }
        p.setCfop(ToolString.onlyNumbers((String)i.getItemNotaLivroFiscal().getCfop().getCodigo()));
        if (i.getIndicadorTotal() == 1) {
            p.setCompoeValorNota(ConstNFeProdutoCompoeValorNota.SIM);
        } else {
            p.setCompoeValorNota(ConstNFeProdutoCompoeValorNota.NAO);
        }
        p.setValorTotalBruto(Double.valueOf(i.getVrProduto() + i.getVrServico()));
        p.setValorFrete(i.getValorFrete());
        p.setValorSeguro(i.getVrSeguro());
        p.setValorDesconto(i.getValorDesconto());
        p.setValorOutrasDespesasAcessorias(i.getValorDespAcessoria());
        p.setValorUnitario(i.getValorUnitarioCom());
        p.setValorUnitarioTributavel(i.getValorUnitarioTrib());
        p.setNumeroPedidoCliente(i.getNrPedido());
        if (ToolMethods.isStrWithData((String)ToolString.onlyNumbers((String)i.getNrItemPedido()))) {
            p.setNumeroPedidoItemCliente(Integer.valueOf(ToolString.onlyNumbers((String)i.getNrItemPedido())));
        }
        if (i.getProduto().getCest() != null) {
            p.setCodigoEspecificadorSituacaoTributaria(i.getProduto().getCest().getCodigo());
        }
        if (i.getProduto().getCodBeneficioFiscal() != null && i.getProduto().getCodBeneficioFiscal().trim().length() > 0) {
            p.setCodigoBeneficioFiscalUF(i.getProduto().getCodBeneficioFiscal());
        }
        if (ToolMethods.isAffirmative((Number)i.getModeloFiscal().getUtilizaCodigoFCI()) && ToolMethods.isStrWithData((String)i.getProduto().getCodigoFCI())) {
            p.setNumeroControleFCI(i.getProduto().getCodigoFCI());
        }
        p.setVeiculo(null);
        p.setCombustivel(this.getCombustivel(i, nf));
        p.setDeclaracoesImportacao(this.getDeclaracoesImportacao(i, nf));
        p.setMedicamento(this.getMedicamento(i, nf));
        p.getRastros().addAll(this.getRastro(i));
        return p;
    }

    private List<NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoRastreabilidade> getRastro(ItemNotaFiscalPropria it) {
        ArrayList<NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoRastreabilidade> lista = new ArrayList<NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoRastreabilidade>();
        for (GradeItemNotaFiscalPropria g : it.getGradesNotaFiscalPropria()) {
            if (!ToolMethods.isEquals((Object)g.getLoteFabricacao().getUnico(), (Object)0) || g.getLoteFabricacao().getDataFabricacao() == null || g.getLoteFabricacao().getDataValidade() == null) continue;
            LoteFabricacao lote = g.getLoteFabricacao();
            NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoRastreabilidade r = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoRastreabilidade();
            r.setNumeroLote(lote.getLoteFabricacao());
            r.setDataFabricacao(ToolDate.formatarLocalDate((Date)lote.getDataFabricacao()));
            r.setDataValidade(ToolDate.formatarLocalDate((Date)lote.getDataValidade()));
            r.setQuantidadeLote(g.getQuantidade());
            if (lote.getCodigoAgregacao() != null && lote.getCodigoAgregacao().trim().length() > 0) {
                r.setCodigoAgregacao(lote.getCodigoAgregacao());
            }
            lista.add(r);
        }
        return lista;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoMedicamento getMedicamento(ItemNotaFiscalPropria it, NotaFiscalPropria nf) {
        if (!ToolMethods.isEquals((Object)nf.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
            return null;
        }
        if (ToolMethods.isStrWithData((String)it.getProduto().getCodAnvisa())) {
            NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoMedicamento med = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoMedicamento();
            med.setPrecoMaximoConsumidor(it.getProduto().getValorMaximoConsumo());
            if (ToolMethods.isStrWithData((String)it.getProduto().getMotivoIsencaoAnvisa())) {
                med.setMotivoIsencao(it.getProduto().getMotivoIsencaoAnvisa());
            }
            if (!ToolMethods.isNull((Object)it.getProduto().getCodAnvisa()).booleanValue()) {
                med.setCodigoProdutoAnvisa(it.getProduto().getCodAnvisa());
            }
            return med;
        }
        return null;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel getCombustivel(ItemNotaFiscalPropria it, NotaFiscalPropria nf) {
        if (it.getProduto().getClassificacaoProdutoANP() == null) {
            return null;
        }
        UnidadeFederativa uf = it.getItemNotaLivroFiscal().getUfConsumoComb();
        if (uf == null) {
            return null;
        }
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel c = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel();
        c.setCodigoProdutoANP(it.getProduto().getClassificacaoProdutoANP().getCodigo());
        c.setDescricaoProdutoANP(it.getProduto().getClassificacaoProdutoANP().getDescricao());
        c.setUf(this.getCodigoIBGEUF(uf.getSigla()));
        c.setQuantidade(this.formatarNumerosNullCaso0(it.getItemNotaLivroFiscal().getQtdCombTempAmb()));
        if (ToolMethods.isWithData((Number)it.getProduto().getPercGLP()) || ToolMethods.isWithData((Number)it.getProduto().getPercGNI()) || ToolMethods.isWithData((Number)it.getProduto().getPercGNN())) {
            c.setPercentualGLPDerivadoPetroleo(this.formatarNumerosNullCaso0(it.getProduto().getPercGLP()));
            c.setPercentualGasNaturalImportado(this.formatarNumerosNullCaso0(it.getProduto().getPercGNI()));
            c.setPercentualGasNaturalNacional(this.formatarNumerosNullCaso0(it.getProduto().getPercGNN()));
            c.setValorPartida(this.formatarNumerosNullCaso0(it.getItemNotaLivroFiscal().getValorPartida()));
        }
        if (ToolMethods.isWithData((Number)it.getProduto().getPercIndiceMisturaBioDiesel())) {
            c.setPercentualIndiceMisturaBio(it.getProduto().getPercIndiceMisturaBioDiesel());
        }
        c.setEncerrante(this.getEncerrantes(it, nf));
        c.setCide(this.getCide(it, nf));
        return c;
    }

    protected List<NFeNotaFiscalPropriaItem> getItens(List<ItemNotaFiscalPropria> itens, NotaFiscalPropria nf) {
        LinkedList<NFeNotaFiscalPropriaItem> ret = new LinkedList<NFeNotaFiscalPropriaItem>();
        itens = this.ordenarItensPorNrSequencial(nf.getItensNotaPropria());
        for (ItemNotaFiscalPropria it : itens) {
            NFeNotaFiscalPropriaItem i = new NFeNotaFiscalPropriaItem();
            i.setImposto(this.getImpostoItem(it, nf));
            i.setImpostoDevolvido(this.itemOutros.getImpostoDevolvido(it));
            i.setNumeroItem(it.getNumeroItem());
            i.setInformacoesAdicionais(ToolString.build((String)" ", (String[])new String[]{it.getInfAdicionalItemSistema(), it.getInfAdicionalItem(), this.getInfAdicionalProdutoParametrizacaoNomeXML(nf.getUnidadeFatCliente().getCliente(), it.getProduto())}));
            i.setProduto(this.getProdutoItem(it, nf));
            ret.add(i);
        }
        return ret;
    }

    private List<ItemNotaFiscalPropria> ordenarItensPorNrSequencial(List<ItemNotaFiscalPropria> itensNotaPropria) {
        Collections.sort(itensNotaPropria, (item1, item2) -> item1.getNumeroItem().compareTo(item2.getNumeroItem()));
        return itensNotaPropria;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto getImpostoItem(ItemNotaFiscalPropria it, NotaFiscalPropria nf) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto imp = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto(this.itemIpi.getItemSujeitoIPI(nf), EnumConstantsMentorSimNao.SIM, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.SIM, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.SIM, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO);
        imp.setCofins(this.itemCofins.getCofins(it));
        imp.setCofinsst(this.itemCofins.getCofinsST(it));
        imp.setIcms(this.itemIcms.getIcms(it, nf));
        imp.setIcmsUfDestino(this.itemIcms.getIcmsUFDestino(it, nf));
        imp.setPis(this.itemPis.getPis(it));
        imp.setPisst(this.itemPis.getPisST(it));
        imp.setIpi(this.itemIpi.getIpi(it, nf));
        imp.setImpostoImportacao(this.itemOutros.getImpostoImportacao(it));
        imp.setIssqn(this.itemOutros.getImpostoIsssqn(it));
        imp.setValorTotalTributos(it.getItemNotaLivroFiscal().getVlrImpostosEstimado());
        return imp;
    }

    public boolean isValidCodigoANP(String codANP) {
        return codANP.equals("210203001") || codANP.equals("320101001") || codANP.equals("320101002") || codANP.equals("320102002") || codANP.equals("320102001") || codANP.equals("320102003") || codANP.equals("820101032") || codANP.equals("820101027") || codANP.equals("820101004") || codANP.equals("820101005") || codANP.equals("820101022") || codANP.equals("820101031") || codANP.equals("820101030") || codANP.equals("820101018") || codANP.equals("820101020") || codANP.equals("820101021") || codANP.equals("420105001") || codANP.equals("420101005") || codANP.equals("420101004") || codANP.equals("420102005") || codANP.equals("820101003") || codANP.equals("820101012") || codANP.equals("420106002") || codANP.equals("830101001") || codANP.equals("420202001") || codANP.equals("420301001") || codANP.equals("510101002") || codANP.equals("510102002") || codANP.equals("510201001") || codANP.equals("510201003") || codANP.equals("510301003") || codANP.equals("510103001") || codANP.equals("510301001") || codANP.equals("820101026") || codANP.equals("320102005") || codANP.equals("320201001") || codANP.equals("320103001") || codANP.equals("220102001") || codANP.equals("320301001") || codANP.equals("320103002") || codANP.equals("820101019") || codANP.equals("820101014") || codANP.equals("820101006") || codANP.equals("820101016") || codANP.equals("820101015") || codANP.equals("820101025") || codANP.equals("820101017") || codANP.equals("820101013") || codANP.equals("420102004") || codANP.equals("420104001") || codANP.equals("820101033") || codANP.equals("820101034") || codANP.equals("420106001") || codANP.equals("820101011") || codANP.equals("510102001") || codANP.equals("420301002") || codANP.equals("410103001") || codANP.equals("410101001") || codANP.equals("410102001") || codANP.equals("430101004") || codANP.equals("510101001");
    }

    public boolean informarEncerranteByCodigoANP(String codigoANP) {
        return codigoANP.equals("810101002") || codigoANP.equals("810101001") || codigoANP.equals("220101005") || codigoANP.equals("220101006") || codigoANP.equals("320103001") || codigoANP.equals("320102002") || codigoANP.equals("320102001") || codigoANP.equals("320102003") || codigoANP.equals("820101033") || codigoANP.equals("820101034") || codigoANP.equals("420106001") || codigoANP.equals("820101011") || codigoANP.equals("820101003") || codigoANP.equals("820101013") || codigoANP.equals("820101012") || codigoANP.equals("420106002") || codigoANP.equals("420301004");
    }

    public String getUfConsumoComb(Cfop cf, UnidadeFederativa uf) {
        String cfop;
        if (cf != null && ((cfop = cf.getCodigo()).equals("1.651") || cfop.equals("1.652") || cfop.equals("1.653") || cfop.equals("1.658") || cfop.equals("1.659") || cfop.equals("1.660") || cfop.equals("1.661") || cfop.equals("1.662") || cfop.equals("1.663") || cfop.equals("1.664") || cfop.equals("2.651") || cfop.equals("2.652") || cfop.equals("2.653") || cfop.equals("2.658") || cfop.equals("2.659") || cfop.equals("2.660") || cfop.equals("2.661") || cfop.equals("2.662") || cfop.equals("2.663") || cfop.equals("2.664") || cfop.equals("3.651") || cfop.equals("3.652") || cfop.equals("3.653") || cfop.equals("5.651") || cfop.equals("5.652") || cfop.equals("5.653") || cfop.equals("5.654") || cfop.equals("5.655") || cfop.equals("5.656") || cfop.equals("5.657") || cfop.equals("5.658") || cfop.equals("5.659") || cfop.equals("5.660") || cfop.equals("5.661") || cfop.equals("5.662") || cfop.equals("5.663") || cfop.equals("5.664") || cfop.equals("5.665") || cfop.equals("5.666") || cfop.equals("5.667") || cfop.equals("6.651") || cfop.equals("6.652") || cfop.equals("6.653") || cfop.equals("6.654") || cfop.equals("6.655") || cfop.equals("6.656") || cfop.equals("6.657") || cfop.equals("6.658") || cfop.equals("6.659") || cfop.equals("6.660") || cfop.equals("6.661") || cfop.equals("6.662") || cfop.equals("6.663") || cfop.equals("6.664") || cfop.equals("6.665") || cfop.equals("6.666") || cfop.equals("6.667") || cfop.equals("7.651") || cfop.equals("7.654") || cfop.equals("7.667"))) {
            return uf.getSigla();
        }
        return null;
    }

    private String getCodigoIBGEUF(String siglaUF) {
        if (!ToolMethods.isStrWithData((String)siglaUF)) {
            return null;
        }
        EnumConstUF uf = EnumConstUF.valueOfSigla((String)siglaUF);
        if (uf == null) {
            return null;
        }
        return uf.getCodigoIbge();
    }

    private UnidadeFederativa getUF(NotaFiscalPropria it) {
        UnidadeFederativa uf = null;
        uf = it.getUnidadeFatCliente() != null ? it.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf() : it.getEmpresa().getPessoa().getEndereco().getCidade().getUf();
        return uf;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel.NFeNotaInfoItemProdutoCombustivelEncerrante getEncerrantes(ItemNotaFiscalPropria it, NotaFiscalPropria nf) {
        if (!this.informarEncerranteByCodigoANP(it.getProduto().getClassificacaoProdutoANP().getCodigo()) || !ToolMethods.isEquals((Object)nf.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
            return null;
        }
        if (it.getPreAbastecimento() == null) {
            return null;
        }
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel.NFeNotaInfoItemProdutoCombustivelEncerrante enc = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel.NFeNotaInfoItemProdutoCombustivelEncerrante();
        enc.setNumeroTanque(it.getPreAbastecimento().getBico().getTanqueCombustivel().getNumeroTanque().toString());
        enc.setNumeroBico(it.getPreAbastecimento().getBico().getCodigo());
        enc.setNumeroBomba(it.getPreAbastecimento().getBico().getBombaCombustivel().getNumeroBomba().toString());
        enc.setValorEncerramentoInicial(Double.valueOf(it.getPreAbastecimento().getValorEncerrante() - it.getPreAbastecimento().getQuantidade()));
        enc.setValorEncerramentoFinal(it.getPreAbastecimento().getValorEncerrante());
        return enc;
    }

    private Double formatarNumerosNullCaso0(Double num) {
        if (num == null) {
            num = 0.0;
        }
        if (num == 0.0) {
            return null;
        }
        return num;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel.NFeNotaInfoItemProdutoCombustivelCIDE getCide(ItemNotaFiscalPropria it, NotaFiscalPropria nf) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel.NFeNotaInfoItemProdutoCombustivelCIDE ci = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel.NFeNotaInfoItemProdutoCombustivelCIDE();
        ci.setQuantidadeBCCIDE(it.getItemNotaLivroFiscal().getQuantidadeBCCIDE());
        ci.setValorAliquota(it.getItemNotaLivroFiscal().getAliquotaCIDE());
        ci.setValor(it.getItemNotaLivroFiscal().getValorCIDE());
        return ci;
    }

    private List<NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoDeclaracaoImportacao> getDeclaracoesImportacao(ItemNotaFiscalPropria it, NotaFiscalPropria nf) {
        if (it.getItemNotaImportacao() == null) {
            return null;
        }
        LinkedList<NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoDeclaracaoImportacao> di = new LinkedList<NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoDeclaracaoImportacao>();
        for (DetImportacaoItem det : it.getItemNotaImportacao().getDetimportacaoItem()) {
            NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoDeclaracaoImportacao d = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoDeclaracaoImportacao();
            d.setNumeroRegistro(det.getNumDocImportacao());
            d.setDataRegistro(ToolDate.formatarLocalDate((Date)det.getDataRegDocImp()));
            d.setLocalDesembaraco(det.getLocalDesembaraco());
            if (det.getUfDesembaraco() != null) {
                d.setUfDesembaraco(this.getCodigoIBGEUF(det.getUfDesembaraco().getSigla()));
            }
            d.setDataDesembaraco(ToolDate.formatarLocalDate((Date)det.getDataDesembaraco()));
            d.setTransporteInternacional(ConstNFeViaTransporteInternacional.valueOfCodigo((String)det.getViaTransporteDetImportacaoItem().getCodigo()));
            if (ToolMethods.isEquals((Object)d.getTransporteInternacional(), (Object)ConstNFeViaTransporteInternacional.MARITIMA)) {
                d.setValorAFRMM(det.getValorAFRMM());
            }
            d.setFormaImportacaoIntermediacao(ConstNFeFormaImportacaoIntermediacao.valueOfCodigo((String)String.valueOf(det.getTipoIntermedio())));
            if (det.getAdquirenteEncomendante() != null) {
                d.setCnpj(ToolString.onlyNumbers((String)det.getAdquirenteEncomendante().getComplemento().getCnpj()));
                d.setUfTerceiro(this.getCodigoIBGEUF(det.getAdquirenteEncomendante().getEndereco().getCidade().getUf().getSigla()));
            }
            if (det.getExportador() != null) {
                d.setCodigoExportador(det.getExportador().getIdentificador().toString());
            }
            this.setAdicoes(det, d);
            di.add(d);
        }
        return di;
    }

    private void setAdicoes(DetImportacaoItem det, NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoDeclaracaoImportacao d) {
        for (AdicoesImportacao a : det.getAdicoesImportacao()) {
            NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoDeclaracaoImportacao.NFeNotaInfoItemProdutoDeclaracaoImportacaoAdicao aa = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoDeclaracaoImportacao.NFeNotaInfoItemProdutoDeclaracaoImportacaoAdicao();
            if (a.getNrDaAdicao() != null) {
                aa.setNumero(Integer.valueOf(a.getNrDaAdicao().intValue()));
            }
            if (a.getNrSeqDaAdicao() != null) {
                aa.setSequencial(Integer.valueOf(a.getNrSeqDaAdicao().intValue()));
            }
            if (a.getFabricante() != null) {
                aa.setCodigoFabricante(a.getFabricante().getIdentificador().toString());
            }
            if (ToolMethods.isStrWithData((String)ToolString.onlyNumbers((String)a.getNrAtoConcessiorioDrawback()))) {
                aa.setNumeroAtoConcessorioDrawback(Long.valueOf(ToolString.onlyNumbers((String)a.getNrAtoConcessiorioDrawback())));
            }
            aa.setDesconto(a.getValorDesconto());
            d.getAdicoes().add(aa);
        }
    }

    private void setInfoEAN(NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto itemNF, ItemNotaFiscalPropria item, NotaFiscalPropria nf) {
        String cEAN = "";
        String cEANTrib = "";
        Cliente cliente = nf.getUnidadeFatCliente().getCliente();
        if (this.opcoesFaturamentoCliente != null) {
            cEAN = this.getCodigoBarrasParametrizacaoNomeXML(cliente, item.getProduto(), CODIGO_BARRAS_EAN);
            cEANTrib = this.getCodigoBarrasParametrizacaoNomeXML(cliente, item.getProduto(), CODIGO_BARRAS_EAN_TRIB);
        }
        for (CodigoBarras c : item.getProduto().getCodigoBarras()) {
            if (!ToolMethods.isStrWithData((String)cEAN) && c.getUsarComoCodigoPrinc() != null && c.getUsarComoCodigoPrinc() == 1) {
                cEAN = ToolString.clearSpecialCharacXML((String)c.getCodigoBarras());
            }
            if (ToolMethods.isStrWithData((String)cEANTrib) || c.getUsarComoCodPrincTrib() == null || c.getUsarComoCodPrincTrib() != 1) continue;
            cEANTrib = ToolString.clearSpecialCharacXML((String)c.getCodigoBarras());
        }
        if (!cEAN.isEmpty() && !cEANTrib.isEmpty()) {
            itemNF.setCodigoDeBarras(cEAN);
            itemNF.setCodigoDeBarrasTributavel(cEANTrib);
        }
        if (!ToolMethods.isStrWithData((String)itemNF.getCodigoDeBarras()) && ToolMethods.isStrWithData((String)itemNF.getCodigoDeBarrasTributavel())) {
            itemNF.setCodigoDeBarras("SEM GTIN");
            itemNF.setCodigoDeBarrasTributavel("SEM GTIN");
        }
    }

    private String getCodigoBarrasParametrizacaoNomeXML(Cliente cliente, Produto produto, Short tipoCodigoBarras) {
        if (this.opcoesFaturamentoCliente == null) {
            return "";
        }
        if (ToolMethods.isEquals((Object)this.opcoesFaturamentoCliente.getAplicarTodoCliente(), (Object)1)) {
            for (ParamNomeclaturaProdutoXML p : this.opcoesFaturamentoCliente.getProdutos()) {
                for (ItemParamNomeclaturaProdutoXML item : p.getItens()) {
                    if (!ToolMethods.isEquals((Object)item.getProduto(), (Object)produto)) continue;
                    if (ToolMethods.isEquals((Object)tipoCodigoBarras, (Object)CODIGO_BARRAS_EAN) && ToolMethods.isStrWithData((String)item.getCodigoBarrasEan())) {
                        return item.getCodigoBarrasEan();
                    }
                    if (!ToolMethods.isEquals((Object)tipoCodigoBarras, (Object)CODIGO_BARRAS_EAN_TRIB) || !ToolMethods.isStrWithData((String)item.getCodigoBarrasEanTrib())) continue;
                    return item.getCodigoBarrasEanTrib();
                }
            }
        }
        if (ToolMethods.isEquals((Object)this.opcoesFaturamentoCliente.getAplicarTodoCliente(), (Object)0)) {
            for (ParamNomeclaturaProdutoXML p : this.opcoesFaturamentoCliente.getProdutos()) {
                if (!ToolMethods.isEquals((Object)p.getCliente(), (Object)cliente)) continue;
                for (ItemParamNomeclaturaProdutoXML item : p.getItens()) {
                    if (!ToolMethods.isEquals((Object)item.getProduto(), (Object)produto)) continue;
                    if (ToolMethods.isEquals((Object)tipoCodigoBarras, (Object)CODIGO_BARRAS_EAN) && ToolMethods.isStrWithData((String)item.getCodigoBarrasEan())) {
                        return item.getCodigoBarrasEan();
                    }
                    if (!ToolMethods.isEquals((Object)tipoCodigoBarras, (Object)CODIGO_BARRAS_EAN_TRIB) || !ToolMethods.isStrWithData((String)item.getCodigoBarrasEanTrib())) continue;
                    return item.getCodigoBarrasEanTrib();
                }
            }
        }
        return "";
    }

    private void setCodigoProduto(NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto itemNF, ItemNotaFiscalPropria item, NotaFiscalPropria nf) {
        if (this.opcoesFaturamento.getUsarCodAuxNfe() != null && this.opcoesFaturamento.getUsarCodAuxNfe() == 1 && item.getProduto().getCodigoAuxiliar() != null && item.getProduto().getCodigoAuxiliar().trim().length() > 0) {
            itemNF.setCodigo(this.refinaXML(item.getProduto().getCodigoAuxiliar()));
        } else {
            itemNF.setCodigo(this.refinaXML(item.getProduto().getIdentificador().toString()));
        }
    }

    private void setNomeProduto(NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto itemNF, ItemNotaFiscalPropria item, NotaFiscalPropria nf) {
        Cliente cliente = nf.getUnidadeFatCliente().getCliente();
        Object nome = item.getProduto().getNome().trim();
        if (this.opcoesFaturamento.getConcCodBarrasItensNfDanfe() == 1 && ToolMethods.isStrWithData((String)itemNF.getCodigoDeBarras())) {
            nome = (String)nome + " - " + String.valueOf(item.getProduto().getCodigoBarras().get(0));
        }
        if (((String)nome).length() > 120) {
            nome = ((String)nome).substring(0, 120);
        }
        if (this.opcoesFaturamentoCliente != null) {
            itemNF.setDescricao(this.refinaXML(this.getNomeProdutoParametrizacaoNomeXML(cliente, item.getProduto(), (String)nome)));
        } else {
            itemNF.setDescricao(this.refinaXML((String)nome));
        }
    }

    private String getNomeProdutoParametrizacaoNomeXML(Cliente cliente, Produto produto, String nome) {
        if (this.opcoesFaturamentoCliente == null) {
            return nome;
        }
        if (ToolMethods.isEquals((Object)this.opcoesFaturamentoCliente.getAplicarTodoCliente(), (Object)1)) {
            for (ParamNomeclaturaProdutoXML p : this.opcoesFaturamentoCliente.getProdutos()) {
                for (ItemParamNomeclaturaProdutoXML item : p.getItens()) {
                    if (!ToolMethods.isEquals((Object)item.getProduto(), (Object)produto) || ToolMethods.isEquals((Object)item.getConcatInfAddProduto(), (Object)1)) continue;
                    return item.getDescricao();
                }
            }
        }
        if (ToolMethods.isEquals((Object)this.opcoesFaturamentoCliente.getAplicarTodoCliente(), (Object)0)) {
            for (ParamNomeclaturaProdutoXML p : this.opcoesFaturamentoCliente.getProdutos()) {
                if (!ToolMethods.isEquals((Object)p.getCliente(), (Object)cliente)) continue;
                for (ItemParamNomeclaturaProdutoXML item : p.getItens()) {
                    if (!ToolMethods.isEquals((Object)item.getProduto(), (Object)produto) || ToolMethods.isEquals((Object)item.getConcatInfAddProduto(), (Object)1)) continue;
                    return item.getDescricao();
                }
            }
        }
        return nome;
    }

    private String refinaXML(String to) {
        String str = ToolString.clearSpecialCharacXML((String)to);
        str = str != null && str.trim().length() > 0 ? str : null;
        return str;
    }

    private void setInfoUnidadeMedida(NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto p, ItemNotaFiscalPropria i, NotaFiscalPropria nf) {
        EnumConstNFeFinalidadeEmissao tipo = EnumConstNFeFinalidadeEmissao.get((Object)nf.getFinalidadeEmNFe().getCodigo());
        if (i.getUnidadeMedidaCom() != null && (ToolMethods.isWithData((Number)i.getQuantidadeTotalCom()) || tipo.isComplementar()) && ToolMethods.isWithData((Number)i.getValorUnitarioCom())) {
            p.setUnidadeComercial(i.getUnidadeMedidaCom().getSigla());
            p.setQuantidadeComercial(i.getQuantidadeTotalCom());
            p.setValorUnitario(i.getValorUnitarioCom());
        } else {
            p.setUnidadeComercial(i.getProduto().getUnidadeMedida().getSigla());
            p.setQuantidadeComercial(i.getQuantidadeTotal());
            p.setValorUnitario(i.getValorUnitario());
        }
        if (i.getUnidadeMedidaTrib() != null && (ToolMethods.isWithData((Number)i.getQuantidadeTotalTrib()) || tipo.isComplementar()) && ToolMethods.isWithData((Number)i.getValorUnitarioTrib())) {
            p.setUnidadeTributavel(i.getUnidadeMedidaTrib().getSigla());
            p.setQuantidadeTributavel(i.getQuantidadeTotalTrib());
            p.setValorUnitarioTributavel(i.getValorUnitarioTrib());
        } else {
            p.setUnidadeTributavel(i.getProduto().getUnidadeMedida().getSigla());
            p.setQuantidadeTributavel(i.getQuantidadeTotal());
            p.setValorUnitarioTributavel(i.getValorUnitario());
        }
    }

    private void setDetalhesExportacao(NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto p, ItemNotaFiscalPropria i, NotaFiscalPropria nf) {
        LinkedList<NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemDetalheExportacao> lista = new LinkedList<NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemDetalheExportacao>();
        for (ItemNotaExportacao itemExp : i.getItensExportacao()) {
            NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemDetalheExportacao exp = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemDetalheExportacao();
            if (ToolMethods.isStrWithData((String)ToolString.onlyNumbers((String)itemExp.getNrAtoConcessorioDrawback()))) {
                exp.setAtoConcessorioDrawback(Long.valueOf(ToolString.onlyNumbers((String)itemExp.getNrAtoConcessorioDrawback())));
            }
            NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemDetalheExportacao.NFeNotaInfoItemExportacaoIndireta ex = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemDetalheExportacao.NFeNotaInfoItemExportacaoIndireta();
            ex.setChaveAcessoNFe(itemExp.getChaveNFeRecExportacao());
            if (ToolMethods.isStrWithData((String)ToolString.onlyNumbers((String)itemExp.getNrRegistroExportacao()))) {
                ex.setNumeroRegistroExportacao(Long.valueOf(ToolString.onlyNumbers((String)itemExp.getNrRegistroExportacao())));
            }
            ex.setQuantidadeItemEfetivamenteExportado(i.getQuantidadeTotal());
            exp.setExportacaoIndireta(ex);
            lista.add(exp);
        }
        p.setDetalhesExportacao(lista);
    }

    private String getInfAdicionalProdutoParametrizacaoNomeXML(Cliente cliente, Produto produto) {
        if (this.opcoesFaturamentoCliente == null) {
            return "";
        }
        if (ToolMethods.isEquals((Object)this.opcoesFaturamentoCliente.getAplicarTodoCliente(), (Object)1)) {
            for (ParamNomeclaturaProdutoXML p : this.opcoesFaturamentoCliente.getProdutos()) {
                for (ItemParamNomeclaturaProdutoXML item : p.getItens()) {
                    if (!ToolMethods.isEquals((Object)item.getProduto(), (Object)produto) || !ToolMethods.isEquals((Object)item.getConcatInfAddProduto(), (Object)1)) continue;
                    return item.getDescricao();
                }
            }
        }
        if (ToolMethods.isEquals((Object)this.opcoesFaturamentoCliente.getAplicarTodoCliente(), (Object)0)) {
            for (ParamNomeclaturaProdutoXML p : this.opcoesFaturamentoCliente.getProdutos()) {
                if (!ToolMethods.isEquals((Object)p.getCliente(), (Object)cliente)) continue;
                for (ItemParamNomeclaturaProdutoXML item : p.getItens()) {
                    if (!ToolMethods.isEquals((Object)item.getProduto(), (Object)produto) || !ToolMethods.isEquals((Object)item.getConcatInfAddProduto(), (Object)1)) continue;
                    return item.getDescricao();
                }
            }
        }
        return "";
    }
}

