/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.notafiscaleletronica;

import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.constants.enums.modelodocfiscal.EnumConstModDocFiscal;
import com.touchcomp.basementor.constants.enums.nfe.ConstantsNFeResponsavelTecnico;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFTipoProcessamento;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeFinalidade;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIdentificacaoLocalDestOperacao;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIndicadorIEDest;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIndicadorPresenca;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIntermediadorComerical;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeMeioPagamento;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeModalidadeFrete;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeOperacaoConsumidorFinal;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeOperadoraCartao;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeProgramaEmissor;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeTipoEmissao;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeTipoEntSai;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeTipoImpressao;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeTipoIntegracaoPagamento;
import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.DadosFiscaisUF;
import com.touchcomp.basementor.model.vo.DocumentosRefNFPropriaPR;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.GrupoDocumentosRefPR;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.LacreVolumeNFe;
import com.touchcomp.basementor.model.vo.LocalEntregaNFPropria;
import com.touchcomp.basementor.model.vo.LoteFaturamentoNFe;
import com.touchcomp.basementor.model.vo.NFeAutDownloadXML;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObservacaoNotaPropria;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.TipoEmissaoNFe;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.VolumeNFe;
import com.touchcomp.basementorclientwebservices.nfe.model.env.lotefat.NFeLoteFaturamento;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropria;
import com.touchcomp.basementorservice.helpers.impl.cfop.HelperCfop;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.dadosfiscaisuf.ServiceDadosFiscaisUFImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class SCompEnvioLoteFatNFe
extends ServiceGenericImpl {
    private HelperCfop helperCFOP;
    private ServiceDadosFiscaisUFImpl serviceDadosFiscaisUF;

    public SCompEnvioLoteFatNFe(HelperCfop helperCFOP, ServiceDadosFiscaisUFImpl serviceDadosFiscaisUF) {
        this.helperCFOP = helperCFOP;
        this.serviceDadosFiscaisUF = serviceDadosFiscaisUF;
    }

    public NFeLoteFaturamento criarNotaEnvio(LoteFaturamentoNFe loteNotas, String versaoAppEmissorNFe) {
        OpcoesFaturamento opcoesFat = this.getSharedData().getOpcoesFaturamento(loteNotas.getEmpresa());
        NFeLoteFaturamento lote = new NFeLoteFaturamento();
        lote.setIdentificador(loteNotas.getIdentificador());
        lote.setTipoProcessamento(ConstNFTipoProcessamento.PROCESSAMENTO_SINCRONO);
        lote.setVersao(loteNotas.getVersaoNFe().getCodigo());
        for (NotaFiscalPropria nf : loteNotas.getNotasFiscais()) {
            lote.getNotas().add(this.criarNota(nf, opcoesFat, versaoAppEmissorNFe));
        }
        return lote;
    }

    private NFeNotaFiscalPropria criarNota(NotaFiscalPropria notaPropria, OpcoesFaturamento opcoesFat, String versaoAppEmissorNFe) {
        NFeNotaFiscalPropria nf = new NFeNotaFiscalPropria();
        nf.setEmitente(this.getEmitente(notaPropria));
        nf.setVersaoNFe(notaPropria.getVersaoNfe().getCodigo());
        nf.setIdentificador(notaPropria.getIdentificador());
        nf.setIdentificacao(this.getIdentificacao(notaPropria, opcoesFat, versaoAppEmissorNFe));
        nf.setInfoDestinatario(this.getDestinatario(notaPropria, notaPropria.getUnidadeFatCliente()));
        nf.setInfoPagamento(this.getInfoPagamento(notaPropria));
        nf.setInfoCobranca(this.getInfoCobranca(notaPropria));
        nf.setInfoTransporte(this.getInfoTransporte(notaPropria));
        nf.setLocalRetirada(this.getInfoLocalRetirada(notaPropria));
        nf.setInfoCompra(this.getInfoCompra(notaPropria));
        nf.setTotal(this.getTotal(notaPropria));
        nf.setChaveNFe(notaPropria.getChaveNFE());
        nf.setPessoasAutorizadasDowXML(this.getPessoasAutoXML(notaPropria));
        nf.setEnderecoEntrega(this.getEnderecoEntrega(notaPropria));
        nf.setRespTecnico(this.getRespTecnico(notaPropria));
        nf.setInformacoesAdicionais(this.getInfoAdicionais(notaPropria));
        nf.setIntermediadorComercial(this.getIntermediador(notaPropria));
        nf.setInfoExportacao(this.getInfoExportacao(notaPropria));
        return nf;
    }

    private NFeNotaFiscalPropria.NFIntermediadorComercial getIntermediador(NotaFiscalPropria nf) {
        if (nf.getIntermediadorComercial() == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFIntermediadorComercial aux = new NFeNotaFiscalPropria.NFIntermediadorComercial();
        aux.setCnpj(nf.getIntermediadorComercial().getPessoa().getComplemento().getCnpj());
        aux.setIdentificadorIntermediador(nf.getIntermediadorComercial().getIdentificacaoIntermediador());
        return aux;
    }

    private NFeNotaFiscalPropria.NFeNotaInfoRespTecnico getRespTecnico(NotaFiscalPropria nf) {
        NFeNotaFiscalPropria.NFeNotaInfoRespTecnico respTecnico = new NFeNotaFiscalPropria.NFeNotaInfoRespTecnico();
        respTecnico.setCnpj(ConstantsNFeResponsavelTecnico.CNPJ);
        respTecnico.setContatoNome(ConstantsNFeResponsavelTecnico.CONTATO);
        respTecnico.setEmail(ConstantsNFeResponsavelTecnico.EMAIL);
        respTecnico.setTelefone(ConstantsNFeResponsavelTecnico.TELEFONE);
        return respTecnico;
    }

    private NFeNotaFiscalPropria.NFeNotaInfoPagamento getInfoPagamento(NotaFiscalPropria nf) {
        NFeNotaFiscalPropria.NFeNotaInfoPagamento infoPag = new NFeNotaFiscalPropria.NFeNotaInfoPagamento();
        LinkedList<NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento> pagamentos = new LinkedList<NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento>();
        for (InfPagamentoNfPropria i : nf.getInfPagamentoNfPropria()) {
            this.setInfPag(i, pagamentos);
        }
        return infoPag;
    }

    private void setInfPag(InfPagamentoNfPropria i, List<NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento> pagamentos) {
        if (ToolMethods.isEquals((Object)i.getTipoPagRetido(), (Object)1) || ToolMethods.isEquals((Object)i.getTipoPagDifal(), (Object)1)) {
            return;
        }
        NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento d = new NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento();
        d.setMeioPagamento(ConstNFeMeioPagamento.valueOfCodigo((String)i.getTipoPagamentoNFe().getCodigo()));
        if (!ToolMethods.isEquals((Object)i.getTipoPagamentoNFe().getCodigo(), (Object)"90")) {
            d.setValorPagamento(i.getValor());
        } else {
            d.setValorPagamento(Double.valueOf(0.0));
        }
        if (ToolMethods.isEquals((Object)i.getTipoPagamentoNFe().getCodigo(), (Object)"99")) {
            d.setDescricaoMeioPagamento(i.getCondicoesPagamento().getNome());
        }
        if (ToolMethods.isEqualsNumber((Number)i.getTipoPagamentoNFe().getCartaoDebCred(), (Number)1)) {
            NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento.NFeNotaInfoCartao c = new NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento.NFeNotaInfoCartao();
            if (i.getBandeiraCartaoNFe() != null) {
                c.setOperadoraCartao(ConstNFeOperadoraCartao.valueOf((String)i.getBandeiraCartaoNFe().getCodigo()));
            }
            if (ToolMethods.isAffirmative((Number)i.getTipoIntegracao())) {
                c.setTipoIntegracao(ConstNFeTipoIntegracaoPagamento.INTEGRADO);
            } else {
                c.setTipoIntegracao(ConstNFeTipoIntegracaoPagamento.SEPARADO);
            }
            if (i.getNrAutorizacao() != null && !i.getNrAutorizacao().isEmpty()) {
                c.setNumeroAutorizacaoOperacaoCartao(i.getNrAutorizacao());
            }
            if (i.getCredenciadoraCreditoDebito() != null) {
                c.setCnpj(i.getCredenciadoraCreditoDebito().getComplemento().getCnpj());
            }
            d.setCartao(c);
        }
        pagamentos.add(d);
    }

    private NFeNotaFiscalPropria.NFeNotaInfoTransporte getInfoTransporte(NotaFiscalPropria notaPropria) {
        NFeNotaFiscalPropria.NFeNotaInfoTransporte ret = new NFeNotaFiscalPropria.NFeNotaInfoTransporte();
        ret.setModalidadeFrete(ConstNFeModalidadeFrete.valueOfCodigo((String)notaPropria.getDadosTransNfPropria().getTipoFrete().getFretePorConta().toString()));
        if (ToolMethods.isEquals((Object)notaPropria.getDadosTransNfPropria().getTipoFrete().getFretePorConta(), (Object)9)) {
            return ret;
        }
        if (notaPropria.getDadosTransNfPropria() == null) {
            return ret;
        }
        this.setInfoTransportador(notaPropria, ret);
        this.setVeiculos(notaPropria, ret);
        this.setReboques(notaPropria, ret);
        this.setVolumes(notaPropria, ret);
        return ret;
    }

    private NFeNotaFiscalPropria.NFeNotaInfoTotal getTotal(NotaFiscalPropria nf) {
        double valorProduto = 0.0;
        double valorServico = 0.0;
        double valorTotalServico = 0.0;
        double valorFrete = 0.0;
        double valorSeguro = 0.0;
        double valorDesconto = 0.0;
        double valorDespAcessoria = 0.0;
        double bcICMS = 0.0;
        double valorIss = 0.0;
        double valorIcms = 0.0;
        double valorIcmsST = 0.0;
        double valorIcmsDesonerado = 0.0;
        double bcICMST = 0.0;
        double valorIPI = 0.0;
        double valorTotal = 0.0;
        double valorPis = 0.0;
        double valorCofins = 0.0;
        double valorPisST = 0.0;
        double valorCofinsST = 0.0;
        double valorContSocial = 0.0;
        double valorIRRF = 0.0;
        double valorInss = 0.0;
        double bcInss = 0.0;
        double bcIrrf = 0.0;
        double valorPisServ = 0.0;
        double valorCofinsServ = 0.0;
        double valorImpostoImportacao = 0.0;
        double valorImpEst = 0.0;
        double valorIcmsFundoPobreza = 0.0;
        double valorIcmsUFRem = 0.0;
        double valorIcmsUFDest = 0.0;
        double valorFCP = 0.0;
        double valorFCPSt = 0.0;
        double valorFCPStRetido = 0.0;
        double valorIpiDevolucao = 0.0;
        for (ItemNotaFiscalPropria vo : nf.getItensNotaPropria()) {
            String codigo = vo.getIncidenciaIcms().getCodigo().substring(1);
            if (vo.getVrServico() > 0.0 && vo.getItemNotaLivroFiscal().getVrIss() > 0.0) {
                valorServico += vo.getVrServico().doubleValue();
                valorTotalServico += vo.getItemNotaLivroFiscal().getValorTotal().doubleValue();
                if (vo.getItemNotaLivroFiscal().getVrIss() > 0.0) {
                    valorIss += vo.getItemNotaLivroFiscal().getVrIss().doubleValue();
                    valorPisServ += vo.getItemNotaLivroFiscal().getVrPis().doubleValue();
                    valorCofinsServ += vo.getItemNotaLivroFiscal().getVrCofins().doubleValue();
                } else {
                    valorPis += vo.getItemNotaLivroFiscal().getVrPis().doubleValue();
                    valorCofins += vo.getItemNotaLivroFiscal().getVrCofins().doubleValue();
                }
            } else {
                valorProduto += vo.getVrProduto().doubleValue();
                valorServico += vo.getVrServico().doubleValue();
                if (vo.getItemNotaLivroFiscal().getVrIcms() > 0.0 && vo.getItemNotaLivroFiscal().getVrIcmsTributado() <= 0.0) {
                    bcICMS += vo.getItemNotaLivroFiscal().getVrBcCalculoIcms().doubleValue();
                }
                bcICMS += vo.getItemNotaLivroFiscal().getVrIcmsTributado().doubleValue();
                if (ToolMethods.isEquals((Object)codigo, (Object)"51") && vo.getItemNotaLivroFiscal().getValorIcmsDiferimento() > 0.0) {
                    bcICMS += vo.getItemNotaLivroFiscal().getVrIcmsOutros().doubleValue();
                }
                bcICMST += vo.getItemNotaLivroFiscal().getVrBcCalculoIcmsSt().doubleValue();
                valorIPI += vo.getItemNotaLivroFiscal().getVrIpiIndustria().doubleValue();
                valorTotal += vo.getItemNotaLivroFiscal().getValorTotal().doubleValue();
                valorIcms += vo.getItemNotaLivroFiscal().getVrIcms().doubleValue();
                valorIcmsST += vo.getItemNotaLivroFiscal().getVrIcmsSt().doubleValue();
                valorIcmsDesonerado += vo.getItemNotaLivroFiscal().getVrIcmsDesonerado().doubleValue();
                valorPis += vo.getItemNotaLivroFiscal().getVrPis().doubleValue();
                valorCofins += vo.getItemNotaLivroFiscal().getVrCofins().doubleValue();
                valorImpostoImportacao += vo.getItemNotaLivroFiscal().getVrImpostoImportacao().doubleValue();
                if (vo.getIssRetido() != null && vo.getIssRetido() != 2) {
                    valorIss += vo.getItemNotaLivroFiscal().getVrIss().doubleValue();
                }
            }
            valorFrete += vo.getValorFrete().doubleValue();
            valorSeguro += vo.getVrSeguro().doubleValue();
            valorDesconto += vo.getValorDesconto().doubleValue();
            valorDespAcessoria += vo.getValorDespAcessoria().doubleValue();
            valorPisST += vo.getItemNotaLivroFiscal().getVrPisSt().doubleValue();
            valorCofinsST += vo.getItemNotaLivroFiscal().getVrCofinsSt().doubleValue();
            valorContSocial += vo.getItemNotaLivroFiscal().getVrContSoc().doubleValue();
            valorIRRF += vo.getItemNotaLivroFiscal().getVrIrrf().doubleValue();
            if (vo.getItemNotaLivroFiscal().getVrIrrf() > 0.0) {
                bcIrrf += vo.getItemNotaLivroFiscal().getValorTotal().doubleValue();
            }
            valorInss += vo.getItemNotaLivroFiscal().getVrInss().doubleValue();
            if (vo.getItemNotaLivroFiscal().getVrInss() > 0.0) {
                bcInss += vo.getItemNotaLivroFiscal().getValorTotal().doubleValue();
            }
            if (vo.getItemNotaLivroFiscal().getValorIcmsPartilhaRem() != null && vo.getItemNotaLivroFiscal().getValorIcmsPartilhaRem() >= 0.0) {
                valorIcmsUFRem += vo.getItemNotaLivroFiscal().getValorIcmsPartilhaRem().doubleValue();
            }
            if (vo.getItemNotaLivroFiscal().getValorIcmsPartilhaDest() != null && vo.getItemNotaLivroFiscal().getValorIcmsPartilhaDest() >= 0.0) {
                valorIcmsUFDest += vo.getItemNotaLivroFiscal().getValorIcmsPartilhaDest().doubleValue();
            }
            if (vo.getItemNotaLivroFiscal().getValorFundoPobreza() != null) {
                valorIcmsFundoPobreza += vo.getItemNotaLivroFiscal().getValorFundoPobreza().doubleValue();
            }
            if (vo.getItemNotaLivroFiscal().getValorFCP() != null) {
                valorFCP += vo.getItemNotaLivroFiscal().getValorFCP().doubleValue();
            }
            if (vo.getItemNotaLivroFiscal().getValorFCPSt() != null) {
                valorFCPSt += vo.getItemNotaLivroFiscal().getValorFCPSt().doubleValue();
            }
            if (vo.getItemNotaLivroFiscal().getValorFCPStRetido() != null) {
                valorFCPStRetido += vo.getItemNotaLivroFiscal().getValorFCPStRetido().doubleValue();
            }
            if (vo.getItemNotaLivroFiscal().getValorIpiDevolucao() != null) {
                valorIpiDevolucao += vo.getItemNotaLivroFiscal().getValorIpiDevolucao().doubleValue();
            }
            valorImpEst += vo.getItemNotaLivroFiscal().getVlrImpostosEstimado().doubleValue();
        }
        NFeNotaFiscalPropria.NFeNotaInfoTotal tot = new NFeNotaFiscalPropria.NFeNotaInfoTotal();
        NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoICMSTotal icms = new NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoICMSTotal();
        icms.setBaseCalculoICMS(Double.valueOf(bcICMS));
        icms.setValorTotalICMS(Double.valueOf(valorIcms));
        icms.setValorICMSDesonerado(Double.valueOf(valorIcmsDesonerado));
        icms.setBaseCalculoICMSST(Double.valueOf(bcICMST));
        icms.setValorTotalICMSST(Double.valueOf(valorIcmsST));
        icms.setValorTotalDosProdutosServicos(Double.valueOf(valorProduto + valorServico));
        icms.setValorTotalFrete(Double.valueOf(valorFrete));
        icms.setValorTotalSeguro(Double.valueOf(valorSeguro));
        icms.setValorTotalDesconto(Double.valueOf(valorDesconto));
        icms.setValorTotalII(Double.valueOf(valorImpostoImportacao));
        icms.setValorTotalIPI(Double.valueOf(valorIPI));
        icms.setValorPIS(Double.valueOf(valorPis));
        icms.setValorCOFINS(Double.valueOf(valorCofins));
        icms.setOutrasDespesasAcessorias(Double.valueOf(valorDespAcessoria));
        icms.setValorTotalNFe(Double.valueOf(valorTotal + valorTotalServico));
        icms.setValorTotalTributos(Double.valueOf(valorImpEst));
        icms.setValorICMSFundoCombatePobreza(Double.valueOf(valorIcmsFundoPobreza));
        icms.setValorICMSPartilhaDestinatario(Double.valueOf(valorIcmsUFDest));
        icms.setValorICMSPartilhaRementente(Double.valueOf(valorIcmsUFRem));
        icms.setValorTotalFundoCombatePobreza(Double.valueOf(valorFCP));
        icms.setValorTotalFundoCombatePobrezaST(Double.valueOf(valorFCPSt));
        icms.setValorTotalFundoCombatePobrezaSTRetido(Double.valueOf(valorFCPStRetido));
        icms.setValorTotalIPIDevolvido(Double.valueOf(0.0));
        tot.setIcmsTotal(icms);
        if (ToolMethods.isWithData((Number)valorTotalServico)) {
            NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoISSQNTotal iss = new NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoISSQNTotal();
            iss.setValorTotalServicosSobNaoIncidenciaNaoTributadosICMS(Double.valueOf(valorServico));
            iss.setBaseCalculoISS(Double.valueOf(valorTotalServico));
            iss.setValorTotalISS(Double.valueOf(valorIss));
            iss.setValorPISsobreServicos(Double.valueOf(valorPisServ));
            iss.setValorCOFINSsobreServicos(Double.valueOf(valorCofinsServ));
            iss.setDataPrestacaoServico(ToolDate.formatarLocalDate((Date)nf.getDataEmissaoNota()));
            tot.setIssqnTotal(iss);
        }
        if (valorPisST > 0.0 || valorCofinsST > 0.0 || valorContSocial > 0.0 || valorIRRF > 0.0 || valorInss > 0.0) {
            NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoRetencoesTributos ret = new NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoRetencoesTributos();
            ret.setValorRetidoPIS(Double.valueOf(valorPis));
            ret.setValorRetidoCOFINS(Double.valueOf(valorCofinsST));
            ret.setValorRetidoCSLL(Double.valueOf(valorContSocial));
            ret.setBaseCalculoIRRF(Double.valueOf(bcIrrf));
            ret.setValorRetidoIRRF(Double.valueOf(valorIRRF));
            ret.setBaseCalculoRetencaoPrevidenciaSocial(Double.valueOf(bcInss));
            ret.setValorRetencaoPrevidenciaSocial(Double.valueOf(valorInss));
            tot.setRetencoesTributos(ret);
        }
        if (valorIpiDevolucao > 0.0) {
            icms.setValorTotalIPIDevolvido(Double.valueOf(valorIpiDevolucao));
        }
        return tot;
    }

    private NFeNotaFiscalPropria.NFeDestinatario getDestinatario(NotaFiscalPropria nfce, UnidadeFatCliente unidadeFatCliente) {
        NFeNotaFiscalPropria.NFeDestinatario dest = new NFeNotaFiscalPropria.NFeDestinatario();
        dest.setCnpjCpf(nfce.getUnidadeFatCliente().getPessoa().getComplemento().getCnpj());
        dest.setEmail(this.getEmail(nfce));
        dest.setEndereco(this.getEndereco(unidadeFatCliente.getPessoa().getEndereco(), this.getTelefone(nfce.getUnidadeFatCliente().getCliente().getPessoa().getComplemento())));
        if (unidadeFatCliente.getPessoa().getComplemento().getPassaporte() != null && !unidadeFatCliente.getPessoa().getComplemento().getPassaporte().isEmpty()) {
            dest.setIdEstrangeiro(unidadeFatCliente.getPessoa().getComplemento().getPassaporte());
        }
        dest.setIndicadorIEDestinatario(this.getIndicadorIEDest(nfce, unidadeFatCliente));
        if ((ToolMethods.isEquals((Object)dest.getIndicadorIEDestinatario(), (Object)ConstNFeIndicadorIEDest.CONTRIBUINTE_ICMS) || ToolMethods.isEquals((Object)dest.getIndicadorIEDestinatario(), (Object)ConstNFeIndicadorIEDest.NAO_CONTRIBUINTE)) && ToolMethods.isStrWithData((String)nfce.getUnidadeFatCliente().getPessoa().getComplemento().getInscEst())) {
            dest.setInscricaoEstadual(nfce.getUnidadeFatCliente().getPessoa().getComplemento().getInscEst());
        }
        dest.setInscricaoMunicipal(unidadeFatCliente.getPessoa().getComplemento().getInscricaoMunicipal());
        dest.setRazaoSocial(nfce.getUnidadeFatCliente().getPessoa().getNome());
        return dest;
    }

    private String getEmail(NotaFiscalPropria nfce) {
        if (nfce.getUnidadeFatCliente() != null) {
            for (EmailPessoa em : nfce.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getEmails()) {
                if (em.getAtivo() == null || em.getAtivo() != 1 || em.getEnviarDadosNfe() == null || em.getEnviarDadosNfe() != 1) continue;
                return em.getEmail();
            }
        }
        return null;
    }

    private NFeNotaFiscalPropria.NFeIdentificacao getIdentificacao(NotaFiscalPropria nf, OpcoesFaturamento opcoesFat, String versaoAppEmissorNFe) {
        NFeNotaFiscalPropria.NFeIdentificacao id = new NFeNotaFiscalPropria.NFeIdentificacao();
        id.setCodigoUf(nf.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge());
        id.setCodigoRandomico(ToolFormatter.completaZerosEsquerda((String)String.valueOf(nf.getCodChaveAcesso()), (int)8));
        id.setNaturezaOperacao(nf.getNaturezaOperacao().getDescricao());
        id.setModelo(EnumConstModDocFiscal.get((Object)nf.getModeloDocFiscal().getCodigo()));
        id.setSerie(nf.getSerie());
        id.setNumeroNota(Long.valueOf(nf.getNumeroNota().longValue()));
        id.setDataHoraEmissao(ZonedDateTime.ofInstant(nf.getDataEmissaoNota().toInstant(), ZoneId.systemDefault()));
        if (ToolMethods.isEquals((Object)nf.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo()) && nf.getDataEntradaSaida() != null) {
            id.setDataHoraSaidaOuEntrada(ZonedDateTime.ofInstant(this.getDataSaida(nf).toInstant(), ZoneId.systemDefault()));
        }
        if (ToolMethods.isEqualsNumber((Number)nf.getNaturezaOperacao().getEntradaSaida(), (Number)2)) {
            id.setTipo(ConstNFeTipoEntSai.ENTRADA);
        } else {
            id.setTipo(ConstNFeTipoEntSai.SAIDA);
        }
        id.setIdentificadorLocalDestinoOperacao(this.getIdentificadorDestOperacao(nf));
        id.setCodigoMunicipio(nf.getEmpresa().getPessoa().getEndereco().getCidade().getCodIbgeCompleto());
        id.setTipoImpressao(ConstNFeTipoImpressao.valueOfCodigo((String)nf.getFormatoImpressao().toString()));
        id.setTipoEmissao(this.getTipoEmissao(nf));
        if (!ToolMethods.isEquals((Object)id.getTipoEmissao(), (Object)ConstNFeTipoEmissao.EMISSAO_NORMAL)) {
            id.setDataHoraContigencia(ZonedDateTime.ofInstant(nf.getPeriodoEmissaoNFe().getDataInicial().toInstant(), ZoneId.systemDefault()));
            id.setJustificativaEntradaContingencia(ToolString.clearInvalidUTF8Char((String)nf.getPeriodoEmissaoNFe().getDescricao()));
        }
        id.setDigitoVerificador(nf.getDigitoVerificador());
        if (ToolMethods.isEqualsNumber((Number)opcoesFat.getTipoAmbiente(), (Number)ConstAmbiente.HOMOLOGACAO.getEnumId())) {
            id.setAmbiente(ConstAmbiente.HOMOLOGACAO);
        } else {
            id.setAmbiente(ConstAmbiente.PRODUCAO);
        }
        id.setFinalidade(ConstNFeFinalidade.valueOfCodigo((String)nf.getFinalidadeEmNFe().getDescricao()));
        id.setOperacaoConsumidorFinal(ConstNFeOperacaoConsumidorFinal.valueOfCodigo((String)String.valueOf(nf.getIndicadorConsumidorFinal())));
        id.setIndicadorPresencaComprador(ConstNFeIndicadorPresenca.valueOfCodigo((String)nf.getIndicadorPresencaConsumidor().toString()));
        id.setProgramaEmissor(ConstNFeProgramaEmissor.CONTRIBUINTE);
        id.setVersaoEmissor(versaoAppEmissorNFe);
        id.setTipoIntermediador(ConstNFeIntermediadorComerical.valueOfCodigo((String)String.valueOf(nf.getTipoIntermediadorComercial())));
        id.setReferenciadas(this.getReferencias(nf));
        return id;
    }

    private ConstNFeIdentificacaoLocalDestOperacao getIdentificadorDestOperacao(NotaFiscalPropria nf) {
        if (nf.getUnidadeFatCliente() == null || ToolMethods.isEquals((Object)nf.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
            return ConstNFeIdentificacaoLocalDestOperacao.OPERACAO_INTERNA;
        }
        ItemNotaFiscalPropria i = (ItemNotaFiscalPropria)nf.getItensNotaPropria().get(0);
        Cfop c = i.getItemNotaLivroFiscal().getCfop();
        if (this.helperCFOP.isOperacaoInterestadual(c)) {
            return ConstNFeIdentificacaoLocalDestOperacao.OPERACAO_INTERESTADUAL;
        }
        if (this.helperCFOP.isOperacaoExterior(c)) {
            return ConstNFeIdentificacaoLocalDestOperacao.OPERACAO_COM_EXTERIOR;
        }
        return ConstNFeIdentificacaoLocalDestOperacao.OPERACAO_INTERNA;
    }

    private NFeNotaFiscalPropria.NFeEmitente getEmitente(NotaFiscalPropria nf) {
        Empresa empresa = nf.getEmpresa();
        NFeNotaFiscalPropria.NFeEmitente emit = new NFeNotaFiscalPropria.NFeEmitente();
        if (empresa.getEmpresaDados().getCnae() != null) {
            emit.setClassificacaoNacionalAtividadesEconomicas(empresa.getEmpresaDados().getCnae().getCodigo());
            emit.setInscricaoMunicipal(empresa.getPessoa().getComplemento().getInscricaoMunicipal());
        }
        emit.setCnpjCpf(empresa.getPessoa().getComplemento().getCnpj());
        emit.setNomeFantasia(empresa.getPessoa().getNomeFantasia());
        emit.setRazaoSocial(empresa.getPessoa().getNome());
        emit.setCodRegimeTributario(String.valueOf(empresa.getEmpresaDados().getRegimeTributario().getCodigo()));
        emit.setInscricaoEstadual(empresa.getPessoa().getComplemento().getInscEst());
        DadosFiscaisUF d = this.serviceDadosFiscaisUF.get(nf.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), empresa);
        if (d != null && ToolMethods.isAffirmative((Number)d.getInscritoEstado())) {
            emit.setInscricaoEstadualSubstituicaoTributaria(d.getInscricaoEstadual());
        }
        emit.setEndereco(this.getEndereco(empresa.getPessoa().getEndereco(), this.getTelefone(empresa.getPessoa().getComplemento())));
        return emit;
    }

    private String getTelefone(Complemento complemento) {
        if (this.isInf(complemento.getFone1())) {
            return complemento.getFone1();
        }
        if (this.isInf(complemento.getFone2())) {
            return complemento.getFone2();
        }
        if (this.isInf(complemento.getCel1())) {
            return complemento.getCel1();
        }
        if (this.isInf(complemento.getCel2())) {
            return complemento.getCel2();
        }
        return null;
    }

    private boolean isInf(String text) {
        return text != null && text.length() > 0;
    }

    private NFeNotaFiscalPropria.NFeEndereco getEndereco(Endereco endereco, String telefone) {
        NFeNotaFiscalPropria.NFeEndereco end = new NFeNotaFiscalPropria.NFeEndereco();
        end.setLogradouro(endereco.getLogradouro());
        end.setNumero(endereco.getNumero());
        end.setComplemento(endereco.getComplemento());
        end.setBairro(endereco.getBairro());
        end.setCep(endereco.getCep());
        end.setCodigoMunicipio(endereco.getCidade().getCodIbgeCompleto());
        end.setCodigoPais(endereco.getCidade().getUf().getPais().getCodIbge());
        end.setCodigoUF(endereco.getCidade().getUf().getCodIbge());
        end.setDescricaoMunicipio(endereco.getCidade().getDescricao());
        end.setTelefone(telefone);
        return end;
    }

    private NFeNotaFiscalPropria.NFNotaInfoCobranca getInfoCobranca(NotaFiscalPropria notaPropria) {
        if (Objects.equals(notaPropria.getModeloDocFiscal().getCodigo(), EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
            return null;
        }
        if (!ToolMethods.isWithData((Collection)notaPropria.getInfPagamentoNfPropria())) {
            return null;
        }
        boolean possuiTitulos = false;
        for (InfPagamentoNfPropria p : notaPropria.getInfPagamentoNfPropria()) {
            if (p.getTitulos() == null || p.getTitulos().isEmpty()) continue;
            possuiTitulos = true;
            break;
        }
        if (!possuiTitulos) {
            return null;
        }
        NFeNotaFiscalPropria.NFNotaInfoCobranca c = new NFeNotaFiscalPropria.NFNotaInfoCobranca();
        Integer cont = 1;
        Double vlrLiqFatura = 0.0;
        for (InfPagamentoNfPropria p : notaPropria.getInfPagamentoNfPropria()) {
            LinkedList titulosOrdenadosVenc = new LinkedList(p.getTitulos());
            Collections.sort(titulosOrdenadosVenc, (o1, o2) -> o1.getDataVencimento().compareTo(o2.getDataVencimento()));
            for (Titulo t : titulosOrdenadosVenc) {
                NFeNotaFiscalPropria.NFNotaInfoParcela infParc = new NFeNotaFiscalPropria.NFNotaInfoParcela();
                infParc.setDataVencimento(LocalDateTime.ofInstant(Instant.ofEpochMilli(t.getDataVencimento().getTime()), ZoneId.systemDefault()).toLocalDate());
                infParc.setValorParcela(t.getValor());
                infParc.setNumeroParcela(ToolString.completaZeros((String)cont.toString(), (int)3, (boolean)true));
                c.getParcelas().add(infParc);
                Integer n = cont;
                cont = cont + 1;
                vlrLiqFatura = vlrLiqFatura + t.getValor();
            }
        }
        if (vlrLiqFatura > 0.0) {
            c.setInfoFatura(this.getInfoFatura(vlrLiqFatura, notaPropria));
        }
        return c;
    }

    private NFeNotaFiscalPropria.NFNotaInfoFatura getInfoFatura(Double vlrLiqFatura, NotaFiscalPropria notaPropria) {
        NFeNotaFiscalPropria.NFNotaInfoFatura f = new NFeNotaFiscalPropria.NFNotaInfoFatura();
        f.setNumeroFatura(ToolString.refina((String)notaPropria.getNumeroNota().toString()));
        f.setValorDesconto(Double.valueOf(0.0));
        f.setValorOriginalFatura(vlrLiqFatura);
        f.setValorLiquidoFatura(vlrLiqFatura);
        return f;
    }

    private NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais getInfoAdicionais(NotaFiscalPropria notaPropria) {
        NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao ob;
        NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais info = new NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais();
        Object obsCont = "";
        Object obsFisco = "";
        boolean flagObsInformada = false;
        for (ObservacaoNotaPropria obs : notaPropria.getObservacaoNota()) {
            if (ToolMethods.isStrWithData((String)obs.getObsFaturamento().getChave())) {
                ob = new NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao();
                ob.setIdentificacaoCampo(obs.getObsFaturamento().getChave());
                ob.setConteudoCampo(ToolString.cut((String)this.refinaXML(obs.getConteudo()), (int)60));
                info.getObservacoesContribuinte().add(ob);
                flagObsInformada = true;
                continue;
            }
            obsCont = (String)obsCont + this.refinaXML(obs.getConteudo());
        }
        for (ObservacaoNotaPropria obs : notaPropria.getObservacaoIntFiscalNotaFiscalPropria()) {
            if (ToolMethods.isStrWithData((String)obs.getObsFaturamento().getChave())) {
                ob = new NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao();
                ob.setIdentificacaoCampo(obs.getObsFaturamento().getChave());
                ob.setConteudoCampo(ToolString.cut((String)this.refinaXML(obs.getConteudo()), (int)60));
                info.getObservacoesContribuinte().add(ob);
                flagObsInformada = true;
                continue;
            }
            obsFisco = (String)obsFisco + this.refinaXML(obs.getConteudo());
        }
        if (ToolMethods.isStrWithData((String)(obsFisco = (String)obsFisco + this.getValoresFCP(notaPropria)))) {
            info.setInformacoesAdicionaisInteresseFisco((String)obsFisco);
            flagObsInformada = true;
        }
        if (ToolMethods.isStrWithData((String)obsCont)) {
            info.setInformacoesComplementaresInteresseContribuinte((String)obsFisco);
            flagObsInformada = true;
        }
        if (!flagObsInformada) {
            return null;
        }
        return info;
    }

    private String getValoresFCP(NotaFiscalPropria nf) {
        String str;
        Double valorFCP = 0.0;
        Double valorFCPSt = 0.0;
        Double valorFCPStRetido = 0.0;
        for (ItemNotaFiscalPropria i : nf.getItensNotaPropria()) {
            valorFCP = valorFCP + i.getItemNotaLivroFiscal().getValorFCP();
            valorFCPSt = valorFCPSt + i.getItemNotaLivroFiscal().getValorFCPSt();
            valorFCPStRetido = valorFCPStRetido + i.getItemNotaLivroFiscal().getValorFCPStRetido();
        }
        StringBuilder sb = new StringBuilder();
        if (valorFCP > 0.0) {
            sb.append("Vr FCP: ");
            sb.append(ToolFormatter.formataNumero((Number)valorFCP, (int)2));
            sb.append(";");
        }
        if (valorFCPSt > 0.0) {
            sb.append("Vr FCP ST: ");
            sb.append(ToolFormatter.formataNumero((Number)valorFCPSt, (int)2));
            sb.append(";");
        }
        if (valorFCPStRetido > 0.0) {
            sb.append("Vr FCP ST Retido: ");
            sb.append(ToolFormatter.formataNumero((Number)valorFCPStRetido, (int)2));
            sb.append(";");
        }
        str = (str = sb.toString()) != null && str.trim().length() > 0 ? str.trim() : "";
        return str;
    }

    private Date getDataSaida(NotaFiscalPropria nfce) {
        if (ToolDate.dataSemHora((Date)nfce.getDataEmissaoNota()).equals(ToolDate.dataSemHora((Date)nfce.getDataEntradaSaida()))) {
            return nfce.getDataEmissaoNota();
        }
        return nfce.getDataEntradaSaida();
    }

    private List<ItemNotaFiscalPropria> ordenaListItens(List<ItemNotaFiscalPropria> list) {
        Collections.sort(list, (n1, n2) -> n1.getNumeroItem().compareTo(n2.getNumeroItem()));
        return list;
    }

    private ConstNFeTipoEmissao getTipoEmissao(NotaFiscalPropria nf) {
        TipoEmissaoNFe tipoEmissao = nf.getPeriodoEmissaoNFe().getTipoEmissaoNfe();
        if (ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)1)) {
            return ConstNFeTipoEmissao.EMISSAO_NORMAL;
        }
        if (ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)4)) {
            return ConstNFeTipoEmissao.CONTINGENCIA_DPEC;
        }
        if (ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)9)) {
            return ConstNFeTipoEmissao.CONTIGENCIA_OFFLINE;
        }
        if (ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)6)) {
            return ConstNFeTipoEmissao.CONTINGENCIA_SVCAN;
        }
        if (ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)7)) {
            return ConstNFeTipoEmissao.CONTINGENCIA_SVCRS;
        }
        throw new RuntimeException("Tipo de contigencia ainda nao mapeada");
    }

    private List<NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada> getReferencias(NotaFiscalPropria nf) {
        NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoModelo1Por1AReferenciada mod1;
        NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada n;
        LinkedList<NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada> ret = new LinkedList<NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada>();
        GrupoDocumentosRefPR gr = nf.getGrupoDocumentosRefPR();
        if (gr == null) {
            return ret;
        }
        for (DocumentosRefNFPropriaPR nfRef : gr.getNotasProprias()) {
            n = new NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada();
            n.setChaveAcesso(nfRef.getChaveNFe());
            ret.add(n);
        }
        for (DocumentosRefNFPropriaPR nfRef : gr.getNotasMod1A()) {
            n = new NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada();
            mod1 = new NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoModelo1Por1AReferenciada();
            mod1.setCodigoUf(nfRef.getEmissor().getEndereco().getCidade().getUf().getCodIbge());
            mod1.setAnoMesEmissaoNFe(ToolDate.dateToStr((Date)nfRef.getDataEmissao(), (String)"yyMM"));
            mod1.setCnpj(ToolString.onlyNumbers((String)nfRef.getEmissor().getComplemento().getCnpj()));
            mod1.setModeloDocumentoFiscal(nfRef.getModeloDocFiscal().getCodigo());
            if (ToolMethods.isStrWithData((String)ToolString.onlyNumbers((String)nfRef.getSerie()))) {
                mod1.setSerie(Integer.valueOf(nfRef.getSerie()));
            }
            if (nfRef.getNumero() != null) {
                mod1.setNumeroDocumentoFiscal(ToolString.onlyNumbers((String)nfRef.getNumero().toString()));
            }
            n.setModelo1por1Referenciada(mod1);
            ret.add(n);
        }
        for (DocumentosRefNFPropriaPR nfRef : gr.getNotasProdutor()) {
            n = new NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada();
            mod1 = new NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoProdutorRuralReferenciada();
            mod1.setCodigoUfEmitente(nfRef.getEmissor().getEndereco().getCidade().getUf().getCodIbge());
            mod1.setAnoMesEmissao(ToolDate.dateToStr((Date)nfRef.getDataEmissao(), (String)"yyMM"));
            String cpfCNPJ = ToolString.onlyNumbers((String)nfRef.getEmissor().getComplemento().getCnpj());
            mod1.setCnpjCpfEmitente(cpfCNPJ);
            String inscEst = ToolString.onlyNumbers((String)nfRef.getEmissor().getComplemento().getInscEst());
            if (inscEst.trim().length() > 0) {
                mod1.setIeEmitente(inscEst);
            } else {
                mod1.setIeEmitente("ISENTO");
            }
            mod1.setModeloDocumentoFiscal(nfRef.getModeloDocFiscal().getCodigo());
            if (ToolMethods.isStrWithData((String)ToolString.onlyNumbers((String)nfRef.getSerie()))) {
                mod1.setSerieDocumentoFiscal(Integer.valueOf(nfRef.getSerie()));
            }
            mod1.setNumeroDocumentoFiscal(nfRef.getNumero());
            n.setInfoNFProdutorRuralReferenciada((NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoProdutorRuralReferenciada)mod1);
            ret.add(n);
        }
        for (DocumentosRefNFPropriaPR nfRef : gr.getNotasTerceiros()) {
            n = new NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada();
            n.setChaveAcesso(nfRef.getChaveNFe());
            ret.add(n);
        }
        for (DocumentosRefNFPropriaPR nfRef : nf.getGrupoDocumentosRefPR().getNfces()) {
            n = new NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada();
            n.setChaveAcesso(nfRef.getChaveNFe());
            ret.add(n);
        }
        return ret;
    }

    private ConstNFeIndicadorIEDest getIndicadorIEDest(NotaFiscalPropria nfce, UnidadeFatCliente unidadeFatCliente) {
        if (ToolMethods.isEquals((Object)nfce.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
            return ConstNFeIndicadorIEDest.NAO_CONTRIBUINTE;
        }
        if (nfce.getUnidadeFatCliente().getPessoa().getComplemento().getContribuinteEstado().equals(EnumConstContrEstadoIcms.CONTRIBUINTE.getEnumId())) {
            return ConstNFeIndicadorIEDest.CONTRIBUINTE_ICMS;
        }
        if (nfce.getUnidadeFatCliente().getPessoa().getComplemento().getContribuinteEstado().equals(EnumConstContrEstadoIcms.ISENTO.getEnumId())) {
            return ConstNFeIndicadorIEDest.CONTRIBUINTE_ISENTO_INSCRICAO_CONTRIBUINTES_ICMS;
        }
        return ConstNFeIndicadorIEDest.NAO_CONTRIBUINTE;
    }

    private void setInfoTransportador(NotaFiscalPropria notaPropria, NFeNotaFiscalPropria.NFeNotaInfoTransporte ret) {
        if (notaPropria.getDadosTransNfPropria().getTransportador() == null) {
            return;
        }
        Transportador transportador = notaPropria.getDadosTransNfPropria().getTransportador();
        ret.setTransportador(new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeInfoTransportador());
        ret.getTransportador().setCnpjCpf(transportador.getPessoa().getComplemento().getCnpj());
        StringBuilder sb = new StringBuilder();
        sb.append(transportador.getPessoa().getEndereco().getLogradouro());
        if (transportador.getPessoa().getEndereco().getNumero() != null) {
            sb.append(",").append(transportador.getPessoa().getEndereco().getNumero());
        }
        if (transportador.getPessoa().getEndereco().getBairro() != null) {
            sb.append(",").append(transportador.getPessoa().getEndereco().getBairro());
        }
        if (sb.length() > 60) {
            sb = new StringBuilder(sb.substring(0, 60));
        }
        ret.getTransportador().setEnderecoComplemento(sb.toString());
        ret.getTransportador().setInscricaoEstadual(transportador.getPessoa().getComplemento().getInscEst());
        ret.getTransportador().setNomeMunicipio(transportador.getPessoa().getEndereco().getCidade().getDescricao());
        ret.getTransportador().setRazaoSocial(transportador.getPessoa().getNome());
        ret.getTransportador().setUf(transportador.getPessoa().getEndereco().getCidade().getUf().getSigla());
    }

    private void setVeiculos(NotaFiscalPropria notaPropria, NFeNotaFiscalPropria.NFeNotaInfoTransporte ret) {
        if (ToolMethods.isStrWithData((String)notaPropria.getDadosTransNfPropria().getPlacaVeiculo())) {
            NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVeiculo veiculo = new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVeiculo();
            veiculo.setPlacaVeiculo(notaPropria.getDadosTransNfPropria().getPlacaVeiculo());
            veiculo.setRegistroNacionalTransportadorCarga(notaPropria.getDadosTransNfPropria().getInscricaoAntt());
            veiculo.setUf(this.getCodigoIBGEUF(notaPropria.getDadosTransNfPropria().getUfPlacaVeiculo()));
            ret.setVeiculo(veiculo);
        }
    }

    private void setReboques(NotaFiscalPropria notaPropria, NFeNotaFiscalPropria.NFeNotaInfoTransporte ret) {
        ArrayList<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque> reb = new ArrayList<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque>();
        String insc = this.refinaXMLNull(notaPropria.getDadosTransNfPropria().getInscricaoAnttReboque1());
        String placa = this.refinaXMLNull(notaPropria.getDadosTransNfPropria().getPlacaReboque1());
        String uf = this.refinaXMLNull(notaPropria.getDadosTransNfPropria().getUfPlacaReboque1());
        if (insc != null || placa != null) {
            NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque v = new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque();
            v.setPlacaVeiculo(placa);
            v.setRegistroNacionalTransportadorCarga(ToolString.onlyNumbers((String)insc));
            v.setCodigoUf(this.getCodigoIBGEUF(uf));
            reb.add(v);
        }
        String insc2 = this.refinaXMLNull(notaPropria.getDadosTransNfPropria().getInscricaoAnttReboque2());
        String placa2 = this.refinaXMLNull(notaPropria.getDadosTransNfPropria().getPlacaReboque2());
        String uf2 = this.refinaXMLNull(notaPropria.getDadosTransNfPropria().getUfPlacaReboque2());
        if (insc2 != null || placa2 != null) {
            NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque v = new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque();
            v.setPlacaVeiculo(placa2);
            v.setRegistroNacionalTransportadorCarga(insc2);
            v.setCodigoUf(this.getCodigoIBGEUF(uf2));
            reb.add(v);
        }
        ret.setReboques(reb);
    }

    private String getCodigoIBGEUF(String siglaUF) {
        if (!ToolMethods.isStrWithData((String)siglaUF)) {
            return null;
        }
        EnumConstUF uf = EnumConstUF.valueOfSigla((String)siglaUF);
        if (uf == null) {
            return null;
        }
        return uf.getCodigoIbge();
    }

    private String refinaXMLNull(String to) {
        String str = ToolString.clearSpecialCharacXML((String)to);
        str = str != null && str.trim().length() > 0 ? str : null;
        return str;
    }

    private String refinaXML(String to) {
        return ToolString.clearSpecialCharacXML((String)to);
    }

    private void setVolumes(NotaFiscalPropria notaPropria, NFeNotaFiscalPropria.NFeNotaInfoTransporte ret) {
        if (!ToolMethods.isWithData((Collection)notaPropria.getVolumes())) {
            return;
        }
        LinkedList<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume> aux = new LinkedList<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume>();
        for (VolumeNFe vol : notaPropria.getVolumes()) {
            NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume v = new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume();
            v.setMarca(vol.getMarca());
            v.setPesoBruto(vol.getPesoBruto());
            v.setPesoLiquido(vol.getPesoLiquido());
            v.setNumeracaoVolumesTransportados(String.valueOf(vol.getNumeroVolume()));
            if (vol.getQuantidade() != null) {
                v.setQuantidadeVolumesTransportados(Long.valueOf(vol.getQuantidade().longValue()));
            }
            if (vol.getEmbalagem() != null) {
                v.setEspecieVolumesTransportados(vol.getEmbalagem().getNome());
            }
            if (ToolMethods.isWithData((Collection)vol.getLacres())) {
                v.setLacres(new LinkedList());
                for (LacreVolumeNFe lacre : vol.getLacres()) {
                    NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume.NFeNotaInfoLacre l = new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume.NFeNotaInfoLacre();
                    l.setNumeroLacres(lacre.getLacre());
                    v.getLacres().add(l);
                }
            }
            aux.add(v);
        }
        ret.setVolumes(aux);
    }

    private NFeNotaFiscalPropria.NFeLocalRetirada getInfoLocalRetirada(NotaFiscalPropria nf) {
        if (nf.getLocalRetiradaNFPropria() == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeLocalRetirada t = new NFeNotaFiscalPropria.NFeLocalRetirada();
        t.setCnpjCpf(ToolString.onlyNumbers((String)nf.getLocalRetiradaNFPropria().getCnpjEnderecoRetirada()));
        Endereco end = nf.getLocalRetiradaNFPropria().getEnderecoRetirada();
        t.setLogradouro(this.refinaXMLNull(end.getLogradouro()));
        t.setNumero(this.refinaXMLNull(end.getNumero()));
        t.setComplemento(this.refinaXMLNull(end.getComplemento()));
        t.setBairro(this.refinaXMLNull(end.getBairro()));
        t.setCodigoMunicipio(end.getCidade().getUf().getCodIbge() + end.getCidade().getCodIbge());
        t.setNomeMunicipio(this.refinaXMLNull(end.getCidade().getDescricao()));
        t.setUf(this.getCodigoIBGEUF(end.getCidade().getUf().getSigla()));
        t.setCep(this.refinaXMLNull(end.getCep()));
        t.setCodigoPais(end.getCidade().getUf().getPais().getCodIbge());
        t.setInscricaoEstadual(this.refinaXMLNull(nf.getLocalRetiradaNFPropria().getInscEstEnderecoRetirada()));
        t.setEmail(this.refinaXMLNull(nf.getLocalRetiradaNFPropria().getEmailEnderecoRetirada()));
        t.setNome(this.refinaXMLNull(nf.getLocalRetiradaNFPropria().getNomeEnderecoRetirada()));
        t.setTelefone(this.refinaXMLNull(nf.getLocalRetiradaNFPropria().getTelefone()));
        return t;
    }

    private NFeNotaFiscalPropria.NFeInfoCompra getInfoCompra(NotaFiscalPropria nf) {
        NFeNotaFiscalPropria.NFeInfoCompra c = new NFeNotaFiscalPropria.NFeInfoCompra();
        if (ToolMethods.isStrWithData((String)nf.getNotaEmpenho())) {
            c.setNotaDeEmpenho(nf.getNotaEmpenho());
        }
        if (ToolMethods.isStrWithData((String)nf.getNrContrato())) {
            c.setContrato(nf.getNrContrato());
        }
        if (ToolMethods.isStrWithData((String)nf.getNrPedidoCompra())) {
            c.setPedido(nf.getNrPedidoCompra());
        }
        if (c.getContrato() != null || c.getNotaDeEmpenho() != null || c.getPedido() != null) {
            return c;
        }
        return null;
    }

    private List<NFeNotaFiscalPropria.NFePessoaAutorizadaDownloadNFe> getPessoasAutoXML(NotaFiscalPropria notaPropria) {
        LinkedList<NFeNotaFiscalPropria.NFePessoaAutorizadaDownloadNFe> toRet = new LinkedList<NFeNotaFiscalPropria.NFePessoaAutorizadaDownloadNFe>();
        for (NFeAutDownloadXML p : notaPropria.getNfeAutDownloadXML()) {
            NFeNotaFiscalPropria.NFePessoaAutorizadaDownloadNFe d = new NFeNotaFiscalPropria.NFePessoaAutorizadaDownloadNFe();
            d.setCnpjCpf(p.getCnpjCPF());
            toRet.add(d);
        }
        return toRet;
    }

    private NFeNotaFiscalPropria.NFeEnderecoEntrega getEnderecoEntrega(NotaFiscalPropria notaPropria) {
        if (notaPropria.getLocalEntregaNFPropria() == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeEnderecoEntrega t = new NFeNotaFiscalPropria.NFeEnderecoEntrega();
        LocalEntregaNFPropria local = notaPropria.getLocalEntregaNFPropria();
        local.setCnpjEnderecoEntrega(local.getCnpjEnderecoEntrega());
        Endereco end = local.getEnderecoEntrega();
        t.setLogradouro(this.refinaXML(end.getLogradouro()));
        t.setNumero(this.refinaXML(end.getNumero()));
        t.setComplemento(this.refinaXMLNull(end.getComplemento()));
        t.setBairro(this.refinaXML(end.getBairro()));
        t.setCodigoMunicipio(end.getCidade().getUf().getCodIbge() + end.getCidade().getCodIbge());
        t.setNomeMunicipio(this.refinaXML(end.getCidade().getDescricao()));
        t.setUf(this.getCodigoIBGEUF(end.getCidade().getUf().getSigla()));
        t.setCep(this.refinaXML(end.getCep()));
        t.setCodigoPais(end.getCidade().getUf().getPais().getCodIbge());
        t.setInscricaoEstadual(this.refinaXMLNull(local.getInscEstEnderecoEntrega()));
        t.setEmail(this.refinaXMLNull(local.getEmailEnderecoEntrega()));
        t.setNome(this.refinaXMLNull(local.getNomeEnderecoEntrega()));
        t.setTelefone(this.refinaXMLNull(local.getTelefone()));
        return t;
    }

    private NFeNotaFiscalPropria.NFeNotaInfoExportacao getInfoExportacao(NotaFiscalPropria notaPropria) {
        if (notaPropria.getUfEmbarque() == null || notaPropria.getLocalEmbarque() == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeNotaInfoExportacao e = new NFeNotaFiscalPropria.NFeNotaInfoExportacao();
        e.setCodigoUfEmbarqueProduto(this.getCodigoIBGEUF(notaPropria.getUfEmbarque().getSigla()));
        e.setLocalEmbarqueProdutos(notaPropria.getLocalEmbarque());
        return e;
    }
}

