/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.notafiscalpropria;

import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.EstoqueTerceiros;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.IntegracaoNotaPropriaNotas;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemReceitaAgronomica;
import com.touchcomp.basementor.model.vo.ItemRetornoCnab;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.LogTitulos;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ReceitaAgronomica;
import com.touchcomp.basementor.model.vo.RetornoCnabCobrancaTitulosNaoBaixados;
import com.touchcomp.basementor.model.vo.SituacaoPedidos;
import com.touchcomp.basementor.model.vo.TicketFiscal;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.service.impl.boletotitulo.ServiceBoletoTituloImpl;
import com.touchcomp.basementorservice.service.impl.estoqueterceiros.ServiceEstoqueTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.integracaonotaproprianotas.ServiceIntegracaoNotaPropriaNotasImpl;
import com.touchcomp.basementorservice.service.impl.logtitulos.ServiceLogTituloImpl;
import com.touchcomp.basementorservice.service.impl.lotecontabil.ServiceLoteContabilImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.ServiceNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.service.impl.pedido.ServicePedidoImpl;
import com.touchcomp.basementorservice.service.impl.receitaagronomica.ServiceReceitaAgronomicaImpl;
import com.touchcomp.basementorservice.service.impl.retornocnab.ServiceItemRetornoCnabImpl;
import com.touchcomp.basementorservice.service.impl.retornocnab.ServiceRetornoCnabCobrancaTitulosNaoBaixadosImpl;
import com.touchcomp.basementorservice.service.impl.ticketfiscal.ServiceTicketFiscalImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceCancelamentoNotaPropria {
    @Autowired
    ServiceRetornoCnabCobrancaTitulosNaoBaixadosImpl serviceRetCnab;
    @Autowired
    ServiceLogTituloImpl serviceLogTitulos;
    @Autowired
    ServiceItemRetornoCnabImpl serviceItemRetornoCnab;
    @Autowired
    ServiceBoletoTituloImpl serviceBoleto;
    @Autowired
    ServicePedidoImpl servicePedido;
    @Autowired
    ServiceLoteContabilImpl serviceLoteContabil;
    @Autowired
    ServiceNotaFiscalPropriaImpl serviceNotaFiscal;
    @Autowired
    ServiceTicketFiscalImpl serviceTicketFiscal;
    @Autowired
    ServiceEstoqueTerceirosImpl serviceEstoqueTerceiros;
    @Autowired
    ServiceReceitaAgronomicaImpl serviceReceita;
    @Autowired
    ServiceIntegracaoNotaPropriaNotasImpl serviceIntegracaoNotaPropriaNotas;

    public NotaFiscalPropria cancelarDadosNotaPropria(NotaFiscalPropria notaFiscalPropria, SituacaoPedidos sitCanc) {
        notaFiscalPropria.setLiberarImpDanfe(Short.valueOf((short)0));
        this.cancelarItens(notaFiscalPropria);
        this.cancelarLivrosFiscais(notaFiscalPropria);
        this.cancelarDocReferenciados(notaFiscalPropria);
        this.cancelarEstTerceiros(notaFiscalPropria);
        this.cancelarPedido(notaFiscalPropria, sitCanc);
        this.cancelarFinanceiro(notaFiscalPropria);
        this.cancelarContabil(notaFiscalPropria);
        this.cancelarTicket(notaFiscalPropria);
        notaFiscalPropria = this.serviceNotaFiscal.saveOrUpdate(notaFiscalPropria);
        return notaFiscalPropria;
    }

    public NotaFiscalPropria inutilizarNotaFiscal(NotaFiscalPropria notaFiscalPropria, SituacaoPedidos sitCanc) {
        notaFiscalPropria.setLiberarImpDanfe(Short.valueOf((short)0));
        this.cancelarItensRecAgro(notaFiscalPropria);
        notaFiscalPropria.getLivrosFiscais().clear();
        this.cancelarDocReferenciados(notaFiscalPropria);
        this.cancelarEstTerceiros(notaFiscalPropria);
        this.cancelarPedido(notaFiscalPropria, sitCanc);
        this.cancelarContabil(notaFiscalPropria);
        this.cancelarFinanceiro(notaFiscalPropria);
        this.cancelarTicket(notaFiscalPropria);
        notaFiscalPropria = this.serviceNotaFiscal.saveOrUpdate(notaFiscalPropria);
        return notaFiscalPropria;
    }

    private void cancelarLogsTitulos(Titulo t) {
        List<LogTitulos> logs = this.serviceLogTitulos.get(t);
        for (LogTitulos l : logs) {
            l.setTitulo(null);
            this.serviceLogTitulos.saveOrUpdateFlush(l);
        }
    }

    private void cancelarRetCnabs(Titulo t) {
        if (!ToolMethods.isWithData((Number)t.getIdentificador())) {
            return;
        }
        List<RetornoCnabCobrancaTitulosNaoBaixados> titNaoBaixadosCnab = this.serviceRetCnab.get(t);
        for (RetornoCnabCobrancaTitulosNaoBaixados r : titNaoBaixadosCnab) {
            this.serviceRetCnab.delete(r);
        }
        List<ItemRetornoCnab> itemRetornoCnab = this.serviceItemRetornoCnab.get(t);
        for (ItemRetornoCnab irc : itemRetornoCnab) {
            this.serviceItemRetornoCnab.delete(irc);
        }
    }

    private void cancelarBoletos(Titulo t) {
        List<BoletoTitulo> boletos = this.serviceBoleto.getBoletos(t);
        for (BoletoTitulo l : boletos) {
            l.setTitulo(null);
            this.serviceBoleto.saveOrUpdate(l);
        }
    }

    private void cancelarPedido(NotaFiscalPropria notaFiscalPropria, SituacaoPedidos sitCanc) {
        if (notaFiscalPropria.getExpedicao() != null && notaFiscalPropria.getExpedicao().getPedido() != null && sitCanc != null) {
            this.servicePedido.atualizaSitPedido(notaFiscalPropria.getExpedicao().getPedido(), sitCanc);
        }
        notaFiscalPropria.setExpedicao(null);
    }

    private void cancelarContabil(NotaFiscalPropria notaFiscalPropria) {
        IntegracaoNotaPropriaNotas i = notaFiscalPropria.getIntegracaoNotaPropriaNotas();
        if (i != null && i.getLoteContabil() != null) {
            notaFiscalPropria.setIntegracaoNotaPropriaNotas(null);
            if (i != null) {
                this.serviceIntegracaoNotaPropriaNotas.delete(i);
            }
        }
    }

    private void cancelarEstTerceiros(NotaFiscalPropria notaFiscalPropria) {
        for (ItemNotaFiscalPropria i : notaFiscalPropria.getItensNotaPropria()) {
            for (GradeItemNotaFiscalPropria g : i.getGradesNotaFiscalPropria()) {
                EstoqueTerceiros est = g.getEstoqueTerceiros();
                g.setEstoqueTerceiros(null);
                if (est == null) continue;
                this.serviceEstoqueTerceiros.delete(est);
            }
        }
    }

    private void cancelarDocReferenciados(NotaFiscalPropria notaFiscalPropria) {
        if (notaFiscalPropria.getGrupoDocumentosRefPR() != null) {
            notaFiscalPropria.getGrupoDocumentosRefPR().getCtes().clear();
            notaFiscalPropria.getGrupoDocumentosRefPR().getNotasMod1A().clear();
            notaFiscalPropria.getGrupoDocumentosRefPR().getNotasProdutor().clear();
            notaFiscalPropria.getGrupoDocumentosRefPR().getNotasProprias().clear();
            notaFiscalPropria.getGrupoDocumentosRefPR().getNotasTerceiros().clear();
            notaFiscalPropria.getGrupoDocumentosRefPR().getProcessosReferenciados().clear();
        }
    }

    private void cancelarTicket(NotaFiscalPropria notaFiscalPropria) {
        if (notaFiscalPropria.getTicketsFiscal() != null) {
            for (TicketFiscal t : notaFiscalPropria.getTicketsFiscal()) {
                t.setNotaFiscalPropria(null);
                this.serviceTicketFiscal.saveOrUpdateFlush(t);
            }
            notaFiscalPropria.getTicketsFiscal().clear();
        }
    }

    private void cancelarFinanceiro(NotaFiscalPropria notaFiscalPropria) {
        for (InfPagamentoNfPropria i : notaFiscalPropria.getInfPagamentoNfPropria()) {
            for (Titulo t : i.getTitulos()) {
                if (!ToolMethods.isWithData((Number)t.getIdentificador())) continue;
                this.cancelarLogsTitulos(t);
                this.cancelarRetCnabs(t);
                this.cancelarBoletos(t);
            }
        }
        notaFiscalPropria.getInfPagamentoNfPropria().clear();
    }

    private void cancelarLivrosFiscais(NotaFiscalPropria notaFiscalPropria) {
        for (LivroFiscal lv : notaFiscalPropria.getLivrosFiscais()) {
            lv.setCancelado(Short.valueOf((short)1));
        }
    }

    private void cancelarItens(NotaFiscalPropria notaFiscalPropria) {
        for (ItemNotaFiscalPropria i : notaFiscalPropria.getItensNotaPropria()) {
            for (GradeItemNotaFiscalPropria g : i.getGradesNotaFiscalPropria()) {
                g.setMovimentacaoFisica(Short.valueOf((short)0));
            }
        }
    }

    private void cancelarItensRecAgro(NotaFiscalPropria notaFiscalPropria) {
        if (!ToolMethods.isWithData((Number)notaFiscalPropria.getIdentificador())) {
            return;
        }
        List<ReceitaAgronomica> rec = this.serviceReceita.getReceitas(notaFiscalPropria);
        notaFiscalPropria.getItensNotaPropria().clear();
        if (rec == null) {
            return;
        }
        for (ReceitaAgronomica receitaAgronomica : rec) {
            for (ItemReceitaAgronomica itemReceitaAgronomica : receitaAgronomica.getItemReceitaAgronomica()) {
                itemReceitaAgronomica.setItemNotaFiscalPropria(null);
            }
            this.serviceReceita.saveOrUpdateFlush(receitaAgronomica);
        }
    }
}

