/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.notafiscalpropria;

import com.touchcomp.basementor.model.impl.CustoProdutoUltimaNF;
import com.touchcomp.basementor.model.vo.AjusteEstoque;
import com.touchcomp.basementor.model.vo.BloqueioNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.DadosTransNfPropria;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.Especie;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.OpcoesECommerce;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.helpers.impl.wmsentradaprodutos.HelperWmsEntradaProdutos;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.bloqueionotafiscalpropria.ServiceBloqueioNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.UtilityGeracaoNotaPropriaXML;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.UtilityNfe;
import com.touchcomp.basementorservice.service.interfaces.ServiceNotaFiscalPropria;
import com.touchcomp.touchvomodel.vo.centraldocsproprios.DTOCentralDocsPropriosNFe;
import com.touchcomp.touchvomodel.vo.integracaonotafiscalpropria.web.DTOIntegracaoNotaFiscalPropria;
import com.touchcomp.touchvomodel.vo.notafiscalpropria.web.DTONotaFiscalPropria;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jdom2.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ServiceNotaFiscalPropriaImpl
extends ServiceGenericEntityImpl<NotaFiscalPropria, Long, DaoNotaFiscalPropriaImpl>
implements ServiceNotaFiscalPropria {
    HelperWmsEntradaProdutos wmsEntradaProdutos;
    ServiceBloqueioNotaFiscalPropriaImpl serviceBloqueioNotaFiscalPropria;

    @Autowired
    public ServiceNotaFiscalPropriaImpl(DaoNotaFiscalPropriaImpl genericDao, HelperWmsEntradaProdutos wmsEntradaProdutos, ServiceBloqueioNotaFiscalPropriaImpl serviceBloqueioNotaFiscalPropria) {
        super(genericDao);
        this.wmsEntradaProdutos = wmsEntradaProdutos;
        this.serviceBloqueioNotaFiscalPropria = serviceBloqueioNotaFiscalPropria;
    }

    @Override
    public Date getDataUltimaCompraCliente(Cliente cliente) {
        return ((DaoNotaFiscalPropriaImpl)this.getGenericDao()).getDataUltimaCompraCliente(cliente);
    }

    @Override
    public NotaFiscalPropria importarNotaPropriaPorXML(Document d, OpcoesFaturamento opcoesFaturamento, OpcoesFinanceiras opcoesFinanceira, OpcoesECommerce opcoesEcommerce, Empresa empresa, EmpresaContabilidade empresaContabilidade, OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos, OpcoesContabeis opcoesContabeis, OpcoesImpostos opImpostos) throws Exception {
        return new UtilityGeracaoNotaPropriaXML().getProcessarNota(d, opcoesFaturamento, opcoesFinanceira, opcoesEcommerce, empresa, empresaContabilidade, opcoesContabeisBaixaTitulos, opcoesContabeis, opImpostos);
    }

    public DadosTransNfPropria getUltDadosTranspInf(Transportador transportador) {
        return ((DaoNotaFiscalPropriaImpl)this.getGenericDao()).getUltDadosTranspInf(transportador);
    }

    @Override
    public NotaFiscalPropria importarNotaPropriaCanceladaPorXML(Document d, OpcoesFaturamento opcoesFaturamento, OpcoesFinanceiras opcoesFinanceira, OpcoesECommerce opcoesEcommerce, Empresa empresa, EmpresaContabilidade empresaContabilidade, OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos, OpcoesContabeis opcoesContabeis, OpcoesImpostos opImpostos) throws Exception {
        return new UtilityGeracaoNotaPropriaXML().getProcessarNotaCancelada(d, opcoesFaturamento, opcoesFinanceira, opcoesEcommerce, empresa, empresaContabilidade, opcoesContabeisBaixaTitulos, opcoesContabeis, opImpostos);
    }

    @Override
    public List<Produto> findProdutosNotas(Date dataInicial) {
        return ((DaoNotaFiscalPropriaImpl)this.getGenericDao()).findProdutosNotas(dataInicial);
    }

    public NotaFiscalPropria getPorNumeroSerieEmpresa(Integer numeroNota, String serie, Empresa empresa) {
        return ((DaoNotaFiscalPropriaImpl)this.getDao()).getPorNumeroSerieEmpresa(numeroNota, serie, empresa);
    }

    public List<NotaFiscalPropria> findNotasTransferenciasNaoTransferidas(String naturezaOperacao, Date dataInicial, Date dataFinal, int page, int maxRes) {
        return ((DaoNotaFiscalPropriaImpl)this.getDao()).findNotasTransferenciasNaoTransferidas(naturezaOperacao, dataInicial, dataFinal, page, maxRes);
    }

    @Override
    public List<Produto> findProdutosTransferencias(Date dataInicial) {
        return ((DaoNotaFiscalPropriaImpl)this.getGenericDao()).findProdutosTransferencias(dataInicial);
    }

    public CustoProdutoUltimaNF getUltimoCustoProd(Long idProduto, Long idEmpresa) {
        return ((DaoNotaFiscalPropriaImpl)this.getDao()).getUltimoCustoProd(idProduto, idEmpresa);
    }

    public CustoProdutoUltimaNF getUltimoCustoProd(Long idProduto) {
        return ((DaoNotaFiscalPropriaImpl)this.getDao()).getUltimoCustoProd(idProduto);
    }

    public void atualizarNatRecPisCofinsItens(Date dataIn, Date dataFim) {
        ((DaoNotaFiscalPropriaImpl)this.getDao()).atualizarNatRecPisCofinsItens(dataIn, dataFim);
    }

    @Override
    public NotaFiscalPropria findNotaPropriaPorNrAndSerieAndCNPJEmpresa(Integer nrNota, String serieNota, String cnpjEmpresa) {
        return ((DaoNotaFiscalPropriaImpl)this.getDao()).findNotaPropriaPorNrAndSerieAndCNPJEmpresa(nrNota, serieNota, cnpjEmpresa);
    }

    public NotaFiscalPropria getBySerialForSync(String serial) {
        return ((DaoNotaFiscalPropriaImpl)this.getDao()).getBySerialForSync(serial);
    }

    @Override
    public List<HashMap> findNotaPropriaVendasPorPeriodoAndEmpresa(Date dataInicial, Date dataFinal, Empresa empresa, Especie especie) {
        return ((DaoNotaFiscalPropriaImpl)this.getDao()).findNotaPropriaVendasPorPeriodoAndEmpresa(dataInicial, dataFinal, empresa, especie);
    }

    @Override
    public List<HashMap> findNotaPropriaVendasPorPeriodoAndEmpresaAndCliente(Date dataInicial, Date dataFinal, Empresa empresa, Especie especie, Cliente cliente) {
        return ((DaoNotaFiscalPropriaImpl)this.getDao()).findNotaPropriaVendasPorPeriodoAndEmpresaAndCliente(dataInicial, dataFinal, empresa, especie, cliente);
    }

    public String toXMLString(NotaFiscalPropria notaFiscalPropria) throws Exception {
        return new UtilityNfe().toXMLString(notaFiscalPropria);
    }

    public NotaFiscalPropria getNotaPropria(String idNotaFiscal) {
        return ((DaoNotaFiscalPropriaImpl)this.getDao()).getNotaProria(idNotaFiscal);
    }

    public List<NotaFiscalPropria> pesquisarNotaPropriaAjusteEstoque(AjusteEstoque ajusteEstoque) {
        return ((DaoNotaFiscalPropriaImpl)this.getDao()).pesquisarNotaPropriaAjusteEstoque(ajusteEstoque);
    }

    public NotaFiscalPropria getultimaNotaByPessoa(String cnpj) {
        return ((DaoNotaFiscalPropriaImpl)this.getDao()).getultimaNotaByPessoa(cnpj);
    }

    public NotaFiscalPropria atualizarDigitoVerificador(NotaFiscalPropria notaFiscalPropria) {
        HashMap h = ((DaoNotaFiscalPropriaImpl)this.getDao()).atualizarDigitoVerificador(notaFiscalPropria);
        ((DaoNotaFiscalPropriaImpl)this.getDao()).salvarDigitoVerificador((String)h.get("CHAVE"), (Integer)h.get("DIGITO"), notaFiscalPropria.getIdentificador());
        return (NotaFiscalPropria)this.get(notaFiscalPropria.getIdentificador());
    }

    @Override
    public NotaFiscalPropria saveOrUpdateOnly(NotaFiscalPropria entity) {
        try {
            entity.setWmsEntradaEstoque(this.wmsEntradaProdutos.getWmsEntrada(entity, this.getSharedData().getWmsOpcoes(entity.getEmpresa())));
            return ((DaoNotaFiscalPropriaImpl)this.getGenericDao()).saveOrUpdate(entity);
        }
        catch (Exception ex) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0228.007", new String[]{String.valueOf(entity), ex.getMessage()}));
        }
    }

    public List<NotaFiscalPropria> findNotasPeriodoAndNumeroNota(Date dataIn, Date dataFim, Short filtrarNumeracao, Integer numeroInicial, Integer numeroFinal) {
        return ((DaoNotaFiscalPropriaImpl)this.getGenericDao()).findNotasPeriodoAndNumeroNota(dataIn, dataFim, filtrarNumeracao, numeroInicial, numeroFinal);
    }

    public List<DTOCentralDocsPropriosNFe> getNotasFiscaisDestinatario(Integer page, Integer regsPage, GrupoEmpresa loggedGrupoEmpresa, Pessoa pessoa, Short filtrarData, Date dataIn, Date dataFim, Short filtrarNr, Long numero, Short filtrarChave, String chaveNFe) {
        return ((DaoNotaFiscalPropriaImpl)this.getDao()).getNotasFiscaisDestinatario(page, regsPage, loggedGrupoEmpresa, pessoa, filtrarData, dataIn, dataFim, filtrarNr, numero, filtrarChave, chaveNFe);
    }

    @Override
    public List<NotaFiscalPropria> findNotasPorPeriodoSemControleCaixaNFCe(Date dataInicial, Date dataFinal, Empresa empresa) {
        List<BloqueioNotaFiscalPropria> bloqueios = this.serviceBloqueioNotaFiscalPropria.verificaBloqueios(dataFinal, empresa);
        if (bloqueios != null && !bloqueios.isEmpty()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0373.001"));
        }
        return ((DaoNotaFiscalPropriaImpl)this.getGenericDao()).findNotasPorPeriodoSemControleCaixaNFCe(dataInicial, dataFinal, empresa.getEmpresaDados().getGrupoEmpresa());
    }

    @Override
    public List findProdutosValorDataNFPropria(Date data, Empresa empresa) {
        return ((DaoNotaFiscalPropriaImpl)this.getGenericDao()).findProdutosValorDataNFPropria(data, empresa);
    }

    @Async
    public CompletableFuture findNotasPorPeriodoSemControleCaixaNFCeAsync(Date dataInicial, Date dataFinal, Empresa empresa) {
        List<NotaFiscalPropria> notas = this.findNotasPorPeriodoSemControleCaixaNFCe(dataInicial, dataFinal, empresa);
        return CompletableFuture.completedFuture(this.buildToDTO(notas, DTOIntegracaoNotaFiscalPropria.DTONotaFiscalPropriaRes.class));
    }

    public List findNotasPeriodoPaginado(Date dataIn, Date dataFim, Integer i, Integer firstResult, Short filtrarNumeroSerie, String serie, Integer numeroInicial, Integer numeroFinal, GrupoEmpresa grupoEmpresa) {
        return ((DaoNotaFiscalPropriaImpl)this.getGenericDao()).findNotasPeriodoPaginado(dataIn, dataFim, i, firstResult, filtrarNumeroSerie, serie, numeroInicial, numeroFinal, grupoEmpresa);
    }

    public List findNotasOrigemDevolucaoPeriodoPaginado(Date dataIn, Date dataFim, int i, int firstResult, GrupoEmpresa grupoEmpresa) {
        return ((DaoNotaFiscalPropriaImpl)this.getGenericDao()).findNotasOrigemDevolucaoPeriodoPaginado(dataIn, dataFim, i, firstResult, grupoEmpresa);
    }

    public VersaoNFe getVersaoEmissaoNFe(Long idNota) {
        return ((DaoNotaFiscalPropriaImpl)this.getDao()).getVersaoEmissaoNFe(idNota);
    }

    public String getChaveNFe(Long idNota) {
        return ((DaoNotaFiscalPropriaImpl)this.getDao()).getChaveNFe(idNota);
    }

    public List<NotaFiscalPropria> getNotaFiscalPropriaRPA(Long geracaoReciboRpa) {
        return ((DaoNotaFiscalPropriaImpl)this.getGenericDao()).getNotaFiscalPropriaRPA(geracaoReciboRpa);
    }

    public NotaFiscalPropria findNotaPropriaPorChave(String chave) {
        return ((DaoNotaFiscalPropriaImpl)this.getGenericDao()).findNotaPropriaPorChave(chave);
    }

    public List<NotaFiscalPropria> findNotasEnvioBoletoEmMassa(Long[] empresa, Date dataInicial, Date dataFinal, Long[] ramo, Long[] meioPag, CarteiraCobranca carteira, Integer intervaloDias) {
        return ((DaoNotaFiscalPropriaImpl)this.getGenericDao()).findNotasEnvioBoletoEmMassa(empresa, dataInicial, dataFinal, ramo, meioPag, carteira, intervaloDias);
    }

    public List<NotaFiscalPropria> findNotasNaoApuradasReinf2020(GrupoEmpresa grupo, Date periodo, Boolean filtrarNotasRetidas) {
        return ((DaoNotaFiscalPropriaImpl)this.getGenericDao()).findNotasNaoApuradasReinf2020(grupo, periodo, filtrarNotasRetidas);
    }

    public List<DTONotaFiscalPropria> getNotaFiscalPropria(Long[] ids) {
        List notaFiscalPropria = this.gets(ids);
        return this.buildToDTOGeneric(notaFiscalPropria, DTONotaFiscalPropria.class);
    }
}

