/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.notafiscalpropria;

import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorservice.components.notafiscal.CompNotaFiscal;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.ServiceNotaFiscalPropriaImpl;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.zip.ToolZipUtils;
import com.touchcomp.basementorxml.model.XMLNfePropria;
import com.touchcomp.basementorxml.service.impl.xmlnfepropria.ServiceXMLNFePropriaImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceNotaFiscalPropriaXML
extends ServiceGenericImpl {
    @Autowired
    ServiceNotaFiscalPropriaImpl serviceNF;
    @Autowired
    ServiceXMLNFePropriaImpl serviceXML;

    public File getXMLsZipFile(String ... chaves) throws ExceptionIO, ExceptionInvalidData {
        return this.getXMLsZipFile(ToolMethods.toList((Object[])chaves));
    }

    public File getXMLsZipFile(List<Long> ids) throws ExceptionIO, ExceptionInvalidData {
        File tmpDir = ToolFile.getFileTMPDir();
        File zip = new File(tmpDir.getAbsolutePath() + File.separator + "arquivo_xml_documentos.zip");
        ToolZipUtils.compress((File)zip, this.getXMLsFile(ids));
        return zip;
    }

    public List<File> getXMLsFile(List<Long> ids) throws ExceptionIO, ExceptionInvalidData {
        LinkedList<File> files = new LinkedList<File>();
        LinkedList<Long> aux = new LinkedList<Long>();
        for (Long id : ids) {
            if (aux.contains(id)) continue;
            files.add(this.getXMLFile(id));
            aux.add(id);
        }
        return files;
    }

    public File getXMLFile(Long idNota) throws ExceptionIO, ExceptionInvalidData {
        return this.getXMLFile(idNota, false);
    }

    public File getXMLFile(Long idNota, boolean removeInvalidUTF) throws ExceptionIO, ExceptionInvalidData {
        try {
            File tmpDir = ToolFile.getFileTMPDir();
            XMLNfePropria aux = this.serviceXML.getXMlNfePropria(idNota);
            if (aux == null) {
                throw new ExceptionInvalidData("E.ERP.1910.001", new Object[]{idNota});
            }
            if (!ToolMethods.isStrWithData((String)aux.getConteudoXML())) {
                throw new ExceptionInvalidData("E.ERP.1910.001", new Object[]{idNota});
            }
            if (!ToolMethods.isStrWithData((String)aux.getConteudoAprovacao())) {
                throw new ExceptionInvalidData("E.ERP.1910.002", new Object[]{idNota});
            }
            VersaoNFe versao = this.serviceNF.getVersaoEmissaoNFe(idNota);
            String chaveNFe = this.serviceNF.getChaveNFe(idNota);
            File temp = new File(tmpDir.getAbsolutePath() + File.separator + CompNotaFiscal.getFileNameXML(chaveNFe));
            Object xml = aux.getConteudoXML();
            String xmlAutorizacao = aux.getConteudoAprovacao();
            if (removeInvalidUTF) {
                xml = ToolString.removeIllegalXMLChar((String)xml);
            }
            if (removeInvalidUTF) {
                xmlAutorizacao = ToolString.removeIllegalXMLChar((String)xmlAutorizacao);
            }
            if (!((String)xml).startsWith("<?xml version=")) {
                xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + (String)xml;
            }
            SAXBuilder sb = new SAXBuilder();
            SAXBuilder sb1 = new SAXBuilder();
            xml = ((String)xml).replaceAll("&#xD;", "");
            xml = ((String)xml).replaceAll("&#xA;", "");
            Document d = sb.build((InputStream)new ByteArrayInputStream(((String)xml).getBytes()));
            Element e = null;
            if (xmlAutorizacao != null) {
                Document a = sb1.build((InputStream)new ByteArrayInputStream(xmlAutorizacao.getBytes()));
                e = a.detachRootElement();
            }
            Element nfeProc = new Element("nfeProc");
            Attribute at = new Attribute("versao", versao.getCodigo());
            nfeProc.setAttribute(at);
            nfeProc.setNamespace(Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe"));
            Element root = d.detachRootElement();
            nfeProc.addContent((Content)root);
            if (e != null) {
                nfeProc.addContent((Content)e);
            }
            String retorno = new XMLOutputter().outputString(nfeProc);
            StringBuilder sbd = new StringBuilder();
            sbd.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            sbd.append(retorno);
            ToolFile.writeStringInFile((File)temp, (String)sbd.toString());
            return temp;
        }
        catch (JDOMException ex) {
            this.logError(ex);
            throw new ExceptionInvalidData("E.ERP.1910.003", new Object[]{idNota});
        }
        catch (IOException ex) {
            this.logError(ex);
            throw new ExceptionInvalidData("E.ERP.1910.003", new Object[]{idNota});
        }
    }
}

