/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.notafiscalpropria;

import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.constants.enums.piscofins.EnumConstTipoAliquotaPisCofins;
import com.touchcomp.basementor.constants.enums.situacaodocumento.EnumConstSituacaoDocumento;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.ClienteFaturamento;
import com.touchcomp.basementor.model.vo.ClienteFichaFinanceira;
import com.touchcomp.basementor.model.vo.ClienteFinanceiro;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.DadosTransNfPropria;
import com.touchcomp.basementor.model.vo.DocumentosRefNFPropriaPR;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.GeracaoContaPessoa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.GrupoDocumentosRefPR;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.IntegracaoNotaPropriaNotas;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObsFaturamento;
import com.touchcomp.basementor.model.vo.ObservacaoNotaPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.OpcoesECommerce;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesFinanceirasTaxas;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.PeriodoEmissaoNFe;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.UnidadeFederativaOrigDest;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorservice.components.calculoimpostos.CalculosImpFiscaisNotaPropria;
import com.touchcomp.basementorservice.components.calculoimpostos.impostosxml.AuxImportarNotaPropriaCofins;
import com.touchcomp.basementorservice.components.calculoimpostos.impostosxml.AuxImportarNotaPropriaICMS;
import com.touchcomp.basementorservice.components.calculoimpostos.impostosxml.AuxImportarNotaPropriaICMSDifal;
import com.touchcomp.basementorservice.components.calculoimpostos.impostosxml.AuxImportarNotaPropriaICMSSN;
import com.touchcomp.basementorservice.components.calculoimpostos.impostosxml.AuxImportarNotaPropriaIPI;
import com.touchcomp.basementorservice.components.calculoimpostos.impostosxml.AuxImportarNotaPropriaPis;
import com.touchcomp.basementorservice.components.calculovalores.BaseCalculoValores;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilNF;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais.CompLancamentosEntradaSaidaFiscais;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.CompGeracaoLancCtbGerencial;
import com.touchcomp.basementorservice.helpers.impl.modelofiscal.HelperModeloFiscal;
import com.touchcomp.basementorservice.helpers.impl.notapropria.HelperItemNotaPropria;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorservice.service.impl.cfop.ServiceCfopImpl;
import com.touchcomp.basementorservice.service.impl.cidade.ServiceCidadeImpl;
import com.touchcomp.basementorservice.service.impl.cliente.ServiceClienteImpl;
import com.touchcomp.basementorservice.service.impl.finalidademnfe.ServiceFinalidadeEmNFeImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.modelodocfiscal.ServiceModeloDocFiscalImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.ServiceNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.UtilityNotaFiscalPropria;
import com.touchcomp.basementorservice.service.impl.opcoescontabeis.ServiceOpcoesContabeisImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaoctbmodfiscal.ServiceParametrizacaoCtbModFiscalImpl;
import com.touchcomp.basementorservice.service.impl.periodoemissaonfe.ServicePeriodoEmissaoNFeImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.situacaodocumento.ServiceSituacaoDocumentoImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatcliente.ServiceUnidadeFatClienteImpl;
import com.touchcomp.basementorservice.service.impl.unidadefederativaorigdest.ServiceUnidadeFederativaOrigDestImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceCfop;
import com.touchcomp.basementorservice.service.interfaces.ServicePlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class UtilityGeracaoNotaPropriaXML {
    Namespace n = Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe");
    private HelperModeloFiscal helperModeloFiscal = (HelperModeloFiscal)ConfApplicationContext.getBean(HelperModeloFiscal.class);
    private ServiceCfop serviceCfop = (ServiceCfop)ConfApplicationContext.getBean(ServiceCfop.class);
    private CompLancamentosEntradaSaidaFiscais compLancamentos = (CompLancamentosEntradaSaidaFiscais)ConfApplicationContext.getBean(CompLancamentosEntradaSaidaFiscais.class);
    private ServicePlanoConta servicePlanoConta = (ServicePlanoConta)ConfApplicationContext.getBean(ServicePlanoConta.class);
    private ServiceProdutoImpl serviceProduto = (ServiceProdutoImpl)ConfApplicationContext.getBean(ServiceProdutoImpl.class);
    private ServiceUnidadeFatClienteImpl serviceUnidadeFatCliente = (ServiceUnidadeFatClienteImpl)ConfApplicationContext.getBean(ServiceUnidadeFatClienteImpl.class);
    private ServiceGradeCorImpl serviceGradeCor = (ServiceGradeCorImpl)ConfApplicationContext.getBean(ServiceGradeCorImpl.class);
    private ServiceParametrizacaoCtbModFiscalImpl serviceParametrizacaoCtbModFiscal = (ServiceParametrizacaoCtbModFiscalImpl)ConfApplicationContext.getBean(ServiceParametrizacaoCtbModFiscalImpl.class);
    private ServiceLoteFabricacaoImpl serviceLoteFabricacao = (ServiceLoteFabricacaoImpl)ConfApplicationContext.getBean(ServiceLoteFabricacaoImpl.class);
    private ServiceSituacaoDocumentoImpl serviceSituacaoDocumento = (ServiceSituacaoDocumentoImpl)ConfApplicationContext.getBean(ServiceSituacaoDocumentoImpl.class);
    private ServiceUnidadeFederativaOrigDestImpl serviceUnidadeFederativaOrigDest = (ServiceUnidadeFederativaOrigDestImpl)ConfApplicationContext.getBean(ServiceUnidadeFederativaOrigDestImpl.class);
    private ServiceModeloDocFiscalImpl serviceModeloDocFiscal = (ServiceModeloDocFiscalImpl)ConfApplicationContext.getBean(ServiceModeloDocFiscalImpl.class);
    private ServicePeriodoEmissaoNFeImpl servicePeriodoEmissaoNFe = (ServicePeriodoEmissaoNFeImpl)ConfApplicationContext.getBean(ServicePeriodoEmissaoNFeImpl.class);
    private ServiceCfopImpl daoCfop = (ServiceCfopImpl)ConfApplicationContext.getBean(ServiceCfopImpl.class);
    private ServiceCidadeImpl daoCidade = (ServiceCidadeImpl)ConfApplicationContext.getBean(ServiceCidadeImpl.class);
    private ServiceClienteImpl daoCliente = (ServiceClienteImpl)ConfApplicationContext.getBean(ServiceClienteImpl.class);
    private ServiceNotaFiscalPropriaImpl daoNotaPropria = (ServiceNotaFiscalPropriaImpl)ConfApplicationContext.getBean(ServiceNotaFiscalPropriaImpl.class);
    private ServiceOpcoesContabeisImpl daoOpcoesContabeis = (ServiceOpcoesContabeisImpl)ConfApplicationContext.getBean(ServiceOpcoesContabeisImpl.class);
    private SCompPlanoConta scPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);

    public NotaFiscalPropria getProcessarNota(Document d, OpcoesFaturamento opcoesFaturamento, OpcoesFinanceiras opcoesFinanceira, OpcoesECommerce opcoesEcommerce, Empresa empresa, EmpresaContabilidade empresaContabilidade, OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos, OpcoesContabeis opcoesContabeis, OpcoesImpostos opImpostos) throws Exception {
        Element inf = d.getRootElement().getChild("NFe", this.n).getChild("infNFe", this.n);
        Element infProt = d.getRootElement().getChild("protNFe", this.n).getChild("infProt", this.n);
        NotaFiscalPropria nota = this.getNotaFiscalPropria(inf, empresa);
        if (nota == null) {
            Object campo = null;
            nota = new NotaFiscalPropria();
            nota.setInformarDadosReformaTributaria(opcoesFaturamento.getInformarDadosReformaTributaria());
            nota.setDataCadastro(new Date());
            nota.setEmpresa(empresa);
            nota.setFaturadoSuframa(Short.valueOf((short)0));
            nota.setSituacaoDocumento(this.getSituacaoDocumentoRegular());
            nota.setVersaoNfe(opcoesFaturamento.getVersaoNFe());
            nota.setIndicadorEmitente(Short.valueOf((short)0));
            nota.setEnviadoReceita(Short.valueOf((short)1));
            nota.setFormatoImpressao(opcoesFaturamento.getTipoImpressao());
            nota.setPeriodoEmissaoNFe(this.getPeriodoEmissaoAtivo(opcoesFaturamento.getEmpresa()));
            nota.setLiberarImpDanfe(Short.valueOf((short)1));
            nota.setCondicaoPagamento(opcoesEcommerce.getCondicoesPagamentoNF());
            if (nota.getCondicaoPagamento() != null && nota.getCondicaoPagamento().getMeioPagamento() != null) {
                nota.setMeioPagamento(nota.getCondicaoPagamento().getMeioPagamento());
            } else {
                nota.setMeioPagamento(opcoesFinanceira.getMeioPagamento());
            }
            this.dadosIde(inf, nota, opcoesEcommerce);
            this.dadosDest(inf, nota, opcoesEcommerce, opcoesContabeis);
            this.dadosProtRecebimento(infProt, nota);
            this.dadosTransp(inf, nota);
            this.dadosDet(inf, nota, opcoesFaturamento, empresaContabilidade, opcoesEcommerce.getRespeitarImpostosXML(), opcoesEcommerce.getCentroEstoqueNF(), opcoesContabeis, opImpostos);
            this.dadosInfAdic(inf, nota, opcoesEcommerce.getObsFaturamentoNF());
            this.dadosCobr(inf, nota, this.n, opcoesFinanceira, opcoesEcommerce.getCondicoesPagamento(), opcoesContabeisBaixaTitulos, opcoesContabeis);
            new UtilityNotaFiscalPropria().calcularTotalizadores(nota);
            this.dadosTotal(inf, nota);
            nota.setLivrosFiscais(new UtilityNotaFiscalPropria().getLivroFiscaisResumo(nota.getItensNotaPropria(), new ArrayList(), nota.getModeloDocFiscal(), nota.getSituacaoDocumento()));
            this.criarLoteContabil(nota, empresaContabilidade, opcoesContabeis);
        }
        if (nota.getFinalidadeEmNFe() == null) {
            nota.setFinalidadeEmNFe(nota.getNaturezaOperacao().getFinalidadeEmNFe());
        }
        if (nota.getFinalidadeEmNFeTipo() == null) {
            nota.setFinalidadeEmNFeTipo(nota.getNaturezaOperacao().getFinalidadeEmNFeTipo());
        }
        return nota;
    }

    public NotaFiscalPropria getProcessarNotaCancelada(Document d, OpcoesFaturamento opcoesFaturamento, OpcoesFinanceiras opcoesFinanceira, OpcoesECommerce opcoesEcommerce, Empresa empresa, EmpresaContabilidade empresaContabilidade, OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos, OpcoesContabeis opcoesContabeis, OpcoesImpostos opImpostos) throws Exception {
        NotaFiscalPropria nota;
        Element inf = d.getRootElement().getChild("infNFe", this.n);
        if (inf == null) {
            inf = d.getRootElement().getChild("NFe", this.n).getChild("infNFe", this.n);
        }
        if ((nota = this.getNotaFiscalPropria(inf, empresa)) == null) {
            nota = new NotaFiscalPropria();
            nota.setInformarDadosReformaTributaria(opcoesFaturamento.getInformarDadosReformaTributaria());
            Object campo = null;
            nota.setDataCadastro(new Date());
            nota.setEmpresa(empresa);
            nota.setFaturadoSuframa(Short.valueOf((short)0));
            nota.setSituacaoDocumento(this.getSituacaoDocumentoRegular());
            nota.setVersaoNfe(opcoesFaturamento.getVersaoNFe());
            nota.setIndicadorEmitente(Short.valueOf((short)0));
            nota.setEnviadoReceita(Short.valueOf((short)1));
            nota.setFormatoImpressao(opcoesFaturamento.getTipoImpressao());
            nota.setPeriodoEmissaoNFe(this.getPeriodoEmissaoAtivo(opcoesFaturamento.getEmpresa()));
            nota.setLiberarImpDanfe(Short.valueOf((short)0));
            nota.setCondicaoPagamento(opcoesEcommerce.getCondicoesPagamentoNF());
            if (nota.getCondicaoPagamento() != null && nota.getCondicaoPagamento().getMeioPagamento() != null) {
                nota.setMeioPagamento(nota.getCondicaoPagamento().getMeioPagamento());
            } else {
                nota.setMeioPagamento(opcoesFinanceira.getMeioPagamento());
            }
            this.dadosIde(inf, nota, opcoesEcommerce);
            this.dadosDest(inf, nota, opcoesEcommerce, opcoesContabeis);
            this.dadosTransp(inf, nota);
            this.dadosDet(inf, nota, opcoesFaturamento, empresaContabilidade, opcoesEcommerce.getRespeitarImpostosXML(), opcoesEcommerce.getCentroEstoqueNF(), opcoesContabeis, opImpostos);
            this.dadosInfAdic(inf, nota, opcoesEcommerce.getObsFaturamentoNF());
            this.dadosCobr(inf, nota, this.n, opcoesFinanceira, opcoesEcommerce.getCondicoesPagamento(), opcoesContabeisBaixaTitulos, opcoesContabeis);
            new UtilityNotaFiscalPropria().calcularTotalizadores(nota);
            this.dadosTotal(inf, nota);
            nota.setLivrosFiscais(new UtilityNotaFiscalPropria().getLivroFiscaisResumo(nota.getItensNotaPropria(), new ArrayList(), nota.getModeloDocFiscal(), nota.getSituacaoDocumento()));
        }
        if (nota.getFinalidadeEmNFe() == null) {
            nota.setFinalidadeEmNFe(nota.getNaturezaOperacao().getFinalidadeEmNFe());
        }
        if (nota.getFinalidadeEmNFeTipo() == null) {
            nota.setFinalidadeEmNFeTipo(nota.getNaturezaOperacao().getFinalidadeEmNFeTipo());
        }
        return nota;
    }

    private NotaFiscalPropria getNotaFiscalPropria(Element inf, Empresa empresa) {
        String nrNota = inf.getChild("ide", this.n).getChild("nNF", this.n).getText();
        String serie = inf.getChild("ide", this.n).getChild("serie", this.n).getText();
        return this.daoNotaPropria.getPorNumeroSerieEmpresa(Integer.valueOf(nrNota), serie, empresa);
    }

    private SituacaoDocumento getSituacaoDocumentoRegular() throws Exception {
        return this.serviceSituacaoDocumento.get(EnumConstSituacaoDocumento.REGULAR);
    }

    public Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino, Produto prod) throws Exception {
        if (prod == null) {
            return 0.0;
        }
        if (ufDestino.equals((Object)ufOrigem)) {
            return prod.getAliquotaIcms();
        }
        return this.getAliquotaICMS(ufOrigem, ufDestino);
    }

    public Double getAliquotaICMS(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino) throws Exception {
        UnidadeFederativaOrigDest found = this.serviceUnidadeFederativaOrigDest.get(ufOrigem, ufDestino);
        if (found != null) {
            return found.getAliquotaICMS();
        }
        return 0.0;
    }

    private PeriodoEmissaoNFe getPeriodoEmissaoAtivo(Empresa empresa) throws Exception {
        return this.servicePeriodoEmissaoNFe.findPeriodoEmissaoNFeAtivo(empresa);
    }

    public ModeloDocFiscal getModeloPorCodigo(String codigo) throws Exception {
        return this.serviceModeloDocFiscal.findByCodigo(EnumConstantsModeloDocFiscal.valueOfCodigo((String)codigo));
    }

    private List<ItemNotaFiscalPropria> getItensNota(NotaFiscalPropria nota, List listaItens, OpcoesFaturamento opcoesFaturamento, Short respeitarImpostos, EmpresaContabilidade empresaContabilidade, CentroEstoque centroEstoque, OpcoesContabeis opCont, OpcoesImpostos opImpostos) throws Exception {
        ArrayList<ItemNotaFiscalPropria> itensNota = new ArrayList<ItemNotaFiscalPropria>();
        int i = 1;
        for (Object object : listaItens) {
            Element det = (Element)object;
            String codigo = det.getChild("prod", this.n).getChild("cProd", this.n).getText();
            Cliente cliente = nota.getUnidadeFatCliente().getCliente();
            NaturezaOperacao natureOperacao = nota.getNaturezaOperacao();
            Produto produto = this.serviceProduto.getByCodigoAuxiliar(codigo);
            if (produto == null) {
                throw new Exception("Nenhum produto encontrado para o codigo " + codigo);
            }
            ItemNotaFiscalPropria it = new ItemNotaFiscalPropria();
            it.setNotaFiscalPropria(nota);
            it.setCentroEstoque(centroEstoque);
            it.setQuantidadeTotal(Double.valueOf(det.getChild("prod", this.n).getChild("qCom", this.n).getText()));
            it.setValorUnitario(Double.valueOf(det.getChild("prod", this.n).getChild("vUnCom", this.n).getText()));
            it.setVrProduto(Double.valueOf(det.getChild("prod", this.n).getChild("vProd", this.n).getText()));
            if (det.getChild("prod", this.n).getChild("vFrete", this.n) != null) {
                it.setValorFrete(Double.valueOf(det.getChild("prod", this.n).getChild("vFrete", this.n).getText()));
                it.setValorFreteItemInf(Double.valueOf(det.getChild("prod", this.n).getChild("vFrete", this.n).getText()));
                it.setFreteItem(Short.valueOf((short)1));
            }
            if (det.getChild("prod", this.n).getChild("vSeg", this.n) != null) {
                it.setVrSeguro(Double.valueOf(det.getChild("prod", this.n).getChild("vSeg", this.n).getText()));
                it.setValorSeguroItemInf(Double.valueOf(det.getChild("prod", this.n).getChild("vSeg", this.n).getText()));
                it.setSeguroItem(Short.valueOf((short)1));
            }
            if (det.getChild("prod", this.n).getChild("vDesc", this.n) != null) {
                it.setValorDesconto(Double.valueOf(det.getChild("prod", this.n).getChild("vDesc", this.n).getText()));
                it.setValorDescontoItemInf(Double.valueOf(det.getChild("prod", this.n).getChild("vDesc", this.n).getText()));
                it.setDescontoItem(Short.valueOf((short)1));
            }
            if (det.getChild("prod", this.n).getChild("vOutro", this.n) != null) {
                it.setValorDespAcessoria(Double.valueOf(det.getChild("prod", this.n).getChild("vOutro", this.n).getText()));
                it.setValorDespAcessItemInf(Double.valueOf(det.getChild("prod", this.n).getChild("vOutro", this.n).getText()));
                it.setDespAcessItem(Short.valueOf((short)1));
            }
            this.validarValoresItem(it);
            it.setNotaFiscalPropria(nota);
            if (opcoesFaturamento.getClassificacaoVendasPadrao() != null) {
                it.setClassificacaoVendas(opcoesFaturamento.getClassificacaoVendasPadrao());
            }
            it.setFatorConversao(Double.valueOf(1.0));
            it.setNumeroItem(Integer.valueOf(i));
            it.setProduto(produto);
            it.setUnidadeMedida(produto.getUnidadeMedida());
            it.setItemNotaLivroFiscal(new ItemNotaLivroFiscal());
            it.getItemNotaLivroFiscal().setItemNotaFiscalPropria(it);
            it.setIndicadorTotal(Short.valueOf((short)1));
            it.setModeloFiscal(this.getModeloFiscal(it));
            it.setGerarFinanceiro(it.getModeloFiscal().getGerarFinanceiro());
            new HelperItemNotaPropria().setParametrosCBSIBSIS(it, nota.getEmpresa(), nota.getDataEmissaoNota(), nota.getNaturezaOperacao(), nota.getUnidadeFatCliente());
            it.setGradesNotaFiscalPropria(this.getGradeItemNotaFiscalPropria(it.getValorUnitario(), it.getQuantidadeTotal(), nota.getDataEntradaSaida(), it, nota.getEmpresa(), nota.getNaturezaOperacao().getEntradaSaida()));
            ModeloFiscal mod = it.getModeloFiscal();
            Produto prod = it.getProduto();
            it.setIncidenciaIcms(mod.getModeloFiscalIcms().getIncidenciaIcms());
            it.setIncidenciaIpi(mod.getModeloFiscalIpi().getIncidenciaIpi());
            it.setIncidenciaPisCofins(mod.getModeloFiscalPisCofins().getIncidenciaPisCofins());
            it.setModalidadeIcms(mod.getModeloFiscalIcms().getModalidadeIcms());
            it.setModalidadeIcmsSt(mod.getModeloFiscalIcms().getModalidadeIcmsSt());
            it.setIssRetido(Short.valueOf(mod.getIssRetido().equals((short)1) ? (short)1 : 0));
            String codCfop = det.getChild("prod", this.n).getChild("CFOP", this.n).getText();
            StringBuilder sb = new StringBuilder();
            sb.append(codCfop.substring(0, 1));
            sb.append(".");
            sb.append(codCfop.substring(1, 4));
            Cfop cfop = this.daoCfop.findByCodigo(sb.toString());
            if (cfop != null) {
                it.getItemNotaLivroFiscal().setCfop(cfop);
            } else if (nota.getNaturezaOperacao().getEntradaSaida() == 1) {
                it.getItemNotaLivroFiscal().setCfop(this.serviceCfop.findCfopSaida(nota.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), nota.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), mod, EnumConstNFeIndicadorPresConsumidor.valueOfCodigo((Short)it.getNotaFiscalPropria().getIndicadorPresencaConsumidor())));
            } else {
                it.getItemNotaLivroFiscal().setCfop(this.serviceCfop.findCfopEntrada(nota.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), nota.getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf(), mod));
            }
            this.setDadosContabeis(it, nota, opCont, it.getItemNotaLivroFiscal().getCfop());
            if (mod.getTipoIRRF() != null && mod.getTipoIRRF() == 1) {
                it.getItemNotaLivroFiscal().setAliquotaIrrf(prod.getAliquotaIrrf());
                it.getItemNotaLivroFiscal().setPercRedIrrf(prod.getPercRedIrrf());
            }
            if (mod.getTipoFunrural() != null && mod.getTipoFunrural() == 1) {
                it.getItemNotaLivroFiscal().setAliquotaFunrural(prod.getAliquotaFunrural());
                it.getItemNotaLivroFiscal().setPercRedFunrural(prod.getPercRedFunrural());
            }
            if (mod.getTipoSenar() != null && mod.getTipoSenar() == 1) {
                it.getItemNotaLivroFiscal().setAliquotaSenar(prod.getAliquotaSenar());
            }
            if (mod.getTipoRat() != null && mod.getTipoRat() == 1) {
                it.getItemNotaLivroFiscal().setAliquotaRat(prod.getAliquotaRat());
            }
            if (mod.getTipoTaxaAnimal() != null && mod.getTipoTaxaAnimal() == 1) {
                it.getItemNotaLivroFiscal().setTaxaSanidadeAnimal(prod.getTaxaSanidadeAnimal());
                it.getItemNotaLivroFiscal().setFatorTaxaSanidadeAnimal(prod.getFatorTaxaSanidadeAnimal());
            }
            if (mod.getTipoLei10833() != null && mod.getTipoLei10833() == 1) {
                it.getItemNotaLivroFiscal().setAliquotaLei10833(prod.getAliquotaLei10833());
                it.getItemNotaLivroFiscal().setPercRedLei10833(prod.getPercRedLei10833());
            }
            if (mod.getTipoOutros() != null && mod.getTipoOutros() == 1) {
                it.getItemNotaLivroFiscal().setAliquotaOutros(prod.getAliquotaOutros());
                it.getItemNotaLivroFiscal().setPercRedOutros(prod.getPercRedOutros());
            }
            if (mod.getTipoContSoc() != null && mod.getTipoContSoc() == 1) {
                it.getItemNotaLivroFiscal().setAliquotaContSoc(prod.getAliquotaContSoc());
                it.getItemNotaLivroFiscal().setPercRedContSoc(prod.getPercRedContSoc());
            }
            if (mod.getIssRetido() != null && mod.getIssRetido() != 2) {
                it.getItemNotaLivroFiscal().setAliquotaIss(prod.getAliquotaIss());
            }
            if (mod.getModeloFiscalPisCofins().getCalcularPisNormal().equals((short)1)) {
                if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                    it.getItemNotaLivroFiscal().setAliquotaPis(mod.getModeloFiscalPisCofins().getAliquotaPis());
                } else {
                    it.getItemNotaLivroFiscal().setAliquotaPis(it.getProduto().getAliquotaPis());
                }
            } else {
                it.getItemNotaLivroFiscal().setAliquotaPis(Double.valueOf(0.0));
            }
            if (mod.getModeloFiscalPisCofins().getCalcularPisSt().equals((short)1)) {
                if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                    it.getItemNotaLivroFiscal().setAliquotaPisSt(mod.getModeloFiscalPisCofins().getAliquotaPisSt());
                } else {
                    it.getItemNotaLivroFiscal().setAliquotaPisSt(it.getProduto().getAliquotaPisSt());
                }
            } else {
                it.getItemNotaLivroFiscal().setAliquotaPisSt(Double.valueOf(0.0));
            }
            if (mod.getModeloFiscalPisCofins().getCalcularCofinsNormal().equals((short)1)) {
                if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                    it.getItemNotaLivroFiscal().setAliquotaCofins(mod.getModeloFiscalPisCofins().getAliquotaCofins());
                } else {
                    it.getItemNotaLivroFiscal().setAliquotaCofins(it.getProduto().getAliquotaCofins());
                }
            } else {
                it.getItemNotaLivroFiscal().setAliquotaCofins(Double.valueOf(0.0));
            }
            if (mod.getModeloFiscalPisCofins().getCalcularCofinsSt().equals((short)1)) {
                if (ToolMethods.isEquals((Object)mod.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                    it.getItemNotaLivroFiscal().setAliquotaCofinsSt(mod.getModeloFiscalPisCofins().getAliquotaCofinsSt());
                } else {
                    it.getItemNotaLivroFiscal().setAliquotaCofinsSt(it.getProduto().getAliquotaCofinsSt());
                }
            } else {
                it.getItemNotaLivroFiscal().setAliquotaCofinsSt(Double.valueOf(0.0));
            }
            double alICMS = 0.0;
            alICMS = mod.getModeloFiscalIcms().getTipoAliquotaIcms() == 2 ? mod.getModeloFiscalIcms().getAliquotaIcms().doubleValue() : this.getAliquotaICMS(nota.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), nota.getUnidadeFatCliente().getCliente().getPessoa().getEndereco().getCidade().getUf(), prod).doubleValue();
            it.getItemNotaLivroFiscal().setAliquotaIcms(Double.valueOf(alICMS));
            if (ToolMethods.isEquals((Object)mod.getModeloFiscalIcms().getTipoPercReducaoBaseCalcIcms(), (Object)2)) {
                it.getItemNotaLivroFiscal().setPercReducaoBCIcms(mod.getModeloFiscalIcms().getReducaoBaseCalcIcms());
            } else {
                it.getItemNotaLivroFiscal().setPercReducaoBCIcms(prod.getReducaoBaseCalcIcms());
            }
            Double aliqIpi = BaseCalculoValores.getAliquotaIpi(prod, mod.getModeloFiscalIpi());
            it.getItemNotaLivroFiscal().setAliquotaIpi(aliqIpi);
            if (mod.getTipoINSS() != null && mod.getTipoINSS() == 1) {
                it.getItemNotaLivroFiscal().setAliquotaInss(prod.getAliquotaInss());
                it.getItemNotaLivroFiscal().setPercRedBcInss(prod.getPercRedBCINSS());
            }
            it.setCest(it.getProduto().getCest());
            it.setNcm(it.getProduto().getNcm());
            new CalculosImpFiscaisNotaPropria().calcularImpostosFiscaisItNotaPropria(it, nota.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), nota.getUnidadeFatCliente(), nota.getSituacaoDocumento(), nota.getEmpresa(), nota.getIndicadorConsumidorFinal(), opcoesFaturamento, nota.getDataEmissaoNota(), empresaContabilidade, opImpostos);
            if (respeitarImpostos != null && respeitarImpostos == 1) {
                Element impostos = det.getChild("imposto", this.n);
                Element icms = impostos.getChild("ICMS", this.n);
                Element ipi = impostos.getChild("IPI", this.n);
                Element pis = impostos.getChild("PIS", this.n);
                Element cofins = impostos.getChild("COFINS", this.n);
                Element icmsDifal = impostos.getChild("ICMSUFDest", this.n);
                new AuxImportarNotaPropriaICMS().valoresImpostosICMS(icms, it);
                new AuxImportarNotaPropriaICMSSN().valoresImpostosICMSSN(icms, it);
                new AuxImportarNotaPropriaICMSDifal().valoresImpostosICMSDifal(icmsDifal, it);
                new AuxImportarNotaPropriaIPI().valoresImpostosIPI(ipi, it);
                new AuxImportarNotaPropriaPis().valoresImpostosPIS(pis, it);
                new AuxImportarNotaPropriaCofins().valoresImpostosCofins(cofins, it);
                it.setNaoCalcularIcms(Short.valueOf((short)1));
                it.setNaoCalcularIpi(Short.valueOf((short)1));
                it.setNaoCalcularPisCofins(Short.valueOf((short)1));
                new HelperItemNotaPropria(it).setNatReceitaPisCofins();
            }
            itensNota.add(it);
        }
        return itensNota;
    }

    private void setDadosContabeis(ItemNotaFiscalPropria i, NotaFiscalPropria no, OpcoesContabeis opCont, Cfop cfop) throws Exception {
        CompParametrizacaoContabilNF comp = (CompParametrizacaoContabilNF)Context.get(CompParametrizacaoContabilNF.class);
        CompParametrizacaoContabilNF.DadosContas dados = comp.getPlanoContasNfPropria(i.getModeloFiscal(), i.getProduto(), no.getUnidadeFatCliente(), no.getNaturezaOperacao(), no.getEmpresa(), no.getUnidadeFatCliente().getCategoriaPessoa(), opCont, cfop);
        i.setPlanoContaCred(dados.getPlanoContaCred());
        i.setPlanoContaDeb(dados.getPlanoContaDeb());
        i.setPlanoContaGerencial(dados.getPcGerencial());
        if (i.getPlanoContaGerencial() == null) {
            throw new Exception("Plano de conta gerencial n\u00c3\u00a3o definido na parametriza\u00c3\u00a7\u00c3\u00a3o cont\u00c3\u00a1bil do modelo fiscal ou no produto.");
        }
    }

    private List<GradeItemNotaFiscalPropria> getGradeItemNotaFiscalPropria(Double valorUnitario, Double quantidade, Date dataEntradaSaida, ItemNotaFiscalPropria item, Empresa empresa, Short entradaSaida) throws Exception {
        ArrayList<GradeItemNotaFiscalPropria> gr = new ArrayList<GradeItemNotaFiscalPropria>();
        GradeItemNotaFiscalPropria g = new GradeItemNotaFiscalPropria();
        item.setFatorConversao(Double.valueOf(1.0));
        g.setGradeCor(this.findPrimeiraGradeCor(item.getProduto()));
        g.setItemNotaFiscalPropria(item);
        g.setLoteFabricacao((LoteFabricacao)this.findLoteProduto(item.getProduto()));
        g.setDataEntradaSaida(dataEntradaSaida);
        g.setValorCusto(valorUnitario);
        g.setMovimentacaoFisica(item.getModeloFiscal().getMovimentacaoFisica());
        g.setQuantidade(quantidade);
        g.setCentroEstoque(item.getCentroEstoque());
        g.setEmpresa(empresa);
        g.setFatorConversao(item.getFatorConversao());
        g.setEntradaSaida(entradaSaida);
        gr.add(g);
        return gr;
    }

    public Object findLoteProduto(Produto produto) throws Exception {
        LoteFabricacao loteFab = this.serviceLoteFabricacao.findLoteUnico(produto);
        if (loteFab == null) {
            loteFab = new LoteFabricacao();
            loteFab.setLoteFabricacao("UNICO");
            loteFab.setDataFabricacao(new Date());
            loteFab.setProduto(produto);
            loteFab.setLoteFabricacao("UNICO");
            loteFab.setStatusLoteFabricacao(produto.getStatusLoteFabricacao());
            loteFab.setLoteBloqueado(produto.getStatusLoteFabricacao().getLoteBloqueado());
            loteFab.setUnico(Short.valueOf((short)1));
            loteFab = this.serviceLoteFabricacao.saveOrUpdate(loteFab);
        }
        return loteFab;
    }

    public GradeCor findPrimeiraGradeCor(Produto produto) throws Exception {
        GradeCor gc = this.serviceGradeCor.getFirstGradeCor(produto);
        if (gc == null) {
            throw new Exception("Produto: " + produto.getNome() + " n\u00c3\u00a3o possui Grade de Cor");
        }
        return gc;
    }

    private void validarValoresItem(ItemNotaFiscalPropria it) {
        if (it.getQuantidadeTotal() == 0.0) {
            it.setQuantidadeTotal(Double.valueOf(1.0));
        }
        if (it.getValorUnitario() == 0.0) {
            it.setValorUnitario(it.getVrProduto());
        }
    }

    private ModeloFiscal getModeloFiscal(ItemNotaFiscalPropria item) throws ExceptionObjNotFound {
        UnidadeFatCliente unidade = item.getNotaFiscalPropria().getUnidadeFatCliente();
        ModeloFiscal modelo = null;
        if (unidade != null && unidade.getCategoriaPessoa() != null && unidade.getPessoa().getEndereco().getCidade() != null && item.getNotaFiscalPropria().getNaturezaOperacao() != null) {
            modelo = this.helperModeloFiscal.getFirst(item.getProduto(), unidade, item.getNotaFiscalPropria().getNaturezaOperacao(), item.getNotaFiscalPropria().getEmpresa());
        }
        return modelo;
    }

    private boolean dadosIde(Element inf, NotaFiscalPropria nota, OpcoesECommerce opcoesEcommerce) throws Exception {
        String ide = inf.getChild("ide", this.n).getChild("tpNF", this.n).getText();
        if (ide.equals("1")) {
            nota.setNaturezaOperacao(opcoesEcommerce.getNaturezaOperacaoNF());
        } else {
            nota.setNaturezaOperacao(opcoesEcommerce.getNaturezaOperacaoDevNF());
        }
        ide = inf.getChild("ide", this.n).getChild("nNF", this.n).getText();
        Integer numNota = Integer.parseInt(ide);
        nota.setNumeroNota(numNota);
        nota.setNumeroNotaInf(nota.getNumeroNota());
        ide = inf.getChild("ide", this.n).getChild("serie", this.n).getText();
        nota.setSerie(ide);
        nota.setSerieInf(nota.getSerie());
        ide = inf.getChild("ide", this.n).getChild("cNF", this.n).getText();
        nota.setCodChaveAcesso(Integer.valueOf(ide));
        ide = inf.getChild("ide", this.n).getChild("cDV", this.n).getText();
        nota.setDigitoVerificador(Integer.valueOf(ide));
        ide = inf.getChild("ide", this.n).getChild("mod", this.n).getText();
        nota.setModeloDocFiscal(this.getModeloPorCodigo(ide));
        ide = inf.getChild("ide", this.n).getChild("dhEmi", this.n).getText();
        nota.setDataEmissaoNota(ToolDate.strToDate((String)(ide.substring(8, 10) + "/" + ide.substring(5, 7) + "/" + ide.substring(0, 4))));
        nota.setHoraEmissao(nota.getDataEmissaoNota());
        ide = inf.getChild("ide", this.n).getChild("dhSaiEnt", this.n).getText();
        nota.setDataEntradaSaida(ToolDate.strToDate((String)(ide.substring(8, 10) + "/" + ide.substring(5, 7) + "/" + ide.substring(0, 4))));
        nota.setHoraEntradaSaida(nota.getDataEntradaSaida());
        ide = inf.getChild("ide", this.n).getChild("tpImp", this.n).getText();
        Short formatoImpressao = Short.parseShort(ide);
        nota.setFormatoImpressao(formatoImpressao);
        ide = inf.getChild("ide", this.n).getChild("tpEmis", this.n).getText();
        Short tipoEmissao = Short.parseShort(ide);
        nota.setTipoEmissao(tipoEmissao);
        String finalidade = ide = inf.getChild("ide", this.n).getChild("finNFe", this.n).getText();
        nota.setFinalidadeEmNFe(((ServiceFinalidadeEmNFeImpl)Context.get(ServiceFinalidadeEmNFeImpl.class)).getByCodigo(String.valueOf(finalidade)));
        nota.setIndicadorPresencaConsumidor(Short.valueOf(Short.parseShort(inf.getChild("ide", this.n).getChild("indPres", this.n).getText())));
        nota.setIndicadorConsumidorFinal(Short.valueOf(Short.parseShort(inf.getChild("ide", this.n).getChild("indFinal", this.n).getText())));
        ide = inf.getAttributeValue("Id");
        String id = ide.substring(3, 47);
        nota.setChaveNFE(id);
        nota.setChaveNFEInf(id);
        Element nfRef = inf.getChild("ide", this.n).getChild("NFref", this.n);
        if (nfRef != null && (ide = nfRef.getChild("refNFe", this.n).getText()) != null && !ide.isEmpty()) {
            GrupoDocumentosRefPR g = new GrupoDocumentosRefPR();
            g.setNotaFiscalPropria(nota);
            DocumentosRefNFPropriaPR d = new DocumentosRefNFPropriaPR();
            d.setChaveNFe(ide);
            g.getNotasProprias().add(d);
            nota.setGrupoDocumentosRefPR(g);
        }
        return true;
    }

    private void dadosDest(Element inf, NotaFiscalPropria nota, OpcoesECommerce opcoesECommerce, OpcoesContabeis opcoesContabeis) throws Exception {
        String cpfCnpj = "";
        cpfCnpj = inf.getChild("dest", this.n).getChild("CNPJ", this.n) != null ? inf.getChild("dest", this.n).getChild("CNPJ", this.n).getText() : inf.getChild("dest", this.n).getChild("CPF", this.n).getText();
        String inscEst = inf.getChild("dest", this.n).getChild("indIEDest", this.n).getText();
        inscEst = inscEst.equals("1") ? inf.getChild("dest", this.n).getChild("IE", this.n).getText() : "ISENTO";
        nota.setUnidadeFatCliente(this.serviceUnidadeFatCliente.getCNPJInscEst(cpfCnpj, inscEst));
        if (nota.getUnidadeFatCliente() == null) {
            nota.setUnidadeFatCliente(this.serviceUnidadeFatCliente.findUnidadeFatByCpfCnpj(cpfCnpj));
            if (nota.getUnidadeFatCliente() == null) {
                this.createCliente(inf, nota, opcoesECommerce, opcoesContabeis);
            }
        }
        if (nota.getUnidadeFatCliente() != null) {
            nota.setClassificacaoCliente(nota.getUnidadeFatCliente().getCliente().getClassificacaoClientes());
            nota.setCategoriaPessoa(nota.getUnidadeFatCliente().getCategoriaPessoa());
        }
    }

    private void dadosProtRecebimento(Element infProt, NotaFiscalPropria nota) {
        nota.setStatus(Short.valueOf(Short.parseShort(infProt.getChild("cStat", this.n).getText())));
        nota.setMotivo(infProt.getChild("xMotivo", this.n).getText());
        nota.setNrProtocolo(infProt.getChild("nProt", this.n).getText());
    }

    private void dadosTransp(Element inf, NotaFiscalPropria nota) {
        DadosTransNfPropria dadosTransNfPropria = new DadosTransNfPropria();
        dadosTransNfPropria.setTransportador(nota.getUnidadeFatCliente().getCliente().getFaturamento().getTransportadora());
        dadosTransNfPropria.setTipoFrete(nota.getUnidadeFatCliente().getCliente().getFaturamento().getTipoFrete());
        dadosTransNfPropria.setNotaFiscalPropria(nota);
        nota.setDadosTransNfPropria(dadosTransNfPropria);
    }

    private void dadosDet(Element inf, NotaFiscalPropria nota, OpcoesFaturamento opcoesFaturamento, EmpresaContabilidade empresaContabilidade, Short respeitarImpostos, CentroEstoque centroEstoque, OpcoesContabeis opCont, OpcoesImpostos opImpostos) throws Exception {
        List listaItens = inf.getChildren("det", this.n);
        nota.setItensNotaPropria(this.getItensNota(nota, listaItens, opcoesFaturamento, respeitarImpostos, empresaContabilidade, centroEstoque, opCont, opImpostos));
    }

    private void dadosInfAdic(Element inf, NotaFiscalPropria nota, ObsFaturamento obsFaturamento) throws Exception {
        ArrayList<ObservacaoNotaPropria> observacoes = new ArrayList<ObservacaoNotaPropria>();
        if (inf.getChild("infAdic", this.n) != null) {
            List tit = inf.getChildren("infAdic", this.n);
            if (obsFaturamento != null) {
                for (Object o : tit) {
                    Element dup = (Element)o;
                    ObservacaoNotaPropria obs = new ObservacaoNotaPropria();
                    obs.setObsFaturamento(obsFaturamento);
                    obs.setConteudo(dup.getChildText("infCpl", this.n));
                    obs.setNotaFiscalPropria(nota);
                    observacoes.add(obs);
                }
            }
        }
        nota.setObservacaoNota(observacoes);
    }

    private void dadosTotal(Element inf, NotaFiscalPropria nota) {
        if (nota.getDadosTransNfPropria() == null) {
            nota.setDadosTransNfPropria(new DadosTransNfPropria());
        }
        String value = inf.getChild("total", this.n).getChild("ICMSTot", this.n).getChild("vFrete", this.n).getText();
        Double vrFrete = Double.parseDouble(value);
        nota.getValoresNfPropria().setValorFrete(vrFrete);
        value = inf.getChild("total", this.n).getChild("ICMSTot", this.n).getChild("vDesc", this.n).getText();
        Double vrDesconto = Double.parseDouble(value);
        nota.getValoresNfPropria().setValorDesconto(vrDesconto);
        value = inf.getChild("total", this.n).getChild("ICMSTot", this.n).getChild("vOutro", this.n).getText();
        Double vrDespAces = Double.parseDouble(value);
        nota.getValoresNfPropria().setValorDespAcess(vrDespAces);
        value = inf.getChild("total", this.n).getChild("ICMSTot", this.n).getChild("vSeg", this.n).getText();
        Double vrSeguro = Double.parseDouble(value);
        nota.getValoresNfPropria().setValorSeguro(vrSeguro);
        value = inf.getChild("total", this.n).getChild("ICMSTot", this.n).getChild("vIPI", this.n).getText();
        Double vrIPi = Double.parseDouble(value);
        nota.getValoresNfPropria().setValorIpiOutros(vrIPi);
        value = inf.getChild("total", this.n).getChild("ICMSTot", this.n).getChild("vICMS", this.n).getText();
        Double vrICMS = Double.parseDouble(value);
        nota.getValoresNfPropria().setValorIcms(vrICMS);
        value = inf.getChild("total", this.n).getChild("ICMSTot", this.n).getChild("vNF", this.n).getText();
        Double vrTotal = Double.parseDouble(value);
        nota.getValoresNfPropria().setValorTotal(vrTotal);
        nota.getValoresNfPropria().setVrBcCofins(vrTotal);
        nota.getValoresNfPropria().setVrBcPis(vrTotal);
        value = inf.getChild("total", this.n).getChild("ICMSTot", this.n).getChild("vPIS", this.n).getText();
        Double vrPis = Double.parseDouble(value);
        nota.getValoresNfPropria().setValorPis(vrPis);
        value = inf.getChild("total", this.n).getChild("ICMSTot", this.n).getChild("vCOFINS", this.n).getText();
        Double vrCofins = Double.parseDouble(value);
        nota.getValoresNfPropria().setValorCofins(vrCofins);
        value = inf.getChild("total", this.n).getChild("ICMSTot", this.n).getChild("vProd", this.n).getText();
        Double vrProd = Double.parseDouble(value);
        nota.getValoresNfPropria().setValorProduto(vrProd);
        value = inf.getChild("total", this.n).getChild("ICMSTot", this.n).getChild("vBCST", this.n).getText();
        Double vrBC = Double.parseDouble(value);
        nota.getValoresNfPropria().setBcIcmsSt(vrBC);
    }

    private void dadosCobr(Element inf, NotaFiscalPropria nota, Namespace n, OpcoesFinanceiras op, CondicoesPagamento condPag, OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData {
        ArrayList<Titulo> titulos = new ArrayList<Titulo>();
        Short cont = 1;
        if (inf.getChild("cobr", n) != null) {
            InfPagamentoNfPropria i = new InfPagamentoNfPropria();
            i.setNotaFiscalPropria(nota);
            i.setMeioPagamento(op.getMeioPagamento());
            if (i.getMeioPagamento() != null) {
                i.setTipoPagamentoNFe(i.getMeioPagamento().getTipoPagamentoNFe());
            }
            List tit = inf.getChild("cobr", n).getChildren("dup", n);
            Double valorTotal = 0.0;
            for (Object o : tit) {
                Element dup = (Element)o;
                Titulo titulo = new Titulo();
                Pessoa pessoa = nota.getUnidadeFatCliente().getCliente().getPessoa();
                titulo.setPessoa(pessoa);
                if (nota.getClassificacaoCliente() != null) {
                    titulo.setClassificacaoPessoa(nota.getClassificacaoCliente());
                } else {
                    titulo.setClassificacaoPessoa(op.getClassificacaoClientes());
                }
                titulo.setCartCobrancaDestino(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(op).getCarteiraCobrancaDestino(pessoa, null));
                titulo.setTipoDoc(op.getTipoDocFinanceiro());
                titulo.setPagRec(Short.valueOf((short)1));
                titulo.setProvisao(Short.valueOf((short)1));
                titulo.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(op).getCarteiraCobranca(titulo.getPagRec()));
                if (dup.getChild("dVenc", n) != null) {
                    String data = dup.getChild("dVenc", n).getText();
                    Date dataVenc = null;
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        dataVenc = format.parse(data);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    titulo.setDataVencimento(dataVenc);
                } else {
                    titulo.setDataVencimento(new Date());
                }
                titulo.setDataVencimentoBase(titulo.getDataVencimento());
                Date dataEmissao = nota.getDataEmissaoNota();
                titulo.setDataEmissao(dataEmissao);
                titulo.setDataCompetencia(nota.getDataEntradaSaida());
                titulo.setDataEntradaSaida(titulo.getDataCompetencia());
                if (dup.getChild("vDup", n) != null) {
                    String value = dup.getChild("vDup", n).getText();
                    Double valor = Double.parseDouble(value);
                    titulo.setValor(valor);
                } else {
                    titulo.setValor(Double.valueOf(0.0));
                }
                if (op.getPercJurosMes() != null && op.getPercJurosMes() > 0.0) {
                    titulo.setPercJurosMes(op.getPercJurosMes());
                    titulo.setVrJurosDia(Double.valueOf(titulo.getValor() * (titulo.getPercJurosMes() / 100.0) / 30.0));
                } else {
                    titulo.setPercJurosMes(Double.valueOf(0.0));
                    titulo.setVrJurosDia(Double.valueOf(0.0));
                }
                titulo.setVrDescontoCondicional(Double.valueOf(0.0));
                Date dataAtual = new Date();
                titulo.setDataCadastro(dataAtual);
                titulo.setEmpresa(nota.getEmpresa());
                titulo.setPercJurosMes(Double.valueOf(0.0));
                titulo.setNumParcTituloEstnota(cont);
                titulo.setMovimentoTitulos(new HashSet());
                PlanoConta plano = this.scPlanoConta.getPlanoConta(nota.getUnidadeFatCliente().getCliente(), opcoesContabeis);
                titulo.setPlanoConta(plano);
                titulo.setTipoPessoa(EnumConstPessoa.CLIENTE.getEnumId());
                titulo.setObservacao("NFP:  (" + titulo.getNumParcTituloEstnota() + "/" + tit.size() + ")" + titulo.getPessoa().toString());
                this.setarPercJurosMultaDesconto(titulo, op);
                titulo.setMeioPagamento(op.getMeioPagamento());
                titulo.setInfPagamentoNfPropria(i);
                i.getTitulos().add(titulo);
                valorTotal = valorTotal + titulo.getValor();
                titulos.add(titulo);
                Short s = cont;
                cont = (short)(cont + 1);
            }
            i.setValor(valorTotal);
            nota.getInfPagamentoNfPropria().add(i);
        } else {
            nota.setInfPagamentoNfPropria(new ArrayList());
        }
        CompGeracaoLancCtbGerencial.criarSetarLancamentosCTBGerencial(nota, titulos, nota.getEmpresa(), opcoesContabeisBaixaTitulos);
        if (condPag != null && !titulos.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Boolean error = false;
            block3: for (InfPagamentoNfPropria infPag : nota.getInfPagamentoNfPropria()) {
                for (Titulo t : infPag.getTitulos()) {
                    int diferenca = ToolDate.diferenceDayBetweenDates((Date)nota.getDataEmissaoNota(), (Date)t.getDataVencimento());
                    if (diferenca >= 0) {
                        sb.append(diferenca);
                        sb.append(";");
                        continue;
                    }
                    error = true;
                    continue block3;
                }
            }
            if (!error.booleanValue()) {
                nota.setCondicaoPagamento(condPag);
                nota.setParcelas(sb.toString());
            }
        }
    }

    private void criarLoteContabil(NotaFiscalPropria nota, EmpresaContabilidade empresaContabilidade, OpcoesContabeis opcoesContabeis) throws Exception {
        if (empresaContabilidade.getLancNotaPropria() == 0) {
            if (nota.getIntegracaoNotaPropriaNotas() != null) {
                nota.getIntegracaoNotaPropriaNotas().setLoteContabil(this.compLancamentos.contabilizar(nota, opcoesContabeis));
            } else {
                nota.setIntegracaoNotaPropriaNotas(new IntegracaoNotaPropriaNotas());
                nota.getIntegracaoNotaPropriaNotas().setLoteContabil(this.compLancamentos.contabilizar(nota, opcoesContabeis));
                nota.getIntegracaoNotaPropriaNotas().setNotaPropria(nota);
            }
        }
    }

    private Short getContribuinteEstado(UnidadeFatCliente unidade) {
        if (unidade.getPessoa().getComplemento().getContribuinteEstado() == null || unidade.getPessoa().getComplemento().getContribuinteEstado().equals((short)3)) {
            return unidade.getCliente().getPessoa().getComplemento().getContribuinteEstado();
        }
        return unidade.getPessoa().getComplemento().getContribuinteEstado();
    }

    private void setarPercJurosMultaDesconto(Titulo t, OpcoesFinanceiras op) {
        if (t.getPagRec() == 1) {
            Double percJuros = op.getPercJurosMes();
            Double percDesc = op.getPercDescMes();
            Double percMulta = op.getPercMulta();
            OpcoesFinanceirasTaxas opTaxas = this.getOpcoesFinanceirasTaxas(t.getMeioPagamento(), op);
            if (opTaxas != null) {
                percJuros = opTaxas.getPercJurosMes();
                percDesc = opTaxas.getPercDescMes();
                percMulta = opTaxas.getPercMulta();
            }
            if (percJuros != null) {
                t.setPercJurosMes(percJuros);
                t.setVrJurosDia(Double.valueOf(t.getValor() * (percJuros / 100.0) / 30.0));
            } else {
                t.setPercJurosMes(Double.valueOf(0.0));
                t.setVrJurosDia(Double.valueOf(0.0));
            }
            if (percDesc != null) {
                t.setPercDescontoMes(percDesc);
            } else {
                t.setPercDescontoMes(Double.valueOf(0.0));
            }
            if (percMulta != null) {
                t.setPercMulta(percMulta);
            } else {
                t.setPercMulta(Double.valueOf(0.0));
            }
        }
    }

    private OpcoesFinanceirasTaxas getOpcoesFinanceirasTaxas(MeioPagamento meioPagamento, OpcoesFinanceiras op) {
        if (meioPagamento != null) {
            for (OpcoesFinanceirasTaxas taxa : op.getTaxas()) {
                if (!taxa.getMeioPagamento().equals((Object)meioPagamento)) continue;
                return taxa;
            }
        }
        return null;
    }

    private void createCliente(Element inf, NotaFiscalPropria nota, OpcoesECommerce opcoesECommmerce, OpcoesContabeis opcoesContabeis) throws Exception {
        String cpfCnpj = "";
        Short tipoPessoa = null;
        if (inf.getChild("dest", this.n).getChild("CNPJ", this.n) != null) {
            cpfCnpj = inf.getChild("dest", this.n).getChild("CNPJ", this.n).getText();
            tipoPessoa = EnumConstTipoPessoaComplementar.JURIDICA.getEnumId();
        } else {
            cpfCnpj = inf.getChild("dest", this.n).getChild("CPF", this.n).getText();
            tipoPessoa = EnumConstTipoPessoaComplementar.FISICA.getEnumId();
        }
        String inscEst = inf.getChild("dest", this.n).getChild("indIEDest", this.n).getText();
        Short contribuinteEstado = null;
        if (inscEst.equals("1")) {
            inscEst = inf.getChild("dest", this.n).getChild("IE", this.n).getText();
            contribuinteEstado = EnumConstContrEstadoIcms.CONTRIBUINTE.getEnumId();
        } else if (inscEst.equals("9")) {
            inscEst = "ISENTO";
            contribuinteEstado = EnumConstContrEstadoIcms.ISENTO.getEnumId();
        } else {
            contribuinteEstado = EnumConstContrEstadoIcms.NAO_CONTRIBUINTE.getEnumId();
        }
        String nome = inf.getChild("dest", this.n).getChild("xNome", this.n).getText();
        String email = "";
        if (inf.getChild("dest", this.n).getChild("email", this.n) != null) {
            inf.getChild("dest", this.n).getChild("email", this.n).getText();
        }
        Element end = inf.getChild("dest", this.n).getChild("enderDest", this.n);
        String codMun = end.getChild("cMun", this.n).getText();
        String logradouro = end.getChild("xLgr", this.n).getText();
        String nro = end.getChild("nro", this.n).getText();
        String compl = "";
        if (end.getChild("xCpl", this.n) != null) {
            compl = end.getChild("xCpl", this.n).getText();
        }
        String bairro = end.getChild("xBairro", this.n).getText();
        String cep = end.getChild("CEP", this.n).getText();
        String fone = "";
        if (end.getChild("fone", this.n) != null) {
            end.getChild("fone", this.n).getText();
        }
        Pessoa p = new Pessoa();
        p.setAtivo(Short.valueOf((short)1));
        p.setNome(nome);
        p.setDataInicioRelacionamento(new Date());
        p.setDataCadastro(new Date());
        Complemento complemento = new Complemento();
        complemento.setAtivo(p.getAtivo());
        complemento.setCnpj(cpfCnpj);
        complemento.setInscEst(inscEst);
        complemento.setFone1(fone);
        if (email != null && !email.isEmpty()) {
            complemento.getEmails().add(this.getEmailPessoa(email));
            complemento.setEmailPrincipal(email);
        }
        complemento.setContribuinteEstado(contribuinteEstado);
        complemento.setTipoPessoa(tipoPessoa);
        Endereco endereco = new Endereco();
        endereco.setLogradouro(logradouro);
        endereco.setBairro(bairro);
        endereco.setNumero(nro);
        endereco.setComplemento(compl);
        endereco.setCep(cep);
        Cidade cidade = this.getCidadePorCodIBGE(codMun);
        endereco.setCidade(cidade);
        p.setEndereco(endereco);
        p.setComplemento(complemento);
        p.setContasPessoa(new GeracaoContaPessoa());
        Cliente c = new Cliente();
        c.setEmpresa(nota.getEmpresa());
        c.setDataCadastro(new Date());
        c.setRegiao(opcoesECommmerce.getRegiao());
        c.setClassificacaoClientes(opcoesECommmerce.getClassificacaoClientes());
        c.setPessoa(p);
        ClienteFinanceiro cf = new ClienteFinanceiro();
        cf.setCliente(c);
        cf.setHabilParaCompra(Integer.valueOf(0));
        ClienteFichaFinanceira cff = new ClienteFichaFinanceira();
        cff.setCliente(c);
        ClienteFaturamento cfa = new ClienteFaturamento();
        cfa.setCliente(c);
        cfa.setCategoriaPessoa(opcoesECommmerce.getCategoriaPessoa());
        cfa.setCondicaoPagamento(opcoesECommmerce.getCondicoesPagamento());
        cfa.setRamoAtividade(opcoesECommmerce.getRamoAtividade());
        cfa.setTransportadora(opcoesECommmerce.getTransportador());
        cfa.setRepresentante(opcoesECommmerce.getRepresentante());
        cfa.setTipoFrete(opcoesECommmerce.getTipoFrete());
        cfa.setTipoConsumidor(Short.valueOf((short)1));
        c.setFinanceiro(cf);
        c.setFaturamento(cfa);
        c.setFichaFinanceira(cff);
        UnidadeFatCliente u = new UnidadeFatCliente();
        u.setCliente(c);
        u.setPessoa(p);
        c.getUnidadeFatClientes().add(u);
        p.setContasPessoa(new GeracaoContaPessoa());
        c = this.daoCliente.saveOrUpdate(c);
        nota.setUnidadeFatCliente((UnidadeFatCliente)c.getUnidadeFatClientes().get(0));
        if (nota.getUnidadeFatCliente() != null) {
            nota.setClassificacaoCliente(nota.getUnidadeFatCliente().getCliente().getClassificacaoClientes());
            nota.setCategoriaPessoa(nota.getUnidadeFatCliente().getCategoriaPessoa());
        }
    }

    private EmailPessoa getEmailPessoa(String email) {
        EmailPessoa e = new EmailPessoa();
        e.setDescricao(email);
        e.setAtivo(Short.valueOf((short)1));
        e.setEmail(email);
        return e;
    }

    private Cidade getCidadePorCodIBGE(String codIBGE) {
        if (codIBGE.trim().length() == 7) {
            return this.daoCidade.getByCodigoIBGECompleto(codIBGE.trim());
        }
        if (codIBGE.trim().length() == 5) {
            return this.daoCidade.getByCodigoIBGE(codIBGE.trim());
        }
        return null;
    }

    private PlanoConta gerarPlanoContaCliente(Cliente c, OpcoesContabeis op) throws ExceptionObjectNotFound {
        return this.servicePlanoConta.getNewPlanoConta(op.getOpcoesContabeisGerContaPessoa().getPlanoContaCliente(), c.getPessoa().getNome(), c.getPessoa().getComplemento().getCnpj(), op);
    }
}

