/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.notafiscalpropria;

import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementorxml.model.XMLNfePropria;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFePropria;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class UtilityNfe {
    private final ServiceXMLNFePropria serviceXMLNFePropria = (ServiceXMLNFePropria)Context.get(ServiceXMLNFePropria.class);

    public String toXMLString(NotaFiscalPropria n) throws IOException, Exception {
        XMLNfePropria xml = this.serviceXMLNFePropria.getXMlNfePropria(n.getIdentificador());
        return this.exportarXML(xml.getConteudoXML(), xml.getConteudoAprovacao(), n.getChaveNFE(), n.getNumeroNota(), n.getVersaoNfe());
    }

    private String exportarXML(String xml, String xmlAutorizacao, String chaveNFE, Integer nrNF, VersaoNFe versao) throws JDOMException, IOException, Exception {
        String retorno;
        SAXBuilder sb = new SAXBuilder();
        SAXBuilder sb1 = new SAXBuilder();
        if (xml == null || xml == null) {
            throw new Exception("Nota " + nrNF + " sem arquivo xml.");
        }
        Document d = sb.build((InputStream)new ByteArrayInputStream(xml.getBytes()));
        Element e = null;
        if (xmlAutorizacao != null) {
            Document a = sb1.build((InputStream)new ByteArrayInputStream(xmlAutorizacao.getBytes()));
            e = a.detachRootElement();
        }
        Element nfeProc = new Element("nfeProc");
        Attribute at = new Attribute("versao", versao.getCodigo());
        nfeProc.setAttribute(at);
        nfeProc.setNamespace(Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe"));
        Element root = d.detachRootElement();
        nfeProc.addContent((Content)root);
        if (e != null) {
            nfeProc.addContent((Content)e);
        }
        if ((retorno = new XMLOutputter().outputString(nfeProc)).contains("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>")) {
            return retorno;
        }
        StringBuilder sbd = new StringBuilder();
        sbd.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        sbd.append(retorno);
        return sbd.toString();
    }
}

