/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.notafiscalpropria;

import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Cooperado;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorservice.components.livrofiscal.impl.CompLivroFiscalNotaPropria;
import com.touchcomp.basementorservice.components.totalizadores.CompTotalizadores;
import com.touchcomp.basementorservice.service.interfaces.ServiceCooperado;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class UtilityNotaFiscalPropria {
    @Autowired
    CompLivroFiscalNotaPropria compLivroFiscalNotaPropria;

    public void calcularTotalizadores(NotaFiscalPropria nf) {
        CompTotalizadores calc = new CompTotalizadores();
        calc.calculaTotalizadores(nf);
        Cooperado cooperado = this.getCooperadoPorCliente(nf.getUnidadeFatCliente().getCliente());
        if (cooperado != null && (cooperado.getTipoRAT() != null && cooperado.getTipoRAT() == 1 || cooperado.getTipoSenar() != null && cooperado.getTipoRAT() == 1 || cooperado.getTipoInss() != null && cooperado.getTipoInss() == 1)) {
            this.calcularInssCooperado(nf, cooperado);
            this.calcularRATCooperado(nf, cooperado);
            this.calcularSenarCooperado(nf, cooperado);
        }
    }

    private Cooperado getCooperadoPorCliente(Cliente cliente) {
        ServiceCooperado serviceCooperado = (ServiceCooperado)ConfApplicationContext.getBean(ServiceCooperado.class);
        return serviceCooperado.findCooperadoPorCliente(cliente);
    }

    private void calcularRATCooperado(NotaFiscalPropria nf, Cooperado cooperado) {
        Double aliquotaRAT = 0.0;
        Double bcRAT = 0.0;
        Double valorRAT = 0.0;
        if (cooperado.getTipoRAT() != null && cooperado.getTipoRAT() == 1) {
            aliquotaRAT = cooperado.getAliquotaRAT();
            bcRAT = nf.getValoresNfPropria().getValorTotal();
            valorRAT = aliquotaRAT / 100.0 * bcRAT;
        } else if (cooperado.getTipoRAT() != null && cooperado.getTipoRAT() == 0) {
            valorRAT = 0.0;
        }
        nf.getValoresNfPropria().setValorRAT(ToolFormatter.arrredondarNumero((Double)valorRAT, (int)2, (int)4));
    }

    private void calcularInssCooperado(NotaFiscalPropria nf, Cooperado cooperado) {
        Double aliquotaInss = 0.0;
        Double bcInss = 0.0;
        Double valorInss = 0.0;
        if (cooperado.getTipoInss() != null && cooperado.getTipoInss() == 1) {
            aliquotaInss = cooperado.getAliquotaInss();
            bcInss = nf.getValoresNfPropria().getValorTotal();
            valorInss = aliquotaInss / 100.0 * bcInss;
        } else if (cooperado.getTipoInss() != null && cooperado.getTipoInss() == 0) {
            valorInss = 0.0;
        }
        nf.getValoresNfPropria().setValorInssNaoRetido(ToolFormatter.arrredondarNumero((Double)valorInss, (int)2, (int)4));
    }

    private void calcularSenarCooperado(NotaFiscalPropria nf, Cooperado cooperado) {
        Double aliquotaSenar = 0.0;
        Double bcSenar = 0.0;
        Double valorSenar = 0.0;
        if (cooperado.getTipoSenar() != null && cooperado.getTipoSenar() == 1) {
            aliquotaSenar = cooperado.getAliquotaSenar();
            bcSenar = nf.getValoresNfPropria().getValorTotal();
            valorSenar = aliquotaSenar / 100.0 * bcSenar;
        } else if (cooperado.getTipoSenar() != null && cooperado.getTipoSenar() == 0) {
            valorSenar = 0.0;
        }
        nf.getValoresNfPropria().setValorSenar(ToolFormatter.arrredondarNumero((Double)valorSenar, (int)2, (int)4));
    }

    public List getLivroFiscaisResumo(List itens, List livrosOld, ModeloDocFiscal modeloDocFiscal, SituacaoDocumento situacaoDoc) throws ExceptionAvaliadorExpressoes {
        List<LivroFiscal> livros = this.compLivroFiscalNotaPropria.getLivroFiscaisResumo(itens, livrosOld, modeloDocFiscal, situacaoDoc);
        return livros;
    }
}

