/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.notafiscalterceiros;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.constants.enums.liberacaonotaterceiros.EnumLiberacaoNFTerceiros;
import com.touchcomp.basementor.model.impl.CustoProdutoUltimaNF;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Especie;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceirosFreteCtrc;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais.CompLancamentosEntradaSaidaFiscais;
import com.touchcomp.basementorservice.components.nfe.consultanfedoc.CompStatusConsNFeDoc;
import com.touchcomp.basementorservice.components.notaterceiros.avaliacaocriticasnfterceiros.CompAvaliacaoCriticasNFTerceiros;
import com.touchcomp.basementorservice.dao.impl.DaoNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.helpers.impl.wmsentradaprodutos.HelperWmsEntradaProdutos;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.livrofiscal.SCompLivroFiscal;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.ServiceNotaFiscalPropriaFreteCtrcImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosFreteCtrcImp;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.UtilCriarCalcularValorFreteCtrc;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.importarxml.UtilImportarNotaTerceiros;
import com.touchcomp.basementorservice.service.impl.opcoescomprasuprimentos.ServiceOpcoesCompraSuprimentosImpl;
import com.touchcomp.basementorservice.service.impl.opcoescontabeis.ServiceOpcoesContabeisImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceNotaFiscalTerceiros;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorxml.model.XMLNFeCTe;
import com.touchcomp.basementorxml.model.XMLNfeTerceiros;
import com.touchcomp.basementorxml.service.impl.xmlnfecte.ServiceXMLNFeCTeImpl;
import com.touchcomp.basementorxml.service.impl.xmlnfeterceiros.ServiceXMLNFeTerceirosImpl;
import com.touchcomp.touchvomodel.vo.integracaonotafiscalterceiros.web.DTOIntegracaoNotaFiscalTerceiros;
import com.touchcomp.touchvomodel.vo.lotecontabil.web.DTOLoteContabil;
import com.touchcomp.touchvomodel.vo.notafiscalterceiros.web.DTONotaFiscalTerceiros;
import com.touchcomp.touchvomodel.vo.notafiscalterceiros.web.DTONotaFiscalTerceirosRes;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ServiceNotaFiscalTerceirosImpl
extends ServiceGenericEntityImpl<NotaFiscalTerceiros, Long, DaoNotaFiscalTerceirosImpl>
implements ServiceNotaFiscalTerceiros {
    final ServiceNotaFiscalPropriaFreteCtrcImpl serviceNotaFreteNotaPropriaCTRC;
    final ServiceNotaFiscalTerceirosFreteCtrcImp serviceNotaFreteTercCTRC;
    final ServiceOpcoesContabeisImpl serviceOpcoesContabeisImpl;
    final ServiceEmpresaImpl serviceEmpresaImpl;
    final ServiceOpcoesCompraSuprimentosImpl serviceOpcoesCompraSuprimentosImpl;
    final CompStatusConsNFeDoc compStatusDoc;
    final CompAvaliacaoCriticasNFTerceiros compAvaliacaoCriticasNFTerceiros;
    final CompLancamentosEntradaSaidaFiscais compLancamentosEntradaSaidaFiscais;
    final SCompLivroFiscal sCompLivroFiscal;
    final ServiceXMLNFeTerceirosImpl serviceXmlTerc;
    final ServiceXMLNFeCTeImpl serviceXmlNfe;
    HelperWmsEntradaProdutos wmsEntradaProdutos;

    @Autowired
    public ServiceNotaFiscalTerceirosImpl(DaoNotaFiscalTerceirosImpl genericDao, ServiceNotaFiscalPropriaFreteCtrcImpl serviceNotaFreteNotaPropriaCTRC, ServiceNotaFiscalTerceirosFreteCtrcImp serviceNotaFreteTercCTRC, ServiceOpcoesContabeisImpl serviceOpcoesContabeisImp, ServiceEmpresaImpl serviceEmpresaImpl, ServiceOpcoesCompraSuprimentosImpl serviceOpcoesCompraSuprimentosImpl, HelperWmsEntradaProdutos wmsEntradaProdutos, CompStatusConsNFeDoc compStatusDoc, CompAvaliacaoCriticasNFTerceiros compAvaliacaoCriticasNFTerceiros, CompLancamentosEntradaSaidaFiscais compLancamentosEntradaSaidaFiscais, SCompLivroFiscal sCompLivroFiscal, ServiceXMLNFeTerceirosImpl serviceXmlTerc, ServiceXMLNFeCTeImpl serviceXmlNfe) {
        super(genericDao);
        this.serviceNotaFreteNotaPropriaCTRC = serviceNotaFreteNotaPropriaCTRC;
        this.serviceNotaFreteTercCTRC = serviceNotaFreteTercCTRC;
        this.serviceOpcoesContabeisImpl = serviceOpcoesContabeisImp;
        this.serviceEmpresaImpl = serviceEmpresaImpl;
        this.serviceOpcoesCompraSuprimentosImpl = serviceOpcoesCompraSuprimentosImpl;
        this.wmsEntradaProdutos = wmsEntradaProdutos;
        this.compStatusDoc = compStatusDoc;
        this.compAvaliacaoCriticasNFTerceiros = compAvaliacaoCriticasNFTerceiros;
        this.compLancamentosEntradaSaidaFiscais = compLancamentosEntradaSaidaFiscais;
        this.sCompLivroFiscal = sCompLivroFiscal;
        this.serviceXmlTerc = serviceXmlTerc;
        this.serviceXmlNfe = serviceXmlNfe;
    }

    @Override
    public Double getMenorCustoProd(Long idProduto, Empresa empresa) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).getMenorCustoProd(idProduto, empresa);
    }

    @Override
    public Double getCustoMedioProd(Long idProduto, Empresa empresa) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).getCustoMedioProd(idProduto, empresa);
    }

    @Override
    public HashMap importarNotaTerceirosPorXML(String naturezaOperacao, Date dataInicial, Date dataFinal, String cnpjEmpresa) {
        return new UtilImportarNotaTerceiros().importarNotaTerceiros(naturezaOperacao, dataInicial, dataFinal, cnpjEmpresa);
    }

    @Override
    public void importarNotaTerceirosPorXML(String naturezaOperacao, Date dataInicial, Date dataFinal, TaskProcessResult result) {
        new UtilImportarNotaTerceiros().importarNotaTerceirosTask(naturezaOperacao, dataInicial, dataFinal, result);
    }

    @Override
    public List<Produto> findProdutosNotas(Date dataInicial) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).findProdutosNotas(dataInicial);
    }

    public CustoProdutoUltimaNF getUltimoCustoProd(Long idProduto) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).getUltimoCustoProd(idProduto, null);
    }

    public CustoProdutoUltimaNF getUltimoCustoProd(Long idProduto, Empresa empresa) {
        return this.getUltimoCustoProd(idProduto, empresa.getIdentificador());
    }

    public CustoProdutoUltimaNF getUltimoCustoProd(Long idProduto, Long idEmpresa) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).getUltimoCustoProd(idProduto, idEmpresa);
    }

    public Double getValorUtilizadoCTe(NotaFiscalTerceiros notaTerceiros) {
        Double freteNFPropria = this.serviceNotaFreteNotaPropriaCTRC.getValorUtilizadoCTe(notaTerceiros);
        Double freteNFTerceiro = this.serviceNotaFreteTercCTRC.getValorUtilizadoCTe(notaTerceiros);
        return freteNFPropria + freteNFTerceiro;
    }

    public List<CustoProdutoUltimaNF> getUltimasEntradasProd(Long idProduto, Empresa logedEmpresa, Integer nrReg) {
        return this.getUltimasEntradasProd(idProduto, logedEmpresa, nrReg, false, false);
    }

    public List<CustoProdutoUltimaNF> getUltimasEntradasProd(Long idProduto, Empresa logedEmpresa, Integer nrReg, boolean carregarUltPrCompra, boolean carregarUltVlrCompra) {
        List<CustoProdutoUltimaNF> ret = ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).getUltimasEntradasProd(idProduto, logedEmpresa, nrReg);
        return ret;
    }

    public List<CustoProdutoUltimaNF> getUltimasEntradasProd(Long idProduto, Integer nrReg, Short filtraFonrDifGrupoEmp, GrupoEmpresa grupoEmp) {
        return this.getUltimasEntradasProd(idProduto, nrReg, false, false, filtraFonrDifGrupoEmp, grupoEmp);
    }

    public List<CustoProdutoUltimaNF> getUltimasEntradasProd(Long idProduto, Integer nrReg, boolean carregarUltPrCompra, boolean carregarUltVlrCompra, Short filtraFonrDifGrupoEmp, GrupoEmpresa grupoEmp) {
        List<CustoProdutoUltimaNF> ret = ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).getUltimasEntradasProd(idProduto, nrReg, filtraFonrDifGrupoEmp, grupoEmp);
        return ret;
    }

    public Double getUltimoValorCompra(Long idProduto) {
        CustoProdutoUltimaNF custo = this.getUltimoCustoProd(idProduto);
        return custo != null ? custo.getValorUltVlrCompra() : 0.0;
    }

    public Double getUltimoPrecoCompra(Long idProduto) {
        CustoProdutoUltimaNF custo = this.getUltimoCustoProd(idProduto);
        return custo != null ? custo.getValorUltPrecoCompra() : 0.0;
    }

    public String getCentroEstoqueUltimaCompra(Long idProduto) {
        CustoProdutoUltimaNF custo = this.getUltimoCustoProd(idProduto);
        return custo != null ? custo.getCentroEstoque() : "";
    }

    public Double getQtdeUltimaCompra(Long idProduto) {
        CustoProdutoUltimaNF custo = this.getUltimoCustoProd(idProduto);
        return custo != null ? custo.getQtde() : 0.0;
    }

    @Override
    public List<HashMap> findNotaTerceirosPorPeriodoAndEmpresa(Date dataInicial, Date dataFinal, Empresa empresa, Especie especie) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).findNotaTerceirosPorPeriodoAndEmpresa(dataInicial, dataFinal, empresa, especie);
    }

    @Override
    public List<NotaFiscalTerceiros> findNotasNaoLiberadasQualidade(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesCompraSuprimentos opcoesCompras) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).findNotasNaoLiberadasQualidade(dataInicial, dataFinal, empresa, opcoesCompras);
    }

    @Override
    public List<NotaFiscalTerceiros> findNotasNaoLiberadasFinanceiro(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesCompraSuprimentos opcoesCompras) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).findNotasNaoLiberadasFinanceiro(dataInicial, dataFinal, empresa, opcoesCompras);
    }

    @Override
    public List<NotaFiscalTerceiros> findNotasNaoLiberadasEstoque(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesCompraSuprimentos opcoesCompras) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).findNotasNaoLiberadasEstoque(dataInicial, dataFinal, empresa, opcoesCompras);
    }

    @Override
    public List<NotaFiscalTerceiros> findNotasNaoLiberadasFiscal(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesCompraSuprimentos opcoesCompras) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).findNotasNaoLiberadasFiscal(dataInicial, dataFinal, empresa, opcoesCompras);
    }

    @Override
    public List<NotaFiscalTerceiros> findNotasPorPeriodo(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).findNotasPorPeriodo(dataInicial, dataFinal, grupoEmpresa);
    }

    @Override
    public List<NotaFiscalTerceiros> findNotasPorPeriodoPaginado(Date dataInicial, Date dataFinal, Integer max, Integer first, Short filtrarNumeroSerie, String serie, Integer numeroInicial, Integer numeroFinal) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).findNotasPorPeriodoPaginado(dataInicial, dataFinal, max, first, filtrarNumeroSerie, serie, numeroInicial, numeroFinal);
    }

    @Async
    public CompletableFuture<List<DTOIntegracaoNotaFiscalTerceiros.DTONotaFiscalTerceiros>> findNotasPorPeriodoAsync(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        List<DTOIntegracaoNotaFiscalTerceiros.DTONotaFiscalTerceiros> result = this.buildToDTO(this.findNotasPorPeriodo(dataInicial, dataFinal, grupoEmpresa), DTOIntegracaoNotaFiscalTerceiros.DTONotaFiscalTerceiros.class);
        return CompletableFuture.completedFuture(result);
    }

    public NotaFiscalTerceiros findNotaTerceirosPorChave(String chave) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).findNotaTerceirosPorChave(chave);
    }

    public NotaFiscalTerceirosFreteCtrc criarCalcularValorFreteCtrc(NotaFiscalTerceiros notaFiscalTerceiros) {
        return new UtilCriarCalcularValorFreteCtrc().criarCalcularValorFreteCtrc(notaFiscalTerceiros);
    }

    public List<NotaFiscalTerceiros> pesquisarNotaTerceirosPeriodoDataEntradaUnidadeFatFornecedorNaoTicketFiscalEntrada(Empresa empresa, Short filtrarDataEntrada, Date dataEntradaInicial, Date dataEntradaFinal, Short filtrarFornecedor, UnidadeFatFornecedor unidadeFatFornecedor) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).pesquisarNotaTerceirosPeriodoDataEntradaUnidadeFatFornecedorNaoTicketFiscalEntrada(empresa, filtrarDataEntrada, dataEntradaInicial, dataEntradaFinal, filtrarFornecedor, unidadeFatFornecedor);
    }

    public List<NotaFiscalTerceiros> getNotasSemConfirmarOperacao(Empresa empresa, Date dataBase, Integer delayDiasLancamento, Integer maxRegsPerTime, Integer page) {
        return ((DaoNotaFiscalTerceirosImpl)this.getDao()).getNotasSemConfirmarOperacao(empresa, dataBase, delayDiasLancamento, maxRegsPerTime, page);
    }

    public List<NotaFiscalTerceiros> getNotasSemConfirmarOperacaoLiberadas(Empresa empresa, Date dataBase, Integer delayDiasLancamento, Integer maxRegsPerTime, Integer page) {
        return ((DaoNotaFiscalTerceirosImpl)this.getDao()).getNotasSemConfirmarOperacaoLiberadas(empresa, dataBase, delayDiasLancamento, maxRegsPerTime, page);
    }

    @Override
    public NotaFiscalTerceiros saveOrUpdateOnly(NotaFiscalTerceiros entity) {
        if (ToolMethods.isAffirmative((Number)this.getSharedData().getWmsOpcoes(entity.getEmpresa()).getEfetuarEntradaWmsAuto())) {
            try {
                entity.setWmsEntradaEstoque(this.wmsEntradaProdutos.getWmsEntrada(entity, this.getSharedData().getWmsOpcoes(entity.getEmpresa())));
            }
            catch (ExceptionInvalidState ex) {
                this.logError(ex);
                throw new ExceptionRuntimeBase((ExceptionBase)((Object)ex));
            }
        }
        if (entity.getConsultaNFeDestDocDist() != null) {
            this.compStatusDoc.definirStatusConsultaDoc(entity.getConsultaNFeDestDocDist());
        }
        entity.getDocCteNotaTeceiros().forEach(i -> i.setNotaFiscalTerceiros(entity));
        entity.getInfPagamentoNfTerceiros().forEach(i -> i.setNotaFiscalTerceiros(entity));
        entity.getObservacaoNotaTerceiros().forEach(i -> i.setNotaTerceiros(entity));
        entity.getObservacoesIntFisco().forEach(i -> i.setNotaFiscalTerceiros(entity));
        for (ItemNotaTerceiros item : entity.getItemNotaTerceiros()) {
            item.getLancCtoEntrada().forEach(i -> i.setItemNotaTerceiros(item));
            item.getLancCtoGerSaida().forEach(i -> i.setItemNotaTerceiros(item));
            item.getItemNotaLivroFiscal().setItemNotaTerceiros(item);
            item.getGrade().forEach(g -> g.setItemNotaTerceiros(item));
            item.getTicketEntradaItemNota().forEach(i -> i.setItemNota(item));
            item.setNotaFiscalTerceiros(entity);
        }
        entity.getNotaTerceirosFreteCtrc().forEach(i -> i.setNotaTerceiros(entity));
        if (entity.getIntegracaoNotaTerceiros() != null) {
            entity.getIntegracaoNotaTerceiros().setNotaFiscalTerceiros(entity);
        }
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).saveOrUpdate(entity);
    }

    @Override
    public NotaFiscalTerceiros afterSaveEntity(NotaFiscalTerceiros entity) {
        try {
            this.compAvaliacaoCriticasNFTerceiros.avaliaNFTerceiros(entity);
            return entity;
        }
        catch (ExceptionInvalidData ex) {
            this.logError(ex);
            throw new ExceptionRuntimeBase(ex.getFormattedMessage());
        }
    }

    public List<NotaFiscalTerceiros> findNotasPeriodoAndNumeroNota(Date dataIn, Date dataFim, Short filtrarNumeracao, Integer numeroInicial, Integer numeroFinal) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).findNotasPeriodoAndNumeroNota(dataIn, dataFim, filtrarNumeracao, numeroInicial, numeroFinal);
    }

    public List<NotaFiscalTerceiros> getNotaFiscalTerceirosRPA(Long geracaoReciboRpa) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).getNotaFiscalTerceirosRPA(geracaoReciboRpa);
    }

    public List<NotaFiscalTerceiros> findNotasByLiberacaoEstoque(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesCompraSuprimentos opcoesCompra) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).findNotasByTipoLiberacao(dataInicial, dataFinal, empresa, opcoesCompra, EnumLiberacaoNFTerceiros.LIBERACAO_ESTOQUE.getValue());
    }

    public DTONotaFiscalTerceiros getPreverLivrosFiscais(Long idNotaFiscalTerceiros) throws ExceptionObjNotFound, ExceptionAvaliadorExpressoes {
        NotaFiscalTerceiros notaFiscalTerceiro = (NotaFiscalTerceiros)this.getOrThrow(idNotaFiscalTerceiros);
        this.sCompLivroFiscal.getLivroFiscal(notaFiscalTerceiro, new ArrayList<LivroFiscal>());
        return this.buildToDTOGeneric(notaFiscalTerceiro, DTONotaFiscalTerceiros.class);
    }

    public DTOLoteContabil getPreverLancamentoContabil(Long idNotaFiscalTerceiros, CapsEmpresa capsEmpresa) throws ExceptionObjNotFound, ExceptionInvalidData {
        NotaFiscalTerceiros notaFiscalTerceiro = (NotaFiscalTerceiros)this.getOrThrow(idNotaFiscalTerceiros);
        OpcoesContabeis opcoesContabeis = this.serviceOpcoesContabeisImpl.getByIdEmpresa(capsEmpresa.get());
        LoteContabil lote = this.compLancamentosEntradaSaidaFiscais.contabilizar(notaFiscalTerceiro, opcoesContabeis);
        return this.buildToDTOGeneric(lote, DTOLoteContabil.class);
    }

    public List<DTONotaFiscalTerceirosRes> getNotaFiscalTerceirosPorDataTipoLiberacao(Long dtInicial, Long dtFinal, Short tipoLiberacao, CapsEmpresa capsEmpresa) throws ExceptionObjNotFound {
        Date dataInicial = new Date(dtInicial);
        Date dataFinal = new Date(dtFinal);
        this.isValidData(dataInicial, dataFinal);
        Empresa empresa = (Empresa)this.serviceEmpresaImpl.getOrThrow(capsEmpresa.get());
        OpcoesCompraSuprimentos opcoesCompraSuprimentos = this.serviceOpcoesCompraSuprimentosImpl.getByIdEmpresa(capsEmpresa.get());
        List<NotaFiscalTerceiros> notas = ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).findNotasByTipoLiberacao(dataInicial, dataFinal, empresa, opcoesCompraSuprimentos, tipoLiberacao);
        if (!ServiceNotaFiscalTerceirosImpl.isWithData(notas)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0284.006"));
        }
        return this.buildToDTOGeneric(notas, DTONotaFiscalTerceirosRes.class);
    }

    private void isValidData(Date dataInicial, Date dataFinal) {
        if (this.isNull(dataInicial).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0284.002"));
        }
        if (this.isNull(dataFinal).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0284.003"));
        }
        if (dataInicial.after(dataFinal)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0284.004"));
        }
        if (dataFinal.before(dataInicial)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0284.005"));
        }
    }

    public List<DTONotaFiscalTerceiros> getNotaFiscalTerceiros(Long[] ids) {
        List notaFiscalTerceiros = this.gets(ids);
        return this.buildToDTOGeneric(notaFiscalTerceiros, DTONotaFiscalTerceiros.class);
    }

    public void vincularXmlCentralDocEletronicos(Date dataInicial, Date dataFinal) throws ExceptionValidacaoDados {
        if (this.isNull(dataInicial).booleanValue()) {
            throw new ExceptionValidacaoDados("V.ERP.0000.004", new Object[0]);
        }
        if (this.isNull(dataFinal).booleanValue()) {
            throw new ExceptionValidacaoDados("V.ERP.0000.005", new Object[0]);
        }
        if (dataFinal.before(dataInicial)) {
            throw new ExceptionValidacaoDados("V.ERP.0000.006", new Object[0]);
        }
        List<Object[]> notasPeriodo = ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).findNotasNaoVinculadasXML(dataInicial, dataFinal);
        if (ServiceNotaFiscalTerceirosImpl.isWithData(notasPeriodo)) {
            for (Object[] data : notasPeriodo) {
                Long identificador = (Long)data[0];
                String chave = (String)data[1];
                XMLNfeTerceiros xmlNfeTerc = this.serviceXmlTerc.getByChave(chave);
                if (this.isNull(xmlNfeTerc).booleanValue()) {
                    XMLNFeCTe xmlNfe = this.serviceXmlNfe.getXMlNfeCTeChaveNFe(chave);
                    if (!this.isNotNull(xmlNfe).booleanValue()) continue;
                    XMLNfeTerceiros vo = new XMLNfeTerceiros();
                    vo.setChaveNFe(chave);
                    vo.setConteudoXML(xmlNfe.getConteudoXML());
                    vo.setIdNotaTerceiros(identificador);
                    this.serviceXmlTerc.saveOrUpdate((Object)vo);
                    continue;
                }
                if (this.isEquals(xmlNfeTerc.getIdNotaTerceiros(), identificador)) continue;
                xmlNfeTerc.setIdNotaTerceiros(identificador);
                this.serviceXmlTerc.saveOrUpdate((Object)xmlNfeTerc);
            }
        }
    }

    public List<NotaFiscalTerceiros> findNotasNaoApuradasReinf2010(GrupoEmpresa grupo, Date periodo, Boolean filtrarNotasRetidas) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).findNotasNaoApuradasReinf2010(grupo, periodo, filtrarNotasRetidas);
    }

    public List<NotaFiscalTerceiros> findNotasNaoApuradasReinf4010(GrupoEmpresa grupo, Date periodo) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).findNotasNaoApuradasReinf4010(grupo, periodo);
    }

    public List<NotaFiscalTerceiros> findNotasNaoApuradasReinf4020(GrupoEmpresa grupo, Date periodo) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).findNotasNaoApuradasReinf4020(grupo, periodo);
    }

    public List<NotaFiscalTerceiros> findNotasOutrasRetencoesReinf4020(GrupoEmpresa grupo, Date periodo) {
        return ((DaoNotaFiscalTerceirosImpl)this.getGenericDao()).findNotasOutrasRetencoesReinf4020(grupo, periodo);
    }
}

