/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.notafiscalterceiros;

import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.zip.ToolZipUtils;
import com.touchcomp.basementorxml.model.XMLNFeCTe;
import com.touchcomp.basementorxml.service.impl.xmlnfecte.ServiceXMLNFeCTeImpl;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceNotaFiscalTerceirosXMLImpl {
    @Autowired
    ServiceXMLNFeCTeImpl serviceXML;

    public File getXMLsZipFile(String ... chaves) throws ExceptionIO, ExceptionInvalidData {
        return this.getXMLsZipFile(ToolMethods.toList((Object[])chaves));
    }

    public File getXMLsZipFile(List<String> chaves) throws ExceptionIO, ExceptionInvalidData {
        File tmpDir = ToolFile.getFileTMPDir();
        File zip = new File(tmpDir.getAbsolutePath() + File.separator + "arquivo_xml_documentos.zip");
        ToolZipUtils.compress((File)zip, this.getXMLsFile(chaves));
        return zip;
    }

    public List<File> getXMLsFile(List<String> chaves) throws ExceptionIO, ExceptionInvalidData {
        LinkedList<File> files = new LinkedList<File>();
        LinkedList<String> aux = new LinkedList<String>();
        for (String chave : chaves) {
            if (aux.contains(chave)) continue;
            files.add(this.getXMLFile(chave));
            aux.add(chave);
        }
        return files;
    }

    public File getXMLFile(String chave) throws ExceptionIO, ExceptionInvalidData {
        return this.getXMLFile(chave, false);
    }

    public File getXMLFile(String chave, boolean removeInvalidUTF) throws ExceptionIO, ExceptionInvalidData {
        File tmpDir = ToolFile.getFileTMPDir();
        XMLNFeCTe aux = this.serviceXML.getXMlNfeCTeChaveNFe(chave);
        if (aux == null) {
            throw new ExceptionInvalidData("E.ERP.1910.001", new Object[]{chave});
        }
        File temp = new File(tmpDir.getAbsolutePath() + File.separator + aux.getChaveNFe() + ".xml");
        Object xml = aux.getConteudoXML();
        if (removeInvalidUTF) {
            xml = ToolString.removeIllegalXMLChar((String)xml);
        }
        if (xml != null && !((String)xml).startsWith("<?xml version=")) {
            xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + (String)xml;
        }
        ToolFile.writeStringInFile((File)temp, (String)xml);
        return temp;
    }
}

