/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.notafiscalterceiros.importarxml;

import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.opcoescompra.EnumConstTipoDataNotaTransferencia;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.constants.enums.situacaodocumento.EnumConstSituacaoDocumento;
import com.touchcomp.basementor.constants.enums.tasks.EnumConstantsTaskResult;
import com.touchcomp.basementor.model.interfaces.InterfaceStaticObjects;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.Cor;
import com.touchcomp.basementor.model.vo.DeParaFornecedor;
import com.touchcomp.basementor.model.vo.DeParaFornecedorCentroEstoque;
import com.touchcomp.basementor.model.vo.DeParaFornecedorItem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EstoqueTerceiros;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.InfPagamentoNfTerceiros;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.ProdutoGrade;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.UnidadeMedida;
import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.calculoimpostos.CalculosImpFiscaisNotaTerceiros;
import com.touchcomp.basementorservice.components.calculoimpostos.impostosxml.AuxImportaNotaTerceirosICMS;
import com.touchcomp.basementorservice.components.calculoimpostos.impostosxml.AuxImportaNotaTerceirosICMSSN;
import com.touchcomp.basementorservice.components.calculoimpostos.impostosxml.AuxImportaNotaTerceirosIPI;
import com.touchcomp.basementorservice.components.calculoimpostos.impostosxml.AuxImportarNotaTerceirosCofins;
import com.touchcomp.basementorservice.components.calculoimpostos.impostosxml.AuxImportarNotaTerceirosPis;
import com.touchcomp.basementorservice.components.calculovalores.BaseCalculoValores;
import com.touchcomp.basementorservice.components.conferencianfterceiros.CompConferenciaNFTerceiros;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilNF;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.CompGeracaoLancCtbGerencial;
import com.touchcomp.basementorservice.dao.impl.DaoNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.helpers.impl.centroestoque.HelperCentroEstoque;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorservice.helpers.impl.unidadefatfornecedor.HelperUnidadeFatFornecedor;
import com.touchcomp.basementorservice.model.task.TaskProcessResult;
import com.touchcomp.basementorservice.service.impl.cfop.ServiceCfopImpl;
import com.touchcomp.basementorservice.service.impl.deparafornecedor.ServiceDeParaFornecedorImpl;
import com.touchcomp.basementorservice.service.impl.empresacontabilidade.ServiceEmpresaContabilidadeImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.modelodocfiscal.ServiceModeloDocFiscalImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.ServiceNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.importarxml.UtilNotaFiscalTerceiros;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.model.NotaPropriaXML;
import com.touchcomp.basementorservice.service.impl.opcoescomprasuprimentos.ServiceOpcoesCompraSuprimentosImpl;
import com.touchcomp.basementorservice.service.impl.opcoescontabeis.ServiceOpcoesContabeisImpl;
import com.touchcomp.basementorservice.service.impl.opcoesestoque.ServiceOpcoesEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.opcoesfinanceiras.ServiceOpcoesFinanceirasImpl;
import com.touchcomp.basementorservice.service.impl.parametrizacaoctbmodfiscal.ServiceParametrizacaoCtbModFiscalImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorservice.service.impl.situacaodocumento.ServiceSituacaoDocumentoImpl;
import com.touchcomp.basementorservice.service.impl.tipofrete.ServiceTipoFreteImpl;
import com.touchcomp.basementorservice.service.impl.transportador.ServiceTransportadorImpl;
import com.touchcomp.basementorservice.service.impl.unidademedida.ServiceUnidadeMedidaImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceEmpresa;
import com.touchcomp.basementorservice.service.interfaces.ServiceModeloFiscal;
import com.touchcomp.basementorservice.service.interfaces.ServiceUnidadeFatFornecedor;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.jdom.ToolJdom;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorxml.model.XMLNfePropria;
import com.touchcomp.basementorxml.model.XMLNfeTerceiros;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFePropria;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFeTerceiros;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class UtilImportarNotaTerceiros {
    private final TLogger logger = TLogger.get(UtilImportarNotaTerceiros.class);
    private Namespace n = Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe");
    private ServiceModeloFiscal serviceModeloFiscal = (ServiceModeloFiscal)ConfApplicationContext.getBean(ServiceModeloFiscal.class);
    private ServiceEmpresa serviceEmpresa = (ServiceEmpresa)ConfApplicationContext.getBean(ServiceEmpresa.class);
    private ServiceUnidadeFatFornecedor serviceFornecedor = (ServiceUnidadeFatFornecedor)ConfApplicationContext.getBean(ServiceUnidadeFatFornecedor.class);
    private ServiceXMLNFePropria serviceXMLNotaPropria = (ServiceXMLNFePropria)ConfApplicationContext.getBean(ServiceXMLNFePropria.class);
    private ServiceXMLNFeTerceiros serviceXMLNFeTerceiros = (ServiceXMLNFeTerceiros)ConfApplicationContext.getBean(ServiceXMLNFeTerceiros.class);
    private ServiceNotaFiscalPropriaImpl serviceNotaPropria = (ServiceNotaFiscalPropriaImpl)ConfApplicationContext.getBean(ServiceNotaFiscalPropriaImpl.class);
    private ServiceNotaFiscalTerceirosImpl serviceNotaTerceiros = (ServiceNotaFiscalTerceirosImpl)ConfApplicationContext.getBean(ServiceNotaFiscalTerceirosImpl.class);
    private ServiceCfopImpl serviceCfop = (ServiceCfopImpl)ConfApplicationContext.getBean(ServiceCfopImpl.class);
    private ServiceDeParaFornecedorImpl serviceDeParaFornecedor = (ServiceDeParaFornecedorImpl)ConfApplicationContext.getBean(ServiceDeParaFornecedorImpl.class);
    private ServiceOpcoesFinanceirasImpl serviceOpcoesFinanceiras = (ServiceOpcoesFinanceirasImpl)ConfApplicationContext.getBean(ServiceOpcoesFinanceirasImpl.class);
    private ServiceOpcoesCompraSuprimentosImpl serviceOpcoesCompra = (ServiceOpcoesCompraSuprimentosImpl)ConfApplicationContext.getBean(ServiceOpcoesCompraSuprimentosImpl.class);
    private ServiceOpcoesContabeisImpl serviceOpcoesContabeis = (ServiceOpcoesContabeisImpl)ConfApplicationContext.getBean(ServiceOpcoesContabeisImpl.class);
    private ServiceUnidadeMedidaImpl serviceUnidadeMedida = (ServiceUnidadeMedidaImpl)ConfApplicationContext.getBean(ServiceUnidadeMedidaImpl.class);
    private ServiceModeloDocFiscalImpl serviceModeloDocFiscal = (ServiceModeloDocFiscalImpl)ConfApplicationContext.getBean(ServiceModeloDocFiscalImpl.class);
    private ServiceTipoFreteImpl serviceTipoFrete = (ServiceTipoFreteImpl)ConfApplicationContext.getBean(ServiceTipoFreteImpl.class);
    private ServiceTransportadorImpl serviceTransportador = (ServiceTransportadorImpl)ConfApplicationContext.getBean(ServiceTransportadorImpl.class);
    private ServiceSituacaoDocumentoImpl serviceSituacaoDocumento = (ServiceSituacaoDocumentoImpl)ConfApplicationContext.getBean(ServiceSituacaoDocumentoImpl.class);
    private ServiceParametrizacaoCtbModFiscalImpl serviceParametrizacaoCtbModFiscal = (ServiceParametrizacaoCtbModFiscalImpl)ConfApplicationContext.getBean(ServiceParametrizacaoCtbModFiscalImpl.class);
    private ServiceLoteFabricacaoImpl serviceLoteFabricacao = (ServiceLoteFabricacaoImpl)ConfApplicationContext.getBean(ServiceLoteFabricacaoImpl.class);
    private ServiceEmpresaContabilidadeImpl serviceEmpresaContabil = (ServiceEmpresaContabilidadeImpl)ConfApplicationContext.getBean(ServiceEmpresaContabilidadeImpl.class);
    private InterfaceStaticObjects sharedData = (InterfaceStaticObjects)ConfApplicationContext.getBean(InterfaceStaticObjects.class);
    private SCompPlanoConta compPlanoConta = (SCompPlanoConta)ConfApplicationContext.getBean(SCompPlanoConta.class);
    private DaoNotaFiscalTerceirosImpl daoNotaTerceiros = (DaoNotaFiscalTerceirosImpl)ConfApplicationContext.getBean(DaoNotaFiscalTerceirosImpl.class);

    public HashMap importarNotaTerceiros(String naturezaOperacao, Date dataInicial, Date dataFinal, String cnpjEmpresa) {
        List<NotaFiscalPropria> notas = this.serviceNotaPropria.findNotasTransferenciasNaoTransferidas(naturezaOperacao, dataInicial, dataFinal, 0, 99999);
        List<NotaPropriaXML> xmls = this.findXMLNotasTransferencia(notas);
        ArrayList<NotaFiscalTerceiros> notasGeradas = new ArrayList<NotaFiscalTerceiros>();
        ArrayList<String> notasNaoGeradas = new ArrayList<String>();
        StringBuilder nao = new StringBuilder();
        for (NotaPropriaXML x : xmls) {
            StringBuilder ret;
            if (ToolMethods.isStrWithData((String)cnpjEmpresa) && !this.notaDestinoEmpresaLogada(cnpjEmpresa, x) || (ret = this.importarNotasTerceiros(x, xmls, notasGeradas)).length() <= 0) continue;
            nao.append((CharSequence)ret);
            notasNaoGeradas.add(nao.toString());
        }
        HashMap<String, ArrayList<Object>> h = new HashMap<String, ArrayList<Object>>();
        h.put("notasGeradas", notasGeradas);
        h.put("notasNaoGeradas", notasNaoGeradas);
        return h;
    }

    public void importarNotaTerceirosTask(String naturezaOperacao, Date dataInicial, Date dataFinal, TaskProcessResult result) {
        try {
            List<NotaFiscalPropria> notas;
            int max = 10;
            int page = 0;
            do {
                notas = this.serviceNotaPropria.findNotasTransferenciasNaoTransferidas(naturezaOperacao, dataInicial, dataFinal, page, max);
                List<NotaPropriaXML> xmls = this.findXMLNotasTransferencia(notas);
                StringBuilder nao = new StringBuilder();
                ArrayList<NotaFiscalTerceiros> notasGeradas = new ArrayList<NotaFiscalTerceiros>();
                for (NotaPropriaXML x : xmls) {
                    StringBuilder ret = this.importarNotasTerceiros(x, xmls, notasGeradas);
                    if (ret.length() <= 0) continue;
                    nao.append((CharSequence)ret);
                    nao.append("-------------------------------");
                }
                if (nao.length() > 0) {
                    result.addDet(EnumConstantsTaskResult.RESULT_ERRO, nao.toString());
                }
                page += max;
            } while (notas.size() > 0);
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public StringBuilder importarNotasTerceiros(NotaPropriaXML x, List<NotaPropriaXML> xmls, List<NotaFiscalTerceiros> notasGeradas) {
        StringBuilder errors = new StringBuilder();
        try {
            String xml = x.getXml().getConteudoXML();
            Document d = ToolJdom.getDocumentWithRecovery((String)xml);
            Element inf = d.getRootElement().getChild("infNFe", this.n);
            String chave = inf.getAttributeValue("Id").substring(3, 47);
            String cnpjCpfEmitente = "";
            String cnpjCpfDestinatario = "";
            cnpjCpfEmitente = inf.getChild("emit", this.n).getChild("CNPJ", this.n) != null ? inf.getChild("emit", this.n).getChild("CNPJ", this.n).getText() : inf.getChild("emit", this.n).getChild("CPF", this.n).getText();
            cnpjCpfDestinatario = inf.getChild("dest", this.n).getChild("CNPJ", this.n) != null ? inf.getChild("dest", this.n).getChild("CNPJ", this.n).getText() : inf.getChild("dest", this.n).getChild("CPF", this.n).getText();
            StringBuilder ret = this.importarNF(x, d, chave, cnpjCpfEmitente, cnpjCpfDestinatario, notasGeradas);
            if (ret.length() > 0) {
                errors.append((CharSequence)ret);
            }
        }
        catch (JDOMException ex) {
            this.logger.error((Throwable)ex);
            System.out.println((Object)ex);
            errors.append("\nMotivo: ");
            errors.append((Object)ex);
        }
        catch (IOException ex) {
            this.logger.error((Throwable)ex);
            System.out.println(ex.getMessage());
            errors.append("\nMotivo: ");
            errors.append(ex.getMessage());
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
            System.out.println(ex);
            errors.append("\nMotivo: ");
            errors.append(ex.getMessage());
        }
        StringBuilder temp = new StringBuilder();
        if (errors.length() > 0) {
            temp.append("\nNr. Nota: ");
            temp.append(x.getNota().getNumeroNota());
            temp.append("\nSerie: ");
            temp.append(x.getNota().getSerie());
            temp.append("\nEmpresa: ");
            temp.append(x.getNota().getEmpresa().toString() + "\n");
            temp.append((CharSequence)errors);
            temp.append("\n\n");
        }
        return temp;
    }

    private List<NotaPropriaXML> findXMLNotasTransferencia(List<NotaFiscalPropria> notasProprias) {
        ArrayList<NotaPropriaXML> notas = new ArrayList<NotaPropriaXML>();
        for (NotaFiscalPropria n : notasProprias) {
            XMLNfePropria xml = (XMLNfePropria)this.serviceXMLNotaPropria.get((Serializable)n.getIdentificador());
            if (xml == null) continue;
            NotaPropriaXML nx = new NotaPropriaXML();
            nx.setNota(n);
            nx.setXml(xml);
            notas.add(nx);
        }
        return notas;
    }

    private Empresa findEmpresa(String cnpj) {
        return this.serviceEmpresa.findByCnpj(cnpj);
    }

    private UnidadeFatFornecedor findFornecedor(String cnpj) {
        return this.serviceFornecedor.getFirstByCnpjCPF(cnpj);
    }

    private XMLNfeTerceiros getOrCreateXMLNFeTerceiros(String chave, NotaPropriaXML x) throws IOException, JDOMException {
        String xmlCompleto = this.exportarXML(x.getXml().getConteudoXML(), x.getXml().getConteudoAprovacao(), x.getNota().getVersaoNfe());
        SAXBuilder sb = new SAXBuilder();
        Document d = sb.build((InputStream)new ByteArrayInputStream(xmlCompleto.getBytes()));
        StringWriter s = new StringWriter();
        XMLOutputter xout = new XMLOutputter();
        xout.output(d.getRootElement(), (Writer)s);
        XMLNfeTerceiros xt = this.serviceXMLNFeTerceiros.getOrCreateXMLNFeTerceirosChave(chave);
        xt.setConteudoXML(s.toString());
        xt = (XMLNfeTerceiros)this.serviceXMLNFeTerceiros.saveOrUpdate((Object)xt);
        return xt;
    }

    private NotaFiscalTerceiros createNotaTerceiros(XMLNfeTerceiros xt, Empresa empresa, DeParaFornecedor dePara, NotaFiscalPropria notaPropria, UnidadeFatFornecedor unidadeFatFornecedor, StringBuilder ret, OpcoesContabeis opcoes, OpcoesImpostos opImpostos, OpcoesCompraSuprimentos opcoesCompra) throws Exception {
        return this.importarNota(xt.getConteudoXML(), (short)0, opcoesCompra.getMarcarOpcaoIcmsStSomCusto(), (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, empresa, dePara, unidadeFatFornecedor, notaPropria, ret, opcoes, opImpostos);
    }

    public NotaFiscalTerceiros importarNota(String xml, Short importarStRet, Short modoCalculoIcmsSt, Short naoRatearVlrAcess, Short naoRatearVlrAgregado, Short naoRatearVlrDesconto, Short naoRatearVlrFrete, Short naoRatearVlrSeguro, Short buscarValorInformadoNota, Short stInfluenciaTotNota, Short igPisCofins, Short respeitarImpostos, Short descartarTitulosXml, Short respeitarLoteFabricacao, Empresa empresa, DeParaFornecedor deParaForn, UnidadeFatFornecedor unidadeFatFornecedor, NotaFiscalPropria notaPropria, StringBuilder ret, OpcoesContabeis opcoes, OpcoesImpostos opImpostos) throws Exception {
        StringBuilder sbd = new StringBuilder();
        sbd.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\"?>");
        sbd.append(xml);
        SAXBuilder sb = new SAXBuilder();
        Document d = sb.build((InputStream)new ByteArrayInputStream(sbd.toString().getBytes()));
        Element inf = d.getRootElement().getChild("NFe", this.n).getChild("infNFe", this.n);
        NotaFiscalTerceiros nota = this.findNotaTerceiros(inf);
        if (nota == null) {
            nota = new NotaFiscalTerceiros();
            nota.setModoArredondamento(Short.valueOf((short)6));
            nota.setSituacaoDocumento(this.getDocumentoRegular());
            nota.setNaoRatearVlrAcess(naoRatearVlrAcess);
            nota.setNaoRatearVlrAgregado(naoRatearVlrAgregado);
            nota.setNaoRatearVlrDesconto(naoRatearVlrDesconto);
            nota.setNaoRatearVlrFrete(naoRatearVlrFrete);
            nota.setNaoRatearVlrSeguro(naoRatearVlrSeguro);
            nota.getValoresNfTerceiros().setValorFreteCtrc(Double.valueOf(0.0));
            nota.setDataCadastro(new Date());
            nota.setEmpresa(empresa);
            nota.setUnidadeFatFornecedor(unidadeFatFornecedor);
            nota.setCategoriaPessoa(nota.getUnidadeFatFornecedor().getCategoriaPessoa());
            nota.setClassificacaoPessoas(nota.getUnidadeFatFornecedor().getFornecedor().getClassificacaoPessoa());
            nota.setUfPrestacao(nota.getUnidadeFatFornecedor().getPessoa().getEndereco().getCidade().getUf());
            nota.setCidadePrestacao(nota.getUnidadeFatFornecedor().getPessoa().getEndereco().getCidade());
            this.dadosIde(inf, nota, this.n);
            this.outrosDados(nota, notaPropria);
            this.dadosTransp(inf, nota, this.n);
            this.dadosTotal(inf, nota, this.n);
            this.dadosDet(igPisCofins, inf, nota, this.n, importarStRet, modoCalculoIcmsSt, buscarValorInformadoNota, stInfluenciaTotNota, respeitarImpostos, deParaForn, notaPropria, ret, opcoes, opImpostos);
            this.dadosCobr(inf, nota, this.n);
            this.calcularTotalizadores(nota);
            this.calcularLivrosFiscais(nota);
            this.gerarLiberacaoNFTerceiros(nota);
        }
        return nota;
    }

    private void setParceiro(ItemNotaTerceiros i, Date data, Empresa e, UnidadeFatFornecedor uni) {
        Pessoa parceiro = uni.getPessoa();
        if (i.getNaturezaOperacao() != null && (i.getNaturezaOperacao().getTipoEstoque() == 1 || i.getNaturezaOperacao().getTipoEstoque() == 4 || i.getNaturezaOperacao().getTipoEstoque() == 5 || i.getNaturezaOperacao().getTipoEstoque() == 6 || i.getNaturezaOperacao().getTipoEstoque() == 8 || i.getNaturezaOperacao().getTipoEstoque() == 9)) {
            for (GradeItemNotaTerceiros g : i.getGrade()) {
                EstoqueTerceiros est = new EstoqueTerceiros();
                est.setPessoaParceiro(parceiro);
                est.setGradeItemNotaTerceiros(g);
                est.setQuantidade(g.getQuantidade());
                est.setData(data);
                est.setNaturezaOperacao(i.getNaturezaOperacao());
                est.setEmpresa(e);
                g.setEstoqueTerceiros(est);
            }
        }
    }

    private boolean dadosIde(Element inf, NotaFiscalTerceiros nota, Namespace n) throws Exception {
        String ide = inf.getChild("ide", n).getChild("nNF", n).getText();
        Integer numNota = Integer.parseInt(ide);
        nota.setNumeroNota(numNota);
        ide = inf.getChild("ide", n).getChild("serie", n).getText();
        nota.setSerie(ide);
        ide = inf.getChild("ide", n).getChild("mod", n).getText();
        nota.setModeloDocFiscal(this.findModeloDocFiscal(ide));
        if (inf.getChild("ide", n).getChild("dEmi", n) != null) {
            ide = inf.getChild("ide", n).getChild("dEmi", n).getText();
        } else {
            ide = inf.getChild("ide", n).getChild("dhEmi", n).getText();
            ide = ide.substring(0, 10);
        }
        Date dataEmissao = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            dataEmissao = format.parse(ide);
        }
        catch (ParseException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new Exception("Erro ao converter a data da nota fiscal: " + ide);
        }
        nota.setDataEmissao(dataEmissao);
        nota.setDataCompetencia(dataEmissao);
        ide = inf.getChild("ide", n).getChild("cDV", n).getText();
        ide = inf.getAttributeValue("Id");
        String id = ide.substring(3, 47);
        nota.setChaveNFE(id);
        return true;
    }

    private void outrosDados(NotaFiscalTerceiros nota, NotaFiscalPropria nPropria) {
        OpcoesCompraSuprimentos opCompra = this.getOpcaoCompra(nota.getEmpresa());
        Date dataAtual = new Date();
        nota.setDataCadastro(dataAtual);
        if (ToolMethods.isEquals((Object)opCompra.getTipoDataNotaTransferencia(), (Object)EnumConstTipoDataNotaTransferencia.TIPO_DATA_NOTA_TRANSF_DATA_EMISSAO.getValue())) {
            nota.setDataEntrada(nota.getDataEmissao());
            nota.setDataCompetencia(nota.getDataEmissao());
        } else if (ToolMethods.isEquals((Object)opCompra.getTipoDataNotaTransferencia(), (Object)EnumConstTipoDataNotaTransferencia.TIPO_DATA_NOTA_TRANSF_DATA_SAIDA.getValue())) {
            nota.setDataEntrada(nPropria.getDataEntradaSaida());
            nota.setDataCompetencia(nPropria.getDataEntradaSaida());
        } else {
            nota.setDataEntrada(dataAtual);
            nota.setDataCompetencia(dataAtual);
        }
    }

    private boolean dadosTransp(Element inf, NotaFiscalTerceiros nota, Namespace n) throws Exception {
        if (inf.getChild("transp", n) != null) {
            Element cn;
            String modFrete = inf.getChild("transp", n).getChild("modFrete", n).getText();
            Short modeloFrete = Short.parseShort(modFrete);
            nota.setTipoFrete(this.findTipoFrete(modeloFrete));
            if (inf.getChild("transp", n).getChild("transporta", n) != null && (cn = inf.getChild("transp", n).getChild("transporta", n).getChild("CNPJ", n)) != null) {
                String cnpj = cn.getText();
                nota.setTransportador(this.findTransportadorPorCNPJ(cnpj));
            }
        }
        return true;
    }

    private void dadosCobr(Element inf, NotaFiscalTerceiros nota, Namespace n) throws ExceptionInvalidData {
        OpcoesFinanceiras op = this.getOpcaoFinanceira(nota.getEmpresa());
        OpcoesCompraSuprimentos opCompra = this.getOpcaoCompra(nota.getEmpresa());
        OpcoesContabeis opContabeis = this.getOpcaoContabil(nota.getEmpresa());
        ArrayList<Titulo> titulos = new ArrayList<Titulo>();
        Short cont = 1;
        if (inf.getChild("cobr", n) != null) {
            List tit = inf.getChild("cobr", n).getChildren("dup", n);
            InfPagamentoNfTerceiros i = this.criarMeioPagamentoPadrao(nota, op);
            for (Object o : tit) {
                Element dup = (Element)o;
                Titulo titulo = new Titulo();
                Pessoa pessoa = nota.getUnidadeFatFornecedor().getFornecedor().getPessoa();
                titulo.setPessoa(pessoa);
                if (nota.getClassificacaoPessoas() != null) {
                    titulo.setClassificacaoPessoa(nota.getClassificacaoPessoas());
                } else {
                    titulo.setClassificacaoPessoa(op.getClassificacaoClientes());
                }
                titulo.setTipoDoc(op.getTipoDocFinanceiro());
                titulo.setPagRec(Short.valueOf((short)0));
                titulo.setProvisao(Short.valueOf((short)1));
                titulo.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(op).getCarteiraCobranca(titulo.getPagRec()));
                if (dup.getChild("dVenc", n) != null) {
                    String data = dup.getChild("dVenc", n).getText();
                    Date dataVenc = null;
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        dataVenc = format.parse(data);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    titulo.setDataVencimento(dataVenc);
                } else {
                    titulo.setDataVencimento(new Date());
                }
                titulo.setDataVencimentoBase(titulo.getDataVencimento());
                Date dataEmissao = nota.getDataEmissao();
                titulo.setDataEmissao(dataEmissao);
                titulo.setDataCompetencia(nota.getDataEntrada());
                titulo.setDataEntradaSaida(titulo.getDataCompetencia());
                if (dup.getChild("vDup", n) != null) {
                    String value = dup.getChild("vDup", n).getText();
                    Double valor = Double.parseDouble(value);
                    titulo.setValor(valor);
                } else {
                    titulo.setValor(Double.valueOf(0.0));
                }
                titulo.setVrJurosDia(Double.valueOf(0.0));
                titulo.setVrDescontoCondicional(Double.valueOf(0.0));
                Date dataAtual = new Date();
                titulo.setDataCadastro(dataAtual);
                Empresa empresa = nota.getEmpresa();
                titulo.setEmpresa(empresa);
                titulo.setPercJurosMes(Double.valueOf(0.0));
                titulo.setNumParcTituloEstnota(cont);
                titulo.setMovimentoTitulos(new HashSet());
                titulo.setInfPagamentoNfTerceiros(i);
                titulo.setPlanoConta(this.compPlanoConta.getPlanoConta(nota.getUnidadeFatFornecedor().getFornecedor(), opContabeis));
                titulo.setTipoPessoa(EnumConstPessoa.FORNECEDOR.getEnumId());
                titulo.setMeioPagamento(i.getMeioPagamento());
                titulos.add(titulo);
                Short s = cont;
                cont = (short)(cont + 1);
            }
            i.getTitulos().addAll(titulos);
            i.setValor(this.getValorMeioPagamento(i.getTitulos()));
            nota.getInfPagamentoNfTerceiros().add(i);
        }
        CompGeracaoLancCtbGerencial.criarSetarLancamentosCTBGerencial(nota, titulos, nota.getEmpresa());
        if (opCompra.getCondicoesPagamentoImportacaoXML() != null && this.existeTitulosNF(nota)) {
            StringBuilder sb = new StringBuilder();
            Boolean error = false;
            block3: for (InfPagamentoNfTerceiros infPag : nota.getInfPagamentoNfTerceiros()) {
                for (Titulo t : infPag.getTitulos()) {
                    int diferenca = ToolDate.diferenceDayBetweenDates((Date)nota.getDataEntrada(), (Date)t.getDataVencimento());
                    if (diferenca >= 0) {
                        sb.append(diferenca);
                        sb.append(";");
                        continue;
                    }
                    error = true;
                    continue block3;
                }
            }
            if (!error.booleanValue()) {
                nota.setCondicoesPagamento(opCompra.getCondicoesPagamentoImportacaoXML());
                nota.setParcelas(sb.toString());
                if (nota.getCondicoesPagamento() != null && nota.getCondicoesPagamento().getMeioPagamento() != null) {
                    nota.setMeioPagamento(nota.getCondicoesPagamento().getMeioPagamento());
                } else {
                    nota.setMeioPagamento(op.getMeioPagamento());
                }
            }
        } else if (opCompra.getCondicoesPagamentoImportacaoXML() != null) {
            nota.setCondicoesPagamento(opCompra.getCondicoesPagamentoImportacaoXML());
            if (nota.getCondicoesPagamento() != null && nota.getCondicoesPagamento().getMeioPagamento() != null) {
                nota.setMeioPagamento(nota.getCondicoesPagamento().getMeioPagamento());
            } else {
                nota.setMeioPagamento(op.getMeioPagamento());
            }
        }
    }

    private void dadosTotal(Element inf, NotaFiscalTerceiros nota, Namespace n) {
        String value = "";
        value = inf.getChild("total", n).getChild("ICMSTot", n).getChild("vFrete", n).getText();
        Double vrFrete = Double.parseDouble(value);
        nota.getValoresNfTerceiros().setValorFreteInf(vrFrete);
        value = inf.getChild("total", n).getChild("ICMSTot", n).getChild("vDesc", n).getText();
        Double vrDesconto = Double.parseDouble(value);
        nota.getValoresNfTerceiros().setValorDescontoInf(vrDesconto);
        value = inf.getChild("total", n).getChild("ICMSTot", n).getChild("vOutro", n).getText();
        Double vrDespAces = Double.parseDouble(value);
        nota.getValoresNfTerceiros().setValorDespAcessoriaInf(vrDespAces);
        value = inf.getChild("total", n).getChild("ICMSTot", n).getChild("vSeg", n).getText();
        Double vrSeguro = Double.parseDouble(value);
        nota.getValoresNfTerceiros().setValorSeguroInf(vrSeguro);
        value = inf.getChild("total", n).getChild("ICMSTot", n).getChild("vIPI", n).getText();
        Double vrIPi = Double.parseDouble(value);
        nota.getValoresNfTerceiros().setValorIpiInf(vrIPi);
        value = inf.getChild("total", n).getChild("ICMSTot", n).getChild("vICMS", n).getText();
        Double vrICMS = Double.parseDouble(value);
        nota.getValoresNfTerceiros().setValorIcmsInf(vrICMS);
        value = inf.getChild("total", n).getChild("ICMSTot", n).getChild("vNF", n).getText();
        Double vrTotal = Double.parseDouble(value);
        nota.getValoresNfTerceiros().setValorTotalInf(vrTotal);
    }

    public void dadosDet(Short ignorarPisCofinsNota, Element inf, NotaFiscalTerceiros nota, Namespace n, Short importarStRet, Short modoCalculoIcmsSt, Short buscarValorInformadoNota, Short stInfluenciaTotNota, Short respeitarImpostos, DeParaFornecedor deParaForn, NotaFiscalPropria notaPropria, StringBuilder ret, OpcoesContabeis opcoes, OpcoesImpostos opImpostos) throws Exception {
        ArrayList itens = new ArrayList();
        List produtos = inf.getChildren("det", n);
        EmpresaContabilidade empresaContabilidade = this.getEmpresaContabilidade(nota.getEmpresa());
        OpcoesEstoque opEst = this.getOpcoesEstoque(nota.getEmpresa());
        for (Object o : produtos) {
            Element det = (Element)o;
            Element prod = det.getChild("prod", n);
            String codigoProduto = prod.getChildText("cProd", n);
            ItemNotaTerceiros vo = new ItemNotaTerceiros();
            vo.setNotaFiscalTerceiros(nota);
            vo.setDescricaoComplementar(ToolString.clearInvalidUTF8Char((String)prod.getChildText("xProd", n)));
            vo.setUnidadeMedidaXML(prod.getChildText("uCom", n));
            if (deParaForn.getNaturezaOperacao() == null) {
                ret.append("Nao foi cadastrado Natureza de Operacao no cadastro do De/Para: " + String.valueOf(deParaForn));
                return;
            }
            vo.setNaturezaOperacao(deParaForn.getNaturezaOperacao());
            vo.setValorUnitario(Double.valueOf(prod.getChildText("vUnCom", n)));
            Double quantidade = Double.valueOf(prod.getChildText("qCom", n));
            vo.setQuantidadeTotal(quantidade);
            vo.setFatorConversao(Double.valueOf(1.0));
            if (det.getAttribute("nItem") != null) {
                vo.setNumeroItem(Integer.valueOf(det.getAttribute("nItem").getValue()));
            } else {
                vo.setNumeroItem(Integer.valueOf(det.getChild("nItem", n).getChild("nItem", n).getValue()));
            }
            this.setProdutoAndGrade(vo, notaPropria, codigoProduto, deParaForn);
            if (vo.getProduto() == null) {
                ret.append("Nao foi encontrado Produto(De/Para) para o codigo " + codigoProduto + " De/Para: " + String.valueOf(deParaForn));
                return;
            }
            vo.setUnidadeMedida(this.findUnidadeMedida(prod.getChildText("uCom", n)));
            vo.setModeloFiscal(this.findModeloFiscal(vo, nota, ret));
            if (vo.getModeloFiscal() == null) {
                return;
            }
            vo.setGerarFinanceiro(vo.getModeloFiscal().getGerarFinanceiro());
            vo.setIndicadorTotal(Short.valueOf((short)1));
            this.setParceiro(vo, nota.getDataEntrada(), nota.getEmpresa(), nota.getUnidadeFatFornecedor());
            vo.setIncidenciaIcms(vo.getModeloFiscal().getModeloFiscalIcms().getIncidenciaIcms());
            vo.setIncidenciaIpi(vo.getModeloFiscal().getModeloFiscalIpi().getIncidenciaIpi());
            vo.setIncidenciaPisCofins(vo.getModeloFiscal().getModeloFiscalPisCofins().getIncidenciaPisCofins());
            vo.setModalidadeIcms(vo.getModeloFiscal().getModeloFiscalIcms().getModalidadeIcms());
            vo.setModalidadeIcmsSt(vo.getModeloFiscal().getModeloFiscalIcms().getModalidadeIcmsSt());
            vo.setCodigoTributacaoDia(vo.getModeloFiscal().getModeloFiscalIcms().getCodigoTributacaoDia());
            vo.setUnidadeMedida(vo.getProduto().getUnidadeMedida());
            if (vo.getModeloFiscal().getModeloFiscalPisCofins() != null) {
                vo.setNaturezaBCCredito(vo.getModeloFiscal().getModeloFiscalPisCofins().getNaturezaBCCredito());
            }
            this.setDadosContabeis(vo, nota, opcoes);
            ItemNotaLivroFiscal in = new ItemNotaLivroFiscal();
            in.setValorStCustoCompTotNota(stInfluenciaTotNota);
            Object cfop = prod.getChildText("CFOP", n);
            cfop = ((String)cfop).substring(0, 1) + "." + ((String)cfop).substring(1);
            in.setCfop(this.findCfopEntrada(nota.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), nota.getUfPrestacao(), vo.getModeloFiscal()));
            in.setItemNotaTerceiros(vo);
            vo.setItemNotaLivroFiscal(in);
            if (vo.getProduto().getAliquotaIss() > 0.0) {
                vo.setVrServico(Double.valueOf(prod.getChildText("vProd", n)));
            } else {
                vo.setVrProduto(Double.valueOf(prod.getChildText("vProd", n)));
            }
            in.setValorTotal(Double.valueOf(vo.getVrProduto() + vo.getVrServico()));
            if (prod.getChildText("vDesc", n) != null) {
                vo.setValorDesconto(Double.valueOf(prod.getChildText("vDesc", n)));
                vo.setDescontoItem(Short.valueOf((short)1));
                vo.setTipoDesconto(Short.valueOf((short)1));
            }
            if (prod.getChildText("vFrete", n) != null) {
                vo.setValorFrete(Double.valueOf(prod.getChildText("vFrete", n)));
                vo.setFreteItem(Short.valueOf((short)1));
                vo.setTipoFrete(Short.valueOf((short)1));
            }
            if (prod.getChildText("vSeg", n) != null) {
                vo.setVrSeguro(Double.valueOf(prod.getChildText("vSeg", n)));
                vo.setSeguroItem(Short.valueOf((short)1));
                vo.setTipoSeguro(Short.valueOf((short)1));
            }
            if (prod.getChildText("vOutro", n) != null) {
                vo.setValorDespAcessoria(Double.valueOf(prod.getChildText("vOutro", n)));
                vo.setDespAcessItem(Short.valueOf((short)1));
                vo.setTipoDespAcessoria(Short.valueOf((short)1));
            }
            double alICMS = in.getAliquotaIcms();
            if (respeitarImpostos.equals((short)0)) {
                if (vo.getModeloFiscal().getModeloFiscalIcms().getTipoAliquotaIcms() == 2) {
                    alICMS = vo.getModeloFiscal().getModeloFiscalIcms().getAliquotaIcms();
                } else if (vo.getModeloFiscal().getModeloFiscalIcms().getTipoAliquotaIcms() == 1) {
                    alICMS = new UtilNotaFiscalTerceiros().getAliquotaICMS(nota.getUfPrestacao(), nota.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), vo.getProduto());
                }
                in.setAliquotaIcms(Double.valueOf(alICMS));
            }
            vo.setCest(vo.getProduto().getCest());
            vo.setNcm(vo.getProduto().getNcm());
            Double aliquotaIpi = BaseCalculoValores.getAliquotaIpi(vo.getProduto(), vo.getModeloFiscal().getModeloFiscalIpi());
            in.setAliquotaIpi(aliquotaIpi);
            nota.getItemNotaTerceiros().add(vo);
            this.valoresImpostos(vo, det.getChild("imposto", n), ignorarPisCofinsNota, importarStRet, modoCalculoIcmsSt, buscarValorInformadoNota, respeitarImpostos, nota.getUnidadeFatFornecedor());
            this.setCentroEstoque(vo, nota, deParaForn, opEst);
            this.setMovimentacaoFisica(vo);
            for (GradeItemNotaTerceiros g : vo.getGrade()) {
                g.setCentroEstoque(vo.getCentroEstoque());
                g.setEmpresa(nota.getEmpresa());
                g.setFatorConversao(vo.getFatorConversao());
            }
            CalculosImpFiscaisNotaTerceiros.calcularImpostosFiscaisItNotaTerceiros(nota.getDataEntrada(), nota.getItemNotaTerceiros(), nota.getUnidadeFatFornecedor(), nota.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, false, false, false, false, false, empresaContabilidade, opImpostos);
        }
        nota.setNumeroItensInf(Integer.valueOf(nota.getItemNotaTerceiros().size()));
    }

    private UnidadeMedida findUnidadeMedida(String sigla) {
        return this.serviceUnidadeMedida.getBySigla(sigla);
    }

    private void valoresImpostos(ItemNotaTerceiros vo, Element impostos, Short ignorarPisCofins, Short importarStRet, Short modoCalculoIcmsSt, Short buscarValorInformadoNota, Short respeitarImpostos, UnidadeFatFornecedor unid) {
        Element icms = impostos.getChild("ICMS", this.n);
        Element ipi = impostos.getChild("IPI", this.n);
        Element pis = impostos.getChild("PIS", this.n);
        Element cofins = impostos.getChild("COFINS", this.n);
        new AuxImportaNotaTerceirosICMS().valoresImpostosICMS(icms, vo, importarStRet, modoCalculoIcmsSt, buscarValorInformadoNota);
        new AuxImportaNotaTerceirosICMSSN().valoresImpostosICMSSN(icms, vo, importarStRet, modoCalculoIcmsSt);
        new AuxImportaNotaTerceirosIPI().valoresImpostosIPI(ipi, vo, unid);
        new AuxImportarNotaTerceirosPis().valoresImpostosPIS(pis, vo, ignorarPisCofins);
        new AuxImportarNotaTerceirosCofins().valoresImpostosCofins(cofins, vo, ignorarPisCofins);
        vo.setNaoCalcularIcms(respeitarImpostos);
        vo.setNaoCalcularIpi(respeitarImpostos);
        vo.setNaoCalcularPisCofins(respeitarImpostos);
    }

    private CompParametrizacaoContabilNF.DadosContas findParametrizacaoCtbModFiscal(ItemNotaTerceiros item, NotaFiscalTerceiros nota, OpcoesContabeis opcoes) throws ExceptionParametrizacao, ExceptionInvalidData {
        return new CompParametrizacaoContabilNF().getPlanoContasNfTerceiros(item.getModeloFiscal(), item.getProduto(), nota.getUnidadeFatFornecedor(), item.getNaturezaOperacao(), nota.getEmpresa(), nota.getUnidadeFatFornecedor().getCategoriaPessoa(), opcoes);
    }

    private InfPagamentoNfTerceiros criarMeioPagamentoPadrao(NotaFiscalTerceiros nota, OpcoesFinanceiras op) {
        InfPagamentoNfTerceiros i = new InfPagamentoNfTerceiros();
        if (nota.getCondicoesPagamento() != null && nota.getCondicoesPagamento().getMeioPagamento() != null) {
            i.setMeioPagamento(nota.getCondicoesPagamento().getMeioPagamento());
        } else {
            i.setMeioPagamento(op.getMeioPagamento());
        }
        if (i.getMeioPagamento() != null) {
            i.setTipoPagamentoNFe(i.getMeioPagamento().getTipoPagamentoNFe());
        }
        i.setNotaFiscalTerceiros(nota);
        return i;
    }

    private Double getValorMeioPagamento(List<Titulo> titulos) {
        Double valor = 0.0;
        for (Titulo t : titulos) {
            valor = valor + t.getValor();
        }
        return valor;
    }

    private boolean existeTitulosNF(NotaFiscalTerceiros nota) {
        for (InfPagamentoNfTerceiros i : nota.getInfPagamentoNfTerceiros()) {
            if (i.getTitulos() == null || i.getTitulos().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private ModeloDocFiscal findModeloDocFiscal(String codigo) {
        return this.serviceModeloDocFiscal.findByCodigo(EnumConstantsModeloDocFiscal.valueOfCodigo((String)codigo));
    }

    private TipoFrete findTipoFrete(Short modeloFrete) {
        return this.serviceTipoFrete.findByCodigo(modeloFrete);
    }

    private Transportador findTransportadorPorCNPJ(String cnpj) {
        return this.serviceTransportador.findByCNPJ(cnpj);
    }

    private ModeloFiscal findModeloFiscal(ItemNotaTerceiros vo, NotaFiscalTerceiros nota, StringBuilder sb) {
        ModeloFiscal mod = this.serviceModeloFiscal.getFirst(vo.getProduto(), nota.getUnidadeFatFornecedor().getCategoriaPessoa(), nota.getUfPrestacao(), vo.getNaturezaOperacao(), nota.getUnidadeFatFornecedor().getFornecedor().getPessoa().getComplemento().getCnpj(), this.getContribuinteEstado(nota.getUnidadeFatFornecedor()), nota.getUnidadeFatFornecedor().getFornecedor().getPessoa().getComplemento().getHabilitarSuframa(), nota.getEmpresa());
        if (mod == null) {
            sb.append("Nenhum modelo fiscal encontrado para o produto: " + vo.getProduto().getIdentificador() + " - " + vo.getProduto().getNome() + "\nCategoria Pessoa: " + String.valueOf(nota.getUnidadeFatFornecedor().getCategoriaPessoa()) + "\nUF Prestacao: " + String.valueOf(nota.getUfPrestacao()) + "\nNatureza Operacao: " + String.valueOf(vo.getNaturezaOperacao()) + "\nCNPJ/CPF: " + nota.getUnidadeFatFornecedor().getFornecedor().getPessoa().getComplemento().getCnpj() + "\nContribuinte: " + this.getContribuinteEstado(nota.getUnidadeFatFornecedor()) + "\nSuframa: " + nota.getUnidadeFatFornecedor().getFornecedor().getPessoa().getComplemento().getHabilitarSuframa() + "\nEmpresa: " + String.valueOf(nota.getEmpresa()));
        }
        return mod;
    }

    private void setProdutoAndGrade(ItemNotaTerceiros vo, NotaFiscalPropria notaPropria, String codigoProduto, DeParaFornecedor dePara) throws Exception {
        for (ItemNotaFiscalPropria i : notaPropria.getItensNotaPropria()) {
            DeParaFornecedorItem itemDePara;
            if (!vo.getNumeroItem().equals(i.getNumeroItem())) continue;
            Boolean achou = false;
            if (dePara.getUtilizaProdutoDiferente() != null && dePara.getUtilizaProdutoDiferente().equals((short)1) && (itemDePara = this.serviceDeParaFornecedor.findDeParaItemEntrada(dePara, i.getProduto())) != null && itemDePara.getProdutoSaida() != null) {
                vo.setProduto(itemDePara.getProdutoEntrada());
                achou = true;
            }
            if (!achou.booleanValue() && i.getProduto().getCodigoAuxiliar() != null && i.getProduto().getCodigoAuxiliar().equals(codigoProduto) && i.getQuantidadeTotal().equals(vo.getQuantidadeTotal())) {
                vo.setProduto(i.getProduto());
                achou = true;
            }
            if (!achou.booleanValue() && i.getProduto().getIdentificador().toString().equals(codigoProduto)) {
                vo.setProduto(i.getProduto());
                achou = true;
            }
            if (!achou.booleanValue()) continue;
            for (GradeItemNotaFiscalPropria gradeP : i.getGradesNotaFiscalPropria()) {
                GradeItemNotaTerceiros g = new GradeItemNotaTerceiros();
                g.setDataEntradaSaida(vo.getNotaFiscalTerceiros().getDataEntrada());
                g.setItemNotaTerceiros(vo);
                g.setQuantidade(gradeP.getQuantidade());
                g.setValorCusto(vo.getValorUnitario());
                if (i.getProduto().equals((Object)vo.getProduto())) {
                    g.setGradeCor(gradeP.getGradeCor());
                    g.setLoteFabricacao(gradeP.getLoteFabricacao());
                } else {
                    Cor cor = gradeP.getGradeCor().getCor();
                    for (ProdutoGrade pg : vo.getProduto().getGradesProduto()) {
                        for (GradeCor gc : pg.getGradesCores()) {
                            if (!gc.getCor().equals((Object)cor)) continue;
                            g.setGradeCor(gc);
                        }
                    }
                    if (vo.getProduto().getLoteUnico().equals((short)1)) {
                        lote = this.serviceLoteFabricacao.findLoteUnico(vo.getProduto());
                        if (lote != null) {
                            g.setLoteFabricacao(lote);
                        }
                    } else {
                        lote = this.serviceLoteFabricacao.findOrCreateLote(vo.getProduto(), gradeP.getLoteFabricacao().getLoteFabricacao());
                        g.setLoteFabricacao(lote);
                    }
                }
                if (g.getGradeCor() == null) {
                    throw new Exception("Nenhuma grade encontrada para o produto: " + vo.getProduto().getIdentificador() + " - " + vo.getProduto().getNome() + ", Cor: " + gradeP.getGradeCor().getCor().getNome());
                }
                if (g.getLoteFabricacao() == null) {
                    throw new Exception("Nenhuma lote de fabricacao encontrado para o produto: " + vo.getProduto().getIdentificador() + " - " + vo.getProduto().getNome());
                }
                vo.getGrade().add(g);
            }
        }
    }

    private SituacaoDocumento getDocumentoRegular() {
        return this.serviceSituacaoDocumento.get(EnumConstSituacaoDocumento.REGULAR);
    }

    private OpcoesFinanceiras getOpcaoFinanceira(Empresa empresa) {
        return this.serviceOpcoesFinanceiras.findByEmpresa(empresa);
    }

    private OpcoesCompraSuprimentos getOpcaoCompra(Empresa empresa) {
        return this.serviceOpcoesCompra.get(empresa);
    }

    private OpcoesContabeis getOpcaoContabil(Empresa empresa) {
        return this.serviceOpcoesContabeis.getByIdEmpresa(empresa.getIdentificador());
    }

    private DeParaFornecedor findDeParaFornecedor(UnidadeFatFornecedor fornecedor, NaturezaOperacao natOperacaoSaida, Empresa empresaDestino) {
        DeParaFornecedor de = this.serviceDeParaFornecedor.findDeParaFornEmpresaNatSaida(fornecedor, empresaDestino, natOperacaoSaida);
        if (de != null) {
            return de;
        }
        de = this.serviceDeParaFornecedor.findDeParaFornEmpresa(fornecedor, empresaDestino);
        return de;
    }

    private Cfop findCfopEntrada(UnidadeFederativa ufEmpresa, UnidadeFederativa ufPrestacao, ModeloFiscal modeloFiscal) throws Exception {
        return this.serviceCfop.findCfopEntrada(ufEmpresa, ufPrestacao, modeloFiscal);
    }

    private void setMovimentacaoFisica(ItemNotaTerceiros vo) {
        for (GradeItemNotaTerceiros g : vo.getGrade()) {
            g.setMovimentacaoFisica(vo.getModeloFiscal().getMovimentacaoFisica());
        }
    }

    private void calcularTotalizadores(NotaFiscalTerceiros nota) {
        new UtilNotaFiscalTerceiros().calcularTotalizadores(nota);
    }

    private void calcularLivrosFiscais(NotaFiscalTerceiros notaTerceiros) throws ExceptionAvaliadorExpressoes {
        List<LivroFiscal> livros = new UtilNotaFiscalTerceiros().getLivrosFiscaisResumo(notaTerceiros.getItemNotaTerceiros(), notaTerceiros.getLivrosFiscais(), notaTerceiros.getModeloDocFiscal(), notaTerceiros.getSituacaoDocumento(), notaTerceiros.getUfPrestacao(), notaTerceiros.getCidadePrestacao());
        notaTerceiros.setLivrosFiscais(livros);
    }

    private void setDadosContabeis(ItemNotaTerceiros vo, NotaFiscalTerceiros nota, OpcoesContabeis opcoes) throws ExceptionParametrizacao, ExceptionInvalidData {
        if (vo.getModeloFiscal().getOpcaoContabilizacao() != null && vo.getModeloFiscal().getOpcaoContabilizacao() == 1) {
            CompParametrizacaoContabilNF.DadosContas dados = this.findParametrizacaoCtbModFiscal(vo, nota, opcoes);
            vo.setPlanoContaDeb(dados.getPlanoContaDeb());
            vo.setPlanoContaCred(dados.getPlanoContaCred());
            vo.setPlanoContaGerencial(dados.getPcGerencial());
            vo.setPlanoContaGerencial(dados.getPcGerencial());
        }
        if (vo.getPlanoContaGerencial() == null) {
            vo.setPlanoContaGerencial(vo.getProduto().getPlanoContaGerencial());
        }
    }

    private void setCentroEstoque(ItemNotaTerceiros vo, NotaFiscalTerceiros nota, DeParaFornecedor deParaForn, OpcoesEstoque opEst) {
        Boolean achou = false;
        for (DeParaFornecedorCentroEstoque d : deParaForn.getCentroEstoques()) {
            if (!d.getEmpresa().equals((Object)nota.getEmpresa())) continue;
            vo.setCentroEstoque(d.getCentroEstoque());
            return;
        }
        if (!achou.booleanValue()) {
            CentroEstoque cen = ((HelperCentroEstoque)ConfApplicationContext.getBean(HelperCentroEstoque.class)).getCentroEstoque(nota.getEmpresa(), opEst, vo, null);
            vo.setCentroEstoque(cen);
        }
    }

    private EmpresaContabilidade getEmpresaContabilidade(Empresa empresa) {
        return this.serviceEmpresaContabil.findByEmpresa(empresa);
    }

    private void gerarLiberacaoNFTerceiros(NotaFiscalTerceiros nota) {
        OpcoesCompraSuprimentos op = this.getOpcaoCompra(nota.getEmpresa());
        CompConferenciaNFTerceiros.avaliarNFParaConferencia(nota, op);
    }

    private Short getContribuinteEstado(UnidadeFatFornecedor unidade) {
        return ((HelperUnidadeFatFornecedor)Context.get(HelperUnidadeFatFornecedor.class)).build(unidade).getContribuinteEstado();
    }

    private OpcoesEstoque getOpcoesEstoque(Empresa empresa) {
        return ((ServiceOpcoesEstoqueImpl)ConfApplicationContext.getBean(ServiceOpcoesEstoqueImpl.class)).get(empresa);
    }

    private NotaFiscalTerceiros findNotaTerceiros(Element inf) {
        String chaveNFe = inf.getAttributeValue("Id");
        chaveNFe = chaveNFe.substring(3, 47);
        return this.daoNotaTerceiros.findNotaByChaveNFe(chaveNFe);
    }

    private StringBuilder importarNF(NotaPropriaXML x, Document d, String chave, String cnpjCpfEmitente, String cnpjCpfDestinatario, List<NotaFiscalTerceiros> notasGeradas) throws IOException, Exception {
        StringBuilder ret = new StringBuilder();
        Empresa empresa = this.findEmpresa(cnpjCpfDestinatario);
        OpcoesContabeis opcoesContabeis = this.sharedData.getOpcoesContabeis(empresa);
        OpcoesImpostos opImpostos = this.sharedData.getOpcoesImpostos(empresa);
        OpcoesCompraSuprimentos opcoesCompra = this.sharedData.getOpcoesCompraSuprimentos(empresa);
        UnidadeFatFornecedor fornecedor = this.findFornecedor(cnpjCpfEmitente);
        if (fornecedor == null) {
            ret.append("Nenhum Fornecedor encontrado para o CNPJ: " + cnpjCpfEmitente);
            return ret;
        }
        DeParaFornecedor dePara = this.findDeParaFornecedor(fornecedor, x.getNota().getNaturezaOperacao(), empresa);
        if (dePara == null) {
            ret.append("Nenhum DePara Fornecedor encontrado para o fornecedor: " + fornecedor.getFornecedor().getPessoa().getNome() + " - " + fornecedor.getFornecedor().getPessoa().getComplemento().getCnpj());
        }
        XMLNfeTerceiros xt = this.getOrCreateXMLNFeTerceiros(chave, x);
        NotaFiscalTerceiros nota = this.createNotaTerceiros(xt, empresa, dePara, x.getNota(), fornecedor, ret, opcoesContabeis, opImpostos, opcoesCompra);
        if (ret == null || ret.length() <= 0 && nota != null) {
            nota = this.serviceNotaTerceiros.saveOrUpdate(nota);
            xt.setIdNotaTerceiros(nota.getIdentificador());
            xt = (XMLNfeTerceiros)this.serviceXMLNFeTerceiros.saveOrUpdate((Object)xt);
            x.getNota().setTransferidaFilial(Short.valueOf((short)1));
            this.serviceNotaPropria.saveOrUpdate(x.getNota());
            System.out.println("\n\nNota Terceiros importada com sucesso. ID: " + nota.getIdentificador());
            notasGeradas.add(nota);
        } else {
            System.out.println("\n\nErro ao importar nota de terceiros: " + String.valueOf(nota));
        }
        return ret;
    }

    private boolean notaDestinoEmpresaLogada(String cnpjEmpresa, NotaPropriaXML x) {
        try {
            String xml = ToolString.clearInvalidUTF8Char((String)x.getXml().getConteudoXML());
            SAXBuilder sb = new SAXBuilder();
            Document d = null;
            d = sb.build((InputStream)new ByteArrayInputStream(xml.getBytes()));
            Element inf = d.getRootElement().getChild("infNFe", this.n);
            String cnpjCpfDestinatario = "";
            cnpjCpfDestinatario = inf.getChild("dest", this.n).getChild("CNPJ", this.n) != null ? inf.getChild("dest", this.n).getChild("CNPJ", this.n).getText() : inf.getChild("dest", this.n).getChild("CPF", this.n).getText();
            return ToolMethods.isEquals((Object)cnpjEmpresa, (Object)cnpjCpfDestinatario);
        }
        catch (JDOMException ex) {
            this.logger.error(ex.getMessage());
            return false;
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage());
            return false;
        }
    }

    private String exportarXML(String xml, String xmlAutorizacao, VersaoNFe versao) throws IOException, JDOMException {
        String retorno;
        SAXBuilder sb = new SAXBuilder();
        SAXBuilder sb1 = new SAXBuilder();
        Document d = sb.build((InputStream)new ByteArrayInputStream(xml.getBytes()));
        Element e = null;
        if (xmlAutorizacao != null) {
            Document a = sb1.build((InputStream)new ByteArrayInputStream(xmlAutorizacao.getBytes()));
            e = a.detachRootElement();
        }
        Element nfeProc = new Element("nfeProc");
        Attribute at = new Attribute("versao", versao.getCodigo());
        nfeProc.setAttribute(at);
        nfeProc.setNamespace(Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe"));
        Element root = d.detachRootElement();
        nfeProc.addContent((Content)root);
        if (e != null) {
            nfeProc.addContent((Content)e);
        }
        if ((retorno = new XMLOutputter().outputString(nfeProc)).contains("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>")) {
            return retorno;
        }
        StringBuilder sbd = new StringBuilder();
        sbd.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        sbd.append(retorno);
        return sbd.toString();
    }
}

