/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.opcoescomprasuprimentos;

import com.touchcomp.basementor.constants.enums.opcoescompra.EnumConstOpComprasOpSections;
import com.touchcomp.basementor.constants.enums.opcoescompra.EnumOpcoesComprasOp;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.interfaces.EnumOpSectionDinamicasInterface;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorrules.opcoesdinamicas.model.DTOOpcoesDinamicas;
import com.touchcomp.basementorservice.dao.impl.DaoOpcoesCompraSuprimentosImpl;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoescomprasuprimentos.HelperOpcoesCompraSuprimentos;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceOpcoesCompraSuprimentos;
import com.touchcomp.touchvomodel.vo.opcoescomprasuprimentos.web.DTOOpcoesCompraSuprimentos;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceOpcoesCompraSuprimentosImpl
extends ServiceGenericEntityImpl<OpcoesCompraSuprimentos, Long, DaoOpcoesCompraSuprimentosImpl>
implements ServiceOpcoesCompraSuprimentos {
    @Autowired
    private HelperOpcoesCompraSuprimentos helper;

    @Autowired
    public ServiceOpcoesCompraSuprimentosImpl(DaoOpcoesCompraSuprimentosImpl genericDao) {
        super(genericDao);
    }

    @Override
    public OpcoesCompraSuprimentos beforeSave(OpcoesCompraSuprimentos vo) {
        if (vo.getOpcoesCompraOp() != null) {
            vo.getOpcoesCompraOp().forEach(i -> i.setOpcoesCompra(vo));
        }
        return vo;
    }

    @Override
    public OpcoesCompraSuprimentos get(Empresa empresa) {
        return this.getByIdEmpresa(empresa.getIdentificador());
    }

    public OpcoesCompraSuprimentos getByIdEmpresa(Long idEmpresa) {
        return ((DaoOpcoesCompraSuprimentosImpl)this.getDao()).getByIdEmpresa(idEmpresa);
    }

    public DTOOpcoesCompraSuprimentos getByIdEmpresaDTO(Long identificador, Class<DTOOpcoesCompraSuprimentos> aClass) {
        OpcoesCompraSuprimentos op = this.getByIdEmpresa(identificador);
        if (op == null) {
            return null;
        }
        return this.buildToDTO(op, aClass);
    }

    public DTOOpcoesDinamicas getOptions(Long idOpcoes) {
        OpcoesCompraSuprimentos op = (OpcoesCompraSuprimentos)this.get(idOpcoes);
        return CompOpcoes.getAllOptions(this.helper.build(op).getItens(), (EnumOpSectionDinamicasInterface[])EnumConstOpComprasOpSections.values(), (EnumOpDinamicasInterface[])EnumOpcoesComprasOp.values());
    }
}

