/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.opcoescontabeisbaixatitulos;

import com.touchcomp.basementor.constants.enums.opcoes.opcoescontabeisbaixatitulos.EnumConstOpContabeisBaixaTituloSections;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoTitulo;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.interfaces.EnumOpSectionDinamicasInterface;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.OpcoesCtbBaixaTitClassClientes;
import com.touchcomp.basementor.model.vo.TipoDoc;
import com.touchcomp.basementor.model.vo.TipoDocOpcoesCtbBaixaTit;
import com.touchcomp.basementor.model.vo.TipoValoresTitulos;
import com.touchcomp.basementor.model.vo.TipoValoresTitulosOpcoesCtbBaixaTit;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorrules.opcoesdinamicas.model.DTOOpcoesDinamicas;
import com.touchcomp.basementorservice.dao.impl.DaoOpcoesContabeisBaixaTitulosImpl;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoescontabeisbaixatitulos.HelperOpcoesContabeisBaixaTitulos;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.classificacaoclientes.ServiceClassificacaoClientesImpl;
import com.touchcomp.basementorservice.service.impl.tipodoc.ServiceTipoDocImpl;
import com.touchcomp.basementorservice.service.impl.tipovalorestitulos.ServiceTipoValoresTitulosImpl;
import com.touchcomp.touchvomodel.vo.opcoescontabeisbaixatitulos.web.DTOOpcoesContabeisBaixaTitulos;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class ServiceOpcoesContabeisBaixaTitulosImpl
extends ServiceGenericEntityImpl<OpcoesContabeisBaixaTitulos, Long, DaoOpcoesContabeisBaixaTitulosImpl> {
    @Autowired
    private ServiceTipoValoresTitulosImpl serviceTipoValoresTitulos;
    @Autowired
    private ServiceTipoDocImpl serviceTipoDoc;
    @Autowired
    private ServiceClassificacaoClientesImpl serviceClassificacaoClientes;
    @Autowired
    private HelperOpcoesContabeisBaixaTitulos helper;

    @Autowired
    public ServiceOpcoesContabeisBaixaTitulosImpl(DaoOpcoesContabeisBaixaTitulosImpl dao) {
        super(dao);
    }

    @Override
    public OpcoesContabeisBaixaTitulos beforeSaveEntity(OpcoesContabeisBaixaTitulos vo) {
        if (ServiceOpcoesContabeisBaixaTitulosImpl.isWithData(vo.getOpcoesContabeisBaixaTitOp())) {
            vo.getOpcoesContabeisBaixaTitOp().forEach(i -> i.setOpcoesContabeisBaixaTitulos(vo));
        }
        if (ServiceOpcoesContabeisBaixaTitulosImpl.isWithData(vo.getOpcoesCtbBaixaTitClassClientes())) {
            vo.getOpcoesCtbBaixaTitClassClientes().forEach(i -> i.setOpcoesContabeisBaixaTitulos(vo));
        }
        if (ServiceOpcoesContabeisBaixaTitulosImpl.isWithData(vo.getTipoDocOpcoesCtbBaixaTit())) {
            vo.getTipoDocOpcoesCtbBaixaTit().forEach(i -> i.setOpcoesContabeisBaixaTitulos(vo));
        }
        if (ServiceOpcoesContabeisBaixaTitulosImpl.isWithData(vo.getTipoValoresTitulosOpcoesCtbBaixaTit())) {
            vo.getTipoValoresTitulosOpcoesCtbBaixaTit().forEach(i -> i.setOpcoesContabeisBaixaTitulos(vo));
        }
        return vo;
    }

    public OpcoesContabeisBaixaTitulos findOpcoesContabeisBaixaTituloPorClassificacaoCliente(ClassificacaoClientes classificacaoClientes) {
        OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos = ((DaoOpcoesContabeisBaixaTitulosImpl)this.getDao()).findOpcoesContabeisBaixaTituloPorClassificacaoCliente(classificacaoClientes);
        if (this.isEquals(opcoesContabeisBaixaTitulos, null)) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0650.002", new Object[]{classificacaoClientes}));
        }
        return opcoesContabeisBaixaTitulos;
    }

    @Cacheable(cacheNames={"OpcoesContabeisBaixaTitulos_1"}, keyGenerator="customKeyGenerator")
    public OpcoesContabeisBaixaTitulos findOpcaoContabilBaixaTituloComFormaPagCache(Short pagRec, TipoDoc tipoDoc, ClassificacaoClientes classificacaoClientes, Short formaPag, Empresa empresa) {
        OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos = ((DaoOpcoesContabeisBaixaTitulosImpl)this.getDao()).findOpcaoContabilBaixaTituloComFormaPag(pagRec, tipoDoc, classificacaoClientes, formaPag, empresa);
        if (this.isEquals(opcoesContabeisBaixaTitulos, null)) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0650.001", new Object[]{pagRec, tipoDoc, classificacaoClientes, formaPag, empresa}));
        }
        return opcoesContabeisBaixaTitulos;
    }

    public OpcoesContabeisBaixaTitulos getOpcoesContabeisByBaixa(BaixaTitulo baixa, Empresa empresa) {
        if (baixa.getTitulo().getTipoDoc() != null) {
            Titulo t = baixa.getTitulo();
            return this.findOpcaoContabilBaixaTituloComFormaPagCache(t.getPagRec(), t.getTipoDoc(), t.getClassificacaoPessoa(), (short)1, empresa);
        }
        return null;
    }

    public List<DTOOpcoesContabeisBaixaTitulos.DTOTipoDocOpcoesCtbBaixaTit> newItemTipoDocumentoFinanceiro(Long[] identificadores) throws ExceptionObjNotFound {
        List tipoDocumentoFinanceiro = this.serviceTipoDoc.gets(identificadores);
        LinkedList<DTOOpcoesContabeisBaixaTitulos.DTOTipoDocOpcoesCtbBaixaTit> res = new LinkedList<DTOOpcoesContabeisBaixaTitulos.DTOTipoDocOpcoesCtbBaixaTit>();
        if (ServiceOpcoesContabeisBaixaTitulosImpl.isWithData(tipoDocumentoFinanceiro)) {
            for (TipoDoc td : tipoDocumentoFinanceiro) {
                TipoDocOpcoesCtbBaixaTit t = new TipoDocOpcoesCtbBaixaTit();
                t.setTipoDoc(td);
                res.add(this.buildToDTOGeneric(t, DTOOpcoesContabeisBaixaTitulos.DTOTipoDocOpcoesCtbBaixaTit.class));
            }
        }
        return res;
    }

    public List<DTOOpcoesContabeisBaixaTitulos.DTOTipoValoresTitulosOpcoesCtbBaixaTit> newItemTipoValorTitulo(Long[] identificadores, EnumConstTipoTitulo pagRec) throws ExceptionObjNotFound, ExceptionInvalidData {
        if (this.isNull(pagRec).booleanValue()) {
            throw new ExceptionInvalidData("Primeiro selecione uma op\u00e7\u00e3o do Tipo de T\u00edtulo!", new Object[0]);
        }
        List tipos = this.serviceTipoValoresTitulos.gets(identificadores);
        LinkedList<DTOOpcoesContabeisBaixaTitulos.DTOTipoValoresTitulosOpcoesCtbBaixaTit> res = new LinkedList<DTOOpcoesContabeisBaixaTitulos.DTOTipoValoresTitulosOpcoesCtbBaixaTit>();
        if (ServiceOpcoesContabeisBaixaTitulosImpl.isWithData(tipos)) {
            for (TipoValoresTitulos tipo : tipos) {
                if (this.isEquals(tipo.getTipoDoc(), pagRec.getValue()) || this.isEquals(tipo.getTipoDoc(), EnumConstTipoTitulo.AMBOS.getValue()) || this.isEquals(EnumConstTipoTitulo.AMBOS, pagRec)) {
                    if (this.isAffimative(tipo.getAtivo())) {
                        TipoValoresTitulosOpcoesCtbBaixaTit t = new TipoValoresTitulosOpcoesCtbBaixaTit();
                        t.setTipoValoresTitulos(tipo);
                        res.add(this.buildToDTOGeneric(t, DTOOpcoesContabeisBaixaTitulos.DTOTipoValoresTitulosOpcoesCtbBaixaTit.class));
                        continue;
                    }
                    throw new ExceptionInvalidData("O Tipo Valor de T\u00edtulo selecionado est\u00e1 inativo!", new Object[0]);
                }
                throw new ExceptionInvalidData("O Tipo Valor de T\u00edtulo selecionado deve ser do mesmo tipo do T\u00edtulo ou Ambos!", new Object[0]);
            }
        }
        return res;
    }

    public List<DTOOpcoesContabeisBaixaTitulos.DTOOpcoesCtbBaixaTitClassClientes> newItemClassificacaoPessoa(Long[] idCassificacaoPessoa) throws ExceptionObjNotFound {
        List classificacaoPessoa = this.serviceClassificacaoClientes.gets(idCassificacaoPessoa);
        LinkedList<DTOOpcoesContabeisBaixaTitulos.DTOOpcoesCtbBaixaTitClassClientes> res = new LinkedList<DTOOpcoesContabeisBaixaTitulos.DTOOpcoesCtbBaixaTitClassClientes>();
        if (ServiceOpcoesContabeisBaixaTitulosImpl.isWithData(classificacaoPessoa)) {
            for (ClassificacaoClientes c : classificacaoPessoa) {
                OpcoesCtbBaixaTitClassClientes o = new OpcoesCtbBaixaTitClassClientes();
                o.setClassificacaoClientes(c);
                res.add(this.buildToDTOGeneric(o, DTOOpcoesContabeisBaixaTitulos.DTOOpcoesCtbBaixaTitClassClientes.class));
            }
        }
        return res;
    }

    public DTOOpcoesDinamicas getOptions(Long idOpcoes) {
        OpcoesContabeisBaixaTitulos op = (OpcoesContabeisBaixaTitulos)this.get(idOpcoes);
        EnumOpDinamicasInterface[] options = new EnumOpDinamicasInterface[]{};
        DTOOpcoesDinamicas din = CompOpcoes.getAllOptions(this.helper.build(op).getItens(), (EnumOpSectionDinamicasInterface[])EnumConstOpContabeisBaixaTituloSections.values(), (EnumOpDinamicasInterface[])options);
        return din;
    }
}

