/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.opcoesestoque;

import com.touchcomp.basementor.constants.enums.opcoesestoque.EnumConstOpEstoqueOp;
import com.touchcomp.basementor.constants.enums.opcoesestoque.EnumConstOpEstoqueOpSections;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.interfaces.EnumOpSectionDinamicasInterface;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.OpcoesEstoqueOp;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorrules.opcoesdinamicas.model.DTOOpcoesDinamicas;
import com.touchcomp.basementorservice.dao.impl.DaoOpcoesEstoqueImpl;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesestoque.HelperOpcoesEstoque;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.touchvomodel.vo.opcoesestoque.web.DTOOpcoesEstoque;
import org.springframework.stereotype.Service;

@Service
public class ServiceOpcoesEstoqueImpl
extends ServiceGenericEntityImpl<OpcoesEstoque, Long, DaoOpcoesEstoqueImpl> {
    private final HelperOpcoesEstoque helperOpcoesEstoque;

    public ServiceOpcoesEstoqueImpl(HelperOpcoesEstoque helperOpcoesEstoque, DaoOpcoesEstoqueImpl genericDao) {
        super(genericDao);
        this.helperOpcoesEstoque = helperOpcoesEstoque;
    }

    @Override
    public OpcoesEstoque get(Empresa empresa) {
        return this.getByIdEmpresa(empresa.getIdentificador());
    }

    public OpcoesEstoque getByIdEmpresa(Long idEmpresa) {
        return ((DaoOpcoesEstoqueImpl)this.getDao()).getByIdEmpresa(idEmpresa);
    }

    @Override
    public OpcoesEstoque beforeSave(OpcoesEstoque aux) {
        for (OpcoesEstoqueOp op : aux.getOpcoesEstoqueOp()) {
            op.setOpcoesEstoque(aux);
        }
        return aux;
    }

    public DTOOpcoesDinamicas getOptions(Long idOpcoes) {
        OpcoesEstoque op = (OpcoesEstoque)this.get(idOpcoes);
        DTOOpcoesDinamicas din = CompOpcoes.getAllOptions(this.helperOpcoesEstoque.build(op).getItens(), (EnumOpSectionDinamicasInterface[])EnumConstOpEstoqueOpSections.values(), (EnumOpDinamicasInterface[])EnumConstOpEstoqueOp.values());
        return din;
    }

    public DTOOpcoesEstoque getByIdEmpresaDTO(Long identificador, Class<DTOOpcoesEstoque> aClass) {
        OpcoesEstoque op = this.getByIdEmpresa(identificador);
        if (op == null) {
            return null;
        }
        return this.buildToDTO(op, aClass);
    }
}

