/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.opcoesfaturamento;

import com.fincatto.documentofiscal.DFModelo;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFaturamentoOp;
import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFaturamentoOpSections;
import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.interfaces.EnumOpSectionDinamicasInterface;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoTickeFiscalProduto;
import com.touchcomp.basementor.model.vo.OpcoesPedidoOtimizadoGrupoDesconto;
import com.touchcomp.basementor.model.vo.OpcoesPedidoOtimizadoGrupoDescontoMaster;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorclientwebservices.nfe.impl.consultastatusservico.UtilConsultaStatusServico;
import com.touchcomp.basementorclientwebservices.nfe.model.ret.statusservico.NFeStatusServicoRet;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorrules.opcoesdinamicas.model.DTOOpcoesDinamicas;
import com.touchcomp.basementorservice.dao.impl.DaoOpcoesFaturamentoImpl;
import com.touchcomp.basementorservice.helpers.impl.configuracaocertificado.HelperConfiguracaoCertificado;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfaturamento.HelperOpcoesFaturamento;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.grupousuarios.ServiceGrupoUsuariosImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceOpcoesFaturamento;
import com.touchcomp.touchvomodel.vo.opcoesfaturamento.web.DTOOpcoesFaturamento;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceOpcoesFaturamentoImpl
extends ServiceGenericEntityImpl<OpcoesFaturamento, Long, DaoOpcoesFaturamentoImpl>
implements ServiceOpcoesFaturamento {
    @Autowired
    private ServiceGrupoUsuariosImpl serviceGrupo;
    @Autowired
    private ServiceProdutoImpl serviceProduto;
    @Autowired
    private HelperOpcoesFaturamento helperOpcoesFat;
    @Autowired
    private HelperConfiguracaoCertificado helperConfigCertificado;

    @Autowired
    public ServiceOpcoesFaturamentoImpl(DaoOpcoesFaturamentoImpl genericDao) {
        super(genericDao);
    }

    @Override
    public OpcoesFaturamento beforeSave(OpcoesFaturamento vo) {
        if (vo.getOpcoesFatNFeDownXML() != null) {
            vo.getOpcoesFatNFeDownXML().forEach(i -> i.setOpcoesFaturamento(vo));
        }
        if (vo.getOpcoesPedidoOtimizadoGrupoDesconto() != null) {
            vo.getOpcoesPedidoOtimizadoGrupoDesconto().forEach(i -> i.setOpcoesFaturamento(vo));
        }
        if (vo.getOpcoesPedidoOtimizadoGrupoDescontoMaster() != null) {
            vo.getOpcoesPedidoOtimizadoGrupoDescontoMaster().forEach(i -> i.setOpcoesFaturamento(vo));
        }
        if (vo.getTicketsProduto() != null) {
            vo.getTicketsProduto().forEach(i -> i.setOpcoesFaturamento(vo));
        }
        if (vo.getOpcoesFaturamentoOp() != null) {
            vo.getOpcoesFaturamentoOp().forEach(i -> i.setOpcoesFaturamento(vo));
        }
        return vo;
    }

    @Override
    public OpcoesFaturamento findByEmpresa(Empresa empresa) {
        return this.getByIdEmpresa(empresa.getIdentificador());
    }

    public OpcoesFaturamento getByIdEmpresa(Long idEmpresa) {
        return ((DaoOpcoesFaturamentoImpl)this.getDao()).getByIdEmpresa(idEmpresa);
    }

    public DTOOpcoesFaturamento getByIdEmpresaDTO(Long identificador, Class<DTOOpcoesFaturamento> aClass) {
        OpcoesFaturamento op = this.getByIdEmpresa(identificador);
        if (op == null) {
            return null;
        }
        return this.buildToDTO(op, aClass);
    }

    public List<DTOOpcoesFaturamento.DTOOpcoesPedidoOtimizadoGrupoDesconto> criarGrupoDescontoUsuarios(Long[] identificadores) {
        if (identificadores == null || identificadores.length == 0) {
            return new ArrayList<DTOOpcoesFaturamento.DTOOpcoesPedidoOtimizadoGrupoDesconto>();
        }
        ArrayList<DTOOpcoesFaturamento.DTOOpcoesPedidoOtimizadoGrupoDesconto> ret = new ArrayList<DTOOpcoesFaturamento.DTOOpcoesPedidoOtimizadoGrupoDesconto>();
        List grupos = this.serviceGrupo.gets(identificadores);
        for (Grupo g : grupos) {
            OpcoesPedidoOtimizadoGrupoDesconto vo = new OpcoesPedidoOtimizadoGrupoDesconto();
            vo.setGrupo(g);
            ret.add(this.buildToDTOGeneric(vo, DTOOpcoesFaturamento.DTOOpcoesPedidoOtimizadoGrupoDesconto.class));
        }
        return ret;
    }

    public List<DTOOpcoesFaturamento.DTOOpcoesPedidoOtimizadoGrupoDescontoMaster> criarGrupoDescontoMasterUsuarios(Long[] identificadores) {
        if (identificadores == null || identificadores.length == 0) {
            return new ArrayList<DTOOpcoesFaturamento.DTOOpcoesPedidoOtimizadoGrupoDescontoMaster>();
        }
        ArrayList<DTOOpcoesFaturamento.DTOOpcoesPedidoOtimizadoGrupoDescontoMaster> ret = new ArrayList<DTOOpcoesFaturamento.DTOOpcoesPedidoOtimizadoGrupoDescontoMaster>();
        List grupos = this.serviceGrupo.gets(identificadores);
        for (Grupo g : grupos) {
            OpcoesPedidoOtimizadoGrupoDescontoMaster vo = new OpcoesPedidoOtimizadoGrupoDescontoMaster();
            vo.setGrupo(g);
            ret.add(this.buildToDTOGeneric(vo, DTOOpcoesFaturamento.DTOOpcoesPedidoOtimizadoGrupoDescontoMaster.class));
        }
        return ret;
    }

    public List<DTOOpcoesFaturamento.DTOOpcoesFaturamentoTickeFiscalProduto> criarTicketFiscalProduto(Long[] identificadores) {
        if (identificadores == null || identificadores.length == 0) {
            return new ArrayList<DTOOpcoesFaturamento.DTOOpcoesFaturamentoTickeFiscalProduto>();
        }
        ArrayList<DTOOpcoesFaturamento.DTOOpcoesFaturamentoTickeFiscalProduto> ret = new ArrayList<DTOOpcoesFaturamento.DTOOpcoesFaturamentoTickeFiscalProduto>();
        List produtos = this.serviceProduto.gets(identificadores);
        for (Produto p : produtos) {
            OpcoesFaturamentoTickeFiscalProduto vo = new OpcoesFaturamentoTickeFiscalProduto();
            vo.setProduto(p);
            ret.add(this.buildToDTOGeneric(vo, DTOOpcoesFaturamento.DTOOpcoesFaturamentoTickeFiscalProduto.class));
        }
        return ret;
    }

    public DTOOpcoesDinamicas getOptions(Long idOpcoes) {
        OpcoesFaturamento op = (OpcoesFaturamento)this.get(idOpcoes);
        return CompOpcoes.getAllOptions(this.helperOpcoesFat.build(op).getItens(), (EnumOpSectionDinamicasInterface[])EnumConstOpFaturamentoOpSections.values(), (EnumOpDinamicasInterface[])EnumConstOpFaturamentoOp.values());
    }

    public String consultarStatusServicoSefaz(ConfiguracaoCertificado config, Empresa empresa, ConstAmbiente ambiente, EnumConstUF uf, DFModelo modelo) throws Exception {
        this.reload(empresa);
        ParamsCertificado params = this.helperConfigCertificado.build(config).getParamsCertificado(ambiente);
        NFeStatusServicoRet status = UtilConsultaStatusServico.consultarStatusServico((ParamsCertificado)params, (EnumConstUF)uf, (DFModelo)modelo);
        String statusDoc = "";
        String motivo = "";
        if (this.isEquals(modelo, DFModelo.NFE)) {
            statusDoc = status.getStatusNFe();
            motivo = status.getMotivoNFe();
        } else if (this.isEquals(modelo, DFModelo.NFCE)) {
            statusDoc = status.getStatusNFCe();
            motivo = status.getMotivoNFCe();
        }
        String observacao = status.getObservacao() != null ? status.getObservacao() : "";
        return MessagesBaseMentor.getMsg((String)"resultadoStatusServicoSefaz", (Object[])new Object[]{statusDoc, uf.getValue(), ambiente.getDescricao(), motivo, observacao});
    }
}

