/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.opcoesfaturamentonfse;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.configservicosterceiros.EnumConstConfigServicosTerceiros;
import com.touchcomp.basementor.constants.enums.nfse.EnumConstConfigServicoNFSe;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.interfaces.EnumOpSectionDinamicasInterface;
import com.touchcomp.basementor.model.vo.ConfigServicosTerceiros;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoNFSe;
import com.touchcomp.basementorclientwebservices.nfse.impl.consultacertificado.UtilConsultaCertificadoNFSe;
import com.touchcomp.basementorclientwebservices.nfse.model.ret.consultacertificado.NFSeResultDadosEmpresa;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorrules.opcoesdinamicas.model.DTOOpcoesDinamicas;
import com.touchcomp.basementorservice.dao.impl.DaoOpcoesFaturamentoNFSeImpl;
import com.touchcomp.basementorservice.helpers.impl.configservicosterceiros.HelperConfigServicosTerceiros;
import com.touchcomp.basementorservice.helpers.impl.opcoesfaturamentonfse.HelperOpcoesFaturamentoNFSe;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.configservicosterceiros.ServiceConfigServicosTerceirosImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchvomodel.vo.opcoesfaturamentonfse.web.DTOOpcoesFaturamentoNFSe;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceOpcoesFaturamentoNFSeImpl
extends ServiceGenericEntityImpl<OpcoesFaturamentoNFSe, Long, DaoOpcoesFaturamentoNFSeImpl> {
    @Autowired
    private HelperOpcoesFaturamentoNFSe helperOpcoesFaturamentoNFSe;
    @Autowired
    private ServiceConfigServicosTerceirosImpl serviceConfigServTerceiros;
    @Autowired
    private HelperConfigServicosTerceiros helperConfigServicosTerceiros;

    @Autowired
    public ServiceOpcoesFaturamentoNFSeImpl(DaoOpcoesFaturamentoNFSeImpl dao) {
        super(dao);
    }

    @Override
    public OpcoesFaturamentoNFSe beforeSaveEntity(OpcoesFaturamentoNFSe entity) {
        if (entity.getEnderecosWebServNFSe() != null) {
            entity.getEnderecosWebServNFSe().forEach(i -> i.setOpcoesFaturamentoNFSe(entity));
        }
        if (entity.getOpcoesFaturamentoNFSeOp() != null) {
            entity.getOpcoesFaturamentoNFSeOp().forEach(i -> i.setOpcoesFaturamentoNFSe(entity));
        }
        return entity;
    }

    public OpcoesFaturamentoNFSe getByIdEmpresa(Long idEmpresa) {
        return ((DaoOpcoesFaturamentoNFSeImpl)this.getDao()).getByIdEmpresa(idEmpresa);
    }

    public DTOOpcoesFaturamentoNFSe getByIdEmpresaDTO(Long identificador, Class<DTOOpcoesFaturamentoNFSe> aClass) {
        OpcoesFaturamentoNFSe op = this.getByIdEmpresa(identificador);
        if (op == null) {
            return null;
        }
        return this.buildToDTO(op, aClass);
    }

    public DTOOpcoesDinamicas getOptions(Long idOpcoes) {
        OpcoesFaturamentoNFSe op = (OpcoesFaturamentoNFSe)this.get(idOpcoes);
        EnumOpSectionDinamicasInterface[] sections = new EnumOpSectionDinamicasInterface[]{};
        EnumOpDinamicasInterface[] options = new EnumOpDinamicasInterface[]{};
        return CompOpcoes.getAllOptions(this.helperOpcoesFaturamentoNFSe.build(op).getItens(), (EnumOpSectionDinamicasInterface[])sections, (EnumOpDinamicasInterface[])options);
    }

    public ConfigServicosTerceiros getConfigFocusNFSe(Empresa empresa) throws ExceptionInvalidData {
        List<ConfigServicosTerceiros> configuracoes = this.serviceConfigServTerceiros.getList(EnumConstConfigServicosTerceiros.FOCUS_NFE);
        if (!ServiceOpcoesFaturamentoNFSeImpl.isWithData(configuracoes)) {
            throw new ExceptionInvalidData("E.ERP.0658.003", new Object[0]);
        }
        if (configuracoes.size() == 1) {
            return configuracoes.get(0);
        }
        ConfigServicosTerceiros config = null;
        for (ConfigServicosTerceiros c : configuracoes) {
            Long idEmpresa;
            String idEmpresaStr = this.helperConfigServicosTerceiros.build(c).getValue(EnumConstConfigServicoNFSe.ID_EMPRESA.getChave());
            if (!this.isNotNull(idEmpresaStr).booleanValue() || !this.isStrWithData(idEmpresaStr) || !this.isEquals(idEmpresa = Long.valueOf(idEmpresaStr), empresa.getIdentificador())) continue;
            config = c;
            break;
        }
        if (this.isNull(config).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.0658.003", new Object[0]);
        }
        return config;
    }

    public WebDTOResult validarCertificado(Empresa empresa, OpcoesFaturamentoNFSe opFatNFSe) {
        WebDTOResult result = new WebDTOResult();
        try {
            ConfigServicosTerceiros config = this.getConfigFocusNFSe(empresa);
            if (this.isNotNull(config).booleanValue()) {
                UtilConsultaCertificadoNFSe api = new UtilConsultaCertificadoNFSe();
                NFSeResultDadosEmpresa dadosEmpresa = api.validarCertificado(empresa, config, opFatNFSe);
                if (this.isNull(dadosEmpresa).booleanValue()) {
                    result.setStatus(EnumConstantsMentorStatus.ERRO);
                    result.setMessage("E.ERP.0763.002");
                } else {
                    this.verificarCertificado(dadosEmpresa, result);
                }
            }
        }
        catch (ExceptionBase ex) {
            result.setStatus(EnumConstantsMentorStatus.ERRO);
            result.setMessage(ex.getFormattedMessage());
        }
        return result;
    }

    private void verificarCertificado(NFSeResultDadosEmpresa dadosEmpresa, WebDTOResult result) {
        Date dataValidadeCertificado = ToolDate.toDate((OffsetDateTime)dadosEmpresa.getCertificadoValidoAte());
        if (this.isNotNull(dataValidadeCertificado).booleanValue()) {
            if (dataValidadeCertificado.before(new Date())) {
                result.setMessage(this.getMessage("M.ERP.0763.001", ToolDate.dateToStr((Date)dataValidadeCertificado)));
            } else {
                result.setMessage(this.getMessage("M.ERP.0763.002", ToolDate.dateToStr((Date)dataValidadeCertificado)));
            }
        } else {
            result.setMessage(this.getMessage("M.ERP.0763.003", new Object[0]));
        }
    }
}

