/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.opcoesfaturamentotransp;

import com.touchcomp.basementor.constants.enums.opcoesfaturamentotransp.EnumConstOpFaturamentoTranspOpSections;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.interfaces.EnumOpSectionDinamicasInterface;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesFatTranspAutDownXML;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoTransp;
import com.touchcomp.basementor.model.vo.OpcoesRelacTransporte;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorrules.opcoesdinamicas.model.DTOOpcoesDinamicas;
import com.touchcomp.basementorservice.dao.impl.DaoOpcoesFaturamentoTranspImpl;
import com.touchcomp.basementorservice.helpers.impl.opcoesfaturamentotransp.HelperOpcoesFaturamentoTransp;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceOpcoesFaturamentoTransp;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.others.cpfcnpj.ValidadeCPFCNPJ;
import com.touchcomp.touchvomodel.vo.opcoesfaturamentotransporte.DTOOpcoesFaturamentoTransp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceOpcoesFaturamentoTranspImpl
extends ServiceGenericEntityImpl<OpcoesFaturamentoTransp, Long, DaoOpcoesFaturamentoTranspImpl>
implements ServiceOpcoesFaturamentoTransp {
    @Autowired
    private HelperOpcoesFaturamentoTransp helper;

    @Autowired
    public ServiceOpcoesFaturamentoTranspImpl(DaoOpcoesFaturamentoTranspImpl genericDao) {
        super(genericDao);
    }

    @Override
    public OpcoesFaturamentoTransp beforeSave(OpcoesFaturamentoTransp aux) {
        if (aux.getOpcoesFatDownloadXMLCTe() != null) {
            aux.getOpcoesFatDownloadXMLCTe().forEach(i -> i.setOpcoesFaturamentoTransporte(aux));
        }
        if (aux.getOpcoesFaturamentoTranspOp() != null) {
            aux.getOpcoesFaturamentoTranspOp().forEach(i -> i.setOpcoesFaturamentoTransp(aux));
        }
        if (aux.getOpcoesRelacTransporte() != null) {
            aux.getOpcoesRelacTransporte().setOpcoesFatTransp(aux);
        }
        return aux;
    }

    @Override
    public OpcoesFaturamentoTransp get(Empresa empresa) {
        return this.getByIdEmpresa(empresa.getIdentificador());
    }

    @Override
    public OpcoesFaturamentoTransp getByCnpjEmpresa(String cnpjEmpresa) {
        return ((DaoOpcoesFaturamentoTranspImpl)this.getGenericDao()).getByCnpjEmpresa(cnpjEmpresa);
    }

    public OpcoesFaturamentoTransp getByIdEmpresa(Long idEmpresa) {
        return ((DaoOpcoesFaturamentoTranspImpl)this.getDao()).getByIdEmpresa(idEmpresa);
    }

    public DTOOpcoesFaturamentoTransp.DTOOpcoesFatTranspAutDownXML criarOpcoesFatTranspAutDownXML(String cpfCnpj) throws ExceptionValidacaoDados {
        if (!ValidadeCPFCNPJ.isValid((String)(cpfCnpj = ToolString.refina((String)cpfCnpj)))) {
            throw new ExceptionValidacaoDados("E.ERP.000011", new Object[0]);
        }
        OpcoesFatTranspAutDownXML vo = new OpcoesFatTranspAutDownXML();
        vo.setCnpjCPF(cpfCnpj);
        return this.buildToDTOGeneric(vo, DTOOpcoesFaturamentoTransp.DTOOpcoesFatTranspAutDownXML.class);
    }

    public DTOOpcoesFaturamentoTransp getByIdEmpresaDTO(Long identificador, Class<DTOOpcoesFaturamentoTransp> aClass) {
        OpcoesFaturamentoTransp op = this.getByIdEmpresa(identificador);
        if (this.isNull(op).booleanValue()) {
            return null;
        }
        if (this.isNull(op.getOpcoesRelacTransporte()).booleanValue()) {
            op.setOpcoesRelacTransporte(new OpcoesRelacTransporte());
        }
        return this.buildToDTO(op, aClass);
    }

    public DTOOpcoesDinamicas getOptions(Long idOpcoes) {
        OpcoesFaturamentoTransp op = (OpcoesFaturamentoTransp)this.get(idOpcoes);
        EnumOpDinamicasInterface[] options = new EnumOpDinamicasInterface[]{};
        DTOOpcoesDinamicas din = CompOpcoes.getAllOptions(this.helper.build(op).getItens(), (EnumOpSectionDinamicasInterface[])EnumConstOpFaturamentoTranspOpSections.values(), (EnumOpDinamicasInterface[])options);
        return din;
    }
}

