/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.opcoesfinanceiras;

import com.touchcomp.basementor.constants.enums.opcoesfinanceiras.EnumConstOpFinanceirasOp;
import com.touchcomp.basementor.constants.enums.opcoesfinanceiras.EnumConstOpFinanceirasOpSections;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.interfaces.EnumOpSectionDinamicasInterface;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorrules.opcoesdinamicas.model.DTOOpcoesDinamicas;
import com.touchcomp.basementorservice.dao.impl.DaoOpcoesFinanceirasImpl;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceOpcoesFinanceiras;
import com.touchcomp.touchvomodel.vo.opcoesfinanceiras.web.DTOOpcoesFinanceiras;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceOpcoesFinanceirasImpl
extends ServiceGenericEntityImpl<OpcoesFinanceiras, Long, DaoOpcoesFinanceirasImpl>
implements ServiceOpcoesFinanceiras {
    @Autowired
    private HelperOpcoesFinanceiras helperOpcoesFinanceiras;

    @Override
    public OpcoesFinanceiras beforeSave(OpcoesFinanceiras vo) {
        if (vo.getTaxas() != null) {
            vo.getTaxas().forEach(opt -> opt.setOpcoesFinanceiras(vo));
        }
        if (vo.getOpcoesFinanceirasOp() != null) {
            vo.getOpcoesFinanceirasOp().forEach(opt -> opt.setOpcoesFinanceiras(vo));
        }
        return vo;
    }

    @Autowired
    public ServiceOpcoesFinanceirasImpl(DaoOpcoesFinanceirasImpl genericDao) {
        super(genericDao);
    }

    @Override
    public OpcoesFinanceiras findByEmpresa(Empresa empresa) {
        return this.getByIdEmpresa(empresa.getIdentificador());
    }

    public OpcoesFinanceiras getByIdEmpresa(Long idEmpresa) {
        return ((DaoOpcoesFinanceirasImpl)this.getDao()).getByIdEmpresa(idEmpresa);
    }

    public DTOOpcoesFinanceiras getByIdEmpresaDTO(Long identificador, Class<DTOOpcoesFinanceiras> aClass) {
        OpcoesFinanceiras op = this.getByIdEmpresa(identificador);
        if (op == null) {
            return null;
        }
        return this.buildToDTO(op, aClass);
    }

    public DTOOpcoesDinamicas getOptions(Long idOpcoes) {
        OpcoesFinanceiras op = (OpcoesFinanceiras)this.get(idOpcoes);
        DTOOpcoesDinamicas din = CompOpcoes.getAllOptions(this.helperOpcoesFinanceiras.build(op).getItens(), (EnumOpSectionDinamicasInterface[])EnumConstOpFinanceirasOpSections.values(), (EnumOpDinamicasInterface[])EnumConstOpFinanceirasOp.values());
        return din;
    }

    public Boolean permitirAlterarOpcoesAvancadas(String password) {
        if (this.isNull(password).booleanValue()) {
            return false;
        }
        return password.equalsIgnoreCase("cvbkl");
    }
}

