/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.opcoespatrimonio;

import com.touchcomp.basementor.constants.enums.opcoespatrimonio.EnumConstOpcoesPatrimonioOP;
import com.touchcomp.basementor.constants.enums.opcoespatrimonio.EnumConstOpcoesPatrimonioSections;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.interfaces.EnumOpSectionDinamicasInterface;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesPatrimonio;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorrules.opcoesdinamicas.model.DTOOpcoesDinamicas;
import com.touchcomp.basementorservice.dao.impl.DaoOpcoesPatrimonioImpl;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoespatrimonio.HelperOpcoesPatrimonio;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceOpcoesPatrimonioImpl
extends ServiceGenericEntityImpl<OpcoesPatrimonio, Long, DaoOpcoesPatrimonioImpl> {
    private final HelperOpcoesPatrimonio helperOpcoesPatrimonio;

    @Autowired
    public ServiceOpcoesPatrimonioImpl(DaoOpcoesPatrimonioImpl dao, HelperOpcoesPatrimonio helperOpcoesPatrimonio) {
        super(dao);
        this.helperOpcoesPatrimonio = helperOpcoesPatrimonio;
    }

    @Override
    public OpcoesPatrimonio beforeSave(OpcoesPatrimonio vo) {
        vo.getOpcoesPatrimonioOp().forEach(i -> i.setOpcoesPatrimonio(vo));
        if (vo.getIncidenciaIcmsTotais() != null) {
            vo.getIncidenciaIcmsTotais().forEach(it -> it.setOpcoesPatrimonio(vo));
        }
        if (vo.getIncidenciaIcmsTrib() != null) {
            vo.getIncidenciaIcmsTrib().forEach(it -> it.setOpcoesPatrimonio(vo));
        }
        return vo;
    }

    @Override
    public OpcoesPatrimonio get(Empresa empresa) {
        return this.getByIdEmpresa(empresa.getIdentificador());
    }

    public OpcoesPatrimonio getByIdEmpresa(Long idEmpresa) {
        return ((DaoOpcoesPatrimonioImpl)this.getDao()).getByIdEmpresa(idEmpresa);
    }

    public DTOOpcoesDinamicas getOptions(Long idOpcoes) {
        OpcoesPatrimonio op = (OpcoesPatrimonio)this.get(idOpcoes);
        DTOOpcoesDinamicas din = CompOpcoes.getAllOptions(this.helperOpcoesPatrimonio.build(op).getItens(), (EnumOpSectionDinamicasInterface[])EnumConstOpcoesPatrimonioSections.values(), (EnumOpDinamicasInterface[])EnumConstOpcoesPatrimonioOP.values());
        return din;
    }
}

