/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.opcoespcp;

import com.touchcomp.basementor.constants.enums.opcoespcp.EnumConstOpcoesPCPOP;
import com.touchcomp.basementor.constants.enums.opcoespcp.EnumConstOpcoesPCPSections;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.interfaces.EnumOpSectionDinamicasInterface;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorrules.opcoesdinamicas.model.DTOOpcoesDinamicas;
import com.touchcomp.basementorservice.dao.impl.DaoOpcoesPCPImpl;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoespcp.HelperOpcoesPCP;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import org.springframework.stereotype.Service;

@Service
public class ServiceOpcoesPCPImpl
extends ServiceGenericEntityImpl<OpcoesPCP, Long, DaoOpcoesPCPImpl> {
    private final HelperOpcoesPCP helperOpcoesPCP;

    public ServiceOpcoesPCPImpl(HelperOpcoesPCP helperOpcoesPCP, DaoOpcoesPCPImpl genericDao) {
        super(genericDao);
        this.helperOpcoesPCP = helperOpcoesPCP;
    }

    public OpcoesPCP getByEmpresa(Empresa empresa) {
        return this.getByIdEmpresa(empresa.getIdentificador());
    }

    public OpcoesPCP getByIdEmpresa(Long idEmpresa) {
        return ((DaoOpcoesPCPImpl)this.getDao()).getByIdEmpresa(idEmpresa);
    }

    @Override
    public OpcoesPCP beforeSave(OpcoesPCP aux) {
        aux.getOpcoesPCPOp().forEach(i -> i.setOpcoesPCP(aux));
        return aux;
    }

    public DTOOpcoesDinamicas getOptions(Long idOpcoes) {
        OpcoesPCP op = (OpcoesPCP)this.get(idOpcoes);
        DTOOpcoesDinamicas din = CompOpcoes.getAllOptions(this.helperOpcoesPCP.build(op).getItens(), (EnumOpSectionDinamicasInterface[])EnumConstOpcoesPCPSections.values(), (EnumOpDinamicasInterface[])EnumConstOpcoesPCPOP.values());
        return din;
    }
}

