/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.opcoesqrcode;

import com.touchcomp.basementor.constants.enums.opcoesqrcode.EnumConstTokensModeloQrCode;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.ItemTokenModeloQrCode;
import com.touchcomp.basementor.model.vo.ModeloQrCode;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SearchClass;
import com.touchcomp.basementor.model.vo.TokenQrCode;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementorexceptions.exceptions.impl.parse.ExceptionParseObject;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.service.impl.opcoesqrcode.model.TempDadosQrCode;
import com.touchcomp.basementorservice.service.impl.searchclass.ServiceSearchClassImpl;
import com.touchcomp.basementorservice.service.impl.searchentities.ServiceEntityFinder;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SCompProcessQrCode
extends BaseMethods {
    @Autowired
    private ServiceSearchClassImpl serviceSearchClass;
    @Autowired
    private ServiceEntityFinder serviceEntityFinder;

    public Optional<Map<String, String>> tryMatch(ModeloQrCode model, String input) {
        String patternStr = model.getParametrizacao();
        Pattern placeholderPattern = Pattern.compile("\\{([^}]+)\\}");
        if (!this.isStrWithData(patternStr)) {
            return Optional.empty();
        }
        Matcher m = placeholderPattern.matcher(patternStr);
        StringBuilder regexBuilder = new StringBuilder();
        ArrayList<String> paramNames = new ArrayList<String>();
        int lastEnd = 0;
        while (m.find()) {
            String literal = patternStr.substring(lastEnd, m.start());
            regexBuilder.append(Pattern.quote(literal));
            String paramName = m.group(1).trim();
            paramNames.add(paramName);
            regexBuilder.append("(.+?)");
            lastEnd = m.end();
        }
        String tail = patternStr.substring(lastEnd);
        regexBuilder.append(Pattern.quote(tail));
        String finalRegex = "^" + regexBuilder.toString() + "$";
        Pattern finalPattern = Pattern.compile(finalRegex);
        Matcher inputMatcher = finalPattern.matcher(input);
        if (!inputMatcher.matches()) {
            return Optional.empty();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < paramNames.size(); ++i) {
            String value = inputMatcher.group(i + 1);
            map.put((String)paramNames.get(i), value);
        }
        return Optional.of(map);
    }

    public Object evaluateTokenQrCode(TokenQrCode token, String value) throws ExceptionReflection {
        SearchClass search = this.serviceSearchClass.getByClass(token.getVoClass());
        if (search != null) {
            return this.serviceEntityFinder.evaluateTokenQrCode(search, token, value);
        }
        return null;
    }

    public TempDadosQrCode evaluate(Map<ModeloQrCode, Map<String, String>> data) throws ExceptionReflection, ExceptionParseObject {
        TempDadosQrCode ret = new TempDadosQrCode();
        if (ToolMethods.isNotNull(data).booleanValue() && !data.keySet().isEmpty()) {
            ModeloQrCode modelo = data.keySet().iterator().next();
            Map<String, String> tokensXvalores = data.get(modelo);
            for (String token : tokensXvalores.keySet()) {
                Optional<ItemTokenModeloQrCode> opt = modelo.getItensQrCode().stream().filter(i -> ToolMethods.isNotNull((Object)i.getToken()) != false && ToolMethods.isEquals((Object)i.getToken().getChave(), (Object)token)).findFirst();
                if (!opt.isPresent()) continue;
                TokenQrCode tk = opt.get().getToken();
                EnumConstTokensModeloQrCode key = EnumConstTokensModeloQrCode.get((String)tk.getChave());
                switch (key) {
                    case CNPJ_FORNECEDOR: {
                        Fornecedor fornecedor = (Fornecedor)this.evaluateTokenQrCode(tk, tokensXvalores.get(token));
                        ret.setFornecedor(fornecedor);
                        break;
                    }
                    case CODIGO_PRODUTO: {
                        Produto produto = (Produto)this.evaluateTokenQrCode(tk, tokensXvalores.get(token));
                        ret.setProduto(produto);
                        break;
                    }
                    case CNPJ_TRANSPORTADOR: {
                        Transportador transportador = (Transportador)this.evaluateTokenQrCode(tk, tokensXvalores.get(token));
                        ret.setTransportador(transportador);
                        break;
                    }
                    case CPF_MOTORISTA: {
                        ret.setCpfMotorista(tokensXvalores.get(token));
                        break;
                    }
                    case PESO_BRUTO: {
                        ret.setPesoBruto(ToolNumber.stringToDouble((String)tokensXvalores.get(token)));
                        break;
                    }
                    case PESO_LIQUIDO: {
                        ret.setPesoLiquido(ToolNumber.stringToDouble((String)tokensXvalores.get(token)));
                        break;
                    }
                    case PLACA: {
                        ret.setPlaca(tokensXvalores.get(token));
                    }
                }
            }
        }
        return ret;
    }
}

