/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.opcoesqrcode;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemTokenModeloQrCode;
import com.touchcomp.basementor.model.vo.ModeloQrCode;
import com.touchcomp.basementor.model.vo.OpcoesQrCode;
import com.touchcomp.basementor.model.vo.TokenQrCode;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.parse.ExceptionParseObject;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.dao.impl.DaoOpcoesQrCodeImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.opcoesqrcode.SCompProcessQrCode;
import com.touchcomp.basementorservice.service.impl.opcoesqrcode.model.TempDadosQrCode;
import com.touchcomp.basementorservice.service.impl.tokenqrcode.ServiceTokenQrCodeImpl;
import com.touchcomp.touchvomodel.vo.opcoesqrcode.DTOOpcoesQrCode;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceOpcoesQrCodeImpl
extends ServiceGenericEntityImpl<OpcoesQrCode, Long, DaoOpcoesQrCodeImpl> {
    @Autowired
    private SCompProcessQrCode comp;
    @Autowired
    private ServiceTokenQrCodeImpl serviceToken;

    @Autowired
    public ServiceOpcoesQrCodeImpl(DaoOpcoesQrCodeImpl genericDao) {
        super(genericDao);
    }

    @Override
    public OpcoesQrCode beforeSaveEntity(OpcoesQrCode entity) {
        if (ServiceOpcoesQrCodeImpl.isWithData(entity.getModelos())) {
            for (ModeloQrCode modelo : entity.getModelos()) {
                modelo.setOpcoesQrCode(entity);
                if (!ServiceOpcoesQrCodeImpl.isWithData(modelo.getItensQrCode())) continue;
                modelo.getItensQrCode().forEach(i -> i.setModeloQrCode(modelo));
            }
        }
        return entity;
    }

    public OpcoesQrCode findByEmpresa(Empresa empresa) {
        return this.getByIdEmpresa(empresa.getIdentificador());
    }

    public OpcoesQrCode getByIdEmpresa(Long idEmpresa) {
        return ((DaoOpcoesQrCodeImpl)this.getDao()).getByIdEmpresa(idEmpresa);
    }

    public DTOOpcoesQrCode getByIdEmpresaDTO(Long identificador, Class<DTOOpcoesQrCode> aClass) {
        OpcoesQrCode op = this.getByIdEmpresa(identificador);
        return this.isNull(op) != false ? this.buildToDTO(new OpcoesQrCode(), aClass) : this.buildToDTO(op, aClass);
    }

    public Map<ModeloQrCode, Map<String, String>> parse(Empresa empresa, String conteudo) {
        OpcoesQrCode opcoesQrCode = this.findByEmpresa(empresa);
        if (this.isNotNull(opcoesQrCode).booleanValue()) {
            for (ModeloQrCode modelo : opcoesQrCode.getModelos()) {
                Optional<Map<String, String>> result = this.comp.tryMatch(modelo, conteudo);
                if (!result.isPresent()) continue;
                return Map.of(modelo, result.get());
            }
        }
        return null;
    }

    public TempDadosQrCode parseAndEvaluate(Empresa empresa, String qrCode) throws ExceptionReflection, ExceptionParseObject {
        Map<ModeloQrCode, Map<String, String>> data = this.parse(empresa, qrCode);
        return this.comp.evaluate(data);
    }

    public TempDadosQrCode evaluate(Map<ModeloQrCode, Map<String, String>> data) throws ExceptionReflection, ExceptionParseObject {
        return this.comp.evaluate(data);
    }

    public DTOOpcoesQrCode.DTOItemTokenModeloQrCode novoItemTokenModeloQrCode(Long idToken) throws ExceptionObjNotFound {
        TokenQrCode token = (TokenQrCode)this.serviceToken.getOrThrow(idToken);
        if (this.isNotNull(token).booleanValue()) {
            ItemTokenModeloQrCode vo = new ItemTokenModeloQrCode();
            vo.setToken(token);
            return this.buildToDTOGeneric(vo, DTOOpcoesQrCode.DTOItemTokenModeloQrCode.class);
        }
        return null;
    }
}

