/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.opcoessistema;

import com.touchcomp.basementor.constants.enums.opcoessistema.EnumConstOpSistemaOp;
import com.touchcomp.basementor.constants.enums.opcoessistema.EnumConstOpSistemaOpSections;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.interfaces.EnumOpSectionDinamicasInterface;
import com.touchcomp.basementor.model.vo.OpcoesSistema;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorrules.opcoesdinamicas.model.DTOOpcoesDinamicas;
import com.touchcomp.basementorservice.dao.impl.DaoOpcoesSistemaImpl;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoessistema.HelperOpcoesSistema;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.usuariobasico.ServiceUsuarioBasicoImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.system.ToolSystem;
import org.springframework.stereotype.Service;

@Service
public class ServiceOpcoesSistemaImpl
extends ServiceGenericEntityImpl<OpcoesSistema, Long, DaoOpcoesSistemaImpl> {
    private final ServiceUsuarioBasicoImpl serviceUsuarioBasico;
    private final HelperOpcoesSistema helperOpcoesSistema;

    public ServiceOpcoesSistemaImpl(ServiceUsuarioBasicoImpl serviceUsuarioBasico, HelperOpcoesSistema helperOpcoesSistema, DaoOpcoesSistemaImpl genericDao) {
        super(genericDao);
        this.serviceUsuarioBasico = serviceUsuarioBasico;
        this.helperOpcoesSistema = helperOpcoesSistema;
    }

    @Override
    public OpcoesSistema beforeSave(OpcoesSistema aux) {
        return aux;
    }

    @Override
    public OpcoesSistema saveOrUpdateOnly(OpcoesSistema entity) {
        OpcoesSistema old = (OpcoesSistema)this.getFirst();
        String mac1 = !TMethods.isStrWithData((String)entity.getMacAddressLibTasks()) ? "" : entity.getMacAddressLibTasks();
        String mac2 = old == null || !TMethods.isStrWithData((String)old.getMacAddressLibTasks()) ? "" : old.getMacAddressLibTasks();
        Short permiteRecSenha = (Short)CompOpcoes.getOption(this.helperOpcoesSistema.build(entity).getItens(), (EnumOpDinamicasInterface)EnumConstOpSistemaOp.PERMITIR_RECUPERAR_SENHA, Short.class);
        if (this.isAffimative(permiteRecSenha) && this.serviceUsuarioBasico.existeEmailAtivoMaisUsuario()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0493.002"));
        }
        entity.getOpcoesSistemaOp().forEach(i -> i.setOpcoesSistema(entity));
        if (old != null) {
            ((DaoOpcoesSistemaImpl)this.getDao()).evict(old);
        }
        if (entity.getOpcoesSistemaOp() != null) {
            entity.getOpcoesSistemaOp().forEach(op -> op.setOpcoesSistema(entity));
        }
        return super.saveOrUpdateOnly(entity);
    }

    public DTOOpcoesDinamicas getOptions(Long idOpcoes) {
        OpcoesSistema op = (OpcoesSistema)this.get(idOpcoes);
        return CompOpcoes.getAllOptions(this.helperOpcoesSistema.build(op).getItens(), (EnumOpSectionDinamicasInterface[])EnumConstOpSistemaOpSections.values(), (EnumOpDinamicasInterface[])EnumConstOpSistemaOp.values());
    }

    public OpcoesSistema createIfNoExists() {
        OpcoesSistema op = (OpcoesSistema)super.getFirst();
        boolean upd = false;
        if (op == null) {
            op = this.helperOpcoesSistema.getOpcoesDefault();
            upd = true;
        }
        if (!ToolMethods.isStrWithData((String)op.getEnderecoAppWebBack())) {
            this.helperOpcoesSistema.build(op).setDefaultEnderecoBack();
            upd = true;
        }
        if (!ToolMethods.isStrWithData((String)op.getEnderecoAppWebFront())) {
            this.helperOpcoesSistema.build(op).setEnderecoAppWebFront();
            upd = true;
        }
        if (upd) {
            op = this.saveOrUpdateFlush(op);
        }
        return op;
    }

    public int getNumeroProcessosSimultaneos() {
        OpcoesSistema opcoesSistema = (OpcoesSistema)this.getFirst();
        if (opcoesSistema == null) {
            return ToolSystem.getMaxThreads();
        }
        Integer qtdTarefas = (Integer)CompOpcoes.getOption(this.helperOpcoesSistema.build(opcoesSistema).getItens(), (EnumOpDinamicasInterface)EnumConstOpSistemaOp.QUANTIDADE_TAREFAS_SIMULTANEAS, Integer.class);
        if (ToolMethods.isWithData((Number)qtdTarefas)) {
            return qtdTarefas;
        }
        return ToolSystem.getMaxThreads();
    }
}

