/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.opcoesvendas;

import com.touchcomp.basementor.constants.enums.opcoesvendas.EnumConstOpVendasOp;
import com.touchcomp.basementor.constants.enums.opcoesvendas.EnumConstOpVendasOpSections;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.interfaces.EnumOpSectionDinamicasInterface;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesVendas;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorrules.opcoesdinamicas.model.DTOOpcoesDinamicas;
import com.touchcomp.basementorservice.dao.impl.DaoOpcoesVendasImpl;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesvendas.HelperOpcoesVendas;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.touchvomodel.vo.opcoesvendas.web.DTOOpcoesVendas;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceOpcoesVendasImpl
extends ServiceGenericEntityImpl<OpcoesVendas, Long, DaoOpcoesVendasImpl> {
    @Autowired
    private HelperOpcoesVendas helperOpcoesVendas;

    @Autowired
    public ServiceOpcoesVendasImpl(DaoOpcoesVendasImpl dao) {
        super(dao);
    }

    @Override
    public OpcoesVendas beforeSave(OpcoesVendas vo) {
        if (vo.getOpcoesVendasOp() != null) {
            vo.getOpcoesVendasOp().forEach(opt -> opt.setOpcoesVendas(vo));
        }
        return vo;
    }

    public DTOOpcoesVendas getByIdEmpresaDTO(Long identificador, Class<DTOOpcoesVendas> aClass) {
        OpcoesVendas op = this.getByIdEmpresa(identificador);
        if (op == null) {
            return null;
        }
        return this.buildToDTO(op, aClass);
    }

    public OpcoesVendas findByEmpresa(Empresa empresa) {
        return this.getByIdEmpresa(empresa.getIdentificador());
    }

    public OpcoesVendas getByIdEmpresa(Long idEmpresa) {
        return ((DaoOpcoesVendasImpl)this.getDao()).getByIdEmpresa(idEmpresa);
    }

    public DTOOpcoesDinamicas getOptions(Long idOpcoes) {
        OpcoesVendas op = (OpcoesVendas)this.get(idOpcoes);
        return CompOpcoes.getAllOptions(this.helperOpcoesVendas.build(op).getItens(), (EnumOpSectionDinamicasInterface[])EnumConstOpVendasOpSections.values(), (EnumOpDinamicasInterface[])EnumConstOpVendasOp.values());
    }
}

