/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.ordemcompra;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.GradeItemOrdemCompra;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ItemOrdemCompra;
import com.touchcomp.basementor.model.vo.ItemOrdemCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.ItemOrdemCompraNecCompra;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.components.ordemcompra.CompLiberacaoOrdemCompra;
import com.touchcomp.basementorservice.components.ordemcompra.calculo.CompCalculoImpostosFiscaisOrdemCompra;
import com.touchcomp.basementorservice.helpers.impl.cotacaocompra.HelperCotacaoCompra;
import com.touchcomp.basementorservice.helpers.impl.ordemcompra.HelperOrdemCompra;
import com.touchcomp.basementorservice.service.impl.liberacaoordemcompra.ServiceLiberacaoOrdemCompraImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;

public class AuxGerarOrdemCompraCotacao
extends BaseMethods {
    private final HelperOrdemCompra helperOrdemCompra;
    private final HelperCotacaoCompra helperCotacaoCompra;
    private final CompLiberacaoOrdemCompra compLibOC;
    private final CompCalculoImpostosFiscaisOrdemCompra compCalImpostosOC;
    private final ServiceLiberacaoOrdemCompraImpl serviceLiberacaoOrdemCompra;

    public AuxGerarOrdemCompraCotacao(HelperOrdemCompra helperOrdemCompra, HelperCotacaoCompra helperCotacaoCompra, CompLiberacaoOrdemCompra compLibOC, CompCalculoImpostosFiscaisOrdemCompra compCalImpostosOC, ServiceLiberacaoOrdemCompraImpl serviceLiberacaoOrdemCompra) {
        this.helperOrdemCompra = helperOrdemCompra;
        this.compLibOC = compLibOC;
        this.helperCotacaoCompra = helperCotacaoCompra;
        this.compCalImpostosOC = compCalImpostosOC;
        this.serviceLiberacaoOrdemCompra = serviceLiberacaoOrdemCompra;
    }

    public List<CotacaoCompra> buildOrdemCompraCotacoes(List<CotacaoCompra> cotacoes, OpcoesCompraSuprimentos opcoes, Usuario user, Empresa emp, OpcoesGerenciais opcoesGerenciais, OpcoesContabeis opcoesContabeis) {
        try {
            for (CotacaoCompra cotacaoCompra : cotacoes) {
                if (!this.isNull(cotacaoCompra.getOrdensCompra()).booleanValue() && !cotacaoCompra.getOrdensCompra().isEmpty()) {
                    throw new ExceptionValidacaoDados("E.ERP.0273.002", new Object[]{cotacaoCompra.getIdentificador()});
                }
                this.buildOrdemCompraCotacao(cotacaoCompra, user, emp, opcoes, opcoesGerenciais);
                List ordensCompra = cotacaoCompra.getOrdensCompra();
                this.calcularTotalizadoresOrdensCompra(ordensCompra);
                this.gerarLiberacaoOrdensCompra(ordensCompra, user, opcoesContabeis);
                this.avaliarFechamentoCotacoes(cotacoes, opcoes);
                this.setarSituacaoNecessidadeCompra(cotacoes, opcoes);
            }
            return cotacoes;
        }
        catch (Exception ex) {
            for (CotacaoCompra cot : cotacoes) {
                cot.getOrdensCompra().clear();
            }
            throw new ExceptionRuntimeBase(ex.getMessage(), (Throwable)ex);
        }
    }

    public CotacaoCompra buildOrdemCompraCotacao(CotacaoCompra cotacaoCompra, OpcoesCompraSuprimentos opcoes, Usuario user, Empresa emp, OpcoesGerenciais opcoesGerenciais, OpcoesContabeis opcoesContabeis) {
        try {
            if (!this.isNull(cotacaoCompra.getOrdensCompra()).booleanValue() && !cotacaoCompra.getOrdensCompra().isEmpty()) {
                throw new ExceptionValidacaoDados("E.ERP.0273.002", new Object[]{cotacaoCompra.getIdentificador()});
            }
            this.buildOrdemCompraCotacao(cotacaoCompra, user, emp, opcoes, opcoesGerenciais);
            List ordensCompra = cotacaoCompra.getOrdensCompra();
            this.calcularTotalizadoresOrdensCompra(ordensCompra);
            this.gerarLiberacaoOrdensCompra(ordensCompra, user, opcoesContabeis);
            this.helperCotacaoCompra.build(cotacaoCompra).avaliaFechamentoCotacao(opcoes);
            this.helperCotacaoCompra.build(cotacaoCompra).setarSituacaoNecessidadeCompra(opcoes);
            cotacaoCompra.getOrdensCompra().addAll(ordensCompra);
            return cotacaoCompra;
        }
        catch (Exception ex) {
            cotacaoCompra.getOrdensCompra().clear();
            throw new ExceptionRuntimeBase(ex.getMessage(), (Throwable)ex);
        }
    }

    public void buildOrdemCompraCotacao(CotacaoCompra cotacaoCompra, Usuario user, Empresa emp, OpcoesCompraSuprimentos opcoesCompra, OpcoesGerenciais opcoesGerenciais) throws Exception {
        ArrayList<OrdemCompra> ordensCompra = new ArrayList<OrdemCompra>();
        for (ItemCotacaoCompra item : cotacaoCompra.getItensCotacaoCompra()) {
            if (this.isNull(opcoesGerenciais).booleanValue() || !this.isAffimative(opcoesGerenciais.getObrigarInfCCCotCompraOrdCompra()) || !this.isNull(item.getCentroCustoReq()).booleanValue()) {
                ordensCompra.addAll(this.buidOrdemCompraItemCotacao(item, user, emp, opcoesCompra));
                continue;
            }
            throw new ExceptionValidacaoDados("E.ERP.0273.001", new Object[]{cotacaoCompra.getIdentificador(), item.getIdentificador()});
        }
        cotacaoCompra.getOrdensCompra().addAll(ordensCompra);
    }

    private List<OrdemCompra> buidOrdemCompraItemCotacao(ItemCotacaoCompra item, Usuario user, Empresa emp, OpcoesCompraSuprimentos opcoesCompra) throws Exception {
        ArrayList<OrdemCompra> ordensCompra = new ArrayList<OrdemCompra>();
        for (FornecedorItemCotacaoCompra fornecedor : item.getFornecedoresItemCotacaoCompra()) {
            if (!this.isAffimative(fornecedor.getSelecionado())) continue;
            OrdemCompra ordemCompra = this.getOrdemCompraFornecedor(ordensCompra, fornecedor, user, emp, opcoesCompra);
            this.buildItemOrdemCompra(ordemCompra, fornecedor);
            this.compCalImpostosOC.calcular(ordemCompra);
            this.helperOrdemCompra.build(ordemCompra).setarPrazoMaximoEntItens(opcoesCompra);
            this.helperOrdemCompra.build(ordemCompra).setarNrSequencial(opcoesCompra);
            this.helperOrdemCompra.build(ordemCompra).setarEmails();
            this.helperOrdemCompra.build(ordemCompra).setarObservacao();
        }
        return ordensCompra;
    }

    private OrdemCompra getOrdemCompraFornecedor(List<OrdemCompra> ordensCompra, FornecedorItemCotacaoCompra fornecedor, Usuario user, Empresa emp, OpcoesCompraSuprimentos opcoesCompra) {
        for (OrdemCompra ordemCompra : ordensCompra) {
            if (!this.isEquals(ordemCompra.getUnidadeFatFornecedor(), fornecedor.getUnidadeFaturamentoFornecedor())) continue;
            return ordemCompra;
        }
        OrdemCompra ordemCompra = this.buildOrdemCompraFornecedor(fornecedor, emp, user, opcoesCompra);
        ordensCompra.add(ordemCompra);
        return ordemCompra;
    }

    public OrdemCompra buildOrdemCompraFornecedor(FornecedorItemCotacaoCompra fornecedor, Empresa empresa, Usuario user, OpcoesCompraSuprimentos opcoesCompra) {
        OrdemCompra ordemCompra = new OrdemCompra();
        ordemCompra.setStatusOrdemCompra(opcoesCompra.getStatusOCGerada());
        ordemCompra.setClassificacaoOC(opcoesCompra.getClassificacaoGerarOC());
        ordemCompra.setParcelas(fornecedor.getCondicaoPagamentoMutante());
        ordemCompra.setPrazoEntrega(fornecedor.getPrazoEntrega() + " dia(s)");
        ordemCompra.setDataEmissao(new Date());
        ordemCompra.setDataCadastro(new Date());
        ordemCompra.setDataAtualizacao(ToolDate.toTimestamp((Date)new Date()));
        ordemCompra.setUsuario(user);
        ordemCompra.setEmpresa(empresa);
        ordemCompra.setCotacaoCompra(fornecedor.getItemCotacaoCompra().getCotacaoCompra());
        ordemCompra.setTipoFrete(fornecedor.getTipoFrete());
        ordemCompra.setCondicaoPagamento(fornecedor.getCondicoesPagamento());
        ordemCompra.setMeioPagamento(ordemCompra.getCondicaoPagamento() != null ? ordemCompra.getCondicaoPagamento().getMeioPagamento() : null);
        ordemCompra.setUnidadeFatFornecedor(fornecedor.getUnidadeFaturamentoFornecedor());
        ordemCompra.setItemOrdemCompra(new ArrayList());
        ordemCompra.setObservacoes(new ArrayList());
        return ordemCompra;
    }

    public void buildItemOrdemCompra(OrdemCompra ordemCompra, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra) {
        ItemOrdemCompra itemOrdemCompra = new ItemOrdemCompra();
        itemOrdemCompra.setFechado(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        itemOrdemCompra.setValorUnitario(fornecedorItemCotacaoCompra.getValorUnitario());
        itemOrdemCompra.setValorDesconto(fornecedorItemCotacaoCompra.getValorDesconto());
        itemOrdemCompra.setValorFrete(fornecedorItemCotacaoCompra.getValorFrete());
        itemOrdemCompra.setVrSeguro(fornecedorItemCotacaoCompra.getValorSeguro());
        itemOrdemCompra.setValorDespAcessoria(fornecedorItemCotacaoCompra.getValorDespesasAcessorias());
        itemOrdemCompra.setVrProduto(Double.valueOf(fornecedorItemCotacaoCompra.getValorUnitario() * fornecedorItemCotacaoCompra.getItemCotacaoCompra().getQuantidade()));
        itemOrdemCompra.setVrServico(Double.valueOf(0.0));
        itemOrdemCompra.setValorAgregado(Double.valueOf(0.0));
        itemOrdemCompra.setQuantidadeTotal(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getQuantidade());
        itemOrdemCompra.setFatorConversao(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getFatorConversao());
        itemOrdemCompra.setProduto(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getGradeCor().getProdutoGrade().getProduto());
        itemOrdemCompra.setPlanoContaDeb(fornecedorItemCotacaoCompra.getPlanoConta());
        itemOrdemCompra.setMarca(fornecedorItemCotacaoCompra.getMarca());
        itemOrdemCompra.setPrazoEntrega(fornecedorItemCotacaoCompra.getPrazoEntrega());
        itemOrdemCompra.setOrdemCompra(ordemCompra);
        itemOrdemCompra.setModeloFiscal(fornecedorItemCotacaoCompra.getModeloFiscal());
        itemOrdemCompra.setUnidadeMedida(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getUnidadeMedida());
        itemOrdemCompra.setNaturezaOperacao(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getNaturezaOperacao());
        itemOrdemCompra.setPlanoContaGerencial(fornecedorItemCotacaoCompra.getPlanoContaGerencial());
        itemOrdemCompra.setGradeItemOrdemCompra(this.buildGradeItemOrdemCompra(itemOrdemCompra, fornecedorItemCotacaoCompra));
        itemOrdemCompra.setItemOrdemCompraLF(this.buildItemOrdemCompraLivroFiscal(itemOrdemCompra, fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal()));
        itemOrdemCompra.setAtivo(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getAtivo());
        itemOrdemCompra.setCentroCustoReq(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getCentroCustoReq());
        itemOrdemCompra.setNaturezaRequisicao(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getNaturezaRequisicao());
        itemOrdemCompra.setGerarReqLancarNota(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getGerarReqLancarNota());
        itemOrdemCompra.setObservacoes(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getObservacao());
        if (fornecedorItemCotacaoCompra.getDataPrevFaturamento().before(new Date())) {
            ordemCompra.setDataPrevFaturamento(new Date());
        } else {
            ordemCompra.setDataPrevFaturamento(fornecedorItemCotacaoCompra.getDataPrevFaturamento());
        }
        ordemCompra.setDataPrevChegada(fornecedorItemCotacaoCompra.getPrazoEntrega() != null ? ToolDate.nextDays((Date)ordemCompra.getDataPrevFaturamento(), (int)fornecedorItemCotacaoCompra.getPrazoEntrega().intValue()) : null);
        if (!this.isNull(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getNecessidadesCompra()).booleanValue()) {
            for (NecessidadeCompra n : fornecedorItemCotacaoCompra.getItemCotacaoCompra().getNecessidadesCompra()) {
                Predicate<ItemOrdemCompraNecCompra> p2 = e -> e.getNecessidadeCompra().equals((Object)n);
                if (itemOrdemCompra.getItemOrdemCompraNecCompra().stream().anyMatch(p2)) continue;
                ItemOrdemCompraNecCompra i = new ItemOrdemCompraNecCompra();
                i.setItemOrdemCompra(itemOrdemCompra);
                i.setNecessidadeCompra(n);
                itemOrdemCompra.getItemOrdemCompraNecCompra().add(i);
            }
        }
        itemOrdemCompra.setValorUnitarioMoeda(fornecedorItemCotacaoCompra.getValorUnitarioMoeda());
        itemOrdemCompra.setCotacaoMoeda(fornecedorItemCotacaoCompra.getCotacaoMoeda());
        itemOrdemCompra.setMoeda(fornecedorItemCotacaoCompra.getMoeda());
        ordemCompra.getItemOrdemCompra().add(itemOrdemCompra);
    }

    private List<GradeItemOrdemCompra> buildGradeItemOrdemCompra(ItemOrdemCompra item, FornecedorItemCotacaoCompra fornecedor) {
        ArrayList<GradeItemOrdemCompra> ret = new ArrayList<GradeItemOrdemCompra>();
        GradeItemOrdemCompra gradeItemOrdemCompra = new GradeItemOrdemCompra();
        gradeItemOrdemCompra.setGradeCor(fornecedor.getItemCotacaoCompra().getGradeCor());
        gradeItemOrdemCompra.setItemOrdemCompra(item);
        gradeItemOrdemCompra.setQuantidade(fornecedor.getItemCotacaoCompra().getQuantidade());
        ret.add(gradeItemOrdemCompra);
        return ret;
    }

    private ItemOrdemCompraLivroFiscal buildItemOrdemCompraLivroFiscal(ItemOrdemCompra itemOrdemCompra, FornecedorItemCotacaoCompraLivroFiscal livroFiscal) {
        ItemOrdemCompraLivroFiscal itemOrdemCompraLivroFiscal;
        ItemOrdemCompraLivroFiscal itemOrdemCompraLivroFiscal2 = itemOrdemCompraLivroFiscal = itemOrdemCompra.getItemOrdemCompraLF() != null ? itemOrdemCompra.getItemOrdemCompraLF() : new ItemOrdemCompraLivroFiscal();
        if (livroFiscal != null) {
            itemOrdemCompraLivroFiscal.setAliquotaIcms(livroFiscal.getAliquotaIcms());
            itemOrdemCompraLivroFiscal.setAliquotaFunrural(livroFiscal.getAliquotaFunrural());
            itemOrdemCompraLivroFiscal.setAliquotaContSoc(livroFiscal.getAliquotaContribuicaoSocial());
            itemOrdemCompraLivroFiscal.setAliquotaInss(livroFiscal.getAliquotaInss());
            itemOrdemCompraLivroFiscal.setAliquotaIrrf(livroFiscal.getAliquotaIrrf());
            itemOrdemCompraLivroFiscal.setAliquotaIss(livroFiscal.getAliquotaIss());
            itemOrdemCompraLivroFiscal.setAliquotaLei10833(livroFiscal.getAliquotaLei10833());
            itemOrdemCompraLivroFiscal.setAliquotaOutros(livroFiscal.getAliquotaOutros());
            itemOrdemCompraLivroFiscal.setAliquotaCofins(livroFiscal.getAliquotaCofins());
            itemOrdemCompraLivroFiscal.setAliquotaPis(livroFiscal.getAliquotaPis());
            itemOrdemCompraLivroFiscal.setAliquotaCofinsSt(livroFiscal.getAliquotaCofinsSt());
            itemOrdemCompraLivroFiscal.setAliquotaPisSt(livroFiscal.getAliquotaPisSt());
            itemOrdemCompraLivroFiscal.setAliquotaIpi(livroFiscal.getAliquotaIpi());
            itemOrdemCompraLivroFiscal.setVrContSoc(livroFiscal.getValorContribuicaoSocial());
            itemOrdemCompraLivroFiscal.setCfop(livroFiscal.getCfop());
            itemOrdemCompraLivroFiscal.setIndPeriodoApuracao(Double.valueOf(0.0));
            itemOrdemCompraLivroFiscal.setValorTotal(livroFiscal.getValorTotal());
            itemOrdemCompraLivroFiscal.setVrBcCalculoIcmsSt(livroFiscal.getValorBaseCalculoIcmsSt());
            itemOrdemCompraLivroFiscal.setVrDespAduaneira(livroFiscal.getValorDespesaAduaneira());
            itemOrdemCompraLivroFiscal.setPercReducaoBCIcms(livroFiscal.getPercentualReducaoBaseCalculoIcms());
            itemOrdemCompraLivroFiscal.setVrDifAliquota(livroFiscal.getValorDiferencaAliquota());
            itemOrdemCompraLivroFiscal.setVrFunrural(livroFiscal.getValorFunrural());
            itemOrdemCompraLivroFiscal.setVrIcms(livroFiscal.getValorIcms());
            itemOrdemCompraLivroFiscal.setVrIcmsIsento(livroFiscal.getValorIcmsIsento());
            itemOrdemCompraLivroFiscal.setVrIcmsOutros(livroFiscal.getValorIcmsOutros());
            itemOrdemCompraLivroFiscal.setVrIcmsSemAprov(livroFiscal.getValorIcmsSemAproveitamento());
            itemOrdemCompraLivroFiscal.setVrIcmsTributado(livroFiscal.getValorIcmsTributado());
            itemOrdemCompraLivroFiscal.setValorIcmsSimples(livroFiscal.getValorIcmsSimples());
            itemOrdemCompraLivroFiscal.setAliquotaIcmsSimples(livroFiscal.getAliquotaIcmsSimples());
            itemOrdemCompraLivroFiscal.setVrImpostoImportacao(livroFiscal.getValorImpostoImportacao());
            itemOrdemCompraLivroFiscal.setVrInss(livroFiscal.getValorInss());
            itemOrdemCompraLivroFiscal.setVrIof(livroFiscal.getValorIof());
            itemOrdemCompraLivroFiscal.setVrIpiComercio(livroFiscal.getValorIpiComercio());
            itemOrdemCompraLivroFiscal.setVrIpiIndustria(livroFiscal.getValorIpiIndustria());
            itemOrdemCompraLivroFiscal.setVrIpiIsento(livroFiscal.getValorIpiIsento());
            itemOrdemCompraLivroFiscal.setVrIpiObservacao(livroFiscal.getValorIpiObservacao());
            itemOrdemCompraLivroFiscal.setVrIpiOutros(livroFiscal.getValorIpiOutros());
            itemOrdemCompraLivroFiscal.setVrIrrf(livroFiscal.getValorIrrf());
            itemOrdemCompraLivroFiscal.setVrIss(livroFiscal.getValorIss());
            itemOrdemCompraLivroFiscal.setVrLei10833(livroFiscal.getValorLei10833());
            itemOrdemCompraLivroFiscal.setVrOutros(livroFiscal.getValorOutros());
            itemOrdemCompraLivroFiscal.setVrIcmsSt(livroFiscal.getValorIcmsSt());
            itemOrdemCompraLivroFiscal.setVrIpiTributado(livroFiscal.getValorIpiTributado());
            itemOrdemCompraLivroFiscal.setVrBcCalculoIcmsSt(livroFiscal.getValorBaseCalculoIcmsSt());
            itemOrdemCompraLivroFiscal.setVrBcCalculoIcms(livroFiscal.getValorBaseCalculoIcms());
            itemOrdemCompraLivroFiscal.setAliquotaSestSenat(livroFiscal.getAliquotaSestSenat());
            itemOrdemCompraLivroFiscal.setPercRedSestSenat(livroFiscal.getPercentualReducaoSestSenat());
            itemOrdemCompraLivroFiscal.setPercRedBcInss(livroFiscal.getPercentualReducaoBaseCalculoInss());
            itemOrdemCompraLivroFiscal.setValorSestSenat(livroFiscal.getValorSestSenat());
            itemOrdemCompraLivroFiscal.setVrPis(livroFiscal.getValorPis());
            itemOrdemCompraLivroFiscal.setVrCofins(livroFiscal.getValorCofins());
            itemOrdemCompraLivroFiscal.setVrPisSt(livroFiscal.getValorPisSt());
            itemOrdemCompraLivroFiscal.setVrCofinsSt(livroFiscal.getValorCofinsSt());
            itemOrdemCompraLivroFiscal.setIndiceAlteracaoIcmsST(livroFiscal.getIndicadorAlteracaoIcmsST());
            itemOrdemCompraLivroFiscal.setDescontoPadraoIcmsST(livroFiscal.getDescontoPadraoIcmsST());
            itemOrdemCompraLivroFiscal.setAliquotaIcmsST(livroFiscal.getAliquotaIcmsST());
            itemOrdemCompraLivroFiscal.setModalidadeIcmsSt(livroFiscal.getModalidadeIcmsSt());
            itemOrdemCompraLivroFiscal.setUfIcmsSt(livroFiscal.getUnidadeFederativaIcmsSt());
            itemOrdemCompraLivroFiscal.setCategoriaSt(livroFiscal.getCategoriaSt());
            itemOrdemCompraLivroFiscal.setPercRedContSoc(livroFiscal.getPercentualReducaoContribuicaoSocial());
            itemOrdemCompraLivroFiscal.setPercRedFunrural(livroFiscal.getPercentualReducaoFunrural());
            itemOrdemCompraLivroFiscal.setPercRedIrrf(livroFiscal.getPercentualReducaoIrrf());
            itemOrdemCompraLivroFiscal.setPercRedLei10833(livroFiscal.getPercentualReducaoLei10833());
            itemOrdemCompraLivroFiscal.setPercRedOutros(livroFiscal.getPercentualReducaoOutros());
            itemOrdemCompraLivroFiscal.setCalcularIcmsST(livroFiscal.getCalcularIcmsST());
            itemOrdemCompraLivroFiscal.setVrBCCofins(livroFiscal.getValorBaseCalculoCofins());
            itemOrdemCompraLivroFiscal.setVrBCCofinsSt(livroFiscal.getValorBaseCalculoCofinsSt());
            itemOrdemCompraLivroFiscal.setVrBCPis(livroFiscal.getValorBaseCalculoPis());
            itemOrdemCompraLivroFiscal.setVrBCPisSt(livroFiscal.getValorBaseCalculoPisSt());
        }
        return itemOrdemCompraLivroFiscal;
    }

    public void calcularTotalizadoresOrdensCompra(List<OrdemCompra> ordensCompra) {
        if (TMethods.isWithData(ordensCompra)) {
            for (OrdemCompra ordemCompra : ordensCompra) {
                this.calcularTotalizadoresOrdemCompra(ordemCompra);
            }
        }
    }

    public void calcularTotalizadoresOrdemCompra(OrdemCompra ordemCompra) {
        Double valorProduto = 0.0;
        Double valorServico = 0.0;
        Double valorFrete = 0.0;
        Double valorSeguro = 0.0;
        Double valorDesconto = 0.0;
        Double valorDespAcessoria = 0.0;
        Double BaseCalculoICMS = 0.0;
        Double valorIcms = 0.0;
        Double valorIss = 0.0;
        Double BaseCalculoICMST = 0.0;
        Double valorICMST = 0.0;
        Double valorIpiObservacao = 0.0;
        Double valorLei10833 = 0.0;
        Double valorOutros = 0.0;
        Double valorFunrural = 0.0;
        Double valorIRRF = 0.0;
        Double valorInss = 0.0;
        Double valorTotal = 0.0;
        Double valorIcmsIsento = 0.0;
        Double valorIcmsOutros = 0.0;
        Double valorIpiOutros = 0.0;
        Double valorIpiIsento = 0.0;
        Double valorPis = 0.0;
        Double valorContSocial = 0.0;
        Double valorCofins = 0.0;
        Double valorIcmsSA = 0.0;
        Double valorIpiIndustria = 0.0;
        Double valorIpiTributado = 0.0;
        Double valorSestSenat = 0.0;
        for (ItemOrdemCompra itemOrdemCompra : ordemCompra.getItemOrdemCompra()) {
            valorProduto = valorProduto + itemOrdemCompra.getVrProduto();
            valorServico = valorServico + itemOrdemCompra.getVrServico();
            valorFrete = valorFrete + itemOrdemCompra.getValorFrete();
            valorSeguro = valorSeguro + itemOrdemCompra.getVrSeguro();
            valorDesconto = valorDesconto + itemOrdemCompra.getValorDesconto();
            valorDespAcessoria = valorDespAcessoria + itemOrdemCompra.getValorDespAcessoria();
            BaseCalculoICMS = BaseCalculoICMS + itemOrdemCompra.getItemOrdemCompraLF().getVrIcmsTributado();
            valorIcms = valorIcms + itemOrdemCompra.getItemOrdemCompraLF().getVrIcms();
            valorIcmsSA = valorIcmsSA + itemOrdemCompra.getItemOrdemCompraLF().getVrIcmsSemAprov();
            valorIcmsOutros = valorIcmsOutros + itemOrdemCompra.getItemOrdemCompraLF().getVrIcmsOutros();
            BaseCalculoICMST = BaseCalculoICMST + itemOrdemCompra.getItemOrdemCompraLF().getVrBcCalculoIcmsSt();
            valorICMST = valorICMST + itemOrdemCompra.getItemOrdemCompraLF().getVrIcmsSt();
            valorIpiObservacao = valorIpiObservacao + itemOrdemCompra.getItemOrdemCompraLF().getVrIpiObservacao();
            valorIpiIsento = valorIpiIsento + itemOrdemCompra.getItemOrdemCompraLF().getVrIpiIsento();
            valorIpiIndustria = valorIpiIndustria + itemOrdemCompra.getItemOrdemCompraLF().getVrIpiIndustria();
            valorIpiOutros = valorIpiOutros + itemOrdemCompra.getItemOrdemCompraLF().getVrIpiOutros();
            valorIpiTributado = valorIpiTributado + itemOrdemCompra.getItemOrdemCompraLF().getVrIpiTributado();
            valorIRRF = valorIRRF + itemOrdemCompra.getItemOrdemCompraLF().getVrIrrf();
            valorInss = valorInss + itemOrdemCompra.getItemOrdemCompraLF().getVrInss();
            valorIss = valorIss + itemOrdemCompra.getItemOrdemCompraLF().getVrIss();
            valorTotal = valorTotal + itemOrdemCompra.getItemOrdemCompraLF().getValorTotal();
            valorLei10833 = valorLei10833 + itemOrdemCompra.getItemOrdemCompraLF().getVrLei10833();
            valorFunrural = valorFunrural + itemOrdemCompra.getItemOrdemCompraLF().getVrFunrural();
            valorOutros = valorOutros + itemOrdemCompra.getItemOrdemCompraLF().getVrOutros();
            if (itemOrdemCompra.getItemOrdemCompraLF().getVrCofins() != null) {
                valorCofins = valorCofins + itemOrdemCompra.getItemOrdemCompraLF().getVrCofins();
            }
            if (itemOrdemCompra.getItemOrdemCompraLF().getVrPis() != null) {
                valorPis = valorPis + itemOrdemCompra.getItemOrdemCompraLF().getVrPis();
            }
            if (itemOrdemCompra.getItemOrdemCompraLF().getVrContSoc() != null) {
                valorContSocial = valorContSocial + itemOrdemCompra.getItemOrdemCompraLF().getVrContSoc();
            }
            if (itemOrdemCompra.getItemOrdemCompraLF().getValorSestSenat() == null) continue;
            valorSestSenat = valorSestSenat + itemOrdemCompra.getItemOrdemCompraLF().getValorSestSenat();
        }
        ordemCompra.setValorPis(valorPis);
        ordemCompra.setValorSestSenat(valorSestSenat);
        ordemCompra.setValorCofins(valorCofins);
        ordemCompra.setValorContSoc(valorContSocial);
        ordemCompra.setValorIcmsSa(valorIcmsSA);
        ordemCompra.setValorProduto(valorProduto);
        ordemCompra.setValorServico(valorServico);
        ordemCompra.setValorFrete(valorFrete);
        ordemCompra.setValorSeguro(valorSeguro);
        ordemCompra.setValorDesconto(valorDesconto);
        ordemCompra.setValorDespAcess(valorDespAcessoria);
        ordemCompra.setValorIcms(valorIcms);
        ordemCompra.setValorIss(valorIss);
        ordemCompra.setValorIcmsSt(valorICMST);
        ordemCompra.setValorIpiObservacao(valorIpiObservacao);
        ordemCompra.setValorIrrf(valorIRRF);
        ordemCompra.setValorInss(valorInss);
        ordemCompra.setValorTotal(valorTotal);
        ordemCompra.setValorIpiIndustria(valorIpiIndustria);
        ordemCompra.setValorIpiIsento(valorIpiIsento);
        ordemCompra.setValorIpiOutros(valorIpiOutros);
        ordemCompra.setBcIcmsSt(BaseCalculoICMST);
        ordemCompra.setValorIcmsTributado(BaseCalculoICMS);
        ordemCompra.setValorIcmsIsento(valorIcmsIsento);
        ordemCompra.setValorIcmsOutros(valorIcmsOutros);
        ordemCompra.setValorFunrural(valorFunrural);
        ordemCompra.setValorOutros(valorOutros);
        ordemCompra.setValorLei10833(valorLei10833);
        ordemCompra.setValorIpiTributado(valorIpiTributado);
    }

    public void gerarLiberacaoOrdensCompra(List<OrdemCompra> ordensCompra, Usuario user, OpcoesContabeis opcoesContabeis) throws ExceptionTitulo, ExceptionInvalidData {
        for (OrdemCompra ordemCompra : ordensCompra) {
            this.compLibOC.avaliarOC(ordemCompra, user, opcoesContabeis);
            this.serviceLiberacaoOrdemCompra.saveOrUpdate(ordemCompra.getLiberacaoOrdemCompra());
        }
    }

    public void avaliarFechamentoCotacoes(List<CotacaoCompra> cotacoesCompra, OpcoesCompraSuprimentos opcoesCompraSup) {
        for (CotacaoCompra cotacaoCompra : cotacoesCompra) {
            this.helperCotacaoCompra.build(cotacaoCompra).avaliaFechamentoCotacao(opcoesCompraSup);
        }
    }

    public void setarSituacaoNecessidadeCompra(List<CotacaoCompra> cotacoes, OpcoesCompraSuprimentos opcoes) {
        for (CotacaoCompra c : cotacoes) {
            this.helperCotacaoCompra.build(c).setarSituacaoNecessidadeCompra(opcoes);
        }
    }
}

