/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.ordemcompra;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.EmailsOrdemCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeItemOrdemCompra;
import com.touchcomp.basementor.model.vo.ItemOrdemCompra;
import com.touchcomp.basementor.model.vo.ItemRecepcaoMercadorias;
import com.touchcomp.basementor.model.vo.ObservacaoOrdemCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementor.model.vo.OrdemCompraVencimentos;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import com.touchcomp.basementorservice.components.ordemcompra.CompLiberacaoOrdemCompra;
import com.touchcomp.basementorservice.components.ordemcompra.calculo.CompCalculoImpostosFiscaisOrdemCompra;
import com.touchcomp.basementorservice.dao.impl.DaoOrdemCompraImpl;
import com.touchcomp.basementorservice.helpers.impl.cotacaocompra.HelperCotacaoCompra;
import com.touchcomp.basementorservice.helpers.impl.ordemcompra.HelperOrdemCompra;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.boletotitulo.ServiceBoletoTituloImpl;
import com.touchcomp.basementorservice.service.impl.liberacaoordemcompra.ServiceLiberacaoOrdemCompraImpl;
import com.touchcomp.basementorservice.service.impl.ordemcompra.AuxGerarOrdemCompraCotacao;
import com.touchcomp.basementorservice.service.interfaces.ServiceOrdemCompra;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.touchvomodel.vo.ordemcompra.DTOOrdemCompraTotalItens;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceOrdemCompraImpl
extends ServiceGenericEntityImpl<OrdemCompra, Long, DaoOrdemCompraImpl>
implements ServiceOrdemCompra {
    @Autowired
    private CompLiberacaoOrdemCompra compLiberacaoOrdemCompra;
    @Autowired
    private ServiceBoletoTituloImpl serviceBoletoTitulo;
    @Autowired
    private HelperOrdemCompra helperOrdemCompra;
    @Autowired
    private HelperCotacaoCompra helperCotacaoCompra;
    @Autowired
    private CompCalculoImpostosFiscaisOrdemCompra compCalImpostosOC;
    @Autowired
    private ServiceLiberacaoOrdemCompraImpl serviceLiberacaoOrdemCompra;

    @Autowired
    public ServiceOrdemCompraImpl(DaoOrdemCompraImpl genericDao) {
        super(genericDao);
    }

    @Override
    public OrdemCompra beforeSave(OrdemCompra vo) {
        if (vo != null) {
            if (vo.getTitulos() != null) {
                for (Titulo t : vo.getTitulos()) {
                    t.setOrdemCompra(vo);
                }
            }
            if (vo.getItemOrdemCompra() != null) {
                for (ItemOrdemCompra it : vo.getItemOrdemCompra()) {
                    it.setOrdemCompra(vo);
                    if (it.getGradeItemOrdemCompra() != null) {
                        for (GradeItemOrdemCompra gr : it.getGradeItemOrdemCompra()) {
                            gr.setItemOrdemCompra(it);
                        }
                    }
                    if (it.getItemRecepcaoMercadorias() == null) continue;
                    for (ItemRecepcaoMercadorias ir : it.getItemRecepcaoMercadorias()) {
                        ir.setItemOrdemCompra(it);
                    }
                }
            }
            if (vo.getObservacoes() != null) {
                for (ObservacaoOrdemCompra obs : vo.getObservacoes()) {
                    obs.setOrdemCompra(vo);
                }
            }
            if (vo.getVencimentosOrdemCompra() != null) {
                for (OrdemCompraVencimentos ocv : vo.getVencimentosOrdemCompra()) {
                    ocv.setOrdemCompra(vo);
                }
            }
            if (vo.getEmailsOrdemCompra() != null) {
                for (EmailsOrdemCompra e : vo.getEmailsOrdemCompra()) {
                    e.setOrdemCompra(vo);
                }
            }
        }
        return vo;
    }

    @Override
    public OrdemCompra saveOrUpdateOnly(OrdemCompra oc) {
        try {
            this.compLiberacaoOrdemCompra.avaliarOC(oc);
            return super.saveOrUpdateOnly(oc);
        }
        catch (ExceptionTitulo ex) {
            Logger.getLogger(ServiceOrdemCompraImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        catch (ExceptionInvalidData ex) {
            Logger.getLogger(ServiceOrdemCompraImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    public void cancelaOrdemCompra(OrdemCompra vo) {
        if (vo != null && vo.getTitulos() != null) {
            for (Titulo t : vo.getTitulos()) {
                for (BoletoTitulo b : t.getBoletoTitulo()) {
                    b.setTitulo(null);
                    b.setAtivo(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
                }
                this.serviceBoletoTitulo.saveOrUpdate(t.getBoletoTitulo());
            }
            vo.getTitulos().clear();
            vo.setMotivoCancelamento("Cancelamento efetuado pelo recurso 274");
            ((DaoOrdemCompraImpl)this.getGenericDao()).saveOrUpdate(vo);
        }
    }

    @Override
    public List<OrdemCompra> findOrdensByCotacao(Long cotacao) {
        return ((DaoOrdemCompraImpl)this.getGenericDao()).findOrdensByCotacao(cotacao);
    }

    @Override
    public List<OrdemCompra> findOrdensComprasAbertasPorProdutoSemFornecedor(Long produto, Empresa empresa) {
        return ((DaoOrdemCompraImpl)this.getGenericDao()).findOrdensComprasAbertasPorProdutoSemFornecedor(produto, empresa);
    }

    public List<DTOOrdemCompraTotalItens> carregarOrdemCompraTotalProduto(Long produto, Empresa empresa) {
        ArrayList<DTOOrdemCompraTotalItens> ret = new ArrayList<DTOOrdemCompraTotalItens>();
        List<OrdemCompra> ordemCompras = this.findOrdensComprasAbertasPorProdutoSemFornecedor(produto, empresa);
        if (ordemCompras != null) {
            for (OrdemCompra oc : ordemCompras) {
                DTOOrdemCompraTotalItens dto = new DTOOrdemCompraTotalItens();
                dto = this.buildToDTO(oc, DTOOrdemCompraTotalItens.class);
                HelperOrdemCompra helper = (HelperOrdemCompra)ConfApplicationContext.getBean(HelperOrdemCompra.class);
                dto.setQuantidade(helper.build(oc).calcularQuantidadeProduto(produto));
                ret.add(dto);
            }
        }
        return ret;
    }

    public List<CotacaoCompra> buildOrdemCompraCotacoes(List<CotacaoCompra> cotacoes, OpcoesCompraSuprimentos opcoes, Usuario user, Empresa emp, OpcoesGerenciais opcoesGerenciais, OpcoesContabeis opcoesContabeis) {
        AuxGerarOrdemCompraCotacao aux = new AuxGerarOrdemCompraCotacao(this.helperOrdemCompra, this.helperCotacaoCompra, this.compLiberacaoOrdemCompra, this.compCalImpostosOC, this.serviceLiberacaoOrdemCompra);
        return aux.buildOrdemCompraCotacoes(cotacoes, opcoes, user, emp, opcoesGerenciais, opcoesContabeis);
    }

    public CotacaoCompra buildOrdemCompraCotacao(CotacaoCompra cotacao, OpcoesCompraSuprimentos opcoes, Usuario user, Empresa emp, OpcoesGerenciais opcoesGerenciais, OpcoesContabeis opcoesContabeis) {
        AuxGerarOrdemCompraCotacao aux = new AuxGerarOrdemCompraCotacao(this.helperOrdemCompra, this.helperCotacaoCompra, this.compLiberacaoOrdemCompra, this.compCalImpostosOC, this.serviceLiberacaoOrdemCompra);
        return aux.buildOrdemCompraCotacao(cotacao, opcoes, user, emp, opcoesGerenciais, opcoesContabeis);
    }

    public List<Map<String, Object>> findQuantidadeCompradaItem(Long idGradeCor) {
        return ((DaoOrdemCompraImpl)this.getGenericDao()).findQuantidadeCompradaItem(idGradeCor);
    }
}

