/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.ordemservico;

import com.touchcomp.basementor.constants.enums.ordemservico.EnumConstStatusOrdemServico;
import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivo;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorservice.dao.impl.DaoOrdemServicoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.ordemservico.DTOOrdemServicoRes;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceOrdemServicoImpl
extends ServiceGenericEntityImpl<OrdemServico, Long, DaoOrdemServicoImpl> {
    @Autowired
    public ServiceOrdemServicoImpl(DaoOrdemServicoImpl dao) {
        super(dao);
    }

    public List<OrdemServico> pesquisarOrdemServicoEmpresaAtivoStatusPlanoManAtivo(Empresa empresa, Equipamento ativo, Short abertoFechado, PlanoManutencaoAtivo planoManutencaoAtivo) {
        return ((DaoOrdemServicoImpl)this.getGenericDao()).pesquisarOrdemServicoEmpresaAtivoStatusPlanoManAtivo(empresa, ativo, abertoFechado, planoManutencaoAtivo);
    }

    public OrdemServico findByColeta(Coleta coleta) {
        return ((DaoOrdemServicoImpl)this.getDao()).findByColeta(coleta);
    }

    public OrdemServico getOrThrowSeOSComFechamento(Long identificadorOs) throws ExceptionInvalidState {
        OrdemServico os = (OrdemServico)this.get(identificadorOs);
        if (os != null && os.getFechamentoOrdemServico() != null) {
            throw new ExceptionInvalidState("E.ERP.0742.005", new Object[]{os.getFechamentoOrdemServico().getIdentificador()});
        }
        return os;
    }

    public DTOOrdemServicoRes getOrThrowSeOSParaFechamento(Long codigo) throws ExceptionInvalidState {
        OrdemServico os = ((DaoOrdemServicoImpl)this.getGenericDao()).findByCodigo(codigo);
        if (TMethods.isNull((Object)os).booleanValue()) {
            throw new ExceptionInvalidState("E.ERP.0753.001", new Object[]{codigo});
        }
        if (TMethods.isEquals((Object)os.getStatus(), (Object)EnumConstStatusOrdemServico.FECHADA.getValue())) {
            throw new ExceptionInvalidState("E.ERP.0753.002", new Object[]{codigo});
        }
        if (TMethods.isEquals((Object)os.getStatus(), (Object)EnumConstStatusOrdemServico.CANCELADO.getValue())) {
            throw new ExceptionInvalidState("E.ERP.0753.003", new Object[]{codigo});
        }
        DTOOrdemServicoRes dto = new DTOOrdemServicoRes();
        dto.setIdentificador(os.getIdentificador());
        dto.setDescricaoServico(os.getDescricaoServico());
        return dto;
    }
}

