/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.ordemservicoprodlinhaprod;

import com.touchcomp.basementor.constants.enums.codigobarras.EnumConstCodigoBarras;
import com.touchcomp.basementor.constants.enums.tipoproducao.EnumConstTipoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoOsProducaoLinhaProd;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.PlanejamentoProdLinhaProd;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdLinhaProd;
import com.touchcomp.basementorservice.components.codigobarras.CompCodigoBarras;
import com.touchcomp.basementorservice.dao.impl.DaoSubdivisaoOsProdLinProdImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.touchvomodel.vo.oslinhaprod.DTOSubOsLinhaProdRes;
import com.touchcomp.touchvomodel.vo.ossobencomenda.DTOSubOsSobEncomendaRes;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceSubdivisaoOSProdLinhaProdImpl
extends ServiceGenericEntityImpl<SubdivisaoOSProdLinhaProd, Long, DaoSubdivisaoOsProdLinProdImpl> {
    @Autowired
    CompCodigoBarras compCodigoBarras;

    @Autowired
    public ServiceSubdivisaoOSProdLinhaProdImpl(DaoSubdivisaoOsProdLinProdImpl genericDao) {
        super(genericDao);
    }

    public Double getQuantidadeApontada(EnumConstTipoProducao enumConstTipoProducao, SubdivisaoOSProdLinhaProd subdivisaoOSProd) {
        return ((DaoSubdivisaoOsProdLinProdImpl)this.getDao()).getQuantidadeApontada(enumConstTipoProducao, subdivisaoOSProd);
    }

    public SubdivisaoOSProdLinhaProd getSubDivOsProducao(Long codOs, Short codSubOs, GradeCor gradeCor) {
        return ((DaoSubdivisaoOsProdLinProdImpl)this.getDao()).getSubDivOsProducao(codOs, codSubOs, gradeCor);
    }

    public SubdivisaoOSProdLinhaProd verificarFecharOs(OpcoesPCP opcoesPCP, SubdivisaoOSProdLinhaProd subdivisaoOSProd, Date dataFech) {
        if (!ToolMethods.isEquals((Object)opcoesPCP.getFecharOSQndoApontadoLP(), (Object)1)) {
            return subdivisaoOSProd;
        }
        Double qtdApontada = ((DaoSubdivisaoOsProdLinProdImpl)this.getDao()).getQuantidadeApontada(EnumConstTipoProducao.PRODUCAO, subdivisaoOSProd);
        if (subdivisaoOSProd.getQuantidadePrevista() <= qtdApontada) {
            subdivisaoOSProd.setDataFechamento(dataFech);
            subdivisaoOSProd = ((DaoSubdivisaoOsProdLinProdImpl)this.getDao()).saveOrUpdate(subdivisaoOSProd);
        }
        return subdivisaoOSProd;
    }

    public List<SubdivisaoOSProdLinhaProd> getAltCriadas(Date lastDateSync, Long idGrupoProdutos) {
        return ((DaoSubdivisaoOsProdLinProdImpl)this.getDao()).getAltCriadas(lastDateSync, idGrupoProdutos);
    }

    public List<SubdivisaoOSProdLinhaProd> getSubOS(Date dataInicial, Date dataFinal, Empresa empresa) {
        return ((DaoSubdivisaoOsProdLinProdImpl)this.getDao()).getSubOS(dataInicial, dataFinal, empresa);
    }

    public List<EventoOsProducaoLinhaProd> pesquisarEventosSubOS(SubdivisaoOSProdLinhaProd sub) {
        return ((DaoSubdivisaoOsProdLinProdImpl)this.getGenericDao()).pesquisarEventosSubOS(sub);
    }

    public SubdivisaoOSProdLinhaProd getByGradeCor(GradeCor gradeCor) {
        return ((DaoSubdivisaoOsProdLinProdImpl)this.getGenericDao()).getByGradeCor(gradeCor);
    }

    public SubdivisaoOSProdLinhaProd getByCodigoBarras(String codBarrasLinha) {
        return ((DaoSubdivisaoOsProdLinProdImpl)this.getDao()).getByCodigoBarras(codBarrasLinha);
    }

    public DTOSubOsLinhaProdRes getDadosBasicosOS(String codigo, Empresa empresa) {
        EnumConstCodigoBarras tipo = this.compCodigoBarras.identificaTipoCodBarras(codigo);
        if (this.isEquals(EnumConstCodigoBarras.CODIGO_BARRAS_OS_LINHA_PROD, tipo)) {
            return ((DaoSubdivisaoOsProdLinProdImpl)this.getDao()).getDadosBasicosOSAbertaCodBarras(codigo, empresa);
        }
        String[] parts = TString.splitString((String)codigo, (char[])new char[0]);
        if (parts == null || parts.length != 2) {
            return null;
        }
        String codigoOs = parts[0];
        String codigoSubOs = parts[1];
        return ((DaoSubdivisaoOsProdLinProdImpl)this.getDao()).getDadosBasicosAbertaOS(Long.valueOf(codigoOs), Short.valueOf(codigoSubOs), empresa);
    }

    public WebDTOResult<DTOSubOsSobEncomendaRes> getEquipamentos(Long idSubOS, Long idFaseProdutiva) {
        WebDTOResult w = new WebDTOResult();
        List<Map<String, Object>> res = ((DaoSubdivisaoOsProdLinProdImpl)this.getDao()).getEquipamentos(idSubOS, idFaseProdutiva);
        return w.setResult(res);
    }

    public SubdivisaoOSProdLinhaProd getSubOsProducaoEmpresa(Long codOs, Short codSubOs, Empresa empresa) {
        return ((DaoSubdivisaoOsProdLinProdImpl)this.getDao()).getSubOsProducaoEmpresa(codOs, codSubOs, empresa);
    }

    public List<Map<String, Object>> getFormProdPSubOS(Short filtraProduto, Long prodInicial, Long prodFinal, Short filtraData, Date dataInicial, Date dataFinal, Short filtraEspecie, Long especieInicial, Long especieFinal, Short filtraSubEspecie, Long subEspecieInicial, Long subEspecieFinal, Short filtraFabricante, Long fabricanteInicial, Long fabricanteFinal, Long periodoProducao, PlanejamentoProdLinhaProd pl) {
        return ((DaoSubdivisaoOsProdLinProdImpl)this.getGenericDao()).getFormProdPSubOS(filtraProduto, prodInicial, prodFinal, filtraData, dataInicial, dataFinal, filtraEspecie, especieInicial, especieFinal, filtraSubEspecie, subEspecieInicial, subEspecieFinal, filtraFabricante, fabricanteInicial, fabricanteFinal, periodoProducao, pl);
    }

    public List<Map<String, Object>> getPrevQtdProdFormProdPSubOS(Short filtraProduto, Long prodInicial, Long prodFinal, Short filtraData, Date dataInicial, Date dataFinal, Short filtraEspecie, Long especieInicial, Long especieFinal, Short filtraSubEspecie, Long subEspecieInicial, Long subEspecieFinal, Short filtraFabricante, Long fabricanteInicial, Long fabricanteFinal, Long periodoProducao) {
        return ((DaoSubdivisaoOsProdLinProdImpl)this.getGenericDao()).getPrevQtdProdFormProdPSubOS(filtraProduto, prodInicial, prodFinal, filtraData, dataInicial, dataFinal, filtraEspecie, especieInicial, especieFinal, filtraSubEspecie, subEspecieInicial, subEspecieFinal, filtraFabricante, fabricanteInicial, fabricanteFinal, periodoProducao);
    }

    public SubdivisaoOSProdLinhaProd getSubOSAberta(GradeCor gradeCor) {
        return ((DaoSubdivisaoOsProdLinProdImpl)this.getDao()).getSubOSAberta(gradeCor);
    }
}

