/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.ordemservicoprodsobenc;

import com.touchcomp.basementor.model.vo.OrdemServicoProdSobEnc;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdSobEnc;
import com.touchcomp.basementorservice.dao.impl.DaoOrdemServicoProdSobEncImpl;
import com.touchcomp.basementorservice.helpers.impl.ossobencomenda.HelperOrdemServicoProdSobEnc;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.ServiceComunicadoProducaoImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ServiceOrdemServicoProdSobEncImpl
extends ServiceGenericEntityImpl<OrdemServicoProdSobEnc, Long, DaoOrdemServicoProdSobEncImpl> {
    HelperOrdemServicoProdSobEnc helperOrdemServico;
    ServiceComunicadoProducaoImpl serviceComunicado;

    public ServiceOrdemServicoProdSobEncImpl(DaoOrdemServicoProdSobEncImpl dao, HelperOrdemServicoProdSobEnc helperOrdemServico, ServiceComunicadoProducaoImpl serviceComunicado) {
        super(dao);
        this.serviceComunicado = serviceComunicado;
        this.helperOrdemServico = helperOrdemServico;
    }

    public List<OrdemServicoProdSobEnc> findOSSOBEnc(Date dataInicial, Date dataFinal) {
        return ((DaoOrdemServicoProdSobEncImpl)this.getGenericDao()).findOSSOBEnc(dataInicial, dataFinal);
    }

    public OrdemServicoProdSobEnc avaliarFecharSubOS(SubdivisaoOSProdSobEnc sub, Date dataFechamento) {
        sub.setDataFechamento(dataFechamento);
        OrdemServicoProdSobEnc os = sub.getOrdemServicoProdSobEnc();
        Boolean todasFechadas = true;
        for (SubdivisaoOSProdSobEnc s : os.getSubDivisoesOS()) {
            if (s.getDataFechamento() != null || this.isEquals(sub.getIdentificador(), s.getIdentificador())) continue;
            todasFechadas = false;
            break;
        }
        if (todasFechadas.booleanValue()) {
            os.setDataFechamento(dataFechamento);
            if (TMethods.isAffirmative((Number)this.getSharedData().getOpcoesPCP(sub.getOrdemServicoProdSobEnc().getEmpresa()).getNaoAtDtPorDtSubOSSobEnc())) {
                Date max = this.helperOrdemServico.getMaxDate(os.getSubDivisoesOS());
                Date min = this.helperOrdemServico.getMinDate(os.getSubDivisoesOS());
                os.setDataPrevFechamento(max);
                os.setDataPrevInicio(min);
            }
            os = this.beforeSave(os);
            os = this.saveOrUpdate(os);
        }
        return os;
    }

    @Override
    public OrdemServicoProdSobEnc beforeSaveEntity(OrdemServicoProdSobEnc entity) {
        if (this.isNotNull(entity.getComunicadoProducao()).booleanValue()) {
            entity.setComunicadoProducao(this.serviceComunicado.saveOrUpdate(entity.getComunicadoProducao()));
        }
        return entity;
    }
}

