/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.ordemservicoprodsobenc;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.codigobarras.EnumConstCodigoBarras;
import com.touchcomp.basementor.constants.enums.opcoespcp.EnumConstOpcoesPCPOP;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdSobEnc;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.components.codigobarras.CompCodigoBarras;
import com.touchcomp.basementorservice.dao.impl.DaoSubdivisaoOSProdSobEncImpl;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoespcp.HelperOpcoesPCP;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.touchvomodel.vo.ossobencomenda.DTOSubOsSobEncomendaRes;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.List;
import java.util.Map;
import org.hibernate.LockMode;
import org.springframework.stereotype.Service;

@Service
public class ServiceSubdivisaoOSProdSobEncImpl
extends ServiceGenericEntityImpl<SubdivisaoOSProdSobEnc, Long, DaoSubdivisaoOSProdSobEncImpl> {
    private final CompCodigoBarras compCodigoBarras;
    private final HelperOpcoesPCP helperOpcoesPCP;

    public ServiceSubdivisaoOSProdSobEncImpl(CompCodigoBarras compCodigoBarras, HelperOpcoesPCP helperOpcoesPCP, DaoSubdivisaoOSProdSobEncImpl genericDao) {
        super(genericDao);
        this.compCodigoBarras = compCodigoBarras;
        this.helperOpcoesPCP = helperOpcoesPCP;
    }

    public DTOSubOsSobEncomendaRes getDadosBasicosOS(String codigo, Empresa empresa, OpcoesPCP opcoes) {
        ((DaoSubdivisaoOSProdSobEncImpl)this.getGenericDao()).getSession().lock((Object)empresa, LockMode.NONE);
        ((DaoSubdivisaoOSProdSobEncImpl)this.getGenericDao()).getSession().lock((Object)opcoes, LockMode.NONE);
        EnumConstCodigoBarras tipo = this.compCodigoBarras.identificaTipoCodBarras(codigo);
        EnumConstantsMentorSimNao filtrarEmpresaApontamento = EnumConstantsMentorSimNao.get((Object)CompOpcoes.getOption(this.helperOpcoesPCP.build(opcoes).getItens(), (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.RESPEITAR_EMPRESA_OS_APONTAMENTO, Short.class));
        if (this.isEquals(EnumConstCodigoBarras.CODIGO_BARRAS_OS_SOB_ENC, tipo)) {
            return ((DaoSubdivisaoOSProdSobEncImpl)this.getDao()).getDadosBasicosOSAbertaCodBarras(codigo, empresa, filtrarEmpresaApontamento);
        }
        String[] parts = TString.splitString((String)codigo, (char[])new char[0]);
        if (parts == null || parts.length != 2) {
            return null;
        }
        String codigoOs = parts[0];
        String codigoSubOs = parts[1];
        return ((DaoSubdivisaoOSProdSobEncImpl)this.getDao()).getDadosBasicosAbertaOS(Long.valueOf(codigoOs), Short.valueOf(codigoSubOs), empresa, filtrarEmpresaApontamento);
    }

    public WebDTOResult<DTOSubOsSobEncomendaRes> getEquipamentos(OpcoesPCP opcoesPCP, Long idSubOS, String query) throws ExceptionDecodeHexString {
        Short pesquisaDinamica = EnumConstantsMentorSimNao.NAO.getValue();
        if (this.isStrWithData(query) && this.isNotNull(opcoesPCP).booleanValue()) {
            query = ToolHexString.decodeToStr((String)query);
            this.reload(opcoesPCP);
            pesquisaDinamica = (Short)CompOpcoes.getOption(this.helperOpcoesPCP.build(opcoesPCP).getItens(), (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.PESQUISA_DINAMICA_EQUIPAMENTOS, Short.class);
            if (!this.isAffimative(pesquisaDinamica)) {
                throw new ExceptionErroProgramacao("E.ERP.0693.003");
            }
        }
        WebDTOResult w = new WebDTOResult();
        List<Map<String, Object>> res = ((DaoSubdivisaoOSProdSobEncImpl)this.getDao()).getEquipamentos(pesquisaDinamica, idSubOS, query);
        return w.setResult(res);
    }

    public SubdivisaoOSProdSobEnc getByCodigoBarras(String codBarras) {
        return ((DaoSubdivisaoOSProdSobEncImpl)this.getDao()).getByCodigoBarras(codBarras);
    }
}

