/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.paramcentroestoque;

import com.touchcomp.basementor.constants.enums.paramcentroestoque.EnumConstParamCenEstEntSai;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.ParamCentroEstoque;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.ProdLocCentroEstoque;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.dao.impl.DaoParamCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.centroestoque.ServiceCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.opcoesestoque.ServiceOpcoesEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.prodloccentroestoque.ServiceProdLocCentroEstoqueImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceParamCentroEstoqueImpl
extends ServiceGenericEntityImpl<ParamCentroEstoque, Long, DaoParamCentroEstoqueImpl> {
    @Autowired
    private ServiceCentroEstoqueImpl serviceCentroEstoqueImpl;
    @Autowired
    private ServiceOpcoesEstoqueImpl serviceOpcoesEstoqueImpl;
    @Autowired
    private ServiceProdLocCentroEstoqueImpl serviceProdLocCentroEstoqueImpl;

    public ServiceParamCentroEstoqueImpl(DaoParamCentroEstoqueImpl repository) {
        super(repository);
    }

    @Override
    public ParamCentroEstoque beforeSave(ParamCentroEstoque vo) {
        if (vo.getClientes() != null) {
            vo.getClientes().forEach(it -> it.setParamCentroEstoque(vo));
        }
        if (vo.getEspecies() != null) {
            vo.getEspecies().forEach(it -> it.setParamCentroEstoque(vo));
        }
        if (vo.getFornecedores() != null) {
            vo.getFornecedores().forEach(it -> it.setParamCentroEstoque(vo));
        }
        if (vo.getNatOperacao() != null) {
            vo.getNatOperacao().forEach(it -> it.setParamCentroEstoque(vo));
        }
        if (vo.getSubespecies() != null) {
            vo.getSubespecies().forEach(it -> it.setParamCentroEstoque(vo));
        }
        if (vo.getUsuarios() != null) {
            vo.getUsuarios().forEach(it -> it.setParamCentroEstoque(vo));
        }
        return vo;
    }

    public CentroEstoque getCentroEstoque(OpcoesEstoque opcoesEstoque, Empresa empresa, Produto produto, Usuario usuario, NaturezaOperacao naturezaOperacao, Cliente cliente, Pessoa parceiro) {
        ParamCentroEstoque param;
        CentroEstoque centro = this.getCentroParceiro(parceiro, empresa);
        if (centro != null) {
            return centro;
        }
        if (opcoesEstoque == null) {
            return null;
        }
        EnumConstParamCenEstEntSai tipoParam = EnumConstParamCenEstEntSai.AMBOS;
        if (naturezaOperacao != null && naturezaOperacao.getEntradaSaida() == 1) {
            tipoParam = EnumConstParamCenEstEntSai.SAIDA;
        } else if (naturezaOperacao != null) {
            tipoParam = EnumConstParamCenEstEntSai.ENTRADA;
        }
        if (opcoesEstoque.getCustomSugestCentEst() != null && !opcoesEstoque.getCustomSugestCentEst().trim().isEmpty() && (centro = this.getCentroEstoqueCustom(opcoesEstoque.getCustomSugestCentEst(), tipoParam, opcoesEstoque, empresa, produto, usuario, naturezaOperacao, cliente, null)) != null) {
            return centro;
        }
        centro = this.getCentroLocProduto(empresa, produto, opcoesEstoque);
        if (centro != null) {
            return centro;
        }
        if (opcoesEstoque != null && (ToolMethods.isEquals((Object)opcoesEstoque.getUsarParamCentEstNatOperacao(), (Object)1) || ToolMethods.isEquals((Object)opcoesEstoque.getUsarParamCentEstCliente(), (Object)1) || ToolMethods.isEquals((Object)opcoesEstoque.getUsarParamCentEstUsuario(), (Object)1) || ToolMethods.isEquals((Object)opcoesEstoque.getUsarParamCentEstSubespecie(), (Object)1) || ToolMethods.isEquals((Object)opcoesEstoque.getUsarParamCentEstEspecie(), (Object)1)) && (param = ((DaoParamCentroEstoqueImpl)this.getGenericDao()).getCentroEstoque(opcoesEstoque, empresa, produto, usuario, naturezaOperacao, cliente, tipoParam)) != null) {
            return param.getCentroEstoque();
        }
        return this.serviceCentroEstoqueImpl.findCentroEstoquePadraoEmp(empresa);
    }

    public CentroEstoque getCentroEstoque(OpcoesEstoque opcoesEstoque, Empresa empresa, Produto produto, Usuario usuario, NaturezaOperacao naturezaOperacao, Fornecedor fornecedor, Pessoa parceiro) {
        ParamCentroEstoque param;
        CentroEstoque centro = this.getCentroParceiro(parceiro, empresa);
        if (centro != null) {
            return centro;
        }
        if (opcoesEstoque == null) {
            return null;
        }
        EnumConstParamCenEstEntSai tipoParam = EnumConstParamCenEstEntSai.AMBOS;
        if (naturezaOperacao != null && naturezaOperacao.getEntradaSaida() == 1) {
            tipoParam = EnumConstParamCenEstEntSai.SAIDA;
        } else if (naturezaOperacao != null) {
            tipoParam = EnumConstParamCenEstEntSai.ENTRADA;
        }
        if (opcoesEstoque.getCustomSugestCentEst() != null && !opcoesEstoque.getCustomSugestCentEst().trim().isEmpty() && (centro = this.getCentroEstoqueCustom(opcoesEstoque.getCustomSugestCentEst(), tipoParam, opcoesEstoque, empresa, produto, usuario, naturezaOperacao, null, fornecedor)) != null) {
            return centro;
        }
        centro = this.getCentroLocProduto(empresa, produto, opcoesEstoque);
        if (centro != null) {
            return centro;
        }
        if ((ToolMethods.isEquals((Object)opcoesEstoque.getUsarParamCentEstNatOperacao(), (Object)1) || ToolMethods.isEquals((Object)opcoesEstoque.getUsarParamCentEstFornecedor(), (Object)1) || ToolMethods.isEquals((Object)opcoesEstoque.getUsarParamCentEstUsuario(), (Object)1) || ToolMethods.isEquals((Object)opcoesEstoque.getUsarParamCentEstSubespecie(), (Object)1) || ToolMethods.isEquals((Object)opcoesEstoque.getUsarParamCentEstEspecie(), (Object)1)) && (param = ((DaoParamCentroEstoqueImpl)this.getGenericDao()).getCentroEstoque(opcoesEstoque, empresa, produto, usuario, naturezaOperacao, fornecedor, tipoParam)) != null) {
            return param.getCentroEstoque();
        }
        return this.serviceCentroEstoqueImpl.findCentroEstoquePadraoEmp(empresa);
    }

    public CentroEstoque getCentroEstoque(OpcoesEstoque opcoesEstoque, Empresa empresa, Produto produto, Usuario usuario, EnumConstParamCenEstEntSai tipoParam) {
        ParamCentroEstoque param;
        CentroEstoque centro = null;
        if (opcoesEstoque == null) {
            return null;
        }
        if (opcoesEstoque.getCustomSugestCentEst() != null && !opcoesEstoque.getCustomSugestCentEst().trim().isEmpty() && (centro = this.getCentroEstoqueCustom(opcoesEstoque.getCustomSugestCentEst(), tipoParam, opcoesEstoque, empresa, produto, usuario, null, null, null)) != null) {
            return centro;
        }
        centro = this.getCentroLocProduto(empresa, produto, opcoesEstoque);
        if (centro != null) {
            return centro;
        }
        if ((ToolMethods.isEquals((Object)opcoesEstoque.getUsarParamCentEstUsuario(), (Object)1) || ToolMethods.isEquals((Object)opcoesEstoque.getUsarParamCentEstSubespecie(), (Object)1) || ToolMethods.isEquals((Object)opcoesEstoque.getUsarParamCentEstEspecie(), (Object)1)) && (param = ((DaoParamCentroEstoqueImpl)this.getGenericDao()).getCentroEstoque(opcoesEstoque, empresa, produto, usuario, tipoParam)) != null) {
            return param.getCentroEstoque();
        }
        return this.serviceCentroEstoqueImpl.findCentroEstoquePadraoEmp(empresa);
    }

    public CentroEstoque getCentroEstoque(Empresa empresa, Produto produto, EnumConstParamCenEstEntSai tipoParam) {
        OpcoesEstoque opcoes = this.serviceOpcoesEstoqueImpl.get(empresa);
        return this.getCentroEstoque(opcoes, empresa, produto, null, tipoParam);
    }

    private CentroEstoque getCentroParceiro(Pessoa parceiro, Empresa empresa) {
        if (parceiro == null) {
            return null;
        }
        CentroEstoque centro = this.serviceCentroEstoqueImpl.getPorEmpresaParceiro(empresa, parceiro);
        return centro;
    }

    private CentroEstoque getCentroLocProduto(Empresa empresa, Produto produto, OpcoesEstoque opcoesEstoque) {
        if (opcoesEstoque == null) {
            return null;
        }
        if (ToolMethods.isEquals((Object)opcoesEstoque.getUsarParamCentEstLocProdCenEst(), (Object)0)) {
            return null;
        }
        ProdLocCentroEstoque prodLoc = this.serviceProdLocCentroEstoqueImpl.get(empresa, produto);
        return prodLoc != null ? prodLoc.getCentroEstoque() : null;
    }

    private CentroEstoque getCentroEstoqueCustom(String customizacao, EnumConstParamCenEstEntSai tipoParam, OpcoesEstoque opcoesEstoque, Empresa empresa, Produto produto, Usuario usuario, NaturezaOperacao naturezaOperacao, Cliente cliente, Fornecedor fornecedor) {
        for (int i = 0; i < customizacao.split("/").length; ++i) {
            String iCustomizacao = customizacao.split("/")[i];
            Short filtrarEspecie = 0;
            Long idEspecie = 0L;
            Short filtrarSubEspecie = 0;
            Long idSubEspecie = 0L;
            Short filtrarUsuario = 0;
            Long idUsuario = 0L;
            Short filtrarNatOp = 0;
            Long idNatOperacao = 0L;
            Short filtrarFornecedor = 0;
            Long idFornecedor = 0L;
            Short filtrarCliente = 0;
            Long idCliente = 0L;
            for (int j = 0; j < iCustomizacao.split(";").length; ++j) {
                String filtro = iCustomizacao.split(";")[j];
                if (ToolMethods.isEquals((Object)filtro, (Object)"0")) {
                    filtrarEspecie = 1;
                    if (produto != null) {
                        idEspecie = produto.getEspecie().getIdentificador();
                    }
                }
                if (ToolMethods.isEquals((Object)filtro, (Object)"1")) {
                    filtrarSubEspecie = 1;
                    if (produto != null) {
                        idSubEspecie = produto.getSubEspecie().getIdentificador();
                    }
                }
                if (ToolMethods.isEquals((Object)filtro, (Object)"2")) {
                    filtrarUsuario = 1;
                    idUsuario = usuario != null ? usuario.getIdentificador() : 0L;
                }
                if (ToolMethods.isEquals((Object)filtro, (Object)"3")) {
                    filtrarFornecedor = 1;
                    idFornecedor = fornecedor != null ? fornecedor.getIdentificador() : 0L;
                }
                if (ToolMethods.isEquals((Object)filtro, (Object)"4")) {
                    filtrarCliente = 1;
                    idCliente = cliente != null ? cliente.getIdentificador() : 0L;
                }
                if (!ToolMethods.isEquals((Object)filtro, (Object)"5")) continue;
                filtrarNatOp = 1;
                idNatOperacao = naturezaOperacao != null ? naturezaOperacao.getIdentificador() : 0L;
            }
            ParamCentroEstoque param = ((DaoParamCentroEstoqueImpl)this.getGenericDao()).getCentroEstoqueCustomizado(tipoParam, empresa, filtrarEspecie, idEspecie, filtrarSubEspecie, idSubEspecie, filtrarUsuario, idUsuario, filtrarFornecedor, idFornecedor, filtrarCliente, idCliente, filtrarNatOp, idNatOperacao);
            if (param == null) continue;
            return param.getCentroEstoque();
        }
        return null;
    }
}

