/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.parametrizacaocodigobem;

import com.touchcomp.basementor.model.vo.ParametrizacaoCodigoBem;
import com.touchcomp.basementor.model.vo.ParametrizacaoCodigoBemTipoBem;
import com.touchcomp.basementor.model.vo.TipoBem;
import com.touchcomp.basementorservice.dao.impl.DaoParametrizacaoCodigoBemImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.tipobem.ServiceTipoBemImpl;
import com.touchcomp.touchvomodel.vo.parametrizacaocodigobem.web.DTOParametrizacaoCodigoBem;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceParametrizacaoCodigoBemImpl
extends ServiceGenericEntityImpl<ParametrizacaoCodigoBem, Long, DaoParametrizacaoCodigoBemImpl> {
    @Autowired
    private ServiceTipoBemImpl serviceTipoBem;

    @Autowired
    public ServiceParametrizacaoCodigoBemImpl(DaoParametrizacaoCodigoBemImpl genericDao) {
        super(genericDao);
    }

    @Override
    public ParametrizacaoCodigoBem beforeSaveEntity(ParametrizacaoCodigoBem entity) {
        if (ServiceParametrizacaoCodigoBemImpl.isWithData(entity.getItemParametrizacaoCodigoBem())) {
            entity.getItemParametrizacaoCodigoBem().forEach(i -> i.setParametrizacaoCodigoBem(entity));
        }
        if (ServiceParametrizacaoCodigoBemImpl.isWithData(entity.getTipoBem())) {
            entity.getTipoBem().forEach(i -> i.setParametrizacaoCodigoBem(entity));
        }
        return entity;
    }

    public WebDTOResult<List<DTOParametrizacaoCodigoBem.DTOParametrizacaoCodigoBemTipoBem>> criarParametrizacaoCodigoBemTipoBem(Long[] identificadores) {
        WebDTOResult result = new WebDTOResult();
        ArrayList<DTOParametrizacaoCodigoBem.DTOParametrizacaoCodigoBemTipoBem> ret = new ArrayList<DTOParametrizacaoCodigoBem.DTOParametrizacaoCodigoBemTipoBem>();
        List tipoBem = this.serviceTipoBem.gets(identificadores);
        if (ServiceParametrizacaoCodigoBemImpl.isWithData(tipoBem)) {
            for (TipoBem tb : tipoBem) {
                ParametrizacaoCodigoBemTipoBem param = ((DaoParametrizacaoCodigoBemImpl)this.getGenericDao()).findParametrizacaoByTipoBem(tb);
                if (this.isNotNull(param).booleanValue()) {
                    result.addWarning(this.getMessage("E.ERP.2028.001", String.valueOf(tb), String.valueOf(param.getParametrizacaoCodigoBem())));
                    continue;
                }
                ParametrizacaoCodigoBemTipoBem vo = new ParametrizacaoCodigoBemTipoBem();
                vo.setTipoBem(tb);
                ret.add(this.buildToDTOGeneric(vo, DTOParametrizacaoCodigoBem.DTOParametrizacaoCodigoBemTipoBem.class));
            }
        }
        result.setResult(ret);
        return result;
    }
}

