/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.parametrizacaoctbmodfiscal;

import com.google.common.base.Objects;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.ParamCtbModFiscalCategoriaPessoa;
import com.touchcomp.basementor.model.vo.ParamCtbModFiscalClassPessoa;
import com.touchcomp.basementor.model.vo.ParamCtbModFiscalEmpresa;
import com.touchcomp.basementor.model.vo.ParamCtbModFiscalModeloFiscal;
import com.touchcomp.basementor.model.vo.ParamCtbModFiscalNatOperacao;
import com.touchcomp.basementor.model.vo.ParamCtbModFiscalSubEspecie;
import com.touchcomp.basementor.model.vo.ParamCtbModFiscalUF;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbModFiscal;
import com.touchcomp.basementor.model.vo.SubEspecie;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoParametrizacaoCtbModFiscalImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.categoriapessoa.ServiceCategoriaPessoaImpl;
import com.touchcomp.basementorservice.service.impl.classificacaoclientes.ServiceClassificacaoClientesImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.modelofiscal.ServiceModeloFiscalImpl;
import com.touchcomp.basementorservice.service.impl.naturezaoperacao.ServiceNaturezaOperacaoImpl;
import com.touchcomp.basementorservice.service.impl.opcoescontabeis.ServiceOpcoesContabeisImpl;
import com.touchcomp.basementorservice.service.impl.subespecie.ServiceSubEspecieImpl;
import com.touchcomp.basementorservice.service.impl.unidadefederativa.ServiceUnidadeFederativaImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceParametrizacaoCtbModFiscalImpl
extends ServiceGenericEntityImpl<ParametrizacaoCtbModFiscal, Long, DaoParametrizacaoCtbModFiscalImpl> {
    @Autowired
    ServiceOpcoesContabeisImpl serviceOpcoesContabeis;
    ServiceNaturezaOperacaoImpl serviceNaturezaOperacao;
    ServiceSubEspecieImpl serviceSubEspecie;
    ServiceModeloFiscalImpl serviceModeloFiscal;
    ServiceClassificacaoClientesImpl serviceClassificacaoClientes;
    ServiceEmpresaImpl serviceEmpresa;
    ServiceCategoriaPessoaImpl serviceCategoriaPessoa;
    ServiceUnidadeFederativaImpl serviceUnidadeFederativa;

    @Autowired
    public ServiceParametrizacaoCtbModFiscalImpl(DaoParametrizacaoCtbModFiscalImpl genericDao, ServiceNaturezaOperacaoImpl serviceNaturezaOperacao, ServiceSubEspecieImpl serviceSubEspecie, ServiceModeloFiscalImpl serviceModeloFiscal, ServiceClassificacaoClientesImpl serviceClassificacaoClientes, ServiceEmpresaImpl serviceEmpresa, ServiceCategoriaPessoaImpl serviceCategoriaPessoa, ServiceUnidadeFederativaImpl serviceUnidadeFederativa) {
        super(genericDao);
        this.serviceNaturezaOperacao = serviceNaturezaOperacao;
        this.serviceSubEspecie = serviceSubEspecie;
        this.serviceModeloFiscal = serviceModeloFiscal;
        this.serviceClassificacaoClientes = serviceClassificacaoClientes;
        this.serviceEmpresa = serviceEmpresa;
        this.serviceCategoriaPessoa = serviceCategoriaPessoa;
        this.serviceUnidadeFederativa = serviceUnidadeFederativa;
    }

    @Override
    public ParametrizacaoCtbModFiscal beforeSave(ParametrizacaoCtbModFiscal vo) {
        if (TMethods.isNotNull((Object)vo.getNaturezaOperacao()).booleanValue()) {
            vo.getNaturezaOperacao().forEach(i -> i.setParametrizacaoCtbModFiscal(vo));
        }
        if (TMethods.isNotNull((Object)vo.getSubEspecie()).booleanValue()) {
            vo.getSubEspecie().forEach(i -> i.setParametrizacaoCtbModFiscal(vo));
        }
        if (TMethods.isNotNull((Object)vo.getModelosFiscais()).booleanValue()) {
            vo.getModelosFiscais().forEach(i -> i.setParametrizacaoCtbModFiscal(vo));
        }
        if (TMethods.isNotNull((Object)vo.getClassificacoesPessoa()).booleanValue()) {
            vo.getClassificacoesPessoa().forEach(i -> i.setParametrizacaoCtbModFiscal(vo));
        }
        if (TMethods.isNotNull((Object)vo.getEmpresas()).booleanValue()) {
            vo.getEmpresas().forEach(i -> i.setParametrizacaoCtbModFiscal(vo));
        }
        if (TMethods.isNotNull((Object)vo.getCategoriaPessoa()).booleanValue()) {
            vo.getCategoriaPessoa().forEach(i -> i.setParametrizacaoCtbModFiscal(vo));
        }
        if (TMethods.isNotNull((Object)vo.getUfs()).booleanValue()) {
            vo.getUfs().forEach(i -> i.setParametrizacaoCtbModFiscal(vo));
        }
        return vo;
    }

    public ParametrizacaoCtbModFiscal get(ModeloFiscal modeloFiscal, NaturezaOperacao naturezaOperacao, SubEspecie subEspecie, Empresa empresa, CategoriaPessoa categoriaPessoa, UnidadeFederativa uf, ClassificacaoClientes classificacao) {
        OpcoesContabeis opcoesContabeis = this.serviceOpcoesContabeis.findByEmpresa(empresa);
        return this.get(modeloFiscal, naturezaOperacao, subEspecie, empresa, categoriaPessoa, opcoesContabeis, uf, classificacao);
    }

    public ParametrizacaoCtbModFiscal get(ModeloFiscal modeloFiscal, NaturezaOperacao naturezaOperacao, SubEspecie subEspecie, Empresa empresa, CategoriaPessoa categoriaPessoa, OpcoesContabeis opcoesContabeis, UnidadeFederativa uf, ClassificacaoClientes classificacao) {
        Long idModeloFiscal = modeloFiscal != null ? modeloFiscal.getIdentificador() : 0L;
        Long idNatOperacao = naturezaOperacao != null ? naturezaOperacao.getIdentificador() : 0L;
        Long idSubEspecie = subEspecie != null ? subEspecie.getIdentificador() : 0L;
        Long idEmpresa = empresa != null ? empresa.getIdentificador() : 0L;
        Long idGrupoEmpresa = empresa != null ? empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador() : 0L;
        Long idCategoria = categoriaPessoa != null ? categoriaPessoa.getIdentificador() : 0L;
        Long idUF = uf != null ? uf.getIdentificador() : 0L;
        Long idClassificacao = classificacao != null ? classificacao.getIdentificador() : 0L;
        return this.getByIds(opcoesContabeis, idModeloFiscal, idNatOperacao, idSubEspecie, idEmpresa, idGrupoEmpresa, idCategoria, idUF, idClassificacao);
    }

    public ParametrizacaoCtbModFiscal getByIds(OpcoesContabeis opcoesContabeis, Long idModeloFiscal, Long idNatOperacao, Long idSubEspecie, Long idEmpresa, Long idGrupoEmpresa, Long idCategoria, Long idUF, Long idClassificacao) {
        if (opcoesContabeis != null && Objects.equal((Object)opcoesContabeis.getParamCtbNotaFiltrarEmp(), (Object)1) && Objects.equal((Object)opcoesContabeis.getParamCtbNotaFiltrarCategoria(), (Object)1)) {
            ParametrizacaoCtbModFiscal param = ((DaoParametrizacaoCtbModFiscalImpl)this.getGenericDao()).getByEmpModCatUFClass(idEmpresa, idModeloFiscal, idCategoria, idUF, idClassificacao);
            if (param != null) {
                return param;
            }
            return ((DaoParametrizacaoCtbModFiscalImpl)this.getGenericDao()).getByEmpSubNatCatUFClass(idEmpresa, idSubEspecie, idNatOperacao, idCategoria, idUF, idClassificacao);
        }
        if (opcoesContabeis != null && Objects.equal((Object)opcoesContabeis.getParamCtbNotaFiltrarCategoria(), (Object)1)) {
            ParametrizacaoCtbModFiscal param = ((DaoParametrizacaoCtbModFiscalImpl)this.getGenericDao()).getByGrupoModCatUFClass(idGrupoEmpresa, idModeloFiscal, idCategoria, idUF, idClassificacao);
            if (param != null) {
                return param;
            }
            return ((DaoParametrizacaoCtbModFiscalImpl)this.getGenericDao()).getGrupoNatSubCatUFClass(idGrupoEmpresa, idNatOperacao, idSubEspecie, idCategoria, idUF, idClassificacao);
        }
        if (opcoesContabeis != null && Objects.equal((Object)opcoesContabeis.getParamCtbNotaFiltrarEmp(), (Object)1)) {
            ParametrizacaoCtbModFiscal param = ((DaoParametrizacaoCtbModFiscalImpl)this.getGenericDao()).getByEmpModUF(idEmpresa, idModeloFiscal, idUF);
            if (param != null) {
                return param;
            }
            return ((DaoParametrizacaoCtbModFiscalImpl)this.getGenericDao()).getByEmpSubNatUF(idEmpresa, idSubEspecie, idNatOperacao, idUF);
        }
        ParametrizacaoCtbModFiscal param = ((DaoParametrizacaoCtbModFiscalImpl)this.getGenericDao()).getByGrupoModUF(idGrupoEmpresa, idModeloFiscal, idUF);
        if (param != null) {
            return param;
        }
        if (idNatOperacao == null || idSubEspecie == null || idUF == null) {
            return null;
        }
        return ((DaoParametrizacaoCtbModFiscalImpl)this.getGenericDao()).getByGrupoNatSubUF(idGrupoEmpresa, idNatOperacao, idSubEspecie, idUF);
    }

    public ParamCtbModFiscalNatOperacao newItemNaturezaOperacao(Long id) {
        NaturezaOperacao e = (NaturezaOperacao)this.serviceNaturezaOperacao.get(id);
        if (this.isNull(e).booleanValue()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0102.001", new Object[]{id}));
        }
        ParamCtbModFiscalNatOperacao i = new ParamCtbModFiscalNatOperacao();
        i.setNaturezaOperacao(e);
        return i;
    }

    public ParamCtbModFiscalSubEspecie newItemSubEspecie(Long id) {
        SubEspecie e = (SubEspecie)this.serviceSubEspecie.get(id);
        if (this.isNull(e).booleanValue()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0058.003", new Object[]{id}));
        }
        ParamCtbModFiscalSubEspecie i = new ParamCtbModFiscalSubEspecie();
        i.setSubEspecie(e);
        return i;
    }

    public ParamCtbModFiscalModeloFiscal newItemModeloFiscal(Long id) {
        ModeloFiscal e = (ModeloFiscal)this.serviceModeloFiscal.get(id);
        if (this.isNull(e).booleanValue()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0103.002", new Object[]{id}));
        }
        ParamCtbModFiscalModeloFiscal i = new ParamCtbModFiscalModeloFiscal();
        i.setModeloFiscal(e);
        return i;
    }

    public ParamCtbModFiscalClassPessoa newItemClassificacaoCliente(Long id) {
        ClassificacaoClientes e = (ClassificacaoClientes)this.serviceClassificacaoClientes.get(id);
        if (this.isNull(e).booleanValue()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0079.001", new Object[]{id}));
        }
        ParamCtbModFiscalClassPessoa i = new ParamCtbModFiscalClassPessoa();
        i.setClassificacaoPessoa(e);
        return i;
    }

    public ParamCtbModFiscalEmpresa newItemEmpresa(Long id) {
        Empresa e = (Empresa)this.serviceEmpresa.get(id);
        if (this.isNull(e).booleanValue()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0049.001", new Object[]{id}));
        }
        ParamCtbModFiscalEmpresa i = new ParamCtbModFiscalEmpresa();
        i.setEmpresa(e);
        return i;
    }

    public ParamCtbModFiscalCategoriaPessoa newItemCategoriaPessoa(Long id) {
        CategoriaPessoa e = (CategoriaPessoa)this.serviceCategoriaPessoa.get(id);
        if (this.isNull(e).booleanValue()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0045.001", new Object[]{id}));
        }
        ParamCtbModFiscalCategoriaPessoa i = new ParamCtbModFiscalCategoriaPessoa();
        i.setCategoriaPessoa(e);
        return i;
    }

    public ParamCtbModFiscalUF newItemUF(Long id) {
        UnidadeFederativa e = (UnidadeFederativa)this.serviceUnidadeFederativa.get(id);
        if (this.isNull(e).booleanValue()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0150.001", new Object[]{id}));
        }
        ParamCtbModFiscalUF i = new ParamCtbModFiscalUF();
        i.setUnidadeFederativa(e);
        return i;
    }
}

