/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.parametrizacaoctbrps;

import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloRPS;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.ParametrizacaoCtbRPS;
import com.touchcomp.basementorservice.dao.impl.DaoParametrizacaoCtbRPSImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceParametrizacaoCtbRPSImpl
extends ServiceGenericEntityImpl<ParametrizacaoCtbRPS, Long, DaoParametrizacaoCtbRPSImpl> {
    @Autowired
    public ServiceParametrizacaoCtbRPSImpl(DaoParametrizacaoCtbRPSImpl genericDao) {
        super(genericDao);
    }

    @Override
    public ParametrizacaoCtbRPS beforeSave(ParametrizacaoCtbRPS vo) {
        vo.getCategoriaPessoa().forEach(c -> c.setParametrizacaoCtbRPS(vo));
        vo.getClassificacoesPessoa().forEach(c -> c.setParametrizacaoCtbRPS(vo));
        vo.getEmpresas().forEach(c -> c.setParametrizacaoCtbRPS(vo));
        vo.getModelos().forEach(c -> c.setParametrizacaoCtbRPS(vo));
        return vo;
    }

    public ParametrizacaoCtbRPS get(ModeloRPS modeloRps, Empresa empresa, CategoriaPessoa categoriaPessoa, OpcoesContabeis opcoesContabeis, ClassificacaoClientes classificacaoClientes) {
        Long idModeloFiscal = modeloRps != null ? modeloRps.getIdentificador() : 0L;
        Long idEmpresa = empresa != null ? empresa.getIdentificador() : 0L;
        Long idGrupoEmpresa = empresa != null ? empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador() : 0L;
        Long idCategoria = categoriaPessoa != null ? categoriaPessoa.getIdentificador() : 0L;
        Long idClassificacao = classificacaoClientes != null ? classificacaoClientes.getIdentificador() : 0L;
        return this.getByIds(opcoesContabeis, idModeloFiscal, idEmpresa, idGrupoEmpresa, idCategoria, idClassificacao);
    }

    public ParametrizacaoCtbRPS getByIds(OpcoesContabeis opcoesContabeis, Long idModeloRps, Long idEmpresa, Long idGrupoEmpresa, Long idCategoria, Long idClassificacao) {
        ParametrizacaoCtbRPS param;
        if (opcoesContabeis != null && ToolMethods.isEquals((Object)opcoesContabeis.getParamCtbNotaFiltrarEmp(), (Object)1) && ToolMethods.isEquals((Object)opcoesContabeis.getParamCtbNotaFiltrarCategoria(), (Object)1) && (param = ((DaoParametrizacaoCtbRPSImpl)this.getGenericDao()).getByEmpModCatClass(idEmpresa, idModeloRps, idCategoria, idClassificacao)) != null) {
            return param;
        }
        if (opcoesContabeis != null && ToolMethods.isEquals((Object)opcoesContabeis.getParamCtbNotaFiltrarCategoria(), (Object)1) && (param = ((DaoParametrizacaoCtbRPSImpl)this.getGenericDao()).getByGrupoModCatClass(idGrupoEmpresa, idModeloRps, idCategoria, idClassificacao)) != null) {
            return param;
        }
        if (opcoesContabeis != null && ToolMethods.isEquals((Object)opcoesContabeis.getParamCtbNotaFiltrarEmp(), (Object)1)) {
            param = ((DaoParametrizacaoCtbRPSImpl)this.getGenericDao()).getByEmpMod(idEmpresa, idModeloRps);
            if (param != null) {
                return param;
            }
            param = ((DaoParametrizacaoCtbRPSImpl)this.getGenericDao()).getByGrupoEmpMod(idGrupoEmpresa, idModeloRps);
            if (param != null) {
                return param;
            }
        }
        return ((DaoParametrizacaoCtbRPSImpl)this.getGenericDao()).getByGrupoEmp(idGrupoEmpresa);
    }
}

