/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.paramlancgerencial;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ParamLancGerencial;
import com.touchcomp.basementor.model.vo.ParamLancGerencialEmpresa;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.PlanoGerCentroCusto;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidDataRuntime;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoParamLancGerencialImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.touchvomodel.vo.paramlancgerencial.web.DTOParamLancGerencial;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class ServiceParamLancGerencialImpl
extends ServiceGenericEntityImpl<ParamLancGerencial, Long, DaoParamLancGerencialImpl> {
    @Autowired
    private ServiceEmpresaImpl serviceEmpresa;

    @Autowired
    public ServiceParamLancGerencialImpl(DaoParamLancGerencialImpl dao) {
        super(dao);
    }

    @Override
    public ParamLancGerencial beforeSave(ParamLancGerencial p) {
        if (p.getPlanoGerCentroCusto() != null) {
            p.getPlanoGerCentroCusto().forEach(i -> i.setParamLancGerencial(p));
        }
        if (p.getEmpresas() != null) {
            p.getEmpresas().forEach(i -> i.setParamLancGerencial(p));
        }
        return p;
    }

    public PlanoGerCentroCusto newItemPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        PlanoGerCentroCusto i = new PlanoGerCentroCusto();
        i.setPlanoContaGerencial(planoContaGerencial);
        return i;
    }

    @Cacheable(cacheNames={"ParamLancGerencial_1"}, keyGenerator="customKeyGenerator")
    public ParamLancGerencial get(PlanoContaGerencial planoContaGerencial, Empresa empresa) {
        List<ParamLancGerencial> params = ((DaoParamLancGerencialImpl)this.getDao()).get(planoContaGerencial, empresa);
        if (!ServiceParamLancGerencialImpl.isWithData(params)) {
            params = ((DaoParamLancGerencialImpl)this.getDao()).getParamLancGerencialByEmpresa(planoContaGerencial, empresa);
        }
        if (!ServiceParamLancGerencialImpl.isWithData(params)) {
            return null;
        }
        if (params.size() > 1) {
            StringBuilder sb = new StringBuilder();
            params.forEach(i -> sb.append(String.valueOf(i.getIdentificador())).append(";"));
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.ERP.1937.001", new String[]{String.valueOf(empresa), String.valueOf(planoContaGerencial), sb.toString()}));
        }
        return params.getFirst();
    }

    public List<DTOParamLancGerencial.DTOPlanoGerEmpresa> getEmpresasParamLancGerencial(Long[] identificadores) throws ExceptionObjNotFound {
        ArrayList<DTOParamLancGerencial.DTOPlanoGerEmpresa> result = new ArrayList<DTOParamLancGerencial.DTOPlanoGerEmpresa>();
        List empresas = this.serviceEmpresa.gets(identificadores);
        if (ServiceParamLancGerencialImpl.isWithData(empresas)) {
            for (Empresa emp : empresas) {
                ParamLancGerencialEmpresa vo = new ParamLancGerencialEmpresa();
                vo.setEmpresa(emp);
                result.add(this.buildToDTOGeneric(vo, DTOParamLancGerencial.DTOPlanoGerEmpresa.class));
            }
        }
        return result;
    }
}

