/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.paramtribcbsibs;

import com.touchcomp.basementor.constants.enums.modelodocfiscal.EnumConstModDocFiscal;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.basementor.model.vo.CategoriaCbsIbs;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.ClassificacaoTributariaCbsIbs;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalCbsIbs;
import com.touchcomp.basementor.model.vo.Nbs;
import com.touchcomp.basementor.model.vo.Ncm;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbs;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsCat;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsCfop;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsClass;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsClassNbs;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsClassNcm;
import com.touchcomp.basementor.model.vo.ParamTribCbsIbsEmp;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TipoContribuinteCbsIbs;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFatTomPrestRPS;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoParamTribCbsIbsImpl;
import com.touchcomp.basementorservice.helpers.impl.cfop.HelperCfop;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.categoriacbsibs.ServiceCategoriaCbsIbsImpl;
import com.touchcomp.basementorservice.service.impl.classificacaotributariacbsibs.ServiceClassificacaoTributariaCbsIbsImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.modelofiscalcbsibs.ServiceModeloFiscalCbsIbsImpl;
import com.touchcomp.basementorservice.service.impl.ncm.ServiceNcmImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.res.DTOEntidadeCodigoRes;
import com.touchcomp.touchvomodel.vo.ncm.web.DTONcm;
import com.touchcomp.touchvomodel.vo.paramtribcbsibs.web.DTOParamTribCbsIbs;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ServiceParamTribCbsIbsImpl
extends ServiceGenericEntityImpl<ParamTribCbsIbs, Long, DaoParamTribCbsIbsImpl> {
    final ServiceEmpresaImpl serviceEmpresaImpl;
    final ServiceClassificacaoTributariaCbsIbsImpl serviceClassificacaoTributariaCbsIbsImpl;
    final ServiceNcmImpl serviceNcm;
    final ServiceModeloFiscalCbsIbsImpl serviceModeloFiscalCbsIbs;
    final ServiceCategoriaCbsIbsImpl serviceCategoriaCbsIbsImpl;
    final HelperCfop helperCfop;

    public ServiceParamTribCbsIbsImpl(ServiceEmpresaImpl serviceEmpresaImpl, ServiceClassificacaoTributariaCbsIbsImpl serviceClassificacaoTributariaCbsIbsImpl, ServiceNcmImpl serviceNcm, ServiceModeloFiscalCbsIbsImpl serviceModeloFiscalCbsIbs, DaoParamTribCbsIbsImpl genericDao, ServiceCategoriaCbsIbsImpl serviceCategoriaCbsIbsImpl, HelperCfop helperCfop) {
        super(genericDao);
        this.serviceEmpresaImpl = serviceEmpresaImpl;
        this.serviceClassificacaoTributariaCbsIbsImpl = serviceClassificacaoTributariaCbsIbsImpl;
        this.serviceNcm = serviceNcm;
        this.serviceModeloFiscalCbsIbs = serviceModeloFiscalCbsIbs;
        this.serviceCategoriaCbsIbsImpl = serviceCategoriaCbsIbsImpl;
        this.helperCfop = helperCfop;
    }

    public List<DTONcm.DTORegraExcecaoCbsIbs> getRegrasExcecoesCbsIbsByNcm(Long idNcm) throws ExceptionObjNotFound {
        Ncm ncm = (Ncm)this.serviceNcm.getOrThrow(idNcm);
        return this.buildToDTOGeneric(ncm.getRegrasExcecoesCbsIbs(), DTONcm.DTORegraExcecaoCbsIbs.class);
    }

    public DTOEntidadeCodigoRes getIncidenciaModelo(Long idModelo) throws ExceptionObjNotFound {
        ModeloFiscalCbsIbs modelo = (ModeloFiscalCbsIbs)this.serviceModeloFiscalCbsIbs.getOrThrow(idModelo);
        if (this.isNotNull(modelo).booleanValue() && this.isNotNull(modelo.getIncidenciaTributaria()).booleanValue()) {
            return this.buildToDTOGeneric(modelo.getIncidenciaTributaria(), DTOEntidadeCodigoRes.class);
        }
        return null;
    }

    public List<DTOParamTribCbsIbs.DTOParamTribCbsIbsClass> getClassificacoes(List<Long> idClassificacoes) {
        List classes = this.serviceClassificacaoTributariaCbsIbsImpl.gets(idClassificacoes);
        LinkedList<DTOParamTribCbsIbs.DTOParamTribCbsIbsClass> ret = new LinkedList<DTOParamTribCbsIbs.DTOParamTribCbsIbsClass>();
        for (ClassificacaoTributariaCbsIbs classe : classes) {
            DTOParamTribCbsIbs.DTOParamTribCbsIbsClass d = new DTOParamTribCbsIbs.DTOParamTribCbsIbsClass();
            d.setClassificacaoTrib(classe.toString());
            d.setClassificacaoTribIdentificador(classe.getIdentificador());
            ret.add(d);
        }
        return ret;
    }

    public List<DTOParamTribCbsIbs.DTOParamTribCbsIbsEmp> getEmpresas(List<Long> idEmpresas) {
        List empresas = this.serviceEmpresaImpl.gets(idEmpresas);
        LinkedList<DTOParamTribCbsIbs.DTOParamTribCbsIbsEmp> ret = new LinkedList<DTOParamTribCbsIbs.DTOParamTribCbsIbsEmp>();
        for (Empresa empresa : empresas) {
            DTOParamTribCbsIbs.DTOParamTribCbsIbsEmp d = new DTOParamTribCbsIbs.DTOParamTribCbsIbsEmp();
            d.setDataInicioVigencia(new Date());
            d.setEmpresa(empresa.toString());
            d.setEmpresaIdentificador(empresa.getIdentificador());
            ret.add(d);
        }
        return ret;
    }

    public List<DTOParamTribCbsIbs.DTOParamTribCbsIbsCat> getCategorias(List<Long> idCategproas) {
        List categorias = this.serviceCategoriaCbsIbsImpl.gets(idCategproas);
        LinkedList<DTOParamTribCbsIbs.DTOParamTribCbsIbsCat> ret = new LinkedList<DTOParamTribCbsIbs.DTOParamTribCbsIbsCat>();
        for (CategoriaCbsIbs cat : categorias) {
            DTOParamTribCbsIbs.DTOParamTribCbsIbsCat d = new DTOParamTribCbsIbs.DTOParamTribCbsIbsCat();
            d.setDataInicioVigencia(new Date());
            d.setCategoriaCbsIbs(cat.toString());
            d.setCategoriaCbsIbsIdentificador(cat.getIdentificador());
            ret.add(d);
        }
        return ret;
    }

    @Override
    public ParamTribCbsIbs beforeSave(ParamTribCbsIbs aux) {
        for (ParamTribCbsIbsClass classif : aux.getClassificacoes()) {
            classif.setParamTribCbsIbs(aux);
            for (ParamTribCbsIbsClassNbs nb : classif.getNbs()) {
                nb.setNbs(ToolString.onlyNumbers((String)nb.getNbs()));
                nb.setParamTribCbsIbsClass(classif);
            }
            for (ParamTribCbsIbsClassNcm ncm : classif.getNcms()) {
                ncm.setNcm(ToolString.onlyNumbers((String)ncm.getNcm()));
                ncm.setParamTribCbsIbsClass(classif);
            }
        }
        for (ParamTribCbsIbsEmp empresa : aux.getEmpresas()) {
            empresa.setParamTribCbsIbs(aux);
        }
        for (ParamTribCbsIbsCfop cfop : aux.getCfops()) {
            cfop.setCfop(ToolString.onlyNumbers((String)cfop.getCfop()));
            cfop.setParamTribCbsIbs(aux);
        }
        for (ParamTribCbsIbsCat cat : aux.getCategorias()) {
            cat.setParamTribCbsIbs(aux);
        }
        return aux;
    }

    public ParamTribCbsIbsClass getParametrizacaoNFe(Date dataMovimentacao, Empresa empresa, UnidadeFatCliente unidadeFatCliente, Produto produto, EnumConstModDocFiscal modeloDocFiscal, Cfop cfop) throws ExceptionInvalidData {
        List<ParamTribCbsIbsClass> modelos = this.getParametrizacoes(dataMovimentacao, empresa, unidadeFatCliente, produto, modeloDocFiscal, cfop, 1);
        return modelos.isEmpty() ? null : modelos.get(0);
    }

    public List<ParamTribCbsIbsClass> getParametrizacoes(Date dataEmissao, Empresa empresa, UnidadeFatCliente unidadeFatCliente, Produto produto, EnumConstModDocFiscal modeloDocFiscal, Cfop cfop) throws ExceptionInvalidData {
        return this.getParametrizacoes(dataEmissao, empresa, unidadeFatCliente, produto, modeloDocFiscal, cfop, -1);
    }

    private List<ParamTribCbsIbsClass> getParametrizacoes(Date dataEmissao, Empresa empresa, UnidadeFatCliente unidadeFatCliente, Produto produto, EnumConstModDocFiscal modeloDocFiscal, Cfop cfop, Integer qtdReg) throws ExceptionInvalidData {
        List<ParamTribCbsIbsClass> found;
        if (!ToolMethods.isAffirmative((Number)this.getSharedData().getOpcoesFaturamento(empresa).getInformarDadosReformaTributaria())) {
            return new LinkedList<ParamTribCbsIbsClass>();
        }
        if (dataEmissao == null) {
            dataEmissao = new Date();
        }
        if (ToolMethods.isWithData(found = ((DaoParamTribCbsIbsImpl)this.getDao()).getParametrizacaoGeral())) {
            return found;
        }
        TipoContribuinteCbsIbs tipo = unidadeFatCliente.getTipoContribuinteCbsIbs();
        CategoriaCbsIbs categoria = unidadeFatCliente.getCategoriaCbsIbs();
        if (tipo == null) {
            tipo = unidadeFatCliente.getCliente().getFaturamento().getTipoContribuinteCbsIbs();
        }
        if (categoria == null) {
            categoria = unidadeFatCliente.getCliente().getFaturamento().getCategoriaCbsIbs();
        }
        if (ToolMethods.isAnyNull((Object[])new Object[]{dataEmissao, empresa, produto.getNcm(), modeloDocFiscal, cfop, categoria, tipo})) {
            return new LinkedList<ParamTribCbsIbsClass>();
        }
        found = ((DaoParamTribCbsIbsImpl)this.getDao()).getParametrizacao(dataEmissao, empresa, produto.getNcm(), produto.getRegraExcecaoCbsIbs(), modeloDocFiscal, cfop, categoria, tipo, qtdReg);
        if (!ToolMethods.isWithData(found)) {
            throw new ExceptionInvalidData("E.ERP.2037.001", new Object[]{dataEmissao, empresa, modeloDocFiscal.getCodigo(), cfop, categoria, tipo, produto.getNcm(), produto.getRegraExcecaoCbsIbs()});
        }
        return found;
    }

    public ParamTribCbsIbsClass getParametrizacaoRpsNFSe(Date dataEmissao, Empresa empresa, UnidadeFatTomPrestRPS unidadeFatToma, Nbs nbs) throws ExceptionBase {
        List<ParamTribCbsIbsClass> modelos = this.getParametrizacoesRpsNFSe(dataEmissao, empresa, unidadeFatToma, nbs, 1);
        return modelos.isEmpty() ? null : modelos.get(0);
    }

    public List<ParamTribCbsIbsClass> getParametrizacoesRpsNFSe(Date dataEmissao, Empresa empresa, UnidadeFatTomPrestRPS unidadeFatToma, Nbs nbs) throws ExceptionBase {
        return this.getParametrizacoesRpsNFSe(dataEmissao, empresa, unidadeFatToma, nbs, -1);
    }

    private List<ParamTribCbsIbsClass> getParametrizacoesRpsNFSe(Date dataEmissao, Empresa empresa, UnidadeFatTomPrestRPS unidadeFatToma, Nbs nbs, int qtdReg) throws ExceptionBase {
        List<ParamTribCbsIbsClass> found;
        if (!ToolMethods.isAffirmative((Number)this.getSharedData().getOpcoesFaturamentoNFSe(empresa).getInformarDadosReformaTributaria())) {
            return new LinkedList<ParamTribCbsIbsClass>();
        }
        if (dataEmissao == null) {
            dataEmissao = new Date();
        }
        if (ToolMethods.isWithData(found = ((DaoParamTribCbsIbsImpl)this.getDao()).getParametrizacaoGeral())) {
            return found;
        }
        EnumConstModDocFiscal modeloDocFiscal = EnumConstModDocFiscal.NFSE;
        TipoContribuinteCbsIbs tipo = unidadeFatToma.getTomadorPrestadorRPS().getTipoContribuinteCbsIbs();
        CategoriaCbsIbs categoria = unidadeFatToma.getTomadorPrestadorRPS().getCategoriaCbsIbs();
        if (ToolMethods.isAnyNull((Object[])new Object[]{empresa, modeloDocFiscal, categoria, tipo, nbs})) {
            return new LinkedList<ParamTribCbsIbsClass>();
        }
        found = ((DaoParamTribCbsIbsImpl)this.getDao()).getParametrizacao(dataEmissao, empresa, nbs, modeloDocFiscal, categoria, tipo, qtdReg);
        if (!ToolMethods.isWithData(found)) {
            throw new ExceptionInvalidData("E.ERP.2037.002", new Object[]{dataEmissao, empresa, modeloDocFiscal.getCodigo(), categoria, tipo, nbs});
        }
        return found;
    }

    public ParamTribCbsIbsClass getParametrizacaoCTe(Date dataEmissao, Empresa empresa, UnidadeFatCliente unidadeFatCliente, Cfop cfop) throws ExceptionBase {
        List<ParamTribCbsIbsClass> modelos = this.getParametrizacoesCTe(dataEmissao, empresa, unidadeFatCliente, cfop, 1);
        return modelos.isEmpty() ? null : modelos.get(0);
    }

    public List<ParamTribCbsIbsClass> getParametrizacoesCTe(Date dataEmissao, Empresa empresa, UnidadeFatCliente unidadeFatCliente, Cfop cfop) throws ExceptionBase {
        return this.getParametrizacoesCTe(dataEmissao, empresa, unidadeFatCliente, cfop, -1);
    }

    private List<ParamTribCbsIbsClass> getParametrizacoesCTe(Date dataEmissao, Empresa empresa, UnidadeFatCliente unidadeFatCliente, Cfop cfop, int qtdReg) throws ExceptionBase {
        List<ParamTribCbsIbsClass> found;
        if (!ToolMethods.isAffirmative((Number)this.getSharedData().getOpcoesFaturamentoTransporte(empresa).getInformarDadosReformaTributaria())) {
            return new LinkedList<ParamTribCbsIbsClass>();
        }
        if (dataEmissao == null) {
            dataEmissao = new Date();
        }
        if (ToolMethods.isWithData(found = ((DaoParamTribCbsIbsImpl)this.getDao()).getParametrizacaoGeral())) {
            return found;
        }
        EnumConstModDocFiscal modeloDocFiscal = EnumConstModDocFiscal.CTE;
        TipoContribuinteCbsIbs tipo = unidadeFatCliente.getTipoContribuinteCbsIbs();
        CategoriaCbsIbs categoria = unidadeFatCliente.getCategoriaCbsIbs();
        if (tipo == null) {
            tipo = unidadeFatCliente.getCliente().getFaturamento().getTipoContribuinteCbsIbs();
        }
        if (categoria == null) {
            categoria = unidadeFatCliente.getCliente().getFaturamento().getCategoriaCbsIbs();
        }
        if (ToolMethods.isAnyNull((Object[])new Object[]{dataEmissao, empresa, modeloDocFiscal, cfop, categoria, tipo})) {
            return new LinkedList<ParamTribCbsIbsClass>();
        }
        found = ((DaoParamTribCbsIbsImpl)this.getDao()).getParametrizacao(dataEmissao, empresa, modeloDocFiscal, cfop, categoria, tipo, qtdReg);
        if (!ToolMethods.isWithData(found)) {
            throw new ExceptionInvalidData("E.ERP.2037.003", new Object[]{dataEmissao, empresa, modeloDocFiscal.getCodigo(), cfop, categoria, tipo});
        }
        return found;
    }

    public List<ParamTribCbsIbsClass> getParametrizacoesNFe(Date dataMovimentacao, Empresa logedEmpresa, UnidadeFatCliente unidadeFatCliente, Produto produto, EnumConstModDocFiscal mod, ModeloFiscal modeloFiscal, EnumConstNFeIndicadorPresConsumidor indicadorPresenca) throws ExceptionInvalidData {
        return this.getParametrizacoesNFe(dataMovimentacao, logedEmpresa, unidadeFatCliente, produto, mod, modeloFiscal, indicadorPresenca, -1);
    }

    public ParamTribCbsIbsClass getParametrizacaoNFe(Date dataMovimentacao, Empresa logedEmpresa, UnidadeFatCliente unidadeFatCliente, Produto produto, EnumConstModDocFiscal mod, ModeloFiscal modeloFiscal, EnumConstNFeIndicadorPresConsumidor indicadorPresenca) throws ExceptionInvalidData {
        List<ParamTribCbsIbsClass> found = this.getParametrizacoesNFe(dataMovimentacao, logedEmpresa, unidadeFatCliente, produto, mod, modeloFiscal, indicadorPresenca, -1);
        return found.isEmpty() ? null : found.get(0);
    }

    public List<ParamTribCbsIbsClass> getParametrizacoesNFe(Date dataMovimentacao, Empresa logedEmpresa, UnidadeFatCliente unidadeFatCliente, Produto produto, EnumConstModDocFiscal mod, ModeloFiscal modeloFiscal, EnumConstNFeIndicadorPresConsumidor indicadorPresenca, int qtdReg) throws ExceptionInvalidData {
        if (ToolMethods.isAnyNull((Object[])new Object[]{logedEmpresa, unidadeFatCliente, modeloFiscal})) {
            return new LinkedList<ParamTribCbsIbsClass>();
        }
        if (indicadorPresenca == null) {
            indicadorPresenca = EnumConstNFeIndicadorPresConsumidor.OPERACAO_NAO_PRESENCIAL_OUTROS;
        }
        UnidadeFederativa ufOrigem = logedEmpresa.getPessoa().getEndereco().getCidade().getUf();
        UnidadeFederativa ufDestino = unidadeFatCliente.getPessoa().getEndereco().getCidade().getUf();
        Cfop cfop = this.helperCfop.geCfopSaida(ufOrigem, ufDestino, modeloFiscal, indicadorPresenca);
        return this.getParametrizacoes(dataMovimentacao, logedEmpresa, unidadeFatCliente, produto, mod, cfop, qtdReg);
    }

    @Override
    public boolean deleteOnly(ParamTribCbsIbs entity) {
        throw new ExceptionRuntimeBase("E.GEN.000029");
    }

    @Override
    public boolean delete(ParamTribCbsIbs entity) {
        throw new ExceptionRuntimeBase("E.GEN.000029");
    }

    public void deleteById(Long ... ids) {
        throw new ExceptionRuntimeBase("E.GEN.000029");
    }
}

