/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.pedido;

import com.touchcomp.basementor.constants.enums.pedido.EnumConstGeracaoTitulosPreVendaPedido;
import com.touchcomp.basementor.constants.enums.pedido.EnumValidacaoPedido;
import com.touchcomp.basementor.model.interfaces.InterfaceStaticObjects;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.InfPagamentoPedido;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import com.touchcomp.basementorservice.components.titulos.CompGeracaoTitulos;
import com.touchcomp.basementorservice.components.validacaoliberacaopedido.CompValidacaoLiberacaoPedido;
import com.touchcomp.basementorservice.helpers.impl.modelofiscal.HelperModeloFiscal;
import com.touchcomp.basementorservice.helpers.impl.pedido.HelperPedido;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.titulo.ServiceTituloImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;

public class AuxBeforeSave {
    final HelperPedido helperPedido;
    final CompValidacaoLiberacaoPedido compValidacaoLiberacaoPedido;
    final ServiceTituloImpl serviceTitulo;
    final InterfaceStaticObjects sharedData;
    final HelperModeloFiscal helperModeloFiscal;
    final ServiceGradeCorImpl serviceGradeCorImpl;
    final CompGeracaoTitulos compGeracaoTitulos;

    public AuxBeforeSave(HelperPedido helperPedido, CompValidacaoLiberacaoPedido compValidacaoLiberacaoPedido, ServiceTituloImpl serviceTitulo, InterfaceStaticObjects sharedData, HelperModeloFiscal helperModeloFiscal, ServiceGradeCorImpl serviceGradeCorImpl, CompGeracaoTitulos compGeracaoTitulos) {
        this.helperPedido = helperPedido;
        this.compValidacaoLiberacaoPedido = compValidacaoLiberacaoPedido;
        this.serviceTitulo = serviceTitulo;
        this.sharedData = sharedData;
        this.helperModeloFiscal = helperModeloFiscal;
        this.serviceGradeCorImpl = serviceGradeCorImpl;
        this.compGeracaoTitulos = compGeracaoTitulos;
    }

    Pedido beforeSave(Pedido aux) {
        this.helperPedido.setDataPrevisaoSaida(aux, this.sharedData.getOpcoesFaturamento(aux.getEmpresa()));
        this.setCamposValoresPadraoSeVazios(aux);
        this.setDadosFiscais(aux);
        this.criarTitulos(aux);
        this.setMappedBy(aux);
        this.helperPedido.build(aux);
        this.helperPedido.setarNrSequencialItens();
        aux.setNrTotalItens(Integer.valueOf(aux.getItemPedido().size()));
        return aux;
    }

    Pedido beforeSaveEntity(Pedido aux) {
        return this.beforeSaveEntity(aux, true);
    }

    Pedido beforeSaveEntity(Pedido aux, Boolean recalcularValores) {
        try {
            this.helperPedido.setDataPrevisaoSaida(aux, this.sharedData.getOpcoesFaturamento(aux.getEmpresa()));
            this.verificarTitulosECancelamento(aux);
            this.helperPedido.build(aux);
            this.helperPedido.setarEstoqueReserva(this.sharedData.getOpcoesFaturamento(aux.getEmpresa()));
            if (TMethods.isNull((Object)recalcularValores).booleanValue() || recalcularValores.booleanValue()) {
                this.helperPedido.calcularValoresPedido(this.sharedData.getOpcoesFaturamento(aux.getEmpresa()), this.sharedData.getOpcoesContabeis(aux.getEmpresa()));
            }
            EnumValidacaoPedido enumValidacaoPedido = EnumValidacaoPedido.PEDIDO;
            if (TMethods.isStrWithData((String)aux.getSerialForSync()) || aux.getNfceControleCaixa() != null) {
                enumValidacaoPedido = EnumValidacaoPedido.PRE_VENDA;
            }
            this.compValidacaoLiberacaoPedido.validarPedido(this.sharedData.getOpcoesFaturamento(aux.getEmpresa()), this.sharedData.getOpcoesFinanceiras(aux.getEmpresa()), aux, null, enumValidacaoPedido, this.sharedData.getOpcoesFaturamento(aux.getEmpresa()).getConfValidacaoPedidos());
            return aux;
        }
        catch (ExceptionBase e) {
            throw new ExceptionRuntimeBase(e.getFormattedMessage());
        }
    }

    private void verificarTitulosECancelamento(Pedido pedido) {
        block4: {
            block3: {
                if (!TMethods.isAffirmative((Number)pedido.getSituacaoPedido().getCancelarTitulos()) && (pedido.getGeracaoTituloPedido() != null || pedido.getExpedicao() == null || pedido.getExpedicao().isEmpty() || ((Expedicao)pedido.getExpedicao().get(0)).getNotaFiscalPropria() == null)) break block3;
                pedido.getInfPagamentoPedido().clear();
                pedido.getInfPagamentoPedido().addAll(new ArrayList());
                for (ItemPedido it : pedido.getItemPedido()) {
                    for (GradeItemPedido g : it.getGradeItemPedido()) {
                        g.setMovimentacaoFisica(Short.valueOf((short)0));
                    }
                }
                break block4;
            }
            if ((pedido.getSituacaoPedido() == null || !ToolMethods.isAffirmative((Number)pedido.getSituacaoPedido().getNaoGerarTitulosPedido())) && !ToolMethods.isEquals((Object)pedido.getSituacaoPedido().getGerarFinanceiroNFCe(), (Object)EnumConstGeracaoTitulosPreVendaPedido.NAO_GERAR_TITULOS.getValue()) || pedido.getIdentificador() == null || pedido.getInfPagamentoPedido() == null) break block4;
            for (InfPagamentoPedido inf : pedido.getInfPagamentoPedido()) {
                if (inf.getTitulos() == null) continue;
                inf.getTitulos().clear();
            }
        }
    }

    private void criarTitulos(Pedido pedido) {
        if (TMethods.isAffirmative((Number)pedido.getSituacaoPedido().getCancelarTitulos()) || ToolMethods.isAffirmative((Number)pedido.getSituacaoPedido().getNaoGerarTitulosPedido()) || ToolMethods.isEquals((Object)pedido.getSituacaoPedido().getGerarFinanceiroNFCe(), (Object)EnumConstGeracaoTitulosPreVendaPedido.NAO_GERAR_TITULOS.getValue())) {
            return;
        }
        if (!TMethods.isWithData((Collection)pedido.getInfPagamentoPedido())) {
            pedido.getInfPagamentoPedido().add(this.compGeracaoTitulos.criarInfPagPadrao(pedido, this.sharedData.getOpcoesFinanceiras(pedido.getEmpresa()), this.sharedData.getOpcoesContabeis(pedido.getEmpresa())));
        }
        CondicoesPagamento condicoes = null;
        for (InfPagamentoPedido infPagamentoPedido : pedido.getInfPagamentoPedido()) {
            if (infPagamentoPedido.getBandeiraCartaoNFe() == null && infPagamentoPedido.getCondicoesPagamento() != null && infPagamentoPedido.getCondicoesPagamento().getMeioPagamento() != null) {
                infPagamentoPedido.setBandeiraCartaoNFe(infPagamentoPedido.getCondicoesPagamento().getMeioPagamento().getBandeiraCartaoNFe());
            }
            if (infPagamentoPedido.getMeioPagamento() == null && infPagamentoPedido.getCondicoesPagamento() != null) {
                infPagamentoPedido.setMeioPagamento(infPagamentoPedido.getCondicoesPagamento().getMeioPagamento());
            }
            if (!TMethods.isWithData((Collection)infPagamentoPedido.getTitulos())) {
                try {
                    this.compGeracaoTitulos.gerarTitulos(infPagamentoPedido, pedido, this.sharedData.getOpcoesFinanceiras(pedido.getEmpresa()), this.sharedData.getOpcoesContabeis(pedido.getEmpresa()));
                }
                catch (ExceptionInvalidData | ExceptionTitulo throwable) {
                    // empty catch block
                }
            }
            condicoes = infPagamentoPedido.getCondicoesPagamento();
        }
        if (pedido.getCondicoesPagamento() == null && condicoes != null) {
            pedido.setCondicoesPagamento(condicoes);
            pedido.setMeioPagamento(condicoes.getMeioPagamento());
        }
        if (TMethods.isNull((Object)pedido.getMeioPagamento()).booleanValue() && pedido.getCondicoesPagamento() != null) {
            pedido.setMeioPagamento(pedido.getCondicoesPagamento().getMeioPagamento());
        }
    }

    private void setMappedBy(Pedido aux) {
        if (aux.getItemPedido() != null) {
            for (ItemPedido it : aux.getItemPedido()) {
                it.setPedido(aux);
                if (it.getGradeItemPedido() != null) {
                    for (GradeItemPedido gr : it.getGradeItemPedido()) {
                        gr.setItemPedido(it);
                    }
                    it.getGradeItemPedido().removeIf(i -> !ToolMethods.isWithData((Number)i.getQuantidade()));
                }
                if (it.getItemPedidoFiscal() == null) continue;
                it.getItemPedidoFiscal().setItemPedido(it);
            }
        }
        if (aux.getLiberacaoMTC() != null) {
            aux.getLiberacaoMTC().setPedido(aux);
        }
        if (aux.getLiberacaoPedidoPed() != null) {
            aux.getLiberacaoPedidoPed().setPedido(aux);
        }
        if (aux.getInfPagamentoPedido() != null) {
            for (InfPagamentoPedido inf : aux.getInfPagamentoPedido()) {
                inf.setPedido(aux);
                if (inf.getTitulos() == null) continue;
                for (Titulo t : inf.getTitulos()) {
                    t.setInfPagamentoPedido(inf);
                    this.serviceTitulo.beforeSave(t);
                }
            }
        }
        if (aux.getObservacoes() != null) {
            aux.getObservacoes().forEach(i -> i.setPedido(aux));
        }
    }

    private void setCamposValoresPadraoSeVazios(Pedido aux) {
        if (aux.getDataCadastro() == null) {
            aux.setDataCadastro(new Date());
        }
        if (aux.getDataEmissao() == null) {
            aux.setDataEmissao(new Date());
        }
        if (aux.getDataPrevisaoSaida() == null) {
            aux.setDataPrevisaoSaida(new Date());
        }
        if (aux.getDataPrevisaoFat() == null) {
            aux.setDataPrevisaoFat(new Date());
        }
        if (aux.getDataCadastro() == null) {
            aux.setDataCadastro(new Date());
        }
        if (aux.getNaturezaOperacao() == null) {
            aux.setNaturezaOperacao(this.sharedData.getOpcoesFaturamento(aux.getEmpresa()).getNatPrefFaturamento());
        }
        if (aux.getSituacaoPedido() == null) {
            aux.setSituacaoPedido(this.sharedData.getOpcoesFaturamento(aux.getEmpresa()).getSituacaoPedidos());
        }
        if (aux.getMoeda() == null) {
            aux.setMoeda(this.sharedData.getOpcoesFaturamento(aux.getEmpresa()).getMoeda());
        }
    }

    private void setDadosFiscais(Pedido aux) {
        for (ItemPedido itemPedido : aux.getItemPedido()) {
            if (!TMethods.isWithData((Number)itemPedido.getFatorConversao())) {
                itemPedido.setFatorConversao(Double.valueOf(1.0));
            }
            if (itemPedido.getModeloFiscal() == null) {
                try {
                    ((HelperPedido)Context.get(HelperPedido.class)).build(aux).setModeloFiscal(itemPedido, aux.getEmpresa(), aux.getUnidadeFatCliente(), aux.getNaturezaOperacao());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (itemPedido.getGradeItemPedido() == null) {
                itemPedido.setGradeItemPedido(new LinkedList());
            }
            if (TMethods.isWithData((Collection)itemPedido.getGradeItemPedido())) continue;
            GradeCor grade = this.serviceGradeCorImpl.getFirstGradeCor(itemPedido.getProduto());
            GradeItemPedido gradeItem = this.helperPedido.getNovaGrade(grade, aux.getEmpresa(), itemPedido.getQuantidadeTotal());
            itemPedido.getGradeItemPedido().add(gradeItem);
        }
    }
}

