/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.pedido;

import com.touchcomp.basementor.constants.enums.messages.EnumConstStatusWebMessage;
import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFaturamentoOp;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.ItemPedidoFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.TabelaPrecoPromocoesProd;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.calculos.ExceptionCalcPrecosProduto;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.produto.ExceptionProdutoSemGrades;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.components.gradeitempedido.CompGradeItemPedido;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfaturamento.HelperOpcoesFaturamento;
import com.touchcomp.basementorservice.helpers.impl.pedido.HelperPedido;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.pedido.ServiceItemPedidoImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecopromocoes.ServiceTabelaPrecoPromocoesImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.pedido.web.DTOPedido;
import com.touchcomp.touchvomodel.vo.tabelaprecopromocoes.web.DTOTabelaPrecoPromocoes;
import com.touchcomp.touchvomodel.web.WebDTOMessage;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class AuxItemPedido {
    private final ServiceTabelaPrecoPromocoesImpl serviceTabelaPromocao;
    private final ServiceItemPedidoImpl serviceItemPedidoImpl;
    private final CompGradeItemPedido compGradeItemPedido;
    private final ServiceGradeCorImpl serviceGradeCor;
    private final HelperPedido helperPedido;
    private final HelperOpcoesFaturamento helperOpFat;

    public AuxItemPedido(ServiceTabelaPrecoPromocoesImpl serviceTabelaPromocao, HelperPedido helperPedido, CompGradeItemPedido compGradeItemPedido, ServiceGradeCorImpl serviceGradeCor, ServiceItemPedidoImpl serviceItemPedidoImpl, HelperOpcoesFaturamento helperOpFat) {
        this.serviceTabelaPromocao = serviceTabelaPromocao;
        this.compGradeItemPedido = compGradeItemPedido;
        this.serviceGradeCor = serviceGradeCor;
        this.serviceItemPedidoImpl = serviceItemPedidoImpl;
        this.helperPedido = helperPedido;
        this.helperOpFat = helperOpFat;
    }

    public ItemPedido newItemPedido(Produto produto, OpcoesFaturamento op, Empresa empresa, Representante representante, NaturezaOperacao naturezaOp, UnidadeFatCliente unidadeFatCliente, CondicoesPagamento condicoesPag, TipoFrete tipoFrete, String parcelasCondPagMut, Usuario usuario, OpcoesEstoque opEstoque) throws ExceptionAvaliadorExpressoes, ExceptionCalcPrecosProduto, ExceptionBase, ExceptionProdutoSemGrades {
        ItemPedido itemPedido = new ItemPedido();
        itemPedido.setProduto(produto);
        itemPedido.setUnidadeMedida(produto.getUnidadeMedida());
        itemPedido.setFatorConversao(Double.valueOf(1.0));
        this.helperPedido.setModeloFiscal(itemPedido, empresa, unidadeFatCliente, naturezaOp);
        ItemPedidoFiscal itemPedidoFiscal = new ItemPedidoFiscal();
        itemPedidoFiscal.setItemPedido(itemPedido);
        itemPedido.setItemPedidoFiscal(itemPedidoFiscal);
        itemPedido.setTipoTabPreco(op.getTipoTabelaPreco());
        itemPedido.setCentroEstoque(op.getCentroEstoquePedOtimizado());
        this.getTabelaPromocional(produto, empresa, itemPedido);
        if (CompOpcoes.isAffirmative(this.helperOpFat.build(op).getItens(), (EnumOpDinamicasInterface)EnumConstOpFaturamentoOp.UTILIZAR_PERC_SEGURO_TIPO_FRETE) && tipoFrete != null && tipoFrete.getPercFrete() > 0.0 && tipoFrete.getPercSeguro() > 0.0) {
            itemPedido.setPercSeguroItemInf(tipoFrete.getPercSeguro());
            itemPedido.setPercFreteItemInf(tipoFrete.getPercFrete());
        }
        List<GradeItemPedido> lista = this.compGradeItemPedido.findGradeItemPedidoByProdutoExcAll(itemPedido.getProduto(), itemPedido.getGradeItemPedido());
        for (GradeItemPedido grade : lista) {
            grade.setQuantidade(itemPedido.getQuantidadeTotal());
            grade.setItemPedido(itemPedido);
            grade.setCentroEstoque(itemPedido.getCentroEstoque());
        }
        return itemPedido;
    }

    private void getTabelaPromocional(Produto produto, Empresa empresa, ItemPedido it) {
        TabelaPrecoPromocoesProd vo = this.serviceTabelaPromocao.getTabelaPrecosPromo(produto, new Date(), empresa);
        if (TMethods.isNotNull((Object)vo).booleanValue()) {
            it.setValorMaximo(vo.getValorMaximo());
            it.setValorMinimo(vo.getValorMinimo());
            it.setPercComissao(vo.getPercComissao());
        }
    }

    private void getTabelaPromocional(Produto produto, Empresa empresa, DTOPedido.DTOItemPedido it) {
        TabelaPrecoPromocoesProd vo = this.serviceTabelaPromocao.getTabelaPrecosPromo(produto, new Date(), empresa);
        if (TMethods.isNotNull((Object)vo).booleanValue()) {
            it.setValorMaximo(vo.getValorMaximo());
            it.setValorMinimo(vo.getValorMinimo());
            it.setPercComissao(vo.getPercComissao());
            it.setTabelaPromocao(this.serviceTabelaPromocao.buildToDTOGeneric(vo, DTOTabelaPrecoPromocoes.DTOTabelaPrecoPromocoesProd.class));
        }
    }

    public DTOPedido.DTOItemPedido newItemPedidoCatalogo(Produto produto, OpcoesFaturamento op, Empresa empresa, NaturezaOperacao naturezaOp, UnidadeFatCliente unidadeFatCliente, TipoFrete tipoFrete) {
        DTOPedido.DTOItemPedido itemPedido = this.serviceItemPedidoImpl.buildToDTO(new ItemPedido(), DTOPedido.DTOItemPedido.class);
        itemPedido.setProdutoIdentificador(produto.getIdentificador());
        itemPedido.setProdutoNome(produto.getNome());
        itemPedido.setProdutoCodigoAuxiliar(produto.getCodigoAuxiliar());
        if (produto.getUnidadeMedida() != null) {
            itemPedido.setUnidadeMedidaIdentificador(produto.getUnidadeMedida().getIdentificador());
        }
        itemPedido.setFatorConversao(Double.valueOf(1.0));
        itemPedido.setTipoTabPreco(op.getTipoTabelaPreco());
        if (op.getCentroEstoquePedOtimizado() != null) {
            itemPedido.setCentroEstoqueIdentificador(op.getCentroEstoquePedOtimizado().getIdentificador());
        }
        itemPedido.setGradeItemPedido(new ArrayList());
        if (CompOpcoes.isAffirmative(this.helperOpFat.build(op).getItens(), (EnumOpDinamicasInterface)EnumConstOpFaturamentoOp.UTILIZAR_PERC_SEGURO_TIPO_FRETE) && tipoFrete != null && tipoFrete.getPercFrete() > 0.0 && tipoFrete.getPercSeguro() > 0.0) {
            itemPedido.setPercSeguroItemInf(tipoFrete.getPercSeguro());
            itemPedido.setPercFreteItemInf(tipoFrete.getPercFrete());
        }
        this.getTabelaPromocional(produto, empresa, itemPedido);
        List<GradeCor> lista = this.serviceGradeCor.getGradesAtivasByProduto(produto.getIdentificador());
        for (GradeCor grade : lista) {
            DTOPedido.DTOGradeItemPedido dtoGrade = new DTOPedido.DTOGradeItemPedido();
            dtoGrade.setQuantidade(itemPedido.getQuantidadeTotal());
            dtoGrade.setGradeCorIdentificador(grade.getIdentificador());
            dtoGrade.setGradeCor(grade.toString());
            dtoGrade.setGradeCorHexCor(grade.getCor().getCorHex());
            dtoGrade.setGradeCorSigla(grade.getCor().getSigla());
            itemPedido.getGradeItemPedido().add(dtoGrade);
        }
        try {
            ModeloFiscal modeloFiscal = this.helperPedido.getModeloFiscalItem(produto, empresa, unidadeFatCliente, naturezaOp);
            if (modeloFiscal != null) {
                itemPedido.setModeloFiscalIdentificador(modeloFiscal.getIdentificador());
            }
        }
        catch (ExceptionObjNotFound ex) {
            itemPedido.getErrors().add(new WebDTOMessage(ex.getErrorCode(), ex.getMessage(), EnumConstStatusWebMessage.ERRO));
        }
        return itemPedido;
    }
}

