/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.pedido;

import com.touchcomp.basementor.constants.enums.ConstEnumFormImprBI;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFatTipoReservaEstPedido;
import com.touchcomp.basementor.constants.enums.pedido.EnumValidacaoPedido;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistema;
import com.touchcomp.basementor.model.impl.ValidacaoPedidoItem;
import com.touchcomp.basementor.model.vo.AvaliadorExpFormulas;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.InfPagamentoPedido;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.LiberacaoPedido;
import com.touchcomp.basementor.model.vo.LiberacaoPedidoPedItem;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.ModeloEmail;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesMobile;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementor.model.vo.SituacaoNecessidadeCompra;
import com.touchcomp.basementor.model.vo.SituacaoPedidos;
import com.touchcomp.basementor.model.vo.TabelaDescFinancProduto;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.UsuarioEmpresa;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoipi.ExceptionImpostoIPI;
import com.touchcomp.basementorexceptions.exceptions.impl.impostopiscofins.ExceptionImpostoPisCofins;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.mail.ExceptionEmail;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIDefaultParams;
import com.touchcomp.basementorservice.components.businessintelligence.model.DefaultBIParamsMap;
import com.touchcomp.basementorservice.components.calculovalores.pedido.CompCalcVlrPedido;
import com.touchcomp.basementorservice.components.titulos.CompGeracaoTitulos;
import com.touchcomp.basementorservice.components.validacaoliberacaopedido.CompValidacaoLiberacaoPedido;
import com.touchcomp.basementorservice.helpers.impl.pedido.HelperPedido;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.avaliadorexpformulas.ServiceAvaliadorExpFormulasImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.ServiceBuildBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.condicoespagamento.ServiceCondicoesPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.liberacaopedido.ServiceLiberacaoPedidoImpl;
import com.touchcomp.basementorservice.service.impl.meiopagamento.ServiceMeioPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.naturezaoperacao.ServiceNaturezaOperacaoImpl;
import com.touchcomp.basementorservice.service.impl.pedido.ServiceItemPedidoImpl;
import com.touchcomp.basementorservice.service.impl.pedido.ServicePedidoImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.representante.ServiceRepresentanteImpl;
import com.touchcomp.basementorservice.service.impl.situacaopedidos.ServiceSituacaoPedidosImpl;
import com.touchcomp.basementorservice.service.impl.tipofrete.ServiceTipoFreteImpl;
import com.touchcomp.basementorservice.service.impl.transportador.ServiceTransportadorImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatcliente.ServiceUnidadeFatClienteImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementorservice.service.impl.usuarioempresa.ServiceUsuarioEmpresaImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceTabelaDescFinanceiro;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.ToolSendEmail;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.touchvomodel.vo.pedido.mobile.DTOMobilePedido;
import com.touchcomp.touchvomodel.vo.pedido.web.DTOPedido;
import com.touchcomp.touchvomodel.web.WebDTOMessage;
import com.touchcomp.touchvomodel.webservices.PackObjectsSinc;
import java.io.File;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceBuildMobilePedido
extends ServiceGenericImpl {
    @Autowired
    ServiceUsuarioEmpresaImpl serviceUsuarioEmpImpl;
    @Autowired
    private ServicePedidoImpl servicePedido;
    @Autowired
    private ServiceProdutoImpl serviceProduto;
    @Autowired
    private ServiceEmpresaImpl serviceEmpresa;
    @Autowired
    private ServiceCondicoesPagamentoImpl serviceCondicoesPagamento;
    @Autowired
    private ServiceTipoFreteImpl serviceTipoFrete;
    @Autowired
    private ServiceUsuarioImpl serviceUsuario;
    @Autowired
    private ServiceUnidadeFatClienteImpl serviceUnidadeFatCliente;
    @Autowired
    private ServiceMeioPagamentoImpl serviceMeioPagamento;
    @Autowired
    private ServiceNaturezaOperacaoImpl serviceNaturezaOperacao;
    @Autowired
    private ServiceAvaliadorExpFormulasImpl serviceAvaliadorExpFormulas;
    @Autowired
    private ServiceGradeCorImpl serviceGradeCor;
    @Autowired
    private ServiceRepresentanteImpl serviceRepresentante;
    @Autowired
    private ServiceLiberacaoPedidoImpl serviceLiberacaoPedido;
    @Autowired
    private ServiceTabelaDescFinanceiro serviceTabelaDescFinanceiro;
    @Autowired
    private HelperPedido helperPedido;
    @Autowired
    private ServiceSituacaoPedidosImpl serviceSitPedidos;
    @Autowired
    private CompValidacaoLiberacaoPedido compValidacaoLiberacaoPedido;
    @Autowired
    private CompGeracaoTitulos compGeracaoTitulos;
    @Autowired
    private ServiceBuildBusinessIntelligenceImpl serviceBI;
    @Autowired
    private ServiceTransportadorImpl serviceTransportador;
    @Autowired
    private ServiceItemPedidoImpl serviceItemPedido;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<PackObjectsSinc> savePedidos(String data) throws ExceptionIO, ExceptionEmail {
        List liberacoes = ToolJson.readJsonList((String)data, DTOMobilePedido.class);
        List<PackObjectsSinc> ret = this.sincronizaPedidos(liberacoes);
        return ret;
    }

    private List<PackObjectsSinc> sincronizaPedidos(List<DTOMobilePedido> pedidos) throws ExceptionEmail {
        LinkedList<PackObjectsSinc> pedSinc = new LinkedList<PackObjectsSinc>();
        LinkedList<Pedido> saved = new LinkedList<Pedido>();
        for (DTOMobilePedido pedLocal : pedidos) {
            this.sincPedido(pedLocal, saved, pedSinc);
        }
        this.sendEmail(saved);
        return pedSinc;
    }

    private void sincPedido(DTOMobilePedido pedLocal, List<Pedido> saved, List<PackObjectsSinc> pedSinc) {
        PackObjectsSinc pa = new PackObjectsSinc();
        pedSinc.add(pa);
        try {
            pa.setIdObjectMobile(pedLocal.getIdentificador());
            Pedido ped = this.getPedido(pedLocal);
            if (ped != null) {
                pa.setIdObjectMentor(ped.getIdentificador());
                pa.setObservacao("Pedido sincronizado anteriormente.");
                pa.setStatus(Short.valueOf((short)1));
                return;
            }
            ped = this.buildPedido(pedLocal, ped);
            this.validarItensDuplicados(ped, pedLocal);
            boolean libPedido = this.liberarPedidos(ped, pa);
            if (libPedido) {
                this.reservarEstoqueGerarNecessidade(ped, this.getOpcoesFaturamento(ped.getEmpresa()));
            }
            if (libPedido) {
                this.gerarTitulosProv(ped);
                ped = this.servicePedido.beforeSaveWithoutRecalculation(ped);
                ped = this.servicePedido.saveOrUpdateOnly(ped);
                pa.setIdObjectMentor(ped.getIdentificador());
                pa.setObservacao("Pedido sincronizado.");
                pa.setStatus(Short.valueOf((short)1));
            }
            saved.add(ped);
        }
        catch (ExceptionObjectNotFound ex) {
            this.logError(ex);
            pa.setObservacao(ex.getFormattedMessage());
            pa.setStatus(Short.valueOf((short)99));
        }
        catch (ExceptionBase ex) {
            this.logError(ex);
            pa.setObservacao(ex.getFormattedMessage());
            pa.setStatus(Short.valueOf((short)99));
        }
        catch (Exception ex) {
            this.logError(ex);
            pa.setObservacao(ex.getMessage());
            pa.setStatus(Short.valueOf((short)99));
        }
    }

    private void validarItensDuplicados(Pedido ped, DTOMobilePedido pedLocal) {
        this.validarItensPedRecebidos(pedLocal);
        this.validarItensPedidoSalvo(ped);
    }

    private void validarItensPedidoSalvo(Pedido ped) {
        List aux1 = ped.getItemPedido();
        HashMap<Long, Integer> map1 = new HashMap<Long, Integer>();
        for (ItemPedido item : aux1) {
            Integer found = (Integer)map1.get(item.getProduto().getIdentificador());
            if (found == null) {
                found = 0;
            }
            Integer n = found;
            found = found + 1;
            map1.put(item.getProduto().getIdentificador(), found);
            if (found <= 1) continue;
            throw new ExceptionErroProgramacao("Pedido esta sendo salvo com produtos duplicados.");
        }
    }

    private void validarItensPedRecebidos(DTOMobilePedido pedLocal) {
        List aux = pedLocal.getItemPedido();
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (DTOMobilePedido.DTOItemPedido item : aux) {
            Long found = (Long)map.get(item.getProdutoIdentificador());
            if (found == null) {
                found = 0L;
            }
            Long l = found;
            found = found + 1L;
            map.put(item.getProdutoIdentificador(), found);
            if (found <= 1L) continue;
            throw new ExceptionErroProgramacao("Pedido esta sendo salvo com produtos duplicados. Os mesmos chegaram duplicados do mobile. Pedido(Nr Pedido cliente informado): " + pedLocal.getNrPedidoCliente());
        }
    }

    private String getEmails(Pedido ped) {
        Object str = "";
        for (EmailPessoa em : ped.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getEmails()) {
            if (em.getAtivo() == null || em.getAtivo() != 1 || em.getEnviarDadosNfe() == null || em.getEnviarDadosNfe() != 1) continue;
            str = (String)str + em.getEmail();
            str = (String)str + ";";
        }
        return str;
    }

    private Pedido getPedido(DTOMobilePedido pedLocal) {
        return this.servicePedido.getPedidoMobile(pedLocal.getIdentificador(), pedLocal.getUsuarioIdentificador());
    }

    private Pedido buildPedido(DTOMobilePedido pedLocal, Pedido ped) throws ExceptionObjectNotFound, ExceptionImpostoPisCofins, ExceptionImpostoIPI, ExceptionImpostoIcms, ExceptionInvalidState {
        if (ped == null) {
            ped = new Pedido();
        }
        ped.setEmpresa((Empresa)this.serviceEmpresa.get(pedLocal.getEmpresaIdentificador()));
        OpcoesFaturamento op = this.getOpcoesFaturamento(ped.getEmpresa());
        OpcoesMobile opMobile = this.getOpcoesMobile(ped.getEmpresa());
        OpcoesFinanceiras opFinanc = this.getOpcoesFinanceiras(ped.getEmpresa());
        ped.setCondicoesPagamento((CondicoesPagamento)this.serviceCondicoesPagamento.get(pedLocal.getCondicoesPagamentoIdentificador()));
        ped.setCondPagMut(this.checkAndCutText(pedLocal.getCondPagMut(), 100));
        ped.setCentroEstoqueReserva(op.getCentroEstoqueReserva());
        ped.setDataCadastro(new Date());
        ped.setDataEmissao(pedLocal.getDataEmissao());
        ped.setDataPrevisaoSaida(pedLocal.getDataPrevisaoSaida());
        ped.setDataPrevisaoFat(pedLocal.getDataPrevisaoFat());
        ped.setDestacarDesconto(op.getDestacarDesconto());
        ped.setDestacarDespAcessoria(op.getDestacarDespAcessoria());
        ped.setDestacarFrete(op.getDestacarFrete());
        ped.setDestacarSeguro(op.getDestacarSeguro());
        ped.setNaturezaOperacao((NaturezaOperacao)this.serviceNaturezaOperacao.get(pedLocal.getNaturezaOperacaoIdentificador()));
        ped.setNrPedidoCliente(this.checkAndCutText(pedLocal.getNrPedidoCliente(), 15));
        ped.setPercDesconto(pedLocal.getPercDesconto());
        ped.setPercDescFinanceiro(Double.valueOf(0.0));
        ped.setPercDescontoInf(pedLocal.getPercDescontoInf());
        ped.setPercDespAcessoria(Double.valueOf(0.0));
        ped.setPercDespAcessoriaInf(Double.valueOf(0.0));
        ped.setPercFrete(Double.valueOf(0.0));
        ped.setPercFreteInf(Double.valueOf(0.0));
        ped.setPercSeguro(Double.valueOf(0.0));
        ped.setPercSeguroInf(Double.valueOf(0.0));
        ped.setPesoTotal(pedLocal.getPesoTotal());
        ped.setVolumeTotal(pedLocal.getVolumeTotal());
        ped.setValorDesconto(pedLocal.getValorDesconto());
        if (!this.isEquals(opMobile.getTipoReservaEstoque(), (short)2)) {
            ped.setReservarEstoque(op.getTrabReservaEstPed());
        }
        ped.setTipoIntermediadorComercial(opMobile.getTipoIntermediadorComercial());
        ped.setTipoDesconto(pedLocal.getTipoDesconto());
        ped.setTipoDespAcessInf(Short.valueOf((short)1));
        ped.setTipoFreteInf(Short.valueOf((short)1));
        ped.setTipoSeguroInf(Short.valueOf((short)1));
        ped.setTipoFrete((TipoFrete)this.serviceTipoFrete.get(pedLocal.getTipoFreteIdentificador()));
        ped.setUnidadeFatCliente((UnidadeFatCliente)this.serviceUnidadeFatCliente.get(pedLocal.getUnidadeFatClienteIdentificador()));
        ped.setUsuario((Usuario)this.serviceUsuario.get(pedLocal.getUsuarioIdentificador()));
        if (opMobile.getRespRepInformadoCliente() != null && opMobile.getRespRepInformadoCliente() == 1) {
            ped.setRepresentante(ped.getUnidadeFatCliente().getCliente().getFaturamento().getRepresentante());
        } else {
            ped.setRepresentante(this.getRepresentante(ped.getUsuario().getUsuarioBasico().getPessoa()));
        }
        if (ped.getRepresentante() == null) {
            ped.setRepresentante(opMobile.getRepresentantePadrao());
        }
        if (ToolMethods.isWithData((Number)pedLocal.getTransportadorIdentificador())) {
            ped.setTransportador((Transportador)this.serviceTransportador.get(pedLocal.getTransportadorIdentificador()));
        }
        if (ped.getTransportador() == null) {
            ped.setTransportador(ped.getUnidadeFatCliente().getCliente().getFaturamento().getTransportadora());
        }
        if (ped.getTransportador() == null) {
            ped.setTransportador(opMobile.getTransportador());
        }
        ped.setIdPedidoMobile(new BigInteger(pedLocal.getIdentificador().toString()));
        ped.setMoeda(this.getOpcoesFaturamento(ped.getEmpresa()).getMoeda());
        ped.setTipoConsumidor(ped.getUnidadeFatCliente().getCliente().getFaturamento().getTipoConsumidor());
        this.setItensPedido(ped, pedLocal, op, opMobile);
        ped.setInfPagamentoPedido(this.getInfPagamento(ped, pedLocal, opMobile, opFinanc));
        ped.setObservacao(this.checkAndCutText(pedLocal.getObservacao(), 2000));
        ped.setObservacao(TString.concatenar((String)"\n", (String[])new String[]{ped.getObservacao(), ped.getUnidadeFatCliente().getCliente().getFaturamento().getObservacaoPedido()}));
        ped.setIndicadorPresencaConsumidor(opMobile.getIndicadorPresencaConsumidor());
        this.setSituacaoPedido(pedLocal, ped, op);
        this.normalizarPedidoCalcValores(ped, op);
        this.reservarEstoqueGerarNecessidade(ped, op);
        return ped;
    }

    private MeioPagamento getMeioPagamento(OpcoesMobile opMobile, OpcoesFinanceiras opFinanc) {
        if (opMobile.getMeioPagamentoPadrao() != null) {
            return opMobile.getMeioPagamentoPadrao();
        }
        return opFinanc.getMeioPagamento();
    }

    private String checkAndCutText(String str, int size) {
        if (str == null) {
            return str;
        }
        if (str.length() > size) {
            return str.substring(0, size);
        }
        return str;
    }

    private OpcoesMobile getOpcoesMobile(Empresa empresa) throws ExceptionObjectNotFound {
        OpcoesMobile opMobile = this.getSharedData().getOpcoesMobile(empresa);
        return opMobile;
    }

    private OpcoesFinanceiras getOpcoesFinanceiras(Empresa empresa) throws ExceptionObjectNotFound {
        OpcoesFinanceiras found = this.getSharedData().getOpcoesFinanceiras(empresa);
        return found;
    }

    private OpcoesCompraSuprimentos getOpcoesCompraSuprimentos(Empresa empresa) throws ExceptionObjectNotFound {
        OpcoesCompraSuprimentos found = this.getSharedData().getOpcoesCompraSuprimentos(empresa);
        return found;
    }

    private OpcoesContabeis getOpcoesContabeis(Empresa empresa) throws ExceptionObjectNotFound {
        OpcoesContabeis found = this.getSharedData().getOpcoesContabeis(empresa);
        return found;
    }

    private void setItensPedido(Pedido ped, DTOMobilePedido pedLocal, OpcoesFaturamento opcoes, OpcoesMobile opcoesMobile) {
        if (ped.getItemPedido() == null) {
            ped.setItemPedido(new LinkedList());
        } else {
            ped.getItemPedido().clear();
        }
        int i = 1;
        for (DTOMobilePedido.DTOItemPedido itemLocal : pedLocal.getItemPedido()) {
            ItemPedido item = new ItemPedido();
            item.setCentroEstoque(this.getCentroEstoque(ped, opcoesMobile));
            item.setClassificacaoVendas(opcoes.getClassificacaoVendasPadrao());
            item.setDescontoItem(Short.valueOf((short)0));
            item.setDespAcessItem(Short.valueOf((short)0));
            item.setFatorConversao(Double.valueOf(1.0));
            item.setFreteItem(Short.valueOf((short)0));
            item.setInfoAdicionalItem(itemLocal.getInfoAdicionalItem());
            item.setInfoAdicionalItemAux(itemLocal.getInfoAdicionalItemAux());
            Long nrItemPedido = this.getNumeroSequencia(itemLocal.getNrItemPedido(), i);
            if (nrItemPedido != null) {
                item.setNrItemPedido(nrItemPedido.toString());
            }
            item.setNrSequencial(Integer.valueOf(i));
            item.setPedido(ped);
            item.setPercComissao(itemLocal.getPercComissao());
            item.setPercDesconto(itemLocal.getPercDesconto());
            item.setPercDespesaAcessoria(Double.valueOf(0.0));
            item.setPercFrete(Double.valueOf(0.0));
            item.setPercSeguro(Double.valueOf(0.0));
            item.setProduto((Produto)this.serviceProduto.get(itemLocal.getProdutoIdentificador()));
            item.setQuantidadeTotal(itemLocal.getQuantidadeTotal());
            item.setSeguroItem(Short.valueOf((short)0));
            item.setTabDesFinancProduto(this.getTabelaDescFinanceiro(item));
            if (item.getTabDesFinancProduto() != null) {
                item.setValorDescFinanceiro(item.getTabDesFinancProduto().getValorDesc());
            }
            item.setTipoDesconto(Short.valueOf((short)1));
            item.setTipoCondicao(Short.valueOf((short)0));
            item.setTipoDespAcessoria(Short.valueOf((short)1));
            item.setTipoFrete(Short.valueOf((short)1));
            item.setTipoSeguro(Short.valueOf((short)1));
            item.setUnidadeMedida(item.getProduto().getUnidadeMedida());
            item.setValorDesconto(itemLocal.getValorDesconto());
            item.setValorDespesaAcessoria(Double.valueOf(0.0));
            item.setValorFabrica(Double.valueOf(0.0));
            item.setValorFrete(Double.valueOf(0.0));
            item.setValorSeguro(Double.valueOf(0.0));
            item.setValorMaximo(itemLocal.getValorMaximo());
            item.setValorMinimo(itemLocal.getValorMinimo());
            item.setValorCusto(itemLocal.getValorCusto());
            item.setValorSugerido(itemLocal.getValorSugerido());
            item.setValorTotal(itemLocal.getValorTotal());
            item.setValorTotalComImpostos(itemLocal.getValorTotal());
            item.setValorTotalBruto(itemLocal.getValorTotalBruto());
            item.setValorDescontoPromocional(itemLocal.getValorDescontoPromocional());
            item.setPercDescontoPromocional(itemLocal.getPercDescontoPromocional());
            item.setValorUnitario(itemLocal.getValorUnitario());
            item.setTipoTabPreco(itemLocal.getTipoTabPreco());
            if (ToolMethods.isWithData((Number)itemLocal.getFormTabDinCalcPrecoIdentificador())) {
                item.setFormTabDinCalcPreco((AvaliadorExpFormulas)this.serviceAvaliadorExpFormulas.get(itemLocal.getFormTabDinCalcPrecoIdentificador()));
            }
            if (ToolMethods.isWithData((Number)itemLocal.getFormTabDinCalcComissaoIdentificador())) {
                item.setFormTabDinCalcComissao((AvaliadorExpFormulas)this.serviceAvaliadorExpFormulas.get(itemLocal.getFormTabDinCalcComissaoIdentificador()));
            }
            this.setGradesItemPedido(item, itemLocal, opcoes);
            try {
                this.helperPedido.setModeloFiscal(item, ped);
            }
            catch (ExceptionBase ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
            }
            ped.getItemPedido().add(item);
            ++i;
        }
    }

    private TabelaDescFinancProduto getTabelaDescFinanceiro(ItemPedido item) {
        if (item.getPedido().getUnidadeFatCliente().getCliente().getClassificacaoClientes() == null) {
            return null;
        }
        if (item.getProduto() == null) {
            return null;
        }
        TabelaDescFinancProduto tab = this.serviceTabelaDescFinanceiro.getTabelaDescontoItem(item.getPedido().getUnidadeFatCliente().getCliente().getClassificacaoClientes(), item.getProduto(), item.getPedido().getDataEmissao());
        return tab;
    }

    private void setGradesItemPedido(ItemPedido item, DTOMobilePedido.DTOItemPedido itemLocal, OpcoesFaturamento opcoes) {
        LinkedList<GradeItemPedido> aux = item.getGradeItemPedido();
        if (aux == null) {
            aux = new LinkedList<GradeItemPedido>();
        } else {
            aux.clear();
        }
        for (DTOMobilePedido.DTOGradeItemPedido grLocal : itemLocal.getGradeItemPedido()) {
            GradeItemPedido gr = new GradeItemPedido();
            gr.setGradeCor((GradeCor)this.serviceGradeCor.get(grLocal.getGradeCorIdentificador()));
            gr.setItemPedido(item);
            gr.setQuantidade(grLocal.getQuantidade());
            gr.setDataMovimentacao(new Date());
            gr.setEmpresa(opcoes.getEmpresa());
            gr.setCentroEstoque(item.getCentroEstoque());
            gr.setMovimentacaoFisica(Short.valueOf((short)0));
            gr.setReservarEstoque(item.getPedido().getReservarEstoque());
            aux.add(gr);
        }
        item.setGradeItemPedido(aux);
    }

    private Representante getRepresentante(Pessoa pessoa) {
        return this.serviceRepresentante.findRepresentantePorPessoa(pessoa);
    }

    private OpcoesFaturamento getOpcoesFaturamento(Empresa empresa) throws ExceptionObjectNotFound {
        OpcoesFaturamento found = this.getSharedData().getOpcoesFaturamento(empresa);
        return found;
    }

    private boolean liberarPedidos(Pedido ped, PackObjectsSinc pa) throws ExceptionBase {
        OpcoesFaturamento op = this.getOpcoesFaturamento(ped.getEmpresa());
        OpcoesFinanceiras opFin = this.getOpcoesFinanceiras(ped.getEmpresa());
        OpcoesMobile opmob = this.getOpcoesMobile(ped.getEmpresa());
        ValidacaoPedidoItem val = this.compValidacaoLiberacaoPedido.validarPedido(op, opFin, ped, null, EnumValidacaoPedido.PEDIDO, opmob.getConfigValPedidos());
        boolean res = val.isLiberado();
        Object st = "";
        for (LiberacaoPedidoPedItem iten : val.getItens()) {
            st = (String)st + iten.getObservacao() + ". ";
        }
        if (val.contemErro((short)1) || val.contemErro((short)3)) {
            pa.setObservacao((String)st);
            pa.setStatus(Short.valueOf((short)99));
            res = true;
        } else if (val.contemErro((short)2)) {
            pa.setObservacao((String)st);
            pa.setStatus(Short.valueOf((short)99));
            res = false;
        }
        if (!res) {
            res = this.verificaLibPedido(ped, pa);
        }
        return res;
    }

    private boolean verificaLibPedido(Pedido ped, PackObjectsSinc pa) {
        LiberacaoPedido found = this.serviceLiberacaoPedido.getLiberacaoPedido(ped.getUnidadeFatCliente(), ped.getValorTotal());
        if (found != null) {
            found.setLiberacaoUtilizada(Short.valueOf((short)1));
            found.getPedido().add(ped);
            this.serviceLiberacaoPedido.saveOrUpdate(found);
            return true;
        }
        return false;
    }

    private void sendEmail(List<Pedido> pedidos) throws ExceptionEmail {
        LinkedList<Email> emails = new LinkedList<Email>();
        for (Pedido pedido : pedidos) {
            OpcoesMobile op = this.getOpcoesMobile(pedido.getEmpresa());
            if (op.getEnviarEmailPedRecep() == null || op.getEnviarEmailPedRecep() != 1) continue;
            ModeloEmail mod = op.getModeloEmail();
            ServidorEmail serv = op.getServidorEmail();
            try {
                String destinatarios = this.getEmails(pedido);
                if (!ToolMethods.isStrWithData((String)destinatarios)) continue;
                UsuarioEmpresa usuEmp = this.serviceUsuarioEmpImpl.getByUserEmpresa(pedido.getUsuario(), pedido.getEmpresa());
                DefaultBIParamsMap<String, Object> params = CompBIDefaultParams.getDefParamsMap(pedido.getEmpresa(), pedido.getUsuario(), usuEmp != null ? usuEmp.getGrupo() : null, pedido);
                DataOutputBI out = this.serviceBI.gerarConverterFormatoImpBI(op.getBusinessIntelligencePed(), ConstEnumFormImprBI.PDF, EnumConstTipoSistema.INDIFERE, params);
                Email email = new Email();
                email.addAnexos(new File[]{out.getFile()});
                email.setAssunto(mod.getTituloEmail());
                email.setCorpoMensagem(new String(mod.getModelo()));
                email.addDestinatarios(new String[]{destinatarios});
                email.setServidor(new Email.ServidorEmail(serv.getServidor(), serv.getServidorImap(), serv.getServidorPop(), serv.getEmail(), serv.getSenha(), serv.getPortaEmail(), serv.getNaoAutenticarEmail(), serv.getLogin(), serv.getServerProperties(), serv.getGerarArquivoExtensaoEml(), serv.getDebugServer()));
                emails.add(email);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logError(e);
            }
        }
        ToolSendEmail.sendEmailWithException(emails);
    }

    private void gerarTitulosProv(Pedido ped) throws ExceptionObjectNotFound, ExceptionTitulo, ExceptionInvalidData {
        OpcoesFinanceiras opcoesFinanceiras = this.getOpcoesFinanceiras(ped.getEmpresa());
        OpcoesContabeis opcoesContabeis = this.getOpcoesContabeis(ped.getEmpresa());
        this.compGeracaoTitulos.gerarTitulos(ped, opcoesFinanceiras, opcoesContabeis);
    }

    private void normalizarPedidoCalcValores(Pedido ped, OpcoesFaturamento opcoes) throws ExceptionImpostoPisCofins, ExceptionImpostoIPI, ExceptionImpostoIcms, ExceptionObjectNotFound {
        CompCalcVlrPedido.calcularValoresPedido(ped, opcoes, this.getOpcoesContabeis(ped.getEmpresa()));
    }

    private Long getNumeroSequencia(Long nrItemCliente, Integer i) {
        if (nrItemCliente != null) {
            return nrItemCliente;
        }
        return i.longValue();
    }

    private List<InfPagamentoPedido> getInfPagamento(Pedido ped, DTOMobilePedido pedLocal, OpcoesMobile opMobile, OpcoesFinanceiras opFinanc) {
        MeioPagamento meio = null;
        LinkedList<InfPagamentoPedido> inf = ped.getInfPagamentoPedido();
        if (inf == null) {
            inf = new LinkedList<InfPagamentoPedido>();
        }
        inf.clear();
        for (DTOMobilePedido.DTOInfPagamentoPedido dto : pedLocal.getInfPagamentoPedido()) {
            InfPagamentoPedido i = new InfPagamentoPedido();
            i.setCondicoesPagamento((CondicoesPagamento)this.serviceCondicoesPagamento.get(dto.getCondicoesPagamentoIdentificador()));
            if (ToolMethods.isWithData((Number)dto.getMeioPagamentoIdentificador())) {
                i.setMeioPagamento((MeioPagamento)this.serviceMeioPagamento.get(dto.getMeioPagamentoIdentificador()));
            } else if (i.getCondicoesPagamento() != null) {
                i.setMeioPagamento(i.getCondicoesPagamento().getMeioPagamento());
            }
            if (i.getMeioPagamento() == null) {
                i.setMeioPagamento(this.getMeioPagamento(opMobile, opFinanc));
            }
            if (i.getMeioPagamento() != null) {
                i.setTipoIntegracao(i.getMeioPagamento().getTipoIntegracao());
                i.setTipoPagamentoNFe(i.getMeioPagamento().getTipoPagamentoNFe());
                i.setBandeiraCartaoNFe(i.getMeioPagamento().getBandeiraCartaoNFe());
                i.setCredenciadoraCreditoDebito(i.getMeioPagamento().getCredenciadoraCreditoDebito());
            }
            i.setNrDiasMedios(0);
            i.setParcelas(dto.getParcelas());
            i.setPedido(ped);
            i.setValor(dto.getValor());
            i.setValorAcrescimo(dto.getValorAcrescimo());
            i.setValorDesconto(dto.getValorDesconto());
            i.setValorLiquido(dto.getValorLiquido());
            i.setValorTroco(dto.getValorTroco());
            inf.add(i);
            meio = i.getMeioPagamento();
        }
        if (meio == null) {
            ped.setMeioPagamento(this.getMeioPagamento(opMobile, opFinanc));
        } else {
            ped.setMeioPagamento(meio);
        }
        return inf;
    }

    private void setSituacaoPedido(DTOMobilePedido pedLocal, Pedido ped, OpcoesFaturamento op) {
        if (pedLocal.getSituacaoPedidoIdentificador() != null && pedLocal.getSituacaoPedidoIdentificador() > 0L) {
            ped.setSituacaoPedido((SituacaoPedidos)this.serviceSitPedidos.get(pedLocal.getSituacaoPedidoIdentificador()));
        }
        if (ped.getSituacaoPedido() == null) {
            ped.setSituacaoPedido(op.getSituacaoPedidos());
        }
    }

    private void reservarEstoqueGerarNecessidade(Pedido ped, OpcoesFaturamento op) throws ExceptionInvalidState {
        OpcoesCompraSuprimentos opCompra;
        EnumConstantsMentorSimNao criarNec = EnumConstantsMentorSimNao.get((Object)op.getCriarNecessidadeCompra());
        SituacaoNecessidadeCompra sitNec = null;
        CentroCusto cc = null;
        OpcoesMobile opMobile = this.getOpcoesMobile(ped.getEmpresa());
        if (opMobile.getTipoReservaEstoque() == 2) {
            return;
        }
        if (criarNec == EnumConstantsMentorSimNao.SIM && (opCompra = this.getOpcoesCompraSuprimentos(ped.getEmpresa())) != null) {
            cc = opCompra.getCentroCustoNecessidadeCompra();
            sitNec = opCompra.getSituacaoNecessidadeCadastro();
        }
        this.servicePedido.reservarGerarNecCompra(ped, criarNec, op.getSituacaoPedidosNecessidade(), ped.getUsuario(), cc, sitNec, op.getCentroEstoqueReserva(), EnumConstOpFatTipoReservaEstPedido.get((Object)op.getTipoReservaEstoquePedido()));
    }

    private CentroEstoque getCentroEstoque(Pedido ped, OpcoesMobile opcoes) {
        return opcoes.getCentroEstoque();
    }

    public List<DTOPedido.DTOItemPedido> buildOnlineItensPedido(Long idUsuario, Long idEmpresa, Long idNaturezaOp, Long idRepresentante, Long idUnidadeFat, Long idCondPagamento, Long idTipoFrete, String parcelas, Long[] produtos) {
        LinkedList<DTOPedido.DTOItemPedido> itens = new LinkedList<DTOPedido.DTOItemPedido>();
        if (produtos != null && produtos.length > 0) {
            for (Long id : produtos) {
                DTOPedido.DTOItemPedido itemPedido = this.serviceItemPedido.buildToDTO(new ItemPedido(), DTOPedido.DTOItemPedido.class);
                try {
                    itemPedido = this.serviceItemPedido.newItemPedidoDTO(id, idEmpresa, idRepresentante, idNaturezaOp, idUnidadeFat, idCondPagamento, idTipoFrete, parcelas, idUsuario, DTOPedido.DTOItemPedido.class);
                }
                catch (Exception ex) {
                    itemPedido.setProdutoIdentificador(id);
                    itemPedido.getErrors().add(new WebDTOMessage((Throwable)ex));
                }
                itens.add(itemPedido);
            }
        }
        return itens;
    }
}

