/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.pedido;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFatResEstoquePed;
import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFatTipoReservaEstPedido;
import com.touchcomp.basementor.constants.enums.pedido.EnumConstGeracaoTitulosPreVendaPedido;
import com.touchcomp.basementor.constants.enums.pedido.EnumValidacaoPedido;
import com.touchcomp.basementor.model.impl.ValidacaoPedidoItem;
import com.touchcomp.basementor.model.interfaces.InterfaceStaticObjects;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.LiberacaoPedido;
import com.touchcomp.basementor.model.vo.LiberacaoPedidoPedItem;
import com.touchcomp.basementor.model.vo.NFCeOpcoes;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.SituacaoNecessidadeCompra;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.calculovalores.pedido.CompCalcVlrPedido;
import com.touchcomp.basementorservice.components.titulos.CompGeracaoTitulos;
import com.touchcomp.basementorservice.components.validacaoliberacaopedido.CompValidacaoLiberacaoPedido;
import com.touchcomp.basementorservice.helpers.impl.centroestoque.HelperCentroEstoque;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.liberacaopedido.ServiceLiberacaoPedidoImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.pedido.ServicePedidoImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.pedido.nfce.DTOPedidoV2;
import com.touchcomp.touchvomodel.webservices.PackObjectsSinc;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Deprecated
@Service
public class ServiceBuildNFCePedidoV2
extends ServiceGenericImpl {
    @Autowired
    private ServiceLoteFabricacaoImpl serviceLoteFabricacao;
    @Autowired
    private ServicePedidoImpl servicePedido;
    @Autowired
    private ServiceLiberacaoPedidoImpl serviceLiberacaoPedido;
    @Autowired
    private CompValidacaoLiberacaoPedido compValidacaoLiberacaoPedido;
    @Autowired
    private InterfaceStaticObjects sharedData;

    public List<PackObjectsSinc> savePedidos(String data) throws ExceptionBase {
        List liberacoes = ToolJson.readJsonList((String)data, DTOPedidoV2.class);
        List<PackObjectsSinc> ret = this.sincronizaPedidos(liberacoes);
        return ret;
    }

    private List<PackObjectsSinc> sincronizaPedidos(List<DTOPedidoV2> pedidos) throws ExceptionBase {
        LinkedList<PackObjectsSinc> listRet = new LinkedList<PackObjectsSinc>();
        for (DTOPedidoV2 pedLocal : pedidos) {
            Pedido ped = (Pedido)this.servicePedido.buildToEntity(pedLocal);
            PackObjectsSinc p = new PackObjectsSinc();
            this.processaPedidoSincronizado(ped, p);
            this.servicePedido.saveOrUpdate(ped);
            p.setIdObjectMentor(ped.getIdentificador());
            p.setStatus(Short.valueOf((short)1));
            p.setObservacao("Pedido sincronizado.");
            p.setSerialObjetoOrigem(ped.getSerialForSync());
            listRet.add(p);
        }
        return listRet;
    }

    private void processaPedidoSincronizado(Pedido pedido, PackObjectsSinc p) throws ExceptionBase {
        OpcoesFaturamento opFat = this.getOpcoesFaturamento(pedido.getEmpresa());
        NFCeOpcoes opcoesNFCe = this.getOpcoesNFCe(pedido.getEmpresa());
        pedido.setModoReservaEstoque(opFat.getTrabReservaEstPed());
        pedido.setReservarEstoque(this.reservarEstoquePedidoBySituacaoAndOpcoes(pedido, opFat));
        if (pedido.getUnidadeFatCliente() == null) {
            pedido.setUnidadeFatCliente(opcoesNFCe.getUnidadeFatCliente());
        }
        if (pedido.getUnidadeFatCliente() == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1180.001", new Object[]{pedido.getEmpresa()}));
        }
        int i = 1;
        for (ItemPedido itemPedido : pedido.getItemPedido()) {
            itemPedido.setPedido(pedido);
            itemPedido.setCentroEstoque(this.getCentroEstoque(pedido.getEmpresa(), this.getOpcoesEstoque(pedido.getEmpresa()), itemPedido, pedido.getUsuario()));
            itemPedido.getGradeItemPedido().forEach(c -> {
                c.setItemPedido(itemPedido);
                c.setDataMovimentacao(pedido.getDataEmissao());
                c.setEmpresa(pedido.getEmpresa());
                c.setCentroEstoque(itemPedido.getCentroEstoque());
                c.setLoteFabricacao(this.serviceLoteFabricacao.findOrCreateLoteUnico(c.getItemPedido().getProduto()));
                c.setReservarEstoque(pedido.getReservarEstoque());
            });
            itemPedido.setNrSequencial(Integer.valueOf(i));
            ++i;
        }
        pedido.setNrTotalItens(Integer.valueOf(pedido.getItemPedido().size()));
        pedido.getInfPagamentoPedido().forEach(a -> {
            a.setPedido(pedido);
            if (a.getPedido().getCondicoesPagamento() == null) {
                a.getPedido().setCondicoesPagamento(a.getCondicoesPagamento());
            }
            if (a.getCondicoesPagamento() == null) {
                a.setCondicoesPagamento(pedido.getCondicoesPagamento());
                a.getPedido().setMeioPagamento(a.getCondicoesPagamento().getMeioPagamento());
            }
        });
        if (ToolMethods.isNotNull((Object)pedido.getSituacaoPedido()).booleanValue() && !ToolMethods.isEquals((Object)pedido.getSituacaoPedido().getGerarFinanceiroNFCe(), (Object)EnumConstGeracaoTitulosPreVendaPedido.NAO_GERAR_TITULOS.getValue())) {
            try {
                ((CompGeracaoTitulos)Context.get(CompGeracaoTitulos.class)).gerarTitulosPedPreVenda(pedido, this.getOpcoesFinanceiras(pedido.getEmpresa()), this.getSharedData().getOpcoesContabeis(pedido.getEmpresa()));
            }
            catch (ExceptionInvalidData | ExceptionTitulo ex) {
                ex.printStackTrace();
                p.setObservacao(ex.getMessage());
                p.setStatus(Short.valueOf((short)0));
                this.getLogger().error(ex);
                throw new ExceptionErroProgramacao(ex.getMessage(), ex);
            }
        } else {
            pedido.getInfPagamentoPedido().forEach(a -> a.getTitulos().clear());
        }
        if (ToolMethods.isEquals((Object)pedido.getCondicoesPagamento().getCondMutante(), (Object)1)) {
            pedido.setCondPagMut(pedido.getCondicoesPagamento().getParcelasMutante());
        }
        this.createEnderecoEntregaPedido(pedido);
        pedido.setMoeda(opFat.getMoeda());
        pedido.setTipoConsumidor(this.getTipoConsumidorPedido(pedido));
        try {
            CompCalcVlrPedido.calcularValoresPedido(pedido, opFat, this.getOpcoesContabeis(pedido.getEmpresa()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            p.setObservacao(ex.getMessage());
            p.setStatus(Short.valueOf((short)0));
            this.getLogger().error((Throwable)ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
        this.liberarPedidos(pedido, p);
        this.reservarEstoqueGerarNecessidade(pedido, this.getOpcoesFaturamento(pedido.getEmpresa()));
    }

    private void createEnderecoEntregaPedido(Pedido aux) {
        if (aux.getEnderecoEntrega() != null) {
            Endereco endereco = new Endereco();
            endereco.setBairro(aux.getEnderecoEntrega().getBairro());
            endereco.setCep(aux.getEnderecoEntrega().getCep());
            endereco.setCidade(aux.getEnderecoEntrega().getCidade());
            endereco.setComplemento(aux.getEnderecoEntrega().getComplemento());
            endereco.setLogradouro(aux.getEnderecoEntrega().getLogradouro());
            endereco.setNumero(aux.getEnderecoEntrega().getNumero());
            endereco.setObservacao(aux.getEnderecoEntrega().getObservacao());
            endereco.setReferencia(aux.getEnderecoEntrega().getReferencia());
            aux.setEnderecoEntrega(endereco);
        }
    }

    private Short getTipoConsumidorPedido(Pedido aux) {
        if (ToolMethods.isEquals((Object)this.getOpcoesNFCe(aux.getEmpresa()).getUnidadeFatCliente(), (Object)aux.getUnidadeFatCliente())) {
            return (short)1;
        }
        return aux.getUnidadeFatCliente().getCliente().getFaturamento().getTipoConsumidor();
    }

    private CentroEstoque getCentroEstoque(Empresa empresa, OpcoesEstoque opEst, ItemPedido item, Usuario usuario) {
        return ((HelperCentroEstoque)ConfApplicationContext.getBean(HelperCentroEstoque.class)).getCentroEstoque(empresa, opEst, item, usuario);
    }

    private boolean liberarPedidos(Pedido ped, PackObjectsSinc pa) throws ExceptionBase {
        OpcoesFaturamento op = this.getOpcoesFaturamento(ped.getEmpresa());
        OpcoesFinanceiras opFin = this.getOpcoesFinanceiras(ped.getEmpresa());
        ValidacaoPedidoItem val = this.compValidacaoLiberacaoPedido.validarPedido(op, opFin, ped, null, EnumValidacaoPedido.PEDIDO, op.getConfValidacaoPedidos());
        boolean res = val.isLiberado();
        Object st = "";
        for (LiberacaoPedidoPedItem iten : val.getItens()) {
            st = (String)st + iten.getObservacao() + ". ";
        }
        if (val.contemErro((short)1) || val.contemErro((short)3)) {
            pa.setObservacao((String)st);
            pa.setStatus(Short.valueOf((short)99));
            res = true;
        } else if (val.contemErro((short)2)) {
            pa.setObservacao((String)st);
            pa.setStatus(Short.valueOf((short)99));
            res = false;
        }
        if (!res) {
            res = this.verificaLibPedido(ped, pa);
        }
        return res;
    }

    private boolean verificaLibPedido(Pedido ped, PackObjectsSinc pa) {
        LiberacaoPedido found = this.serviceLiberacaoPedido.getLiberacaoPedido(ped.getUnidadeFatCliente(), ped.getValorTotal());
        if (found != null) {
            found.setLiberacaoUtilizada(Short.valueOf((short)1));
            found.getPedido().add(ped);
            this.serviceLiberacaoPedido.saveOrUpdate(found);
            return true;
        }
        return false;
    }

    private Short reservarEstoquePedidoBySituacaoAndOpcoes(Pedido aux, OpcoesFaturamento op) {
        if (ToolMethods.isEquals((Object)op.getTipoReservaEstoquePedido(), (Object)EnumConstOpFatResEstoquePed.NAO_RESERVAR.getValue())) {
            return (short)0;
        }
        if (ToolMethods.isEquals((Object)aux.getSituacaoPedido().getBloqueioReservaEstoque(), (Object)1)) {
            return (short)0;
        }
        return (short)1;
    }

    private void reservarEstoqueGerarNecessidade(Pedido ped, OpcoesFaturamento op) throws ExceptionInvalidState {
        OpcoesCompraSuprimentos opCompra;
        EnumConstantsMentorSimNao criarNec = EnumConstantsMentorSimNao.get((Object)op.getCriarNecessidadeCompra());
        SituacaoNecessidadeCompra sitNec = null;
        CentroCusto cc = null;
        if (criarNec == EnumConstantsMentorSimNao.SIM && (opCompra = this.getOpcoesCompraSuprimentos(ped.getEmpresa())) != null) {
            sitNec = opCompra.getSituacaoNecessidadeCadastro();
            cc = opCompra.getCentroCustoNecessidadeCompra();
        }
        this.servicePedido.reservarGerarNecCompra(ped, criarNec, op.getSituacaoPedidosNecessidade(), ped.getUsuario(), cc, sitNec, op.getCentroEstoqueReserva(), EnumConstOpFatTipoReservaEstPedido.get((Object)op.getTipoReservaEstoquePedido()));
    }

    public OpcoesFinanceiras getOpcoesFinanceiras(Empresa empresa) throws ExceptionObjectNotFound {
        return this.sharedData.getOpcoesFinanceiras(empresa);
    }

    private OpcoesFaturamento getOpcoesFaturamento(Empresa empresa) throws ExceptionObjectNotFound {
        return this.sharedData.getOpcoesFaturamento(empresa);
    }

    private OpcoesEstoque getOpcoesEstoque(Empresa empresa) throws ExceptionObjectNotFound {
        return this.sharedData.getOpcoesEstoque(empresa);
    }

    private OpcoesContabeis getOpcoesContabeis(Empresa empresa) throws ExceptionObjectNotFound {
        return this.sharedData.getOpcoesContabeis(empresa);
    }

    private NFCeOpcoes getOpcoesNFCe(Empresa empresa) throws ExceptionObjectNotFound {
        return this.sharedData.getOpcoesNFCe(empresa);
    }

    private OpcoesCompraSuprimentos getOpcoesCompraSuprimentos(Empresa empresa) throws ExceptionObjectNotFound {
        return this.sharedData.getOpcoesCompraSuprimentos(empresa);
    }
}

