/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.pedido;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFatResEstoquePed;
import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFatTipoReservaEstPedido;
import com.touchcomp.basementor.constants.enums.pedido.EnumConstGeracaoTitulosPreVendaPedido;
import com.touchcomp.basementor.constants.enums.pedido.EnumValidacaoPedido;
import com.touchcomp.basementor.model.impl.ValidacaoPedidoItem;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.LiberacaoPedido;
import com.touchcomp.basementor.model.vo.LiberacaoPedidoPedItem;
import com.touchcomp.basementor.model.vo.NFCeControleCaixa;
import com.touchcomp.basementor.model.vo.NFCeOpcoes;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.SituacaoNecessidadeCompra;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorexceptions.exceptions.util.UtilException;
import com.touchcomp.basementorservice.components.calculovalores.pedido.CompCalcVlrPedido;
import com.touchcomp.basementorservice.components.titulos.CompGeracaoTitulos;
import com.touchcomp.basementorservice.components.validacaoliberacaopedido.CompValidacaoLiberacaoPedido;
import com.touchcomp.basementorservice.dao.impl.DaoPedidoImpl;
import com.touchcomp.basementorservice.helpers.impl.centroestoque.HelperCentroEstoque;
import com.touchcomp.basementorservice.helpers.impl.pedido.HelperItemPedido;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.liberacaopedido.ServiceLiberacaoPedidoImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.nfcecontrolecaixa.ServiceNFCeControleCaixaImpl;
import com.touchcomp.basementorservice.service.impl.pedido.ServicePedidoImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.pedido.nfce.DTOPedidoV8;
import com.touchcomp.touchvomodel.webservices.PackObjectsSinc;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceBuildNFCePedidoV8
extends ServiceGenericImpl {
    @Autowired
    private ServiceLoteFabricacaoImpl serviceLoteFabricacao;
    @Autowired
    private ServicePedidoImpl servicePedido;
    @Autowired
    private ServiceLiberacaoPedidoImpl serviceLiberacaoPedido;
    @Autowired
    private CompValidacaoLiberacaoPedido compValidacaoLiberacaoPedido;
    @Autowired
    ServiceNFCeControleCaixaImpl serviceNFCeControleCaixa;

    public List<PackObjectsSinc> savePedidos(String data) throws ExceptionBase {
        List liberacoes = ToolJson.readJsonList((String)data, DTOPedidoV8.class);
        return this.sincronizaPedidos(liberacoes);
    }

    private List<PackObjectsSinc> sincronizaPedidos(List<DTOPedidoV8> pedidos) throws ExceptionBase {
        LinkedList<PackObjectsSinc> listRet = new LinkedList<PackObjectsSinc>();
        for (DTOPedidoV8 pedLocal : pedidos) {
            String serialForSincControleCaixa = pedLocal.getNfceControleCaixaSerialForSinc();
            NFCeControleCaixa caixa = null;
            if (ToolMethods.isStrWithData((String)serialForSincControleCaixa)) {
                caixa = this.serviceNFCeControleCaixa.getBySerial(serialForSincControleCaixa);
            }
            pedLocal.setNfceControleCaixaSerialForSinc(null);
            Pedido ped = (Pedido)this.servicePedido.buildToEntity(pedLocal);
            if (ped.getIdentificador() != null) {
                ((DaoPedidoImpl)this.servicePedido.getGenericDao()).getSession().evict((Object)((ItemPedido)ped.getItemPedido().getFirst()).getValorDesconto());
            }
            ped.setNfceControleCaixa(caixa);
            try {
                PackObjectsSinc p = new PackObjectsSinc();
                this.processaPedidoSincronizado(ped, p);
                ped = this.servicePedido.saveOrUpdate(ped);
                this.servicePedido.flushData();
                p.setIdObjectMentor(ped.getIdentificador());
                p.setStatus(Short.valueOf((short)1));
                p.setObservacao("Pedido sincronizado.");
                p.setSerialObjetoOrigem(ped.getSerialForSync());
                listRet.add(p);
            }
            catch (Exception ex) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1180.006", new Object[]{String.valueOf(ped.getUnidadeFatCliente()), ToolDate.dateToStr((Date)ped.getDataEmissao()), ToolFormatter.arrredondarNumero((Double)ped.getValorTotal(), (int)2), UtilException.getAllCauses((Throwable)ex)}));
            }
        }
        return listRet;
    }

    private void processaPedidoSincronizado(Pedido pedido, PackObjectsSinc p) throws ExceptionBase {
        OpcoesFaturamento opFat = this.getSharedData().getOpcoesFaturamento(pedido.getEmpresa());
        NFCeOpcoes opcoesNFCe = this.getSharedData().getOpcoesNFCe(pedido.getEmpresa());
        pedido.setModoReservaEstoque(opFat.getTrabReservaEstPed());
        pedido.setReservarEstoque(this.reservarEstoquePedidoBySituacaoAndOpcoes(pedido, opFat));
        if (pedido.getUnidadeFatCliente() == null) {
            pedido.setUnidadeFatCliente(opcoesNFCe.getUnidadeFatCliente());
        }
        if (pedido.getUnidadeFatCliente() == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1180.001", new Object[]{pedido.getEmpresa()}));
        }
        if (pedido.getTransportador() == null) {
            pedido.setTransportador(pedido.getUnidadeFatCliente().getCliente().getFaturamento().getTransportadora());
        }
        this.buildItensPedido(pedido);
        pedido.setNrTotalItens(Integer.valueOf(pedido.getItemPedido().size()));
        this.buildInfPagPedido(pedido, p);
        if (ToolMethods.isEquals((Object)pedido.getCondicoesPagamento().getCondMutante(), (Object)1)) {
            pedido.setCondPagMut(pedido.getCondicoesPagamento().getParcelasMutante());
        }
        this.createEnderecoEntregaPedido(pedido);
        pedido.setMoeda(opFat.getMoeda());
        pedido.setTipoConsumidor(this.getTipoConsumidorPedido(pedido));
        try {
            CompCalcVlrPedido.calcularValoresPedido(pedido, opFat, this.getSharedData().getOpcoesContabeis(pedido.getEmpresa()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            p.setObservacao(ex.getMessage());
            p.setStatus(Short.valueOf((short)0));
            this.getLogger().error((Throwable)ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
        this.liberarPedidos(pedido, p);
        this.reservarEstoqueGerarNecessidade(pedido, this.getSharedData().getOpcoesFaturamento(pedido.getEmpresa()));
    }

    private void buildInfPagPedido(Pedido pedido, PackObjectsSinc p) {
        pedido.getInfPagamentoPedido().forEach(a -> {
            a.setPedido(pedido);
            if (a.getPedido().getCondicoesPagamento() == null) {
                a.getPedido().setCondicoesPagamento(a.getCondicoesPagamento());
                a.getPedido().setMeioPagamento(a.getMeioPagamento());
            }
            if (a.getCondicoesPagamento() == null) {
                a.setCondicoesPagamento(pedido.getCondicoesPagamento());
                a.getPedido().setMeioPagamento(a.getCondicoesPagamento().getMeioPagamento());
            }
        });
        this.gerarTitulosPedido(pedido, p);
    }

    private void gerarTitulosPedido(Pedido pedido, PackObjectsSinc p) {
        if (ToolMethods.isNotNull((Object)pedido.getSituacaoPedido()).booleanValue() && !ToolMethods.isEquals((Object)pedido.getSituacaoPedido().getGerarFinanceiroNFCe(), (Object)EnumConstGeracaoTitulosPreVendaPedido.NAO_GERAR_TITULOS.getValue())) {
            try {
                ((CompGeracaoTitulos)Context.get(CompGeracaoTitulos.class)).gerarTitulosPedPreVenda(pedido, this.getSharedData().getOpcoesFinanceiras(pedido.getEmpresa()), this.getSharedData().getOpcoesContabeis(pedido.getEmpresa()));
            }
            catch (ExceptionInvalidData | ExceptionTitulo ex) {
                ex.printStackTrace();
                p.setObservacao(ex.getMessage());
                p.setStatus(Short.valueOf((short)0));
                this.getLogger().error(ex);
                throw new ExceptionErroProgramacao(ex.getMessage(), ex);
            }
        } else {
            pedido.getInfPagamentoPedido().forEach(a -> a.getTitulos().clear());
        }
    }

    private void buildItensPedido(Pedido pedido) {
        int i = 1;
        for (ItemPedido itemPedido : pedido.getItemPedido()) {
            itemPedido.setPedido(pedido);
            itemPedido.setCentroEstoque(this.getCentroEstoque(pedido.getEmpresa(), this.getSharedData().getOpcoesEstoque(pedido.getEmpresa()), itemPedido, pedido.getUsuario()));
            itemPedido.getGradeItemPedido().forEach(c -> {
                c.setItemPedido(itemPedido);
                c.setDataMovimentacao(pedido.getDataEmissao());
                c.setEmpresa(pedido.getEmpresa());
                c.setCentroEstoque(itemPedido.getCentroEstoque());
                c.setLoteFabricacao(this.serviceLoteFabricacao.findOrCreateLoteUnico(c.getItemPedido().getProduto()));
                c.setReservarEstoque(pedido.getReservarEstoque());
                if (ToolMethods.isEquals((Object)c.getReservarEstoque(), (Object)1) && ToolMethods.isEquals((Object)EnumConstOpFatResEstoquePed.RESERVAR_BAIXA_EFETIVA.getValue(), (Object)pedido.getModoReservaEstoque())) {
                    c.setMovimentacaoFisica(Short.valueOf((short)1));
                }
            });
            new HelperItemPedido().setOutrosValoresAcessoriosComplementares(itemPedido);
            itemPedido.setNrSequencial(Integer.valueOf(i));
            ++i;
        }
    }

    private void createEnderecoEntregaPedido(Pedido aux) {
        if (aux.getEnderecoEntrega() != null) {
            Endereco endereco = new Endereco();
            endereco.setBairro(aux.getEnderecoEntrega().getBairro());
            endereco.setCep(aux.getEnderecoEntrega().getCep());
            endereco.setCidade(aux.getEnderecoEntrega().getCidade());
            endereco.setComplemento(aux.getEnderecoEntrega().getComplemento());
            endereco.setLogradouro(aux.getEnderecoEntrega().getLogradouro());
            endereco.setNumero(aux.getEnderecoEntrega().getNumero());
            endereco.setObservacao(aux.getEnderecoEntrega().getObservacao());
            endereco.setReferencia(aux.getEnderecoEntrega().getReferencia());
            aux.setEnderecoEntrega(endereco);
        }
    }

    private Short getTipoConsumidorPedido(Pedido aux) {
        if (ToolMethods.isEquals((Object)this.getSharedData().getOpcoesNFCe(aux.getEmpresa()).getUnidadeFatCliente(), (Object)aux.getUnidadeFatCliente())) {
            return (short)1;
        }
        return aux.getUnidadeFatCliente().getCliente().getFaturamento().getTipoConsumidor();
    }

    private CentroEstoque getCentroEstoque(Empresa empresa, OpcoesEstoque opEst, ItemPedido item, Usuario usuario) {
        return ((HelperCentroEstoque)ConfApplicationContext.getBean(HelperCentroEstoque.class)).getCentroEstoque(empresa, opEst, item, usuario);
    }

    private boolean liberarPedidos(Pedido ped, PackObjectsSinc pa) throws ExceptionBase {
        OpcoesFaturamento op = this.getSharedData().getOpcoesFaturamento(ped.getEmpresa());
        OpcoesFinanceiras opFin = this.getSharedData().getOpcoesFinanceiras(ped.getEmpresa());
        ValidacaoPedidoItem val = new ValidacaoPedidoItem();
        val = this.compValidacaoLiberacaoPedido.validarPedido(op, opFin, ped, val, EnumValidacaoPedido.PRE_VENDA, op.getConfValidacaoPedidos());
        boolean res = val.isLiberado();
        Object st = "";
        for (LiberacaoPedidoPedItem iten : val.getItens()) {
            st = (String)st + iten.getObservacao() + ". ";
        }
        if (val.contemErro((short)1)) {
            pa.setObservacao((String)st);
            pa.setStatus(Short.valueOf((short)99));
            res = true;
        } else if (val.contemErro((short)2) || val.contemErro((short)3)) {
            pa.setObservacao((String)st);
            pa.setStatus(Short.valueOf((short)99));
            res = false;
        }
        if (!res) {
            res = this.verificaLibPedido(ped);
        }
        return res;
    }

    private boolean verificaLibPedido(Pedido ped) {
        LiberacaoPedido found = this.serviceLiberacaoPedido.getLiberacaoPedido(ped.getUnidadeFatCliente(), ped.getValorTotal());
        if (found != null) {
            found.setLiberacaoUtilizada(Short.valueOf((short)1));
            found.getPedido().add(ped);
            this.serviceLiberacaoPedido.saveOrUpdate(found);
            return true;
        }
        return false;
    }

    private Short reservarEstoquePedidoBySituacaoAndOpcoes(Pedido aux, OpcoesFaturamento op) {
        if (ToolMethods.isEquals((Object)op.getTrabReservaEstPed(), (Object)EnumConstOpFatResEstoquePed.NAO_RESERVAR.getValue())) {
            return (short)0;
        }
        if (ToolMethods.isEquals((Object)aux.getSituacaoPedido().getBloqueioReservaEstoque(), (Object)1)) {
            return (short)0;
        }
        return (short)1;
    }

    private void reservarEstoqueGerarNecessidade(Pedido ped, OpcoesFaturamento op) throws ExceptionInvalidState {
        OpcoesCompraSuprimentos opCompra;
        EnumConstantsMentorSimNao criarNec = EnumConstantsMentorSimNao.get((Object)op.getCriarNecessidadeCompra());
        SituacaoNecessidadeCompra sitNec = null;
        CentroCusto cc = null;
        if (criarNec == EnumConstantsMentorSimNao.SIM && (opCompra = this.getSharedData().getOpcoesCompraSuprimentos(ped.getEmpresa())) != null) {
            sitNec = opCompra.getSituacaoNecessidadeCadastro();
            cc = opCompra.getCentroCustoNecessidadeCompra();
        }
        this.servicePedido.reservarGerarNecCompra(ped, criarNec, op.getSituacaoPedidosNecessidade(), ped.getUsuario(), cc, sitNec, op.getCentroEstoqueReserva(), EnumConstOpFatTipoReservaEstPedido.get((Object)op.getTipoReservaEstoquePedido()));
    }
}

