/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.pedido;

import com.touchcomp.basementor.constants.enums.messages.EnumConstStatusWebMessage;
import com.touchcomp.basementor.constants.enums.pedido.EnumValidacaoPedido;
import com.touchcomp.basementor.model.impl.ValidacaoPedidoItem;
import com.touchcomp.basementor.model.impl.ValoresPrecoItemPedido;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProd;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.LiberacaoPedidoPedItem;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.calculos.ExceptionCalcPrecosProduto;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.produto.ExceptionProdutoSemGrades;
import com.touchcomp.basementorservice.components.gradeitempedido.CompGradeItemPedido;
import com.touchcomp.basementorservice.components.validacaoliberacaopedido.CompValidacaoLiberacaoPedido;
import com.touchcomp.basementorservice.dao.impl.DaoItemPedidoImpl;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfaturamento.HelperOpcoesFaturamento;
import com.touchcomp.basementorservice.helpers.impl.pedido.HelperPedido;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.analiseprecovenda.ServiceAnalisePrVendaProdImpl;
import com.touchcomp.basementorservice.service.impl.condicoespagamento.ServiceCondicoesPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.naturezaoperacao.ServiceNaturezaOperacaoImpl;
import com.touchcomp.basementorservice.service.impl.opcoesestoque.ServiceOpcoesEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.opcoesfaturamento.ServiceOpcoesFaturamentoImpl;
import com.touchcomp.basementorservice.service.impl.pedido.AuxItemPedido;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.representante.ServiceRepresentanteImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecobaseproduto.ServiceTabelaPrecoBaseProdutoImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecopromocoes.ServiceTabelaPrecoPromocoesImpl;
import com.touchcomp.basementorservice.service.impl.tabelaprecos.ServiceCalcTabelaPrecosImpl;
import com.touchcomp.basementorservice.service.impl.tipofrete.ServiceTipoFreteImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatcliente.ServiceUnidadeFatClienteImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.touchvomodel.vo.pedido.web.DTOPedido;
import com.touchcomp.touchvomodel.web.WebDTOMessage;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ServiceItemPedidoImpl
extends ServiceGenericEntityImpl<ItemPedido, Long, DaoItemPedidoImpl> {
    private final ServiceProdutoImpl serviceProdutoImpl;
    private final ServiceRepresentanteImpl serviceRepresentanteImpl;
    private final ServiceNaturezaOperacaoImpl serviceNaturezaOperacaoImpl;
    private final ServiceCondicoesPagamentoImpl serviceCondicoesPagamentoImpl;
    private final ServiceUnidadeFatClienteImpl serviceUnidadeFatClienteImpl;
    private final CompValidacaoLiberacaoPedido compValidacaoLiberacaoPedido;
    private final ServiceCalcTabelaPrecosImpl serviceCalcTabelaPrecosImpl;
    private final HelperPedido helperPedido;
    private final HelperOpcoesFaturamento helperOpFat;
    private final CompGradeItemPedido compGradeItemPedido;
    private final ServiceGradeCorImpl serviceGradeCor;
    private final ServiceTabelaPrecoBaseProdutoImpl serviceTabelaPrecoBaseProdutoImpl;
    private final ServiceTabelaPrecoPromocoesImpl serviceTabelaPrecoPromocoesImpl;
    private final ServiceEmpresaImpl serviceEmpresa;
    private final ServiceUsuarioImpl serviceUsuario;
    private final ServiceOpcoesFaturamentoImpl serviceOpcoesFaturamento;
    private final ServiceOpcoesEstoqueImpl serviceOpcoesEstoque;
    private final ServiceTipoFreteImpl serviceTipoFrete;
    private final ServiceAnalisePrVendaProdImpl serviceAnalisePrVendaProd;

    public ServiceItemPedidoImpl(ServiceProdutoImpl serviceProdutoImpl, ServiceRepresentanteImpl serviceRepresentanteImpl, ServiceNaturezaOperacaoImpl serviceNaturezaOperacaoImpl, ServiceCondicoesPagamentoImpl serviceCondicoesPagamentoImpl, ServiceUnidadeFatClienteImpl serviceUnidadeFatClienteImpl, CompValidacaoLiberacaoPedido compValidacaoLiberacaoPedido, ServiceCalcTabelaPrecosImpl serviceCalcTabelaPrecosImpl, HelperPedido helperPedido, CompGradeItemPedido compGradeItemPedido, DaoItemPedidoImpl genericDao, ServiceGradeCorImpl serviceGradeCor, ServiceTabelaPrecoBaseProdutoImpl serviceTabelaPrecoBaseProdutoImpl, ServiceTabelaPrecoPromocoesImpl serviceTabelaPrecoPromocoesImpl, ServiceEmpresaImpl serviceEmpresa, ServiceUsuarioImpl serviceUsuario, ServiceOpcoesFaturamentoImpl serviceOpcoesFaturamento, ServiceOpcoesEstoqueImpl serviceOpcoesEstoque, HelperOpcoesFaturamento helperOpFat, ServiceTipoFreteImpl serviceTipoFrete, ServiceAnalisePrVendaProdImpl serviceAnalisePrVendaProd) {
        super(genericDao);
        this.serviceProdutoImpl = serviceProdutoImpl;
        this.serviceRepresentanteImpl = serviceRepresentanteImpl;
        this.serviceNaturezaOperacaoImpl = serviceNaturezaOperacaoImpl;
        this.serviceCondicoesPagamentoImpl = serviceCondicoesPagamentoImpl;
        this.serviceUnidadeFatClienteImpl = serviceUnidadeFatClienteImpl;
        this.compValidacaoLiberacaoPedido = compValidacaoLiberacaoPedido;
        this.serviceCalcTabelaPrecosImpl = serviceCalcTabelaPrecosImpl;
        this.helperPedido = helperPedido;
        this.compGradeItemPedido = compGradeItemPedido;
        this.serviceGradeCor = serviceGradeCor;
        this.serviceTabelaPrecoBaseProdutoImpl = serviceTabelaPrecoBaseProdutoImpl;
        this.serviceTabelaPrecoPromocoesImpl = serviceTabelaPrecoPromocoesImpl;
        this.serviceEmpresa = serviceEmpresa;
        this.serviceUsuario = serviceUsuario;
        this.serviceOpcoesFaturamento = serviceOpcoesFaturamento;
        this.serviceOpcoesEstoque = serviceOpcoesEstoque;
        this.helperOpFat = helperOpFat;
        this.serviceTipoFrete = serviceTipoFrete;
        this.serviceAnalisePrVendaProd = serviceAnalisePrVendaProd;
    }

    public ItemPedido newItemPedido(Long idProduto, OpcoesFaturamento opcoesFaturamento, Empresa empresa, Long idRepresentante, Long idNaturezaOp, Long idUnidadeFat, Long idCondPagamento, Long idTipoFrete, String parcelasCondPagMut, Usuario usuario, OpcoesEstoque opcoesEstoque) throws ExceptionBase, ExceptionCalcPrecosProduto, ExceptionAvaliadorExpressoes, ExceptionProdutoSemGrades {
        Produto produto = (Produto)this.serviceProdutoImpl.getOrThrow(idProduto);
        UnidadeFatCliente unidadeFatCliente = (UnidadeFatCliente)this.serviceUnidadeFatClienteImpl.getOrThrow(idUnidadeFat);
        Representante representante = (Representante)this.serviceRepresentanteImpl.getOrThrow(idRepresentante);
        NaturezaOperacao natureza = (NaturezaOperacao)this.serviceNaturezaOperacaoImpl.getOrThrow(idNaturezaOp);
        CondicoesPagamento condicoesPag = (CondicoesPagamento)this.serviceCondicoesPagamentoImpl.getOrThrow(idCondPagamento);
        TipoFrete tipoFrete = (TipoFrete)this.serviceTipoFrete.getOrThrow(idTipoFrete);
        return this.newItemPedido(produto, opcoesFaturamento, empresa, representante, natureza, unidadeFatCliente, condicoesPag, tipoFrete, parcelasCondPagMut, usuario, opcoesEstoque);
    }

    public ItemPedido newItemPedido(Produto produto, OpcoesFaturamento opcoesFaturamento, Empresa empresa, Representante representante, NaturezaOperacao naturezaOp, UnidadeFatCliente unidadeFatCliente, CondicoesPagamento condPagamento, TipoFrete tipoFrete, String parcelasCondPagMut, Usuario usuario, OpcoesEstoque opcoesEstoque) throws ExceptionBase, ExceptionCalcPrecosProduto, ExceptionAvaliadorExpressoes, ExceptionProdutoSemGrades {
        ItemPedido item = new AuxItemPedido(this.serviceTabelaPrecoPromocoesImpl, this.helperPedido, this.compGradeItemPedido, this.serviceGradeCor, this, this.helperOpFat).newItemPedido(produto, opcoesFaturamento, empresa, representante, naturezaOp, unidadeFatCliente, condPagamento, tipoFrete, parcelasCondPagMut, usuario, opcoesEstoque);
        this.calcularValoresComissao(item, opcoesFaturamento, unidadeFatCliente, representante, condPagamento, parcelasCondPagMut, empresa, naturezaOp, usuario);
        return item;
    }

    public List<DTOPedido.DTOItemPedido> findItensDestaquePromocao(Long idUnidadeFat, Long idNaturezaOp, Long idRepresentante, Long idCondPagamento, Long idTipoFrete, String parcelasCondPagMut, Empresa empresa, OpcoesFaturamento opcoesFaturamento, OpcoesEstoque opcoesEstoque, Usuario usuario, Pageable pageable) throws ExceptionObjNotFound, ExceptionCalcPrecosProduto, ExceptionAvaliadorExpressoes, ExceptionProdutoSemGrades {
        UnidadeFatCliente unidadeFatCliente = (UnidadeFatCliente)this.serviceUnidadeFatClienteImpl.getOrThrowWithCache(idUnidadeFat);
        NaturezaOperacao natureza = (NaturezaOperacao)this.serviceNaturezaOperacaoImpl.getOrThrowWithCache(idNaturezaOp);
        Representante representante = (Representante)this.serviceRepresentanteImpl.getOrThrowWithCache(idRepresentante);
        CondicoesPagamento condPagamento = (CondicoesPagamento)this.serviceCondicoesPagamentoImpl.getOrThrowWithCache(idCondPagamento);
        TipoFrete tipoFrete = (TipoFrete)this.serviceTipoFrete.getOrThrowWithCache(idTipoFrete);
        List<Produto> produtos = this.serviceTabelaPrecoPromocoesImpl.getProdutosDestaquePromocao(new Date(), empresa, pageable);
        return this.findItensCategoria(opcoesFaturamento, empresa, representante, natureza, unidadeFatCliente, condPagamento, tipoFrete, produtos, parcelasCondPagMut, usuario, opcoesEstoque, pageable);
    }

    public List<DTOPedido.DTOItemPedido> findItensCategoria(String search, Long idCategoria, OpcoesFaturamento opcoesFaturamento, Empresa empresa, Long idRepresentante, Long idNaturezaOp, Long idUnidadeFat, Long idCondPagamento, Long idTipoFrete, String parcelasCondPagMut, Usuario usuario, OpcoesEstoque opcoesEstoque, Pageable pageable) throws ExceptionObjNotFound, ExceptionCalcPrecosProduto, ExceptionAvaliadorExpressoes, ExceptionProdutoSemGrades {
        UnidadeFatCliente unidadeFatCliente = (UnidadeFatCliente)this.serviceUnidadeFatClienteImpl.getOrThrowWithCache(idUnidadeFat);
        NaturezaOperacao natureza = (NaturezaOperacao)this.serviceNaturezaOperacaoImpl.getOrThrowWithCache(idNaturezaOp);
        Representante representante = (Representante)this.serviceRepresentanteImpl.getOrThrowWithCache(idRepresentante);
        CondicoesPagamento condPagamento = (CondicoesPagamento)this.serviceCondicoesPagamentoImpl.getOrThrowWithCache(idCondPagamento);
        TipoFrete tipoFrete = (TipoFrete)this.serviceTipoFrete.getOrThrowWithCache(idTipoFrete);
        List<Produto> produtos = this.serviceTabelaPrecoBaseProdutoImpl.findProdutosByCategoria(search, idCategoria, pageable);
        return this.findItensCategoria(opcoesFaturamento, empresa, representante, natureza, unidadeFatCliente, condPagamento, tipoFrete, produtos, parcelasCondPagMut, usuario, opcoesEstoque, pageable);
    }

    public List<DTOPedido.DTOItemPedido> findItensCategoria(OpcoesFaturamento opcoesFaturamento, Empresa empresa, Representante representante, NaturezaOperacao natureza, UnidadeFatCliente unidadeFatCliente, CondicoesPagamento condPagamento, TipoFrete tipoFrete, List<Produto> produtos, String parcelasCondPagMut, Usuario usuario, OpcoesEstoque opcoesEstoque, Pageable pageable) throws ExceptionObjNotFound, ExceptionCalcPrecosProduto, ExceptionAvaliadorExpressoes, ExceptionProdutoSemGrades {
        ArrayList<DTOPedido.DTOItemPedido> ret = new ArrayList<DTOPedido.DTOItemPedido>();
        if (produtos != null) {
            for (Produto p : produtos) {
                DTOPedido.DTOItemPedido dto = new AuxItemPedido(this.serviceTabelaPrecoPromocoesImpl, this.helperPedido, this.compGradeItemPedido, this.serviceGradeCor, this, this.helperOpFat).newItemPedidoCatalogo(p, opcoesFaturamento, empresa, natureza, unidadeFatCliente, tipoFrete);
                if (dto.getErrors().isEmpty()) {
                    this.calcularValoresComissao(dto, p, opcoesFaturamento, unidadeFatCliente, representante, condPagamento, parcelasCondPagMut, empresa, natureza, usuario);
                }
                ret.add(dto);
            }
        }
        return ret;
    }

    public <E> E newItemPedidoDTO(Long idProduto, OpcoesFaturamento opcoesFaturamento, Empresa empresa, Long idRepresentante, Long idNaturezaOp, Long idUnidadeFat, Long idCondPagamento, Long idTipoFrete, String parcelasCondPagMut, Usuario usuario, OpcoesEstoque opcoesEstoque, Class<E> aClass) throws ExceptionBase, ExceptionCalcPrecosProduto, ExceptionAvaliadorExpressoes, ExceptionProdutoSemGrades {
        ItemPedido item = this.newItemPedido(idProduto, opcoesFaturamento, empresa, idRepresentante, idNaturezaOp, idUnidadeFat, idCondPagamento, idTipoFrete, parcelasCondPagMut, usuario, opcoesEstoque);
        return this.buildToDTO(item, aClass);
    }

    public <E> E newItemPedidoDTO(Long idProduto, Long idEmpresa, Long idRepresentante, Long idNaturezaOp, Long idUnidadeFat, Long idCondPagamento, Long idTipoFrete, String parcelasCondPagMut, Long idUsuario, Class<E> aClass) throws ExceptionBase, ExceptionCalcPrecosProduto, ExceptionAvaliadorExpressoes, ExceptionProdutoSemGrades {
        Empresa empresa = (Empresa)this.serviceEmpresa.getOrThrow(idEmpresa);
        Usuario usuario = (Usuario)this.serviceUsuario.getOrThrow(idUsuario);
        OpcoesFaturamento opcoesFaturamento = this.serviceOpcoesFaturamento.getByIdEmpresa(empresa.getIdentificador());
        OpcoesEstoque opcoesEstoque = this.serviceOpcoesEstoque.getByIdEmpresa(empresa.getIdentificador());
        ItemPedido item = this.newItemPedido(idProduto, opcoesFaturamento, empresa, idRepresentante, idNaturezaOp, idUnidadeFat, idCondPagamento, idTipoFrete, parcelasCondPagMut, usuario, opcoesEstoque);
        return this.buildToDTO(item, aClass);
    }

    public void validarItemPedido(DTOPedido.DTOItemPedido input, WebDTOResult result, OpcoesFaturamento opcoesFaturamento, OpcoesFinanceiras opcoesFin) throws ExceptionBase {
        ItemPedido itemPedido = (ItemPedido)this.buildToEntity(input);
        ValidacaoPedidoItem val = this.compValidacaoLiberacaoPedido.validarItemPedido(opcoesFaturamento, itemPedido, null, opcoesFin, EnumValidacaoPedido.PEDIDO, null);
        for (LiberacaoPedidoPedItem item : val.getItens()) {
            if (this.isEquals(item.getItemValBloqueio().getTipoValPedidos(), (short)2) && !this.isAffimative(item.getLiberado())) {
                result.addErroMessage(item.getItemValBloqueio().getIdentificador().toString(), item.getItemValBloqueio().getDescricao());
            }
            if (!this.isEquals(item.getItemValBloqueio().getTipoValPedidos(), (short)1) || this.isAffimative(item.getLiberado())) continue;
            result.addErroMessage(item.getItemValBloqueio().getIdentificador().toString(), item.getItemValBloqueio().getDescricao());
        }
    }

    public void calcularValoresComissao(ItemPedido itemPedido, OpcoesFaturamento op, UnidadeFatCliente unidadeFatCliente, Representante representante, CondicoesPagamento condicoesPag, String parcelasCondPagMut, Empresa empresa, NaturezaOperacao naturezaOp, Usuario usuario) throws ExceptionAvaliadorExpressoes, ExceptionCalcPrecosProduto {
        ValoresPrecoItemPedido val = this.serviceCalcTabelaPrecosImpl.calcularValores(op, unidadeFatCliente, representante, itemPedido.getProduto(), TDate.dataSemHora((Date)new Date()), op.getMoeda(), condicoesPag, parcelasCondPagMut, null, empresa, naturezaOp, usuario, null);
        itemPedido.setValorUnitario(val.getValorSugerido());
        itemPedido.setValorMaximo(val.getValorMaximo());
        itemPedido.setValorMinimo(val.getValorMinimo());
        itemPedido.setValorCusto(val.getValorCusto());
        if (val.getComissao() != null) {
            itemPedido.setPercComissao(val.getComissao().getPercComissao());
        }
        itemPedido.setFormTabDinCalcPreco(val.getAvaliadorExpFormulasCalPreco());
        itemPedido.setFormTabDinCalcComissao(val.getComissao().getAvaliadorExpFormulasCalComissao());
    }

    public void calcularValoresComissao(DTOPedido.DTOItemPedido itemPedido, Produto produto, OpcoesFaturamento op, UnidadeFatCliente unidadeFatCliente, Representante representante, CondicoesPagamento condicoesPag, String parcelasCondPagMut, Empresa empresa, NaturezaOperacao naturezaOp, Usuario usuario) {
        try {
            ValoresPrecoItemPedido val = this.serviceCalcTabelaPrecosImpl.calcularValores(op, unidadeFatCliente, representante, produto, TDate.dataSemHora((Date)new Date()), op.getMoeda(), condicoesPag, parcelasCondPagMut, null, empresa, naturezaOp, usuario, null);
            itemPedido.setValorUnitario(val.getValorSugerido());
            itemPedido.setValorMaximo(val.getValorMaximo());
            itemPedido.setValorMinimo(val.getValorMinimo());
            itemPedido.setValorCusto(val.getValorCusto());
            if (val.getComissao() != null) {
                itemPedido.setPercComissao(val.getComissao().getPercComissao());
            }
            if (val.getAvaliadorExpFormulasCalPreco() != null) {
                itemPedido.setFormTabDinCalcPrecoIdentificador(val.getAvaliadorExpFormulasCalPreco().getIdentificador());
            }
            if (val.getComissao().getAvaliadorExpFormulasCalComissao() != null) {
                itemPedido.setFormTabDinCalcComissaoIdentificador(val.getComissao().getAvaliadorExpFormulasCalComissao().getIdentificador());
            }
        }
        catch (ExceptionAvaliadorExpressoes | ExceptionCalcPrecosProduto ex) {
            itemPedido.getErrors().add(new WebDTOMessage(ex.getErrorCode(), ex.getMessage(), EnumConstStatusWebMessage.ERRO));
        }
    }

    public DTOPedido.DTOItemPedido aplicarValorAnalise(Long idAnalise, DTOPedido.DTOItemPedido dto) throws ExceptionObjNotFound, ExceptionInvalidData {
        AnalisePrVendaProd analise = (AnalisePrVendaProd)this.serviceAnalisePrVendaProd.getOrThrow(idAnalise);
        Produto produto = (Produto)this.serviceProdutoImpl.getOrThrow(dto.getProdutoIdentificador());
        this.helperPedido.aplicarValorAnaliseCusto(produto, dto, analise);
        return dto;
    }
}

