/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.pedido;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.crud.EnumConstCRUD;
import com.touchcomp.basementor.constants.enums.manutencaositpedidos.EnumConstFiltroGrupoSituacaoRota;
import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFatTipoReservaEstPedido;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.GrupoPessoas;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.ModeloEmail;
import com.touchcomp.basementor.model.vo.ObsFaturamento;
import com.touchcomp.basementor.model.vo.ObservacaoPedidoFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.OrdemServicoProdLinhaProd;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.RamoAtividade;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementor.model.vo.SituacaoNecessidadeCompra;
import com.touchcomp.basementor.model.vo.SituacaoPedidos;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.calculos.ExceptionCalcPrecosProduto;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoipi.ExceptionImpostoIPI;
import com.touchcomp.basementorexceptions.exceptions.impl.impostopiscofins.ExceptionImpostoPisCofins;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.mail.ExceptionEmail;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.email.builders.CompEmailPedido;
import com.touchcomp.basementorservice.components.titulos.CompGeracaoTitulos;
import com.touchcomp.basementorservice.components.validacaoliberacaopedido.CompValidacaoLiberacaoPedido;
import com.touchcomp.basementorservice.dao.impl.DaoPedidoImpl;
import com.touchcomp.basementorservice.helpers.impl.modelofiscal.HelperModeloFiscal;
import com.touchcomp.basementorservice.helpers.impl.oslinhaproducao.HelperOrdemServicoLinhaProd;
import com.touchcomp.basementorservice.helpers.impl.pedido.HelperPedido;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.ServiceBuildBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.businessintelligence.ServiceBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.expedicao.ServiceExpedicaoImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.modeloemail.ServiceModeloEmailImpl;
import com.touchcomp.basementorservice.service.impl.obsfaturamento.ServiceObsFaturamentoImpl;
import com.touchcomp.basementorservice.service.impl.pedido.AuxBeforeSave;
import com.touchcomp.basementorservice.service.impl.pedido.ServiceItemPedidoImpl;
import com.touchcomp.basementorservice.service.impl.pedido.ServicePedidoNecessidadeCompra;
import com.touchcomp.basementorservice.service.impl.pedido.ServicePedidoReservaEstoque;
import com.touchcomp.basementorservice.service.impl.servidoremail.ServiceServidorEmailImpl;
import com.touchcomp.basementorservice.service.impl.situacaopedidos.ServiceSituacaoPedidosImpl;
import com.touchcomp.basementorservice.service.impl.titulo.ServiceTituloImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementorservice.service.impl.usuarioempresa.ServiceUsuarioEmpresaImpl;
import com.touchcomp.basementorservice.service.interfaces.ServicePedido;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.dtotransfer.ToolDTOBuilder;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.crud.impl.ValidCrudPedidoImpl;
import com.touchcomp.touchvomodel.vo.businessintelligence.DTOBusinessIntelligenceSendEmail;
import com.touchcomp.touchvomodel.vo.pedido.nfce.DTOPedidoV10;
import com.touchcomp.touchvomodel.vo.pedido.nfce.DTOPedidoV2;
import com.touchcomp.touchvomodel.vo.pedido.nfce.DTOPedidoV3;
import com.touchcomp.touchvomodel.vo.pedido.nfce.DTOPedidoV4;
import com.touchcomp.touchvomodel.vo.pedido.nfce.DTOPedidoV5;
import com.touchcomp.touchvomodel.vo.pedido.nfce.DTOPedidoV6;
import com.touchcomp.touchvomodel.vo.pedido.nfce.DTOPedidoV7;
import com.touchcomp.touchvomodel.vo.pedido.nfce.DTOPedidoV8;
import com.touchcomp.touchvomodel.vo.pedido.nfce.DTOPedidoV9;
import com.touchcomp.touchvomodel.vo.pedido.web.DTOCancelarPedido;
import com.touchcomp.touchvomodel.vo.pedido.web.DTODadosFaturamentoPedido;
import com.touchcomp.touchvomodel.vo.pedido.web.DTOPedido;
import com.touchcomp.touchvomodel.vo.pedido.web.auxiliar.TempManutencaoSituacaoPedidos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ServicePedidoImpl
extends ServiceGenericEntityImpl<Pedido, Long, DaoPedidoImpl>
implements ServicePedido {
    final HelperPedido helperPedido;
    final ServiceItemPedidoImpl serviceItemPedido;
    final CompGeracaoTitulos compGeracaoTitulos;
    final ServiceTituloImpl serviceTitulo;
    final ServiceUsuarioEmpresaImpl serviceUsuarioEmpresa;
    final HelperModeloFiscal helperModeloFiscal;
    final ServiceGradeCorImpl serviceGradeCorImpl;
    final CompValidacaoLiberacaoPedido compValidacaoLiberacaoPedido;
    final ValidCrudPedidoImpl validCrudPedido;
    final ServiceUsuarioImpl serviceUsuarioImpl;
    final ServiceSituacaoPedidosImpl serviceSituacaoPedidosImpl;
    private ServiceObsFaturamentoImpl serviceObsFaturamento;
    final ServiceExpedicaoImpl serviceExpedicao;
    final HelperOrdemServicoLinhaProd helperOrdemServicoLinhaProd;

    public ServicePedidoImpl(HelperPedido helperPedido, ServiceItemPedidoImpl serviceItemPedido, CompGeracaoTitulos compGeracaoTitulos, DaoPedidoImpl genericDao, ServiceTituloImpl serviceTitulo, ServiceUsuarioEmpresaImpl serviceUsuarioEmpresa, HelperModeloFiscal helperModeloFiscal, ServiceGradeCorImpl serviceGradeCorImpl, CompValidacaoLiberacaoPedido compValidacaoLiberacaoPedido, ValidCrudPedidoImpl validCrudPedido, ServiceUsuarioImpl serviceUsuarioImpl, ServiceSituacaoPedidosImpl serviceSituacaoPedidosImpl, ServiceObsFaturamentoImpl serviceObsFaturamento, ServiceExpedicaoImpl serviceExpedicao, HelperOrdemServicoLinhaProd helperOrdemServicoLinhaProd) {
        super(genericDao);
        this.helperPedido = helperPedido;
        this.serviceItemPedido = serviceItemPedido;
        this.compGeracaoTitulos = compGeracaoTitulos;
        this.serviceTitulo = serviceTitulo;
        this.serviceUsuarioEmpresa = serviceUsuarioEmpresa;
        this.helperModeloFiscal = helperModeloFiscal;
        this.serviceGradeCorImpl = serviceGradeCorImpl;
        this.compValidacaoLiberacaoPedido = compValidacaoLiberacaoPedido;
        this.validCrudPedido = validCrudPedido;
        this.serviceUsuarioImpl = serviceUsuarioImpl;
        this.serviceSituacaoPedidosImpl = serviceSituacaoPedidosImpl;
        this.serviceObsFaturamento = serviceObsFaturamento;
        this.serviceExpedicao = serviceExpedicao;
        this.helperOrdemServicoLinhaProd = helperOrdemServicoLinhaProd;
    }

    @Override
    public Pedido saveOrUpdateOnly(Pedido entity) {
        try {
            return super.saveOrUpdateOnly(entity);
        }
        catch (Exception ex) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1180.006", new Object[]{String.valueOf(entity.getUnidadeFatCliente()), ToolDate.dateToStr((Date)entity.getDataEmissao()), ToolFormatter.arrredondarNumero((Double)entity.getValorTotal(), (int)2), ex.getMessage()}));
        }
    }

    @Override
    public Double getValorMedioPedidos(Cliente cliente) {
        return ((DaoPedidoImpl)this.getGenericDao()).getValorMedioPedidos(cliente);
    }

    @Override
    public Double getValorPedidoAberto(Cliente cliente) {
        return ((DaoPedidoImpl)this.getGenericDao()).getValorPedidoAberto(cliente);
    }

    @Override
    public Double getValorGrSituacaoCliente(Long idGrSituacao, Long idCliente) {
        return ((DaoPedidoImpl)this.getGenericDao()).getValorGrSituacaoCliente(idGrSituacao, idCliente);
    }

    @Override
    public Double getValorSituacaoCliente(Long idSituacao, Long idCliente) {
        return ((DaoPedidoImpl)this.getGenericDao()).getValorSituacaoCliente(idSituacao, idCliente);
    }

    @Override
    public Double getValorGrSituacaoGrPessoas(Long idGrSituacao, Long idGrPessoas) {
        return ((DaoPedidoImpl)this.getGenericDao()).getValorGrSituacaoGrPessoas(idGrSituacao, idGrPessoas);
    }

    @Override
    public Double getValorSituacaoGrPessoas(Long idSituacao, Long idGrPessoas) {
        return ((DaoPedidoImpl)this.getGenericDao()).getValorSituacaoGrPessoas(idSituacao, idGrPessoas);
    }

    @Override
    public Double getValorPedidoAbertoGrPessoas(GrupoPessoas grPessoas) {
        return ((DaoPedidoImpl)this.getGenericDao()).getValorPedidoAbertoGrPessoas(grPessoas);
    }

    @Override
    public Pedido beforeSave(Pedido aux) {
        aux = new AuxBeforeSave(this.helperPedido, this.compValidacaoLiberacaoPedido, this.serviceTitulo, this.getSharedData(), this.helperModeloFiscal, this.serviceGradeCorImpl, this.compGeracaoTitulos).beforeSave(aux);
        return aux;
    }

    @Override
    public Pedido beforeSaveEntity(Pedido aux) {
        aux = new AuxBeforeSave(this.helperPedido, this.compValidacaoLiberacaoPedido, this.serviceTitulo, this.getSharedData(), this.helperModeloFiscal, this.serviceGradeCorImpl, this.compGeracaoTitulos).beforeSaveEntity(aux);
        return aux;
    }

    public Pedido beforeSaveWithoutRecalculation(Pedido aux) {
        aux = this.beforeSave(aux);
        aux = new AuxBeforeSave(this.helperPedido, this.compValidacaoLiberacaoPedido, this.serviceTitulo, this.getSharedData(), this.helperModeloFiscal, this.serviceGradeCorImpl, this.compGeracaoTitulos).beforeSaveEntity(aux, false);
        return aux;
    }

    @Override
    protected void addCustomConverters(ToolDTOBuilder builder) {
    }

    public Pedido getBySerial(String serialForSinc) {
        return ((DaoPedidoImpl)this.getGenericDao()).getBySerialForSinc(serialForSinc);
    }

    @Override
    public Pedido getBySerialForSync(String serialForSinc) {
        return ((DaoPedidoImpl)this.getGenericDao()).getBySerialForSinc(serialForSinc);
    }

    @Override
    public Pedido getObjectIfExists(Object aux) {
        if (aux instanceof String) {
            return this.getBySerial((String)aux);
        }
        if (aux instanceof DTOPedido) {
            return this.getBySerial(((DTOPedido)aux).getSerialForSync());
        }
        if (aux instanceof DTOPedido) {
            return (Pedido)this.get(((DTOPedido)aux).getIdentificadorERP());
        }
        if (aux instanceof DTOPedidoV2) {
            return this.getBySerial(((DTOPedidoV2)aux).getSerialForSync());
        }
        if (aux instanceof DTOPedidoV3) {
            return this.getBySerial(((DTOPedidoV3)aux).getSerialForSync());
        }
        if (aux instanceof DTOPedidoV4) {
            return this.getBySerial(((DTOPedidoV4)aux).getSerialForSync());
        }
        if (aux instanceof DTOPedidoV5) {
            return this.getBySerial(((DTOPedidoV5)aux).getSerialForSync());
        }
        if (aux instanceof DTOPedidoV6) {
            return this.getBySerial(((DTOPedidoV6)aux).getSerialForSync());
        }
        if (aux instanceof DTOPedidoV7) {
            return this.getBySerial(((DTOPedidoV7)aux).getSerialForSync());
        }
        if (aux instanceof DTOPedidoV8) {
            return this.getBySerial(((DTOPedidoV8)aux).getSerialForSync());
        }
        if (aux instanceof DTOPedidoV9) {
            return this.getBySerial(((DTOPedidoV9)aux).getSerialForSync());
        }
        return this.getBySerial(((DTOPedidoV10)aux).getSerialForSync());
    }

    @Override
    public List<Pedido> getAllPedidosPreVenda(Long idSituacaoPedido, Long idEmpresa) {
        return ((DaoPedidoImpl)this.getGenericDao()).getAllPedidosPreVenda(idSituacaoPedido, idEmpresa);
    }

    @Override
    public List<Pedido> findPedidosPreVendaGeral(String aux, Long idEmpresa) {
        return this.findPedidosPreVenda(aux, null, idEmpresa);
    }

    @Override
    public List<Pedido> findPedidosPreVenda(String aux, Long idSituacaoPedido, Long idEmpresa) {
        LinkedList<Pedido> pedidos = new LinkedList<Pedido>();
        if (aux == null || aux.isEmpty()) {
            return pedidos;
        }
        if (ToolString.isAIntegerNumber((String)aux)) {
            pedidos.addAll(((DaoPedidoImpl)this.getGenericDao()).getPedidosByIdentificador(idEmpresa, Long.valueOf(aux), idSituacaoPedido));
        } else if (ToolString.isADoubleNumber((String)aux)) {
            pedidos.addAll(((DaoPedidoImpl)this.getGenericDao()).getPedidosByValor(idEmpresa, Double.valueOf(aux), idSituacaoPedido));
        } else if (ToolString.isADateClassic((String)aux, (String)"dd/MM/yyyy")) {
            if (aux.length() == 10) {
                Date data = ToolDate.strToDate((String)aux);
                pedidos.addAll(((DaoPedidoImpl)this.getGenericDao()).getPedidosByDateEmissao(idEmpresa, data, idSituacaoPedido));
            }
        } else {
            String cli = "cli:";
            String rep = "rep:";
            String obs = "obs:";
            if (aux.startsWith(cli)) {
                aux = aux.substring(cli.length());
                pedidos.addAll(((DaoPedidoImpl)this.getGenericDao()).getPedidossByCliente(idEmpresa, aux, idSituacaoPedido, 2000));
            }
            if (aux.startsWith(rep)) {
                aux = aux.substring(rep.length());
                pedidos.addAll(((DaoPedidoImpl)this.getGenericDao()).getPedidossByRepresentante(idEmpresa, aux, idSituacaoPedido, 2000));
            }
            if (aux.startsWith(obs)) {
                aux = aux.substring(obs.length());
                pedidos.addAll(((DaoPedidoImpl)this.getGenericDao()).getPedidossByObs(idEmpresa, aux, idSituacaoPedido, 2000));
            }
        }
        ArrayList<Pedido> pedidosNaoFaturados = new ArrayList<Pedido>();
        for (Pedido pedido : pedidos) {
            if (!ToolMethods.isWithData((Collection)pedido.getExpedicao())) {
                pedidosNaoFaturados.add(pedido);
                continue;
            }
            Expedicao e = (Expedicao)pedido.getExpedicao().get(0);
            if (e.getNotaFiscalPropria() != null) continue;
            pedidosNaoFaturados.add(pedido);
        }
        return pedidosNaoFaturados;
    }

    @Override
    public boolean updateSituacaoPedidoBySerialForSync(String serialForSync, Long isSituacao) {
        return ((DaoPedidoImpl)this.getGenericDao()).updateSituacaoPedidoSerialForSync(isSituacao, serialForSync);
    }

    public boolean updateSituacaoPedidoByIdentificador(Long idPedido, Long idSituacao) {
        return ((DaoPedidoImpl)this.getGenericDao()).updateSituacaoPedidoIdentificador(idSituacao, idPedido);
    }

    public void atualizarSitPedidoSubOSLinha(OrdemServicoProdLinhaProd ordemServicoProdLinhaProd) {
        if (!this.helperOrdemServicoLinhaProd.build(ordemServicoProdLinhaProd).osFechada().booleanValue()) {
            return;
        }
        OpcoesPCP op = this.getSharedData().getOpcoesPCP(ordemServicoProdLinhaProd.getEmpresa());
        if (op == null) {
            return;
        }
        SituacaoPedidos sitOld = op.getSitPedidosPlanProd();
        SituacaoPedidos sitNew = op.getSitPedidosComProd();
        if (sitOld == null || sitNew == null) {
            return;
        }
        ((DaoPedidoImpl)this.getDao()).atualizarSitPedidoSubOSLinha(sitOld, sitNew, ordemServicoProdLinhaProd);
    }

    @Override
    public List<Pedido> getAllPedidosVendasFinanceiras(Long idEmpresa, Date dataInicial, Date dataFinal) {
        List<Pedido> aux = ((DaoPedidoImpl)this.getGenericDao()).getAllPedidosVendasFinanceiras(idEmpresa, dataInicial, dataFinal);
        return aux;
    }

    public Pedido getPedidoMobile(Long idMobile, Long usuarioIdentificador) {
        return ((DaoPedidoImpl)this.getDao()).getPedidoMobile(idMobile, usuarioIdentificador);
    }

    public Pedido getPedido(Empresa empresa, Long identificador) {
        return ((DaoPedidoImpl)this.getDao()).getPedido(empresa, identificador);
    }

    public void reservarEstoqueGerarNecessidade(Pedido ped, OpcoesFaturamento op, OpcoesCompraSuprimentos opCompra) throws ExceptionInvalidState {
        this.reservarEstoqueGerarNecessidade(ped, op, opCompra, op.getCentroEstoqueReserva());
    }

    public void reservarEstoqueGerarNecessidade(Pedido ped, OpcoesFaturamento op, OpcoesCompraSuprimentos opCompra, CentroEstoque cestReserva) throws ExceptionInvalidState {
        EnumConstantsMentorSimNao criarNec = EnumConstantsMentorSimNao.get((Object)op.getCriarNecessidadeCompra());
        SituacaoNecessidadeCompra sitNec = null;
        CentroCusto cc = null;
        if (criarNec == EnumConstantsMentorSimNao.SIM && opCompra != null) {
            cc = opCompra.getCentroCustoNecessidadeCompra();
            sitNec = opCompra.getSituacaoNecessidadeCadastro();
        }
        if (cestReserva == null) {
            cestReserva = op.getCentroEstoqueReserva();
        }
        this.reservarGerarNecCompra(ped, criarNec, op.getSituacaoPedidosNecessidade(), ped.getUsuario(), cc, sitNec, cestReserva, EnumConstOpFatTipoReservaEstPedido.get((Object)op.getTipoReservaEstoquePedido()));
    }

    public void reservarGerarNecCompra(Pedido pedidoNew, EnumConstantsMentorSimNao criarNecCompras, SituacaoPedidos sitGerarNec, Usuario usuario, CentroCusto centroCusto, SituacaoNecessidadeCompra sitNecCompra, CentroEstoque destino, EnumConstOpFatTipoReservaEstPedido tipoReserva) throws ExceptionInvalidState {
        ServicePedidoNecessidadeCompra servNec = this.getBean(ServicePedidoNecessidadeCompra.class);
        ServicePedidoReservaEstoque servRes = this.getBean(ServicePedidoReservaEstoque.class);
        servRes.reservarEstoque(pedidoNew, destino, usuario, tipoReserva);
        servNec.criarNecessidadeCompras(pedidoNew, criarNecCompras, sitGerarNec, usuario, centroCusto, sitNecCompra);
    }

    public Pedido getPedidoEmpresaNumeroPedidoCliente(Empresa empresa, UnidadeFatCliente unidadeFatCliente, String numeroPedidoCliente) {
        return ((DaoPedidoImpl)this.getGenericDao()).getPedidoEmpresaNumeroPedidoCliente(empresa, unidadeFatCliente, numeroPedidoCliente);
    }

    public void atualizaSitPedido(Pedido pedido, SituacaoPedidos situacaoPedidos) {
        if (pedido == null || situacaoPedidos == null) {
            return;
        }
        ((DaoPedidoImpl)this.getGenericDao()).atualizaSitPedido(pedido, situacaoPedidos);
    }

    public List<Pedido> pesquisarHistoricoVendasUltimosPedidos(Empresa empresa, Long idPedido, UnidadeFatCliente unidadeFatCliente, Integer numeroPedidosAvaliados) {
        return ((DaoPedidoImpl)this.getGenericDao()).pesquisarHistoricoVendasUltimosPedidos(empresa, idPedido, unidadeFatCliente, numeroPedidosAvaliados);
    }

    public SituacaoPedidos getSituacaoAtualPedido(Long idPedido) {
        return ((DaoPedidoImpl)this.getDao()).getSituacaoAtualPedido(idPedido);
    }

    public double getValorPedidosAberto(Long idPessoa) {
        return ((DaoPedidoImpl)this.getDao()).getValorPedidosEmAberto(idPessoa);
    }

    public double getValorPedidosAberto(Pessoa pessoa) {
        if (pessoa == null) {
            return 0.0;
        }
        return ((DaoPedidoImpl)this.getDao()).getValorPedidosEmAberto(pessoa.getIdentificador());
    }

    public void sendPedidoEmail(DTOBusinessIntelligenceSendEmail det) throws ExceptionBuildBI, ExceptionInvalidData, ExceptionEmail, ExceptionReflection {
        ServiceBusinessIntelligenceImpl serviceBI = (ServiceBusinessIntelligenceImpl)ConfApplicationContext.getBean(ServiceBusinessIntelligenceImpl.class);
        ServiceServidorEmailImpl serviceServidorEmail = (ServiceServidorEmailImpl)ConfApplicationContext.getBean(ServiceServidorEmailImpl.class);
        ServiceModeloEmailImpl serviceModeloEmail = (ServiceModeloEmailImpl)ConfApplicationContext.getBean(ServiceModeloEmailImpl.class);
        ServiceEmpresaImpl serviceEmpresa = (ServiceEmpresaImpl)ConfApplicationContext.getBean(ServiceEmpresaImpl.class);
        ServiceUsuarioImpl serviceUsuario = (ServiceUsuarioImpl)ConfApplicationContext.getBean(ServiceUsuarioImpl.class);
        ServiceBuildBusinessIntelligenceImpl serviceBuild = (ServiceBuildBusinessIntelligenceImpl)ConfApplicationContext.getBean(ServiceBuildBusinessIntelligenceImpl.class);
        CompEmailPedido compEmail = (CompEmailPedido)ConfApplicationContext.getBean(CompEmailPedido.class);
        BusinessIntelligence bi = (BusinessIntelligence)serviceBI.get(det.getIdBusinessIntegelligenc());
        ServidorEmail serv = (ServidorEmail)serviceServidorEmail.get(det.getIdServidorEmail());
        ModeloEmail mod = (ModeloEmail)serviceModeloEmail.get(det.getIdModeloEmail());
        Empresa empresa = (Empresa)serviceEmpresa.get(det.getIdEmpresa());
        Usuario usuario = (Usuario)serviceUsuario.get(det.getIdUsuario());
        Grupo grupo = this.serviceUsuarioEmpresa.getByUserEmpresa(usuario, empresa).getGrupo();
        String emails = det.getEmails();
        Long idEntity = det.getIdObject();
        compEmail.enviarPedidoMobile(bi, serv, mod, empresa, usuario, grupo, (Pedido)this.get(idEntity), emails);
    }

    public void calcularValoresPrecoComissao(Pedido pedido, OpcoesFaturamento opcoesFaturamento) throws ExceptionAvaliadorExpressoes, ExceptionCalcPrecosProduto {
        for (ItemPedido itemPedido : pedido.getItemPedido()) {
            this.serviceItemPedido.calcularValoresComissao(itemPedido, opcoesFaturamento, pedido.getUnidadeFatCliente(), pedido.getRepresentante(), pedido.getCondicoesPagamento(), pedido.getCondPagMut(), pedido.getEmpresa(), pedido.getNaturezaOperacao(), pedido.getUsuario());
        }
    }

    public DTOPedido calcularTotalizadores(DTOPedido input, OpcoesFaturamento opcoes, OpcoesContabeis opcoesContabeis) throws ExceptionReflection, ExceptionImpostoPisCofins, ExceptionImpostoIPI, ExceptionImpostoIcms {
        ToolDTOBuilder builder = this.getDefaultDtoBuilder(input.getClass());
        Pedido p = (Pedido)builder.toEntity((Object)input);
        this.helperPedido.build(p).calcularValoresPedido(opcoes, opcoesContabeis);
        return (DTOPedido)builder.toDTO((Object)p);
    }

    public void criarTitulos(Pedido vo, OpcoesFinanceiras opcoesFinanceiras, OpcoesContabeis opcoesContabeis) throws ExceptionTitulo, ExceptionInvalidData {
        this.compGeracaoTitulos.gerarTitulos(vo, opcoesFinanceiras, opcoesContabeis);
    }

    public Pedido criarTitulos(DTOPedido dto, OpcoesFinanceiras opcoesFinanceiras, OpcoesContabeis opcoesContabeis) throws ExceptionTitulo, ExceptionInvalidData {
        Pedido vo = (Pedido)this.buildToEntity(dto);
        this.compGeracaoTitulos.gerarTitulos(vo, opcoesFinanceiras, opcoesContabeis);
        return vo;
    }

    public ValidCrudPedidoImpl cancelarPedido(DTOCancelarPedido input, Usuario usuarioCanc) throws ExceptionObjNotFound {
        Pedido p = (Pedido)this.getOrThrow(input.getPedidoIdentificador());
        this.validCrudPedido.clearContainer();
        this.validCrudPedido.isValidData((InterfaceVO)p, EnumConstCRUD.UPDATE);
        if (this.validCrudPedido.hasErrors()) {
            return this.validCrudPedido;
        }
        p.setSituacaoPedido((SituacaoPedidos)this.serviceSituacaoPedidosImpl.getOrThrow(input.getSituacaoPedidoIdentificador()));
        p.setUsuarioCancelamento(usuarioCanc);
        p.setMotivoCancelamento(input.getMotivoCancelamento());
        p.setDataCancelamento(new Date());
        this.saveOrUpdate(p);
        return this.validCrudPedido;
    }

    public DTOPedido.DTOObservacaoPedidoFaturamento novaObservacaoFaturamento(Long identificador) throws ExceptionObjNotFound {
        ObsFaturamento obs = (ObsFaturamento)this.serviceObsFaturamento.getOrThrow(identificador);
        ObservacaoPedidoFaturamento vo = new ObservacaoPedidoFaturamento();
        vo.setObservacaoFaturamento(obs);
        return this.buildToDTOGeneric(vo, DTOPedido.DTOObservacaoPedidoFaturamento.class);
    }

    public List<TempManutencaoSituacaoPedidos> findManutencaoPed(Date dataInicial, Date dataFinal, EnumConstFiltroGrupoSituacaoRota filter, Object filterValue, Short tipoData, Empresa empresa, Representante representante, Short filtrarData, Transportador transportadorInicial, Transportador transportadorFinal, RamoAtividade ramoAtividadeInicial, RamoAtividade ramoAtividadeFinal, Long idPedidoCodBarras) {
        List<TempManutencaoSituacaoPedidos> result = ((DaoPedidoImpl)this.getGenericDao()).findManutencaoPed(dataInicial, dataFinal, filter, filterValue, tipoData, empresa, representante, filtrarData, transportadorInicial, transportadorFinal, ramoAtividadeInicial, ramoAtividadeFinal, idPedidoCodBarras);
        for (TempManutencaoSituacaoPedidos p : result) {
            List<TempManutencaoSituacaoPedidos.TempManutencaoSituacaoPedidosExp> expedicoes = this.serviceExpedicao.findExpedicoesPedido(p.getIdentificador());
            p.setExpedicoes(expedicoes);
            int nrConferida = 0;
            int nrNotas = 0;
            for (TempManutencaoSituacaoPedidos.TempManutencaoSituacaoPedidosExp exp : expedicoes) {
                if (ToolMethods.isAffirmative((Number)exp.getConferida())) {
                    ++nrConferida;
                }
                if (!ToolMethods.isNotNull((Object)exp.getNumeroNota()).booleanValue()) continue;
                ++nrNotas;
            }
            p.setQtdNotas(Integer.valueOf(nrNotas));
            p.setQtdNotasConferidas(Integer.valueOf(nrConferida));
        }
        return result;
    }

    public DTODadosFaturamentoPedido consultarFaturamentoPedido(Long identificadorPedido) throws ExceptionObjNotFound {
        Pedido pedido = (Pedido)this.getOrThrow(identificadorPedido);
        DTODadosFaturamentoPedido dto = new DTODadosFaturamentoPedido();
        dto.setIdentificador(pedido.getIdentificador());
        dto.setIdentificadorCliente(pedido.getUnidadeFatCliente().getCliente().getIdentificador());
        dto.setNomeCliente(pedido.getUnidadeFatCliente().getCliente().getPessoa().getNome());
        dto.setNrPedido(pedido.getNrPedidoCliente());
        List<TempManutencaoSituacaoPedidos.TempManutencaoSituacaoPedidosExp> expedicoes = this.serviceExpedicao.findExpedicoesPedido(identificadorPedido);
        if (ServicePedidoImpl.isWithData(expedicoes)) {
            for (TempManutencaoSituacaoPedidos.TempManutencaoSituacaoPedidosExp i : expedicoes) {
                DTODadosFaturamentoPedido.DTOExpedicoesPedido e = new DTODadosFaturamentoPedido.DTOExpedicoesPedido();
                e.setIdentificadorExpedicao(i.getIdentificador());
                e.setIdentificadorNota(i.getIdentificadorNotaPropria());
                e.setNumeroNota(i.getNumeroNota());
                e.setSerie(i.getSerie());
                dto.getExpedicoes().add(e);
            }
        }
        return dto;
    }
}

