/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.pedido;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.EmailGrupoNecCompra;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.GradeItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.ItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.SituacaoNecessidadeCompra;
import com.touchcomp.basementor.model.vo.SituacaoPedidos;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ServicePedidoNecessidadeCompra {
    public void criarNecessidadeCompras(Pedido pedidoNew, EnumConstantsMentorSimNao criarNecCompras, SituacaoPedidos sitGerarNec, Usuario usuario, CentroCusto centroCusto, SituacaoNecessidadeCompra sitNecCompra) {
        if (pedidoNew.getSituacaoPedido() != null && pedidoNew.getSituacaoPedido().getBloqueioReservaEstoque().equals((short)1)) {
            this.cancelarNecComprasSePossivel(pedidoNew);
            return;
        }
        if (criarNecCompras != EnumConstantsMentorSimNao.SIM) {
            return;
        }
        if (pedidoNew.getExpedicao() != null && !pedidoNew.getExpedicao().isEmpty()) {
            return;
        }
        if (pedidoNew.getSituacaoPedido().getCancelarTitulos() != null && pedidoNew.getSituacaoPedido().getCancelarTitulos().equals((short)1)) {
            this.cancelarNecComprasSePossivel(pedidoNew);
        }
        HashMap<GradeCor, ItemReservaNecessidade> hash = new HashMap<GradeCor, ItemReservaNecessidade>();
        this.buildHashItens(hash, pedidoNew);
        this.buildHashNecessidade(hash, pedidoNew);
        this.buildHashTransf(hash, pedidoNew);
        this.gerarNecessidades(pedidoNew, hash, usuario, centroCusto, sitNecCompra);
        this.limparNecessidadesVazias(pedidoNew);
        if (pedidoNew.getNecessidadesCompra().size() > 0 && sitGerarNec != null) {
            pedidoNew.setSituacaoPedido(sitGerarNec);
        }
    }

    private void buildHashTransf(HashMap<GradeCor, ItemReservaNecessidade> hash, Pedido pedidoNew) {
        if (pedidoNew.getTransferencias() == null) {
            return;
        }
        for (TransferenciaCentroEstoque t : pedidoNew.getTransferencias()) {
            for (ItemTransfCentroEstoque i : t.getItemTransfCentroEstoque()) {
                for (GradeItemTransfCentroEstoque g : i.getGradeItemTransCentroEst()) {
                    ItemReservaNecessidade itemReserva;
                    if (hash.get(g.getGradeCor()) != null) {
                        itemReserva = hash.get(g.getGradeCor());
                    } else {
                        itemReserva = new ItemReservaNecessidade();
                        itemReserva.setCentroEstoqueOrigem(i.getOrigem());
                        itemReserva.setGradeCor(g.getGradeCor());
                        itemReserva.setDataMovimentacao(g.getDataTransferencia());
                        hash.put(g.getGradeCor(), itemReserva);
                    }
                    itemReserva.setQtdeReservada(itemReserva.getQtdeReservada() + g.getQuantidade());
                }
            }
        }
    }

    private void buildHashNecessidade(HashMap<GradeCor, ItemReservaNecessidade> hash, Pedido pedidoNew) {
        if (pedidoNew.getTransferencias() == null) {
            return;
        }
        for (NecessidadeCompra g : pedidoNew.getNecessidadesCompra()) {
            ItemReservaNecessidade itemReserva;
            if (hash.get(g.getGradeCor()) != null) {
                itemReserva = hash.get(g.getGradeCor());
            } else {
                itemReserva = new ItemReservaNecessidade();
                itemReserva.setGradeCor(g.getGradeCor());
                hash.put(g.getGradeCor(), itemReserva);
            }
            itemReserva.setQtdeNecessidade(itemReserva.getQtdeReservada() + g.getQuantidadeNecessidade());
        }
    }

    private void buildHashItens(HashMap<GradeCor, ItemReservaNecessidade> hash, Pedido pedidoNew) {
        for (ItemPedido i : pedidoNew.getItemPedido()) {
            for (GradeItemPedido g : i.getGradeItemPedido()) {
                ItemReservaNecessidade itemReserva;
                if (ToolMethods.isAffirmative((Number)g.getMovimentacaoFisica())) continue;
                if (hash.get(g.getGradeCor()) != null) {
                    itemReserva = hash.get(g.getGradeCor());
                } else {
                    itemReserva = new ItemReservaNecessidade();
                    itemReserva.setCentroEstoqueOrigem(g.getItemPedido().getCentroEstoque());
                    itemReserva.setGradeCor(g.getGradeCor());
                    itemReserva.setDataMovimentacao(g.getItemPedido().getPedido().getDataEmissao());
                    hash.put(g.getGradeCor(), itemReserva);
                }
                itemReserva.setQuantidade(itemReserva.getQuantidade() + g.getQuantidade());
            }
        }
    }

    private void gerarNecessidades(Pedido pedidoNew, HashMap<GradeCor, ItemReservaNecessidade> hash, Usuario usuario, CentroCusto centroCusto, SituacaoNecessidadeCompra sitNecCompra) {
        Set<GradeCor> keys = hash.keySet();
        for (GradeCor key : keys) {
            ItemReservaNecessidade item = hash.get(key);
            Double qtdNecessidade = item.getQuantidade() - item.getQtdeReservada() - item.getQtdeNecessidade();
            if (qtdNecessidade > 0.0) {
                this.criarNecessidade(pedidoNew, key, usuario, qtdNecessidade, centroCusto, sitNecCompra);
                continue;
            }
            this.removerQtdNecessidade(pedidoNew, qtdNecessidade);
        }
    }

    private void criarNecessidade(Pedido pedidoNew, GradeCor grade, Usuario usuario, Double quantidade, CentroCusto centroCusto, SituacaoNecessidadeCompra sitNecCompra) {
        NecessidadeCompra n = new NecessidadeCompra();
        n.setDataCadastro(new Date());
        n.setEmpresa(pedidoNew.getEmpresa());
        n.setDataNecessidade(new Date());
        n.setDesativarNecessidade(Short.valueOf((short)0));
        n.setObservacao("Necessidade Gerada a partir de um Pedido Clientes");
        n.setGradeCor(grade);
        n.setUsuarioSolicitante(usuario);
        n.setNaturezaOperacao(n.getGradeCor().getProdutoGrade().getProduto().getTipoIemSped().getNaturezaOperacaoNecCompra());
        n.setTipoGeracao(Short.valueOf((short)1));
        n.setTipoNecessidade(Short.valueOf((short)0));
        n.setEstoqueMinimo(Double.valueOf(0.0));
        n.setEstoqueRessuprimento(Double.valueOf(0.0));
        n.setEstoqueMaximo(Double.valueOf(0.0));
        n.setEstoque(Double.valueOf(0.0));
        n.setQuantidadeComprada(Double.valueOf(0.0));
        n.setQuantidadeNecessidadeGerada(Double.valueOf(0.0));
        n.setQuantidadeAdicional(quantidade);
        n.setQuantidadeNecessidade(quantidade);
        n.setPedido(pedidoNew);
        String emailUsuaio = usuario.getUsuarioBasico().getPessoa().getComplemento().getEmailPrincipal();
        if (emailUsuaio != null && emailUsuaio.trim().length() > 0) {
            EmailGrupoNecCompra email = new EmailGrupoNecCompra();
            email.setNecessidadeCompra(n);
            email.setEmail(emailUsuaio);
            n.getEmailGrupoNecCompra().add(email);
        }
        n.setCentroCusto(centroCusto);
        n.setSituacaoNecessidadeCompra(sitNecCompra);
        pedidoNew.getNecessidadesCompra().add(n);
    }

    private void removerQtdNecessidade(Pedido pedidoNew, Double qtdNecessidade) {
        for (NecessidadeCompra g : pedidoNew.getNecessidadesCompra()) {
            g.setQuantidadeNecessidade(Double.valueOf(g.getQuantidadeNecessidade() + qtdNecessidade));
            if (g.getQuantidadeNecessidade() >= 0.0) {
                qtdNecessidade = 0.0;
                break;
            }
            qtdNecessidade = g.getQuantidadeNecessidade();
            g.setQuantidadeNecessidade(Double.valueOf(0.0));
        }
    }

    private void limparNecessidadesVazias(Pedido pedidoNew) {
        pedidoNew.getNecessidadesCompra().removeIf(i -> i.getQuantidadeNecessidade() <= 0.0);
    }

    private void cancelarNecComprasSePossivel(Pedido pedidoNew) {
        LinkedList<NecessidadeCompra> temp = new LinkedList<NecessidadeCompra>();
        for (NecessidadeCompra n : pedidoNew.getNecessidadesCompra()) {
            if (n.getItemCotacaoCompraGerada() == null) continue;
            temp.add(n);
        }
        pedidoNew.getNecessidadesCompra().removeAll(temp);
    }

    static class ItemReservaNecessidade {
        private GradeCor gradeCor;
        private Double qtdeNecessidade = 0.0;
        private Double qtdeReservada = 0.0;
        private Double quantidade = 0.0;
        private CentroEstoque centroEstoqueOrigem;
        private Date dataMovimentacao;

        @Generated
        public GradeCor getGradeCor() {
            return this.gradeCor;
        }

        @Generated
        public Double getQtdeNecessidade() {
            return this.qtdeNecessidade;
        }

        @Generated
        public Double getQtdeReservada() {
            return this.qtdeReservada;
        }

        @Generated
        public Double getQuantidade() {
            return this.quantidade;
        }

        @Generated
        public CentroEstoque getCentroEstoqueOrigem() {
            return this.centroEstoqueOrigem;
        }

        @Generated
        public Date getDataMovimentacao() {
            return this.dataMovimentacao;
        }

        @Generated
        public void setGradeCor(GradeCor gradeCor) {
            this.gradeCor = gradeCor;
        }

        @Generated
        public void setQtdeNecessidade(Double qtdeNecessidade) {
            this.qtdeNecessidade = qtdeNecessidade;
        }

        @Generated
        public void setQtdeReservada(Double qtdeReservada) {
            this.qtdeReservada = qtdeReservada;
        }

        @Generated
        public void setQuantidade(Double quantidade) {
            this.quantidade = quantidade;
        }

        @Generated
        public void setCentroEstoqueOrigem(CentroEstoque centroEstoqueOrigem) {
            this.centroEstoqueOrigem = centroEstoqueOrigem;
        }

        @Generated
        public void setDataMovimentacao(Date dataMovimentacao) {
            this.dataMovimentacao = dataMovimentacao;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemReservaNecessidade)) {
                return false;
            }
            ItemReservaNecessidade other = (ItemReservaNecessidade)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$qtdeNecessidade = this.getQtdeNecessidade();
            Double other$qtdeNecessidade = other.getQtdeNecessidade();
            if (this$qtdeNecessidade == null ? other$qtdeNecessidade != null : !((Object)this$qtdeNecessidade).equals(other$qtdeNecessidade)) {
                return false;
            }
            Double this$qtdeReservada = this.getQtdeReservada();
            Double other$qtdeReservada = other.getQtdeReservada();
            if (this$qtdeReservada == null ? other$qtdeReservada != null : !((Object)this$qtdeReservada).equals(other$qtdeReservada)) {
                return false;
            }
            Double this$quantidade = this.getQuantidade();
            Double other$quantidade = other.getQuantidade();
            if (this$quantidade == null ? other$quantidade != null : !((Object)this$quantidade).equals(other$quantidade)) {
                return false;
            }
            GradeCor this$gradeCor = this.getGradeCor();
            GradeCor other$gradeCor = other.getGradeCor();
            if (this$gradeCor == null ? other$gradeCor != null : !this$gradeCor.equals(other$gradeCor)) {
                return false;
            }
            CentroEstoque this$centroEstoqueOrigem = this.getCentroEstoqueOrigem();
            CentroEstoque other$centroEstoqueOrigem = other.getCentroEstoqueOrigem();
            if (this$centroEstoqueOrigem == null ? other$centroEstoqueOrigem != null : !this$centroEstoqueOrigem.equals(other$centroEstoqueOrigem)) {
                return false;
            }
            Date this$dataMovimentacao = this.getDataMovimentacao();
            Date other$dataMovimentacao = other.getDataMovimentacao();
            return !(this$dataMovimentacao == null ? other$dataMovimentacao != null : !((Object)this$dataMovimentacao).equals(other$dataMovimentacao));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ItemReservaNecessidade;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $qtdeNecessidade = this.getQtdeNecessidade();
            result = result * 59 + ($qtdeNecessidade == null ? 43 : ((Object)$qtdeNecessidade).hashCode());
            Double $qtdeReservada = this.getQtdeReservada();
            result = result * 59 + ($qtdeReservada == null ? 43 : ((Object)$qtdeReservada).hashCode());
            Double $quantidade = this.getQuantidade();
            result = result * 59 + ($quantidade == null ? 43 : ((Object)$quantidade).hashCode());
            GradeCor $gradeCor = this.getGradeCor();
            result = result * 59 + ($gradeCor == null ? 43 : $gradeCor.hashCode());
            CentroEstoque $centroEstoqueOrigem = this.getCentroEstoqueOrigem();
            result = result * 59 + ($centroEstoqueOrigem == null ? 43 : $centroEstoqueOrigem.hashCode());
            Date $dataMovimentacao = this.getDataMovimentacao();
            result = result * 59 + ($dataMovimentacao == null ? 43 : ((Object)$dataMovimentacao).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ServicePedidoNecessidadeCompra.ItemReservaNecessidade(gradeCor=" + String.valueOf(this.getGradeCor()) + ", qtdeNecessidade=" + this.getQtdeNecessidade() + ", qtdeReservada=" + this.getQtdeReservada() + ", quantidade=" + this.getQuantidade() + ", centroEstoqueOrigem=" + String.valueOf(this.getCentroEstoqueOrigem()) + ", dataMovimentacao=" + String.valueOf(this.getDataMovimentacao()) + ")";
        }
    }
}

