/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.pedido;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFatResEstoquePed;
import com.touchcomp.basementor.constants.enums.opcoesfaturamento.EnumConstOpFatTipoReservaEstPedido;
import com.touchcomp.basementor.constants.enums.produto.EnumConstProdutoOpcoesOp;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.GradeItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.ItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.helpers.impl.produto.HelperProduto;
import com.touchcomp.basementorservice.helpers.impl.transferenciacentroestoque.HelperTransferenciaCentroEstoque;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.clone.ToolClone;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
class ServicePedidoReservaEstoque {
    @Autowired
    ServiceSaldoEstoqueImpl serviceSaldoEstoque;
    @Autowired
    HelperTransferenciaCentroEstoque helperTransf;
    @Autowired
    HelperProduto helperProduto;

    ServicePedidoReservaEstoque() {
    }

    public void reservarEstoque(Pedido pedidoNew, CentroEstoque destino, Usuario usuario, EnumConstOpFatTipoReservaEstPedido tipoReservaEst) throws ExceptionInvalidState {
        LinkedList<String> warnings = new LinkedList<String>();
        if (!this.pedidoValidoParaReserva(pedidoNew)) {
            return;
        }
        if (ToolMethods.isEquals((Object)0, (Object)pedidoNew.getReservarEstoque())) {
            this.cancelarReservas(pedidoNew);
            return;
        }
        if (ToolMethods.isEquals((Object)EnumConstOpFatResEstoquePed.RESERVAR_BAIXA_EFETIVA.getValue(), (Object)pedidoNew.getModoReservaEstoque()) || ToolMethods.isEquals((Object)EnumConstOpFatResEstoquePed.RESERVAR_BAIXA_EFETIVA_PRODUTO.getValue(), (Object)pedidoNew.getModoReservaEstoque())) {
            try {
                this.baixarEfetivamenteEstoque(pedidoNew, warnings, destino);
            }
            catch (ExceptionReflection ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
                throw new ExceptionInvalidState("E.ERP.1180.002", new Object[]{this.formatWarnings(warnings)});
            }
        } else {
            this.reservarEstoqueTransferencia(pedidoNew, destino, tipoReservaEst, warnings);
        }
        if (!warnings.isEmpty() && ToolMethods.isEquals((Object)tipoReservaEst, (Object)EnumConstOpFatTipoReservaEstPedido.BLOQUEAR_CASO_QTD_INSUFICIENTE)) {
            throw new ExceptionInvalidState("E.ERP.1180.002", new Object[]{this.formatWarnings(warnings)});
        }
    }

    private boolean pedidoValidoParaReserva(Pedido pedidoNew) {
        if (ToolMethods.isEquals((Object)pedidoNew.getSituacaoPedido().getBloqueioReservaEstoque(), (Object)1)) {
            this.cancelarReservas(pedidoNew);
            return false;
        }
        if (pedidoNew.getSituacaoPedido().getCancelarTitulos() != null && pedidoNew.getSituacaoPedido().getCancelarTitulos().equals((short)1)) {
            pedidoNew.getTransferencias().clear();
            pedidoNew.setTransferencias(new ArrayList());
            return false;
        }
        return true;
    }

    private void reservarEstoqueTransferencia(Pedido pedidoNew, CentroEstoque destino, EnumConstOpFatTipoReservaEstPedido tipoReservaEst, List<String> warnings) {
        this.removerTransferenciasNaoSalvas(pedidoNew);
        HashMap<String, ItemReserva> hash = new HashMap<String, ItemReserva>();
        this.buildHashTransf(hash, pedidoNew);
        this.buildHashItens(hash, pedidoNew);
        this.criarTransferencia(hash, pedidoNew, destino, warnings);
    }

    private String formatWarnings(List<String> warnings) {
        Object st = "";
        for (String str : warnings) {
            st = (String)st + str + "\n";
        }
        return st;
    }

    private List<SaldoEstoqueGeral> findSaldosPorLotesFabricacaoAbertos(GradeCor gradeCor, Empresa emp, CentroEstoque centroEstoque, Date dataPedido) {
        Produto produto = gradeCor != null ? gradeCor.getProdutoGrade().getProduto() : null;
        EnumConstCentroEstDisponibilidade disponibilidade = centroEstoque != null ? EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS : EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_DISPONIVEL;
        return this.serviceSaldoEstoque.findSaldoGradeCentroEstoqueLoteLista(produto, produto, gradeCor, gradeCor, dataPedido, emp, emp, null, centroEstoque, centroEstoque, disponibilidade, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_LOTE_FABRICACAO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_MAIOR_0, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_SOMENTE_QTD);
    }

    private void removerTransferenciasNaoSalvas(Pedido pedidoNew) {
        ArrayList<TransferenciaCentroEstoque> transferencias = new ArrayList<TransferenciaCentroEstoque>();
        for (TransferenciaCentroEstoque t : pedidoNew.getTransferencias()) {
            if (t.getIdentificador() == null || t.getIdentificador() <= 0L) continue;
            transferencias.add(t);
        }
        pedidoNew.setTransferencias(transferencias);
    }

    private void buildHashTransf(HashMap<String, ItemReserva> hash, Pedido pedidoNew) {
        if (pedidoNew.getTransferencias() == null) {
            return;
        }
        for (TransferenciaCentroEstoque t : pedidoNew.getTransferencias()) {
            for (ItemTransfCentroEstoque i : t.getItemTransfCentroEstoque()) {
                for (GradeItemTransfCentroEstoque g : i.getGradeItemTransCentroEst()) {
                    ItemReserva itemReserva;
                    String key = this.getKeyMap(g);
                    if (hash.get(key) != null) {
                        itemReserva = hash.get(key);
                    } else {
                        itemReserva = new ItemReserva();
                        itemReserva.setCentroEstoqueOrigem(i.getOrigem());
                        itemReserva.setGradeCor(g.getGradeCor());
                        itemReserva.setDataMovimentacao(g.getDataTransferencia());
                        hash.put(key, itemReserva);
                    }
                    itemReserva.setQtdeOld(itemReserva.getQtdeOld() + g.getQuantidade());
                }
            }
        }
    }

    private String getKeyMap(GradeItemTransfCentroEstoque i) {
        Object key = "";
        if (i.getGradeCor() != null) {
            key = (String)key + i.getGradeCor().getIdentificador();
        }
        key = (String)key + "-";
        if (i.getOrigem() != null) {
            key = (String)key + i.getOrigem().getIdentificador();
        }
        return key;
    }

    private String getKeyMap(GradeItemPedido i) {
        Object key = "";
        if (i.getGradeCor() != null) {
            key = (String)key + i.getGradeCor().getIdentificador();
        }
        key = (String)key + "-";
        if (i.getItemPedido().getCentroEstoque() != null) {
            key = (String)key + i.getItemPedido().getCentroEstoque().getIdentificador();
        }
        return key;
    }

    private EnumConstantsMentorSimNao reservarProduto(Pedido pedidoNew, Produto produto) {
        if (ToolMethods.isEquals((Object)EnumConstOpFatResEstoquePed.NAO_RESERVAR.getValue(), (Object)pedidoNew.getModoReservaEstoque())) {
            return EnumConstantsMentorSimNao.NAO;
        }
        if (ToolMethods.isEquals((Object)EnumConstOpFatResEstoquePed.RESERVAR_BAIXA_EFETIVA_PRODUTO.getValue(), (Object)pedidoNew.getModoReservaEstoque()) || ToolMethods.isEquals((Object)EnumConstOpFatResEstoquePed.RESERVAR_TRANSFERENCIA_ESTOQUE_PRODUTO.getValue(), (Object)pedidoNew.getModoReservaEstoque())) {
            if (!CompOpcoes.isAffirmative(this.helperProduto.build(produto).getItens(), (EnumOpDinamicasInterface)EnumConstProdutoOpcoesOp.RESERVAR_ESTOQUE_FATURAR_PRODUTO_DV)) {
                return EnumConstantsMentorSimNao.NAO;
            }
            return EnumConstantsMentorSimNao.SIM;
        }
        return EnumConstantsMentorSimNao.SIM;
    }

    private void buildHashItens(HashMap<String, ItemReserva> hash, Pedido pedidoNew) {
        for (ItemPedido i : pedidoNew.getItemPedido()) {
            for (GradeItemPedido g : i.getGradeItemPedido()) {
                ItemReserva itemReserva;
                if (!ToolMethods.isEquals((Object)this.reservarProduto(pedidoNew, g.getGradeCor().getProdutoGrade().getProduto()), (Object)EnumConstantsMentorSimNao.SIM) || !ToolMethods.isEquals((Object)g.getReservarEstoque(), (Object)1)) continue;
                String key = this.getKeyMap(g);
                if (hash.get(key) != null) {
                    itemReserva = hash.get(key);
                } else {
                    itemReserva = new ItemReserva();
                    itemReserva.setCentroEstoqueOrigem(g.getItemPedido().getCentroEstoque());
                    itemReserva.setGradeCor(g.getGradeCor());
                    itemReserva.setDataMovimentacao(g.getItemPedido().getPedido().getDataEmissao());
                    hash.put(key, itemReserva);
                }
                if (itemReserva == null) continue;
                itemReserva.setQtdeNew(itemReserva.getQtdeNew() + g.getQuantidade());
            }
        }
    }

    private void criarTransferencia(HashMap<String, ItemReserva> hash, Pedido pedidoNew, CentroEstoque destino, List<String> warnings) {
        Set<String> set = hash.keySet();
        Date dataReserva = new Date();
        ArrayList<GradeItemTransfCentroEstoque> gradesTransDif = new ArrayList<GradeItemTransfCentroEstoque>();
        for (String gc : set) {
            ItemReserva i2 = hash.get(gc);
            Double diferenca = ToolFormatter.arrredondarNumero((Double)(i2.getQtdeNew() - i2.getQtdeOld()), (int)6);
            if (diferenca > 0.0) {
                this.criarGradesTransferencias(gradesTransDif, i2.getGradeCor(), diferenca, pedidoNew.getEmpresa(), i2.getCentroEstoqueOrigem(), destino, dataReserva, warnings);
                continue;
            }
            if (!(diferenca < 0.0)) continue;
            this.removerDiferenca(pedidoNew, i2, diferenca);
        }
        for (GradeItemTransfCentroEstoque gi : gradesTransDif) {
            ItemTransfCentroEstoque item;
            TransferenciaCentroEstoque tr;
            Optional<TransferenciaCentroEstoque> foundTr = pedidoNew.getTransferencias().stream().filter(i -> ToolMethods.isEquals((Object)ToolDate.dataSemHora((Date)i.getDataTransferencia()), (Object)ToolDate.dataSemHora((Date)gi.getDataTransferencia()))).findFirst();
            if (foundTr.isPresent()) {
                tr = foundTr.get();
            } else {
                tr = this.criarTransferencia(pedidoNew, dataReserva);
                pedidoNew.getTransferencias().add(tr);
            }
            Optional<ItemTransfCentroEstoque> foundItem = tr.getItemTransfCentroEstoque().stream().filter(i -> ToolMethods.isEquals((Object)i.getDestino(), (Object)gi.getDestino()) && ToolMethods.isEquals((Object)i.getOrigem(), (Object)gi.getOrigem()) && ToolMethods.isEquals((Object)i.getProduto(), (Object)gi.getGradeCor().getProdutoGrade().getProduto())).findFirst();
            if (foundItem.isPresent()) {
                item = foundItem.get();
            } else {
                item = this.criarItemTransferencia(gi.getOrigem(), gi.getDestino(), gi.getGradeCor().getProdutoGrade().getProduto());
                tr.getItemTransfCentroEstoque().add(item);
            }
            Optional<GradeItemTransfCentroEstoque> foundGr = item.getGradeItemTransCentroEst().stream().filter(i -> ToolMethods.isEquals((Object)i.getGradeCor(), (Object)gi.getGradeCor()) && ToolMethods.isEquals((Object)i.getLoteFabricacao(), (Object)gi.getLoteFabricacao())).findFirst();
            if (foundGr.isPresent()) {
                foundGr.get().setQuantidade(Double.valueOf(foundGr.get().getQuantidade() + gi.getQuantidade()));
                continue;
            }
            gi.setItemTransfCentroEst(item);
            item.getGradeItemTransCentroEst().add(gi);
        }
        for (TransferenciaCentroEstoque transf : pedidoNew.getTransferencias()) {
            this.helperTransf.build(transf);
            this.helperTransf.limparItensZerados();
            this.helperTransf.normalizarDadosAntesSalvar();
        }
        pedidoNew.getTransferencias().removeIf(i -> i.getItemTransfCentroEstoque().isEmpty());
    }

    private TransferenciaCentroEstoque criarTransferencia(Pedido ped, Date dataTransferencia) {
        TransferenciaCentroEstoque tr = new TransferenciaCentroEstoque();
        tr.setDataCadastro(new Date());
        tr.setDataTransferencia(dataTransferencia);
        tr.setEmpresa(ped.getEmpresa());
        tr.setPedido(ped);
        return tr;
    }

    private ItemTransfCentroEstoque criarItemTransferencia(CentroEstoque origem, CentroEstoque destino, Produto produto) {
        ItemTransfCentroEstoque it = new ItemTransfCentroEstoque();
        it.setProduto(produto);
        it.setDestino(destino);
        it.setOrigem(origem);
        return it;
    }

    private void removerDiferenca(Pedido pedidoNew, ItemReserva item, Double diferenca) {
        for (TransferenciaCentroEstoque t : pedidoNew.getTransferencias()) {
            block1: for (ItemTransfCentroEstoque it : t.getItemTransfCentroEstoque()) {
                List found = it.getGradeItemTransCentroEst().stream().filter(i -> ToolMethods.isEquals((Object)i.getGradeCor(), (Object)item.getGradeCor())).collect(Collectors.toList());
                for (GradeItemTransfCentroEstoque g : found) {
                    g.setQuantidade(Double.valueOf(g.getQuantidade() + diferenca));
                    if (g.getQuantidade() >= 0.0) {
                        diferenca = 0.0;
                        continue block1;
                    }
                    diferenca = g.getQuantidade();
                    g.setQuantidade(Double.valueOf(0.0));
                }
            }
        }
    }

    private void baixarEfetivamenteEstoque(Pedido pedidoNew, List<String> warnings, CentroEstoque centroEstoque) throws ExceptionReflection {
        pedidoNew.getTransferencias().clear();
        for (ItemPedido item : pedidoNew.getItemPedido()) {
            if (centroEstoque != null) {
                item.setCentroEstoque(centroEstoque);
            }
            LinkedList novasGrades = new LinkedList();
            for (GradeItemPedido gr : item.getGradeItemPedido()) {
                if (!ToolMethods.isEquals((Object)this.reservarProduto(pedidoNew, gr.getGradeCor().getProdutoGrade().getProduto()), (Object)EnumConstantsMentorSimNao.SIM) || !ToolMethods.isEquals((Object)gr.getReservarEstoque(), (Object)1)) continue;
                if (gr.getCentroEstoque() == null || gr.getLoteFabricacao() == null) {
                    this.reservarGradeItem(novasGrades, item, gr, pedidoNew.getEmpresa(), warnings, centroEstoque);
                }
                gr.setMovimentacaoFisica(Short.valueOf((short)1));
            }
            item.getGradeItemPedido().addAll(novasGrades);
        }
    }

    private void criarGradesTransferencias(List<GradeItemTransfCentroEstoque> gradesTransDif, GradeCor grade, Double quantidade, Empresa emp, CentroEstoque origem, CentroEstoque destino, Date dataPedido, List<String> warnings) {
        List<SaldoEstoqueGeral> saldosLotes = this.findSaldosPorLotesFabricacaoAbertos(grade, emp, origem, dataPedido);
        if (saldosLotes.isEmpty()) {
            warnings.add("Produto sem estoque: " + String.valueOf(grade.getCor()) + " / " + grade.getProdutoGrade().getProduto().getIdentificador() + "-" + grade.getProdutoGrade().getProduto().getNome() + " - Quantidade Faltante: " + quantidade);
            return;
        }
        int i = 0;
        double qtdRemas = quantidade;
        do {
            double qtdTransf;
            SaldoEstoqueGeral sal;
            if (qtdRemas > (sal = saldosLotes.get(i)).getQuantidade()) {
                qtdRemas -= sal.getQuantidade().doubleValue();
                qtdTransf = sal.getQuantidade();
            } else {
                qtdTransf = qtdRemas;
                qtdRemas = 0.0;
            }
            gradesTransDif.add(this.criarGradeTransf(sal.getCentroEstoque(), destino, grade, sal.getLoteFabricacao(), sal.getValorMedio(), qtdTransf, emp, dataPedido));
            if (!(qtdRemas > 0.0) || ++i < saldosLotes.size()) continue;
            warnings.add("Produto sem estoque suficiente: " + String.valueOf(grade.getCor()) + " / " + grade.getProdutoGrade().getProduto().getIdentificador() + "-" + grade.getProdutoGrade().getProduto().getNome() + " - Quantidade Faltante: " + qtdRemas);
            break;
        } while (qtdRemas > 0.0);
    }

    private GradeItemTransfCentroEstoque criarGradeTransf(CentroEstoque centroEstoqueOrig, CentroEstoque centroEstoqueDest, GradeCor grade, LoteFabricacao loteFabricacao, Double valorMedio, double qtdTransf, Empresa emp, Date dataPedido) {
        GradeItemTransfCentroEstoque gr = new GradeItemTransfCentroEstoque();
        gr.setDataTransferencia(dataPedido);
        gr.setGradeCor(grade);
        gr.setLoteFabricacao(loteFabricacao);
        gr.setOrigem(centroEstoqueOrig);
        gr.setDestino(centroEstoqueDest);
        gr.setQuantidade(Double.valueOf(qtdTransf));
        gr.setEmpresa(emp);
        return gr;
    }

    private void cancelarReservas(Pedido pedidoNew) {
        pedidoNew.getTransferencias().clear();
        for (ItemPedido item : pedidoNew.getItemPedido()) {
            for (GradeItemPedido gr : item.getGradeItemPedido()) {
                gr.setMovimentacaoFisica(Short.valueOf((short)0));
            }
        }
    }

    private void reservarGradeItem(List novasGrades, ItemPedido item, GradeItemPedido grade, Empresa emp, List<String> warnings, CentroEstoque centroEstoque) throws ExceptionReflection {
        Date dataMov = new Date();
        List<SaldoEstoqueGeral> saldosLotes = this.findSaldosPorLotesFabricacaoAbertos(grade.getGradeCor(), emp, centroEstoque, dataMov);
        if (saldosLotes.isEmpty()) {
            warnings.add("Produto sem estoque: " + String.valueOf(grade.getGradeCor().getCor()) + " / " + grade.getGradeCor().getProdutoGrade().getProduto().getIdentificador() + "-" + grade.getGradeCor().getProdutoGrade().getProduto().getNome() + " - Quantidade Faltante: " + grade.getQuantidade());
            return;
        }
        int i = 0;
        double qtdRemas = grade.getQuantidade();
        do {
            double qtdTransf;
            SaldoEstoqueGeral sal;
            if (qtdRemas > (sal = saldosLotes.get(i)).getQuantidade()) {
                qtdRemas -= sal.getQuantidade().doubleValue();
                qtdTransf = sal.getQuantidade();
            } else {
                qtdTransf = qtdRemas;
                qtdRemas = 0.0;
            }
            grade.setLoteFabricacao(sal.getLoteFabricacao());
            grade.setCentroEstoque(sal.getCentroEstoque());
            grade.setDataMovimentacao(dataMov);
            grade.setMovimentacaoFisica(Short.valueOf((short)1));
            grade.setEmpresa(emp);
            grade.setQuantidade(Double.valueOf(qtdTransf));
            ++i;
            if (qtdRemas > 0.0) {
                grade = (GradeItemPedido)ToolClone.clone((Object)grade);
                grade.setQuantidade(Double.valueOf(qtdRemas));
                grade.setItemPedido(item);
                novasGrades.add(grade);
            }
            if (!(qtdRemas > 0.0) || i < saldosLotes.size()) continue;
            warnings.add("Produto sem estoque: " + String.valueOf(grade.getGradeCor().getCor()) + " / " + grade.getGradeCor().getProdutoGrade().getProduto().getIdentificador() + "-" + grade.getGradeCor().getProdutoGrade().getProduto().getNome() + " - Quantidade Faltante: " + qtdRemas);
            break;
        } while (qtdRemas > 0.0);
    }

    static class ItemReserva {
        private GradeCor gradeCor;
        private Double qtdeOld = 0.0;
        private Double qtdeNew = 0.0;
        private CentroEstoque centroEstoqueOrigem;
        private Date dataMovimentacao;

        @Generated
        public GradeCor getGradeCor() {
            return this.gradeCor;
        }

        @Generated
        public Double getQtdeOld() {
            return this.qtdeOld;
        }

        @Generated
        public Double getQtdeNew() {
            return this.qtdeNew;
        }

        @Generated
        public CentroEstoque getCentroEstoqueOrigem() {
            return this.centroEstoqueOrigem;
        }

        @Generated
        public Date getDataMovimentacao() {
            return this.dataMovimentacao;
        }

        @Generated
        public void setGradeCor(GradeCor gradeCor) {
            this.gradeCor = gradeCor;
        }

        @Generated
        public void setQtdeOld(Double qtdeOld) {
            this.qtdeOld = qtdeOld;
        }

        @Generated
        public void setQtdeNew(Double qtdeNew) {
            this.qtdeNew = qtdeNew;
        }

        @Generated
        public void setCentroEstoqueOrigem(CentroEstoque centroEstoqueOrigem) {
            this.centroEstoqueOrigem = centroEstoqueOrigem;
        }

        @Generated
        public void setDataMovimentacao(Date dataMovimentacao) {
            this.dataMovimentacao = dataMovimentacao;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemReserva)) {
                return false;
            }
            ItemReserva other = (ItemReserva)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$qtdeOld = this.getQtdeOld();
            Double other$qtdeOld = other.getQtdeOld();
            if (this$qtdeOld == null ? other$qtdeOld != null : !((Object)this$qtdeOld).equals(other$qtdeOld)) {
                return false;
            }
            Double this$qtdeNew = this.getQtdeNew();
            Double other$qtdeNew = other.getQtdeNew();
            if (this$qtdeNew == null ? other$qtdeNew != null : !((Object)this$qtdeNew).equals(other$qtdeNew)) {
                return false;
            }
            GradeCor this$gradeCor = this.getGradeCor();
            GradeCor other$gradeCor = other.getGradeCor();
            if (this$gradeCor == null ? other$gradeCor != null : !this$gradeCor.equals(other$gradeCor)) {
                return false;
            }
            CentroEstoque this$centroEstoqueOrigem = this.getCentroEstoqueOrigem();
            CentroEstoque other$centroEstoqueOrigem = other.getCentroEstoqueOrigem();
            if (this$centroEstoqueOrigem == null ? other$centroEstoqueOrigem != null : !this$centroEstoqueOrigem.equals(other$centroEstoqueOrigem)) {
                return false;
            }
            Date this$dataMovimentacao = this.getDataMovimentacao();
            Date other$dataMovimentacao = other.getDataMovimentacao();
            return !(this$dataMovimentacao == null ? other$dataMovimentacao != null : !((Object)this$dataMovimentacao).equals(other$dataMovimentacao));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ItemReserva;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $qtdeOld = this.getQtdeOld();
            result = result * 59 + ($qtdeOld == null ? 43 : ((Object)$qtdeOld).hashCode());
            Double $qtdeNew = this.getQtdeNew();
            result = result * 59 + ($qtdeNew == null ? 43 : ((Object)$qtdeNew).hashCode());
            GradeCor $gradeCor = this.getGradeCor();
            result = result * 59 + ($gradeCor == null ? 43 : $gradeCor.hashCode());
            CentroEstoque $centroEstoqueOrigem = this.getCentroEstoqueOrigem();
            result = result * 59 + ($centroEstoqueOrigem == null ? 43 : $centroEstoqueOrigem.hashCode());
            Date $dataMovimentacao = this.getDataMovimentacao();
            result = result * 59 + ($dataMovimentacao == null ? 43 : ((Object)$dataMovimentacao).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ServicePedidoReservaEstoque.ItemReserva(gradeCor=" + String.valueOf(this.getGradeCor()) + ", qtdeOld=" + this.getQtdeOld() + ", qtdeNew=" + this.getQtdeNew() + ", centroEstoqueOrigem=" + String.valueOf(this.getCentroEstoqueOrigem()) + ", dataMovimentacao=" + String.valueOf(this.getDataMovimentacao()) + ")";
        }
    }
}

