/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.pedidoalmoxarifado;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.opcoesestoque.EnumConstOpEstoqueOp;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemPedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.ItemPedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.PedidoAlmoxarifado;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidDataRuntime;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.dao.impl.DaoPedidoAlmoxarifadoImpl;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesestoque.HelperOpcoesEstoque;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceGradeCor;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServicePedidoAlmoxarifadoImpl
extends ServiceGenericEntityImpl<PedidoAlmoxarifado, Long, DaoPedidoAlmoxarifadoImpl> {
    ServiceGradeCor serviceGradeCor;
    ServiceProdutoImpl serviceProduto;
    ServiceSaldoEstoqueImpl serviceSaldoEstoque;
    HelperOpcoesEstoque helperOpcoesEstoque;

    @Autowired
    public ServicePedidoAlmoxarifadoImpl(DaoPedidoAlmoxarifadoImpl dao, ServiceGradeCor serviceGradeCor, ServiceProdutoImpl serviceProduto, ServiceSaldoEstoqueImpl serviceSaldoEstoque, HelperOpcoesEstoque helperOpcoesEstoque) {
        super(dao);
        this.serviceGradeCor = serviceGradeCor;
        this.serviceProduto = serviceProduto;
        this.serviceSaldoEstoque = serviceSaldoEstoque;
        this.helperOpcoesEstoque = helperOpcoesEstoque;
    }

    public ItemPedidoAlmoxarifado newItem(Produto produto) {
        ItemPedidoAlmoxarifado e = new ItemPedidoAlmoxarifado();
        e.setProduto(produto);
        List<GradeCor> grades = this.serviceGradeCor.get(produto);
        grades.forEach(i -> e.getGradesItensAlmoxarifado().add(this.newGrade((GradeCor)i)));
        return e;
    }

    public GradeItemPedidoAlmoxarifado newGrade(GradeCor g) {
        GradeItemPedidoAlmoxarifado e = new GradeItemPedidoAlmoxarifado();
        e.setGradeCor(g);
        return e;
    }

    @Override
    public PedidoAlmoxarifado beforeSave(PedidoAlmoxarifado e) {
        try {
            e.getItensPedido().forEach(i -> {
                i.setPedidoAlmoxarifado(e);
                i.getGradesItensAlmoxarifado().forEach(g -> g.setItemPedidoAlmoxarifado(i));
                i.setQuantidadeTotal(Double.valueOf(i.getGradesItensAlmoxarifado().stream().mapToDouble(g -> g.getQuantidade()).sum()));
            });
            this.validQtdPedido(e);
            return e;
        }
        catch (ExceptionObjNotFound | ExceptionValidacaoDados ex) {
            this.logError(ex);
            throw new ExceptionRuntimeBase(new ExcepCodeDetail(ex.getFormattedMessage()), ex);
        }
    }

    public Double findSaldoEstoqueGrade(Long produto, Long gradeCor, Long dataPedido, Empresa loggedEmpresa) throws ExceptionValidacaoDados {
        Produto prod = (Produto)this.serviceProduto.get(produto);
        if (this.isNull(prod).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.0065.003", new Object[0]);
        }
        GradeCor grade = (GradeCor)this.serviceGradeCor.get(gradeCor);
        if (this.isNull(grade).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.0064.001", new Object[0]);
        }
        if (this.isNull(dataPedido).booleanValue() || dataPedido <= 0L) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("V.ERP.0287.001"));
        }
        SaldoEstoqueGeralBasico saldo = this.serviceSaldoEstoque.findSaldoGradeCor(prod, grade, new Date(dataPedido), loggedEmpresa, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_GRADE, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_TUDO, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_DISPONIVEL, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
        if (saldo != null) {
            return saldo.getQuantidade();
        }
        return 0.0;
    }

    public Double findSaldoEstoqueItem(Long produto, Long dataPedido, Empresa loggedEmpresa) throws ExceptionValidacaoDados {
        Produto prod = (Produto)this.serviceProduto.get(produto);
        if (this.isNull(prod).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.0065.003", new Object[0]);
        }
        if (this.isNull(dataPedido).booleanValue() || dataPedido <= 0L) {
            throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("V.ERP.0287.001"));
        }
        SaldoEstoqueGeralBasico saldo = this.serviceSaldoEstoque.findSaldoProdutoBasico(prod, loggedEmpresa, new Date(dataPedido), EnumConstSaldoEstTipoSaldo.TIPO_SALDO_PRODUTO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_TUDO, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_DISPONIVEL, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
        if (saldo != null) {
            return saldo.getQuantidade();
        }
        return 0.0;
    }

    private void validQtdPedido(PedidoAlmoxarifado vo) throws ExceptionValidacaoDados, ExceptionObjNotFound {
        OpcoesEstoque opcoesEstoque;
        if (this.isNotNull(this.getSharedData()).booleanValue() && this.isNotNull(opcoesEstoque = this.getSharedData().getOpcoesEstoque(vo.getEmpresa())).booleanValue() && !CompOpcoes.isAffirmative(this.helperOpcoesEstoque.build(opcoesEstoque).getItens(), (EnumOpDinamicasInterface)EnumConstOpEstoqueOp.PERMITE_PEDIDO_ALMOX_COM_QTD_MAIOR_QUE_ESTOQUE_DISPONIVEL)) {
            ArrayList<CallSite> lista = new ArrayList<CallSite>();
            for (ItemPedidoAlmoxarifado item : vo.getItensPedido()) {
                Double saldo = this.serviceSaldoEstoque.getSaldoEstoqueItem(item.getProduto().getIdentificador(), new Date().getTime(), new CapsEmpresa(vo.getEmpresa().getIdentificador()));
                if (!(item.getQuantidadeTotal() > saldo)) continue;
                lista.add((CallSite)((Object)(String.valueOf(item.getProduto().getIdentificador()) + "-" + item.getProduto().getNome() + " - Saldo: " + ToolFormatter.arrredondarNumero((Double)saldo, (int)3))));
            }
            String produtosQtndMaior = String.join((CharSequence)" | ", lista);
            if (this.isStrWithData(produtosQtndMaior)) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0287.003", new String[]{produtosQtndMaior}));
            }
        }
    }
}

