/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.pesquisa;

import com.touchcomp.basementor.constants.enums.nodo.EnumConstNodos;
import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.OpcoesSistema;
import com.touchcomp.basementor.model.vo.Pesquisa;
import com.touchcomp.basementor.model.vo.PesquisaEfetuada;
import com.touchcomp.basementor.model.vo.PesquisaSetorUsuario;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.dao.impl.DaoPesquisaImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.nodo.ServiceNodoImpl;
import com.touchcomp.basementorservice.service.impl.opcoessistema.ServiceOpcoesSistemaImpl;
import com.touchcomp.basementorservice.service.impl.pesquisaefetuada.ServicePesquisaEfetuadaImpl;
import com.touchcomp.basementorservice.service.impl.setorusuario.ServiceSetorUsuarioImpl;
import com.touchcomp.basementorservice.service.impl.smartlink.ServiceSmartLinkImpl;
import com.touchcomp.touchvomodel.vo.pesquisasetorusuario.web.DTOPesquisaSetorUsuario;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServicePesquisaImpl
extends ServiceGenericEntityImpl<Pesquisa, Long, DaoPesquisaImpl> {
    private final ServiceSmartLinkImpl serviceSmartLink;
    private final ServicePesquisaEfetuadaImpl servicePesquisaEfetuada;
    private final ServiceNodoImpl serviceNodo;
    private final ServiceOpcoesSistemaImpl serviceOpcoesSistema;
    private final ServiceSetorUsuarioImpl serviceSetorUsuarioImpl;

    @Autowired
    public ServicePesquisaImpl(DaoPesquisaImpl genericDao, ServiceSmartLinkImpl serviceSmartLink, ServicePesquisaEfetuadaImpl servicePesquisaEfetuada, ServiceNodoImpl serviceNodo, ServiceOpcoesSistemaImpl serviceOpcoesSistema, ServiceSetorUsuarioImpl serviceSetorUsuarioImpl) {
        super(genericDao);
        this.serviceSmartLink = serviceSmartLink;
        this.servicePesquisaEfetuada = servicePesquisaEfetuada;
        this.serviceNodo = serviceNodo;
        this.serviceOpcoesSistema = serviceOpcoesSistema;
        this.serviceSetorUsuarioImpl = serviceSetorUsuarioImpl;
    }

    @Override
    public Pesquisa beforeSave(Pesquisa vo) {
        if (vo.getQuestoesPesquisa() != null) {
            vo.getQuestoesPesquisa().forEach(i -> {
                i.setPesquisa(vo);
                i.getValoresPadroes().forEach(v -> v.setQuestaoPesquisa(i));
            });
        }
        if (vo.getEdicaoPesquisa() != null) {
            vo.getEdicaoPesquisa().forEach(i -> i.setPesquisa(vo));
        }
        vo.getPesquisaSetorUsuario().forEach(i -> i.setPesquisa(vo));
        return vo;
    }

    public void buildSmartLinkPesquisa(Pesquisa vo) throws ExceptionBuildBI, UnknownHostException, ExceptionValidacaoDados, ExceptionIO, ExceptionReflection, ExceptionInvalidData, ExceptionInvalidState {
        Nodo nodoPesquisa = (Nodo)this.serviceNodo.get(EnumConstNodos.PESQUISA_EFETUADA.getValue());
        List<PesquisaEfetuada> pesquisas = this.cadastraPesquisaDestinatarios(vo);
        if (!pesquisas.isEmpty() && nodoPesquisa != null) {
            for (PesquisaEfetuada p : pesquisas) {
                OpcoesSistema opcoes = this.getSharedData().getOpcoesSistema();
                this.serviceSmartLink.buildSmartLink(vo.getSmartComponent(), EnumConstStatusObjeto.get((Object)vo.getStatus()), nodoPesquisa, p.getPessoa(), vo.getModeloEnvioMensagens(), p.getIdentificador(), vo.getDataEncerramento(), opcoes);
            }
        }
    }

    public List<PesquisaEfetuada> cadastraPesquisaDestinatarios(Pesquisa vo) throws ExceptionBuildBI {
        ArrayList<PesquisaEfetuada> ret = new ArrayList<PesquisaEfetuada>();
        if (vo.getSmartComponent() != null) {
            List<Pessoa> destinatarios = this.serviceSmartLink.getDestinatariosSmartLink(vo.getSmartComponent());
            for (Pessoa pessoa : destinatarios) {
                PesquisaEfetuada p = new PesquisaEfetuada();
                p.setDataCadastro(new Date());
                p.setEmpresa(vo.getEmpresa());
                p.setPessoa(pessoa);
                ret.add(this.servicePesquisaEfetuada.saveOrUpdate(p));
            }
        }
        return ret;
    }

    public List<DTOPesquisaSetorUsuario> getPesquisaSetorUsuario(Long[] ids) {
        List setoresUsuario = this.serviceSetorUsuarioImpl.gets(ids);
        List pesquisaSetorUsuario = setoresUsuario.stream().map(i -> {
            PesquisaSetorUsuario item = new PesquisaSetorUsuario();
            item.setSetorUsuario(i);
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(pesquisaSetorUsuario, DTOPesquisaSetorUsuario.class);
    }
}

