/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.pesquisaefetuada;

import com.touchcomp.basementor.constants.enums.pesquisa.EnumConstTipoPergunta;
import com.touchcomp.basementor.model.vo.PesquisaEfetuada;
import com.touchcomp.basementor.model.vo.QuestaoPesquisaEfetuada;
import com.touchcomp.basementorservice.dao.impl.DaoPesquisaEfetuadaImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServicePesquisaEfetuadaImpl
extends ServiceGenericEntityImpl<PesquisaEfetuada, Long, DaoPesquisaEfetuadaImpl> {
    @Autowired
    public ServicePesquisaEfetuadaImpl(DaoPesquisaEfetuadaImpl dao) {
        super(dao);
    }

    @Override
    public PesquisaEfetuada beforeSave(PesquisaEfetuada entity) {
        Double vlr = 0.0;
        for (QuestaoPesquisaEfetuada q : entity.getQuestoesPesquisa()) {
            q.setPesquisaEfetuada(entity);
            if (q.getQuestaoPesquisaVlrPadrao() != null || q.getValor() == null || q.getValor().trim().length() <= 0 || !this.isEquals(q.getQuestaoPesquisa().getTipoPergunta().getContabiliza(), EnumConstTipoPergunta.CONTABILIZA.getValue())) continue;
            vlr = vlr + Double.valueOf(q.getValor());
        }
        if (!entity.getQuestoesPesquisa().isEmpty()) {
            entity.setNotaMedia(Double.valueOf(vlr / (double)entity.getQuestoesPesquisa().size()));
        }
        return entity;
    }
}

