/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.pessoa;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementorclientwebservices.consultapessoas.model.DTOConsutalPessoaResp;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.helpers.impl.fornecedor.HelperFornecedor;
import com.touchcomp.basementorservice.helpers.impl.pessoa.HelperPessoa;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.cidade.ServiceCidadeImpl;
import com.touchcomp.basementorservice.service.impl.cnae.ServiceCnaeImpl;
import com.touchcomp.basementorservice.service.impl.fornecedor.ServiceFornecedorImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.pessoa.web.DTOPessoa;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SCCadastraPessoaConsultaImpl
extends ServiceGenericImpl {
    final ServiceFornecedorImpl serviceFornecedorImpl;
    final ServicePessoaImpl servicePessoaImpl;
    final ServiceCidadeImpl serviceCidadeImpl;
    final ServiceCnaeImpl serviceCnaeImpl;
    final HelperPessoa helperPessoa;
    final HelperFornecedor helperFornecedor;

    public SCCadastraPessoaConsultaImpl(ServiceFornecedorImpl serviceFornecedorImpl, ServicePessoaImpl servicePessoaImpl, ServiceCidadeImpl serviceCidadeImpl, ServiceCnaeImpl serviceCnaeImpl, HelperPessoa helperPessoa, HelperFornecedor helperFornecedor) {
        this.serviceFornecedorImpl = serviceFornecedorImpl;
        this.servicePessoaImpl = servicePessoaImpl;
        this.serviceCidadeImpl = serviceCidadeImpl;
        this.serviceCnaeImpl = serviceCnaeImpl;
        this.helperPessoa = helperPessoa;
        this.helperFornecedor = helperFornecedor;
    }

    public DTOPessoa cadastrarPessoa(DTOConsutalPessoaResp.Pessoa sel) throws ExceptionReflection {
        Pessoa pes = this.servicePessoaImpl.getByCPFCNPJ(sel.getCpfCnpj());
        pes = this.criaOuAtualizaPessoa(pes, sel);
        return this.builderToDTO(Pessoa.class, DTOPessoa.class, pes);
    }

    private void atualizaPessoa(Pessoa pes, DTOConsutalPessoaResp.Pessoa sel) {
        pes.setNome(ToolString.cut((String)sel.getNome(), (int)60));
        pes.setNomeFantasia(ToolString.cut((String)sel.getNomeFantasia(), (int)60));
        pes.getEndereco().setBairro(ToolString.cut((String)sel.getEndereco().getBairro(), (int)60));
        pes.getEndereco().setCep(ToolString.cut((String)sel.getEndereco().getCep(), (int)9));
        pes.getEndereco().setComplemento(ToolString.cut((String)sel.getEndereco().getComplemento(), (int)60));
        pes.getEndereco().setLogradouro(ToolString.cut((String)sel.getEndereco().getLogradouro(), (int)60));
        pes.getEndereco().setNumero(ToolString.cut((String)sel.getEndereco().getNumero(), (int)10));
        pes.getEndereco().setCidade(this.serviceCidadeImpl.getByCodigoIBGECompleto(sel.getEndereco().getCodigoMunicipio()));
        pes.getComplemento().setCnae(this.serviceCnaeImpl.getByCodigo(sel.getCnaePrincipal()));
        pes.getComplemento().setCnpj(ToolString.onlyNumbers((String)sel.getCpfCnpj()));
        pes.getComplemento().setInscEst(ToolString.onlyNumbers((String)sel.getInscricaoEstadual()));
        pes.getComplemento().setAtivo(pes.getAtivo());
    }

    public Pessoa criaOuAtualizaPessoa(Pessoa pes, DTOConsutalPessoaResp.Pessoa sel) {
        if (pes == null) {
            pes = this.helperPessoa.getNew();
        }
        this.atualizaPessoa(pes, sel);
        return pes;
    }

    @Transactional(readOnly=true)
    public List<Fornecedor> criaOuAtualizaFornecedor(DTOConsutalPessoaResp st, boolean atualizarCadastro, Empresa empresa) {
        LinkedList<Fornecedor> fornecedores = new LinkedList<Fornecedor>();
        for (DTOConsutalPessoaResp.Pessoa cad : st.getPessoas()) {
            UnidadeFatFornecedor unid;
            Pessoa pessoaUnidFat;
            String cpfCnpj = cad.getCpfCnpj();
            String ie = cad.getInscricaoEstadual();
            Fornecedor fornecedor = this.serviceFornecedorImpl.getFornecedorCpfCpnjAtivo(cpfCnpj);
            Pessoa pessoa = null;
            if (fornecedor != null) {
                pessoa = fornecedor.getPessoa();
            }
            if (pessoa == null) {
                pessoa = this.servicePessoaImpl.getByCPFCNPJAtiva(cpfCnpj);
            }
            if (pessoa == null) {
                pessoa = this.helperPessoa.getNew();
                this.atualizaPessoa(pessoa, cad);
            }
            if (atualizarCadastro) {
                this.atualizaPessoa(pessoa, cad);
            }
            if (fornecedor == null) {
                fornecedor = this.helperFornecedor.build(fornecedor).criarFornecedor(pessoa, empresa);
            }
            if (!TMethods.isWithData((Collection)fornecedor.getUnidadesFatForn())) {
                pessoaUnidFat = this.servicePessoaImpl.getByCnpjInscricaoEstadualAtiva(cpfCnpj, ie);
                if (pessoaUnidFat == null) {
                    pessoaUnidFat = this.helperPessoa.getNew();
                    this.atualizaPessoa(pessoaUnidFat, cad);
                }
                unid = this.helperFornecedor.build(fornecedor).criarUnidadeFatPadrao(pessoaUnidFat);
                unid.setFornecedor(fornecedor);
                fornecedor.getUnidadesFatForn().add(unid);
            }
            if (!TMethods.isEquals((Object)ie, (Object)pessoa.getComplemento().getInscEst()) && TMethods.isStrWithData((String)pessoa.getComplemento().getInscEst())) {
                pessoaUnidFat = this.servicePessoaImpl.getByCnpjInscricaoEstadualAtiva(cpfCnpj, ie);
                if (pessoaUnidFat == null) {
                    pessoaUnidFat = this.helperPessoa.getNew();
                    this.atualizaPessoa(pessoaUnidFat, cad);
                }
                if (atualizarCadastro) {
                    this.atualizaPessoa(pessoaUnidFat, cad);
                }
                unid = this.helperFornecedor.build(fornecedor).criarUnidadeFatPadrao(pessoaUnidFat);
                unid.setFornecedor(fornecedor);
                fornecedor.getUnidadesFatForn().add(unid);
            }
            fornecedores.add(fornecedor);
        }
        return fornecedores;
    }
}

