/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.pessoa;

import com.touchcomp.basementor.constants.enums.configservicosterceiros.EnumConstConfigServicosTerceiros;
import com.touchcomp.basementor.constants.enums.configservicosterceiros.impl.ConstantsConsultaDadosPessoas;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.model.vo.ConfigServicosTerceiros;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorclientwebservices.consultapessoas.WEBConsultaPessoas;
import com.touchcomp.basementorclientwebservices.consultapessoas.constants.ConstEnumConsultaPessoasProvider;
import com.touchcomp.basementorclientwebservices.consultapessoas.model.DTOConsultaPessoaParams;
import com.touchcomp.basementorclientwebservices.consultapessoas.model.DTOConsutalPessoaResp;
import com.touchcomp.basementorclientwebservices.nfe.impl.consultacadastro.UtilConsultaCadastro;
import com.touchcomp.basementorservice.helpers.impl.configservicosterceiros.HelperConfigServicosTerceiros;
import com.touchcomp.basementorservice.helpers.impl.configuracaocertificado.HelperConfiguracaoCertificado;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.configservicosterceiros.ServiceConfigServicosTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.configuracaocertificado.ServiceConfiguracaoCertificadoImpl;
import org.springframework.stereotype.Service;

@Service
public class SCConsultaDadosPessoa
extends ServiceGenericImpl {
    private final HelperConfiguracaoCertificado helperConfigCertificado;
    private final HelperConfigServicosTerceiros helperConfigServicosTerceiros;
    private final UtilConsultaCadastro utilConsultaCadastro;
    private final ServiceConfiguracaoCertificadoImpl serviceConfiguracaoCertificadoImpl;
    private final ServiceConfigServicosTerceirosImpl serviceConfigServicosTerceirosImpl;

    public SCConsultaDadosPessoa(HelperConfiguracaoCertificado helperConfigCertificado, HelperConfigServicosTerceiros helperConfigServicosTerceiros, UtilConsultaCadastro utilConsultaCadastro, ServiceConfiguracaoCertificadoImpl serviceConfiguracaoCertificadoImpl, ServiceConfigServicosTerceirosImpl serviceConfigServicosTerceirosImpl) {
        this.helperConfigCertificado = helperConfigCertificado;
        this.helperConfigServicosTerceiros = helperConfigServicosTerceiros;
        this.utilConsultaCadastro = utilConsultaCadastro;
        this.serviceConfiguracaoCertificadoImpl = serviceConfiguracaoCertificadoImpl;
        this.serviceConfigServicosTerceirosImpl = serviceConfigServicosTerceirosImpl;
    }

    public DTOConsutalPessoaResp consultaCadastro(String cnpj, String inscEst, String codUF, Empresa empresa) throws Exception {
        ConfiguracaoCertificado configCert = this.serviceConfiguracaoCertificadoImpl.getByEmpresaOrThrow(empresa);
        ConfigServicosTerceiros configServ = this.serviceConfigServicosTerceirosImpl.get(EnumConstConfigServicosTerceiros.CONSULTA_CADASTROS_PESSOAS);
        WEBConsultaPessoas.Config config = new WEBConsultaPessoas.Config();
        ConstEnumConsultaPessoasProvider prov = null;
        if (configServ != null) {
            String provedor = this.helperConfigServicosTerceiros.build(configServ).getValue(ConstantsConsultaDadosPessoas.PROVEDOR.getChave());
            String token = this.helperConfigServicosTerceiros.build(configServ).getValue(ConstantsConsultaDadosPessoas.API_TOKEN.getChave());
            prov = ConstEnumConsultaPessoasProvider.get((Object)provedor);
            config.setToken(token);
        }
        if (prov == null) {
            prov = ConstEnumConsultaPessoasProvider.SEFAZ;
        }
        config.setProvider(prov);
        ParamsCertificado paramCert = this.helperConfigCertificado.build(configCert).getParamsCertificado(ConstAmbiente.PRODUCAO);
        WEBConsultaPessoas consulta = new WEBConsultaPessoas();
        config.setParamsCertificado(paramCert);
        DTOConsultaPessoaParams param = new DTOConsultaPessoaParams();
        param.setCodigoUF(codUF);
        param.setCpfCnpj(cnpj);
        param.setInscricaoEstadual(inscEst);
        DTOConsutalPessoaResp resp = consulta.consultaDados(param, config);
        return resp;
    }
}

